"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const sfn = new AWS.StepFunctions();
const rds = new AWS.RDS();
exports.handler = async function (input) {
    console.log(input.RequestType, input.PhysicalResourceId);
    if (input.RequestType == 'Create' || input.RequestType == 'Update') {
        const exec = await sfn.describeExecution({ executionArn: input.PhysicalResourceId }).promise();
        if (exec.status == 'ABORTED' || exec.status == 'FAILED' || exec.status == 'TIMED_OUT') {
            throw new Error(`Step function failed with: ${exec.status}`);
        }
        if (exec.status == 'RUNNING') {
            return { IsComplete: false };
        }
        // exec.status == 'SUCCEEDED'
        if (!exec.output) {
            throw new Error('No output?');
        }
        const output = JSON.parse(exec.output);
        if (output.isCluster) {
            const snapshots = await rds.describeDBClusterSnapshots({ DBClusterSnapshotIdentifier: output.targetSnapshotId }).promise();
            if (!snapshots.DBClusterSnapshots || snapshots.DBClusterSnapshots.length != 1) {
                throw new Error(`Target cluster snapshot ${output.targetSnapshotId} does not exist`);
            }
            await rds.deleteDBClusterSnapshot({ DBClusterSnapshotIdentifier: output.targetSnapshotId }).promise();
        }
        else {
            const snapshots = await rds.describeDBSnapshots({ DBSnapshotIdentifier: output.targetSnapshotId }).promise();
            if (!snapshots.DBSnapshots || snapshots.DBSnapshots.length != 1) {
                throw new Error(`Target instance snapshot ${output.targetSnapshotId} does not exist`);
            }
            await rds.deleteDBSnapshot({ DBSnapshotIdentifier: output.targetSnapshotId }).promise();
        }
        return { IsComplete: true };
    }
    // delete -- we don't actually need to delete anything
    return { IsComplete: true };
};
//# sourceMappingURL=data:application/json;base64,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