"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const sfn = new AWS.StepFunctions();
exports.handler = async function (input) {
    if (input.RequestType == 'Create' || input.RequestType == 'Update') {
        const exec = await sfn.startExecution({ stateMachineArn: input.ResourceProperties.StepFunctionArn }).promise();
        return { PhysicalResourceId: exec.executionArn };
    }
    return { PhysicalResourceId: input.PhysicalResourceId };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5sYW1iZGEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdGVzdC5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzREFBc0Q7QUFDdEQsK0JBQStCO0FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLGFBQWEsRUFBRSxDQUFDO0FBY3BDLE9BQU8sQ0FBQyxPQUFPLEdBQUcsS0FBSyxXQUFXLEtBQVk7SUFDNUMsSUFBSSxLQUFLLENBQUMsV0FBVyxJQUFJLFFBQVEsSUFBSSxLQUFLLENBQUMsV0FBVyxJQUFJLFFBQVEsRUFBRTtRQUNsRSxNQUFNLElBQUksR0FBRyxNQUFNLEdBQUcsQ0FBQyxjQUFjLENBQUMsRUFBRSxlQUFlLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLGVBQWUsRUFBRSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDL0csT0FBTyxFQUFFLGtCQUFrQixFQUFFLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztLQUNsRDtJQUVELE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztBQUMxRCxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXMgKi9cbmltcG9ydCAqIGFzIEFXUyBmcm9tICdhd3Mtc2RrJztcblxuY29uc3Qgc2ZuID0gbmV3IEFXUy5TdGVwRnVuY3Rpb25zKCk7XG5cbmludGVyZmFjZSBJbnB1dCB7XG4gIFJlcXVlc3RUeXBlOiAnQ3JlYXRlJyB8ICdVcGRhdGUnIHwgJ0RlbGV0ZSc7XG4gIFBoeXNpY2FsUmVzb3VyY2VJZDogc3RyaW5nO1xuICBSZXNvdXJjZVByb3BlcnRpZXM6IHtcbiAgICBTdGVwRnVuY3Rpb25Bcm46IHN0cmluZztcbiAgfTtcbn1cblxuaW50ZXJmYWNlIFJlc3VsdCB7XG4gIFBoeXNpY2FsUmVzb3VyY2VJZDogc3RyaW5nO1xufVxuXG5leHBvcnRzLmhhbmRsZXIgPSBhc3luYyBmdW5jdGlvbiAoaW5wdXQ6IElucHV0KTogUHJvbWlzZTxSZXN1bHQ+IHtcbiAgaWYgKGlucHV0LlJlcXVlc3RUeXBlID09ICdDcmVhdGUnIHx8IGlucHV0LlJlcXVlc3RUeXBlID09ICdVcGRhdGUnKSB7XG4gICAgY29uc3QgZXhlYyA9IGF3YWl0IHNmbi5zdGFydEV4ZWN1dGlvbih7IHN0YXRlTWFjaGluZUFybjogaW5wdXQuUmVzb3VyY2VQcm9wZXJ0aWVzLlN0ZXBGdW5jdGlvbkFybiB9KS5wcm9taXNlKCk7XG4gICAgcmV0dXJuIHsgUGh5c2ljYWxSZXNvdXJjZUlkOiBleGVjLmV4ZWN1dGlvbkFybiB9O1xuICB9XG5cbiAgcmV0dXJuIHsgUGh5c2ljYWxSZXNvdXJjZUlkOiBpbnB1dC5QaHlzaWNhbFJlc291cmNlSWQgfTtcbn07Il19