"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const rds = new AWS.RDS();
class NotReady extends Error {
    constructor() {
        super('Not ready');
        this.name = 'NotReady';
    }
}
function checkStatus(status, source) {
    for (const badStatus of ['stop', 'delet', 'fail', 'incompatible', 'inaccessible', 'error']) {
        if (status.indexOf(badStatus) >= 0) {
            throw new Error(`Invalid status ${status} for ${source}`);
        }
    }
    throw new NotReady();
}
function empty(obj) {
    return obj === undefined || obj === null || Object.keys(obj).length == 0;
}
exports.handler = async function (input) {
    console.log(input);
    if (input.resourceType == 'snapshot' && input.snapshotIdentifier) {
        // wait for snapshot
        let status;
        if (input.isCluster) {
            // wait for cluster snapshot
            const snapshots = await rds.describeDBClusterSnapshots({
                DBClusterIdentifier: input.databaseIdentifier,
                DBClusterSnapshotIdentifier: input.snapshotIdentifier,
            }).promise();
            console.log(snapshots);
            if (!snapshots.DBClusterSnapshots || snapshots.DBClusterSnapshots.length != 1) {
                throw new Error(`Unable to find snapshot ${input.snapshotIdentifier} of ${input.databaseIdentifier}`);
            }
            status = snapshots.DBClusterSnapshots[0].Status ?? '';
        }
        else {
            // wait for instance snapshot
            const snapshots = await rds.describeDBSnapshots({
                DBInstanceIdentifier: input.databaseIdentifier,
                DBSnapshotIdentifier: input.snapshotIdentifier,
            }).promise();
            console.log(snapshots);
            if (!snapshots.DBSnapshots || snapshots.DBSnapshots.length != 1) {
                throw new Error(`Unable to find snapshot ${input.snapshotIdentifier} of ${input.databaseIdentifier}`);
            }
            status = snapshots.DBSnapshots[0].Status ?? '';
        }
        if (status == 'available') {
            return;
        }
        checkStatus(status, input.snapshotIdentifier);
    }
    else if (input.resourceType == 'cluster') {
        // wait for db
        const dbs = await rds.describeDBClusters({
            DBClusterIdentifier: input.databaseIdentifier,
        }).promise();
        console.log(dbs);
        if (!dbs.DBClusters || dbs.DBClusters.length != 1) {
            throw new Error(`Unable to find db clsuter ${input.databaseIdentifier}`);
        }
        const status = dbs.DBClusters[0].Status ?? '';
        if (status == 'available' && empty(dbs.DBClusters[0].PendingModifiedValues)) {
            return;
        }
        checkStatus(status, input.databaseIdentifier);
    }
    else if (input.resourceType == 'instance') {
        // wait for db
        const instances = await rds.describeDBInstances({
            DBInstanceIdentifier: input.databaseIdentifier,
        }).promise();
        console.log(instances);
        if (!instances.DBInstances || instances.DBInstances.length != 1) {
            throw new Error(`Unable to find db instance ${input.databaseIdentifier}`);
        }
        const status = instances.DBInstances[0].DBInstanceStatus ?? '';
        if (status == 'available' && empty(instances.DBInstances[0].PendingModifiedValues)) {
            return;
        }
        checkStatus(status, input.databaseIdentifier);
    }
    else {
        throw new Error('Bad parameters');
    }
};
//# sourceMappingURL=data:application/json;base64,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