# mypy-boto3-resource-groups

[![PyPI - mypy-boto3-resource-groups](https://img.shields.io/pypi/v/mypy-boto3-resource-groups.svg?color=blue)](https://pypi.org/project/mypy-boto3-resource-groups)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-resource-groups.svg?color=blue)](https://pypi.org/project/mypy-boto3-resource-groups)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ResourceGroups 1.13.19](https://boto3.amazonaws.com/v1/documentation/api/1.13.19/reference/services/resource-groups.html#ResourceGroups) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-resource-groups](#mypy-boto3-resource-groups)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ResourceGroups` service.

```bash
python -m pip install boto3-stubs[resource-groups]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import resource_groups
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_resource_groups as resource_groups

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("resource-groups")
client: resource_groups.ResourceGroupsClient = boto3.client("resource-groups")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: resource_groups.ResourceGroupsClient = session.client("resource-groups")


# Paginators need type annotation on creation
list_group_resources_paginator: resource_groups.ListGroupResourcesPaginator = client.get_paginator("list_group_resources")
list_groups_paginator: resource_groups.ListGroupsPaginator = client.get_paginator("list_groups")
search_resources_paginator: resource_groups.SearchResourcesPaginator = client.get_paginator("search_resources")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.