import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudTargetGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#id DataIonoscloudTargetGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the target group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#name DataIonoscloudTargetGroup#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#partial_match DataIonoscloudTargetGroup#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#timeouts DataIonoscloudTargetGroup#timeouts}
    */
    readonly timeouts?: DataIonoscloudTargetGroupTimeouts;
}
export interface DataIonoscloudTargetGroupHealthCheck {
}
export declare function dataIonoscloudTargetGroupHealthCheckToTerraform(struct?: DataIonoscloudTargetGroupHealthCheck): any;
export declare class DataIonoscloudTargetGroupHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudTargetGroupHealthCheck | undefined;
    set internalValue(value: DataIonoscloudTargetGroupHealthCheck | undefined);
    get checkInterval(): number;
    get checkTimeout(): number;
    get retries(): number;
}
export declare class DataIonoscloudTargetGroupHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudTargetGroupHealthCheckOutputReference;
}
export interface DataIonoscloudTargetGroupHttpHealthCheck {
}
export declare function dataIonoscloudTargetGroupHttpHealthCheckToTerraform(struct?: DataIonoscloudTargetGroupHttpHealthCheck): any;
export declare class DataIonoscloudTargetGroupHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudTargetGroupHttpHealthCheck | undefined;
    set internalValue(value: DataIonoscloudTargetGroupHttpHealthCheck | undefined);
    get matchType(): string;
    get method(): string;
    get negate(): cdktf.IResolvable;
    get path(): string;
    get regex(): cdktf.IResolvable;
    get response(): string;
}
export declare class DataIonoscloudTargetGroupHttpHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudTargetGroupHttpHealthCheckOutputReference;
}
export interface DataIonoscloudTargetGroupTargets {
}
export declare function dataIonoscloudTargetGroupTargetsToTerraform(struct?: DataIonoscloudTargetGroupTargets): any;
export declare class DataIonoscloudTargetGroupTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudTargetGroupTargets | undefined;
    set internalValue(value: DataIonoscloudTargetGroupTargets | undefined);
    get healthCheckEnabled(): cdktf.IResolvable;
    get ip(): string;
    get maintenanceEnabled(): cdktf.IResolvable;
    get port(): number;
    get weight(): number;
}
export declare class DataIonoscloudTargetGroupTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudTargetGroupTargetsOutputReference;
}
export interface DataIonoscloudTargetGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#create DataIonoscloudTargetGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#default DataIonoscloudTargetGroup#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#delete DataIonoscloudTargetGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group#update DataIonoscloudTargetGroup#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudTargetGroupTimeoutsToTerraform(struct?: DataIonoscloudTargetGroupTimeoutsOutputReference | DataIonoscloudTargetGroupTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudTargetGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudTargetGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudTargetGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group ionoscloud_target_group}
*/
export declare class DataIonoscloudTargetGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_target_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/target_group ionoscloud_target_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudTargetGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudTargetGroupConfig);
    get algorithm(): string;
    private _healthCheck;
    get healthCheck(): DataIonoscloudTargetGroupHealthCheckList;
    private _httpHealthCheck;
    get httpHealthCheck(): DataIonoscloudTargetGroupHttpHealthCheckList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get protocol(): string;
    private _targets;
    get targets(): DataIonoscloudTargetGroupTargetsList;
    private _timeouts;
    get timeouts(): DataIonoscloudTargetGroupTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudTargetGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudTargetGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
