from nlu.universe.feature_node_ids import NLP_NODE_IDS, NLP_HC_NODE_IDS, OCR_NODE_IDS


class Spellbook:
    trainable_models = {
        # map NLU references to NLP approaches
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,  # classifier DL alias
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,  # ner DL alias
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,  # sent DL alias
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

        # 'train.sentence_detector': '',  # deep sentence detector alias
        # 'train.symmetric_spell': '',
        # 'train.context_spell': '',
        # 'train.spell': '',  ## context spell alias
        # 'train.norvig_spell': '',
        # 'train.unlabeled_dependency_parser': '',
        # 'train.labeled_dependency_parser': '',
        # 'train.vivekn_sentiment': '',

    }

    # Reference to all datasets for which we have pretrained models
    datasets = []
    chunk_embeddings = ['embed_sentence']
    # The vocabulary of the nlu Namespace. Any of this references give you a model_anno_obj
    # keys inside a language dict are NLU references and value is the name in SparkNLP

    component_alias_references = {
        # references for SparkNLPAnnotators without pretrained models.
        #  These are names for NLU components that can be created withouth a language prefix

        # multi lang pipes
        'lang': ('detect_language_375', 'component_list'),  # multi lang alias

        # Aliases
        'classify.lang': ('detect_language_375', 'component_list'),  # multi lang detector default

        # eng pipes
        'classify': ('analyze_sentiment', 'component_list'),  # default classifier
        'explain': ('explain_document_ml', 'component_list'),  # default explain
        'explain.ml': ('explain_document_ml', 'component_list'),
        'explain.dl': ('explain_document_dl', 'component_list'),
        'ner.conll': ('recognize_entities_dl', 'component_list'),  # default ner
        'ner.dl': ('recognize_entities_dl', 'component_list'),
        'ner.bert': ('recognize_entities_bert', 'component_list'),
        'ner': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto.sm': ('onto_recognize_entities_sm', 'component_list'),

        # 'match.text': ('text_matcher', 'model_anno_obj'),
        # 'match.regex': ('regex_matcher', 'model_anno_obj'),
        # 'match.date': ('date_matcher', 'model_anno_obj'),
        # 'match.context': ('context_parser', 'model_anno_obj'),
        # 'context_parser': ('context_parser', 'model_anno_obj'),

        'match.chunks': ('match_chunks', 'component_list'),
        'clean.stop': ('clean_stop', 'component_list'),
        # 'clean.pattern': ('clean_pattern', 'component_list'),
        'clean.slang': ('clean_slang', 'component_list'),
        # 'spell': ('check_spelling','component_list'),  # bad spell_checker,
        'spell': ('spellcheck_dl', 'model_anno_obj'),  # default spell
        'sentiment': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # default emotion model_anno_obj

        'sentiment.imdb': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.imdb.use': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.twitter.use': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'sentiment.twitter': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'dependency': ('dependency_conllu', 'model_anno_obj'),

        'tokenize': ('spark_nlp_tokenizer', 'model_anno_obj'),  # tokenizer rule based model_anno_obj
        'stem': ('stemmer', 'model_anno_obj'),  # stem rule based model_anno_obj
        'norm': ('normalizer', 'model_anno_obj'),  # rule based model_anno_obj
        'norm_document': ('normalizer', 'model_anno_obj'),  # rule based model_anno_obj

        'chunk': ('default_chunker', 'model_anno_obj'),  # rule based model_anno_obj
        'embed_chunk': ('chunk_embeddings', 'model_anno_obj'),  # rule based model_anno_obj
        'ngram': ('ngram', 'model_anno_obj'),  # rule based model_anno_obj

        'lemma': ('lemma_antbnc', 'model_anno_obj'),  # lemma default en
        'lemma.antbnc': ('lemma_antbnc', 'model_anno_obj'),
        'pos': ('pos_anc', 'model_anno_obj'),  # pos default en
        'pos.anc': ('pos_anc', 'model_anno_obj'),
        'pos.ud_ewt': ('pos_ud_ewt', 'model_anno_obj'),
        # 'ner.crf' :'ner_crf', # crf not supported in NLU
        'ner.dl.glove.6B_100d': ('ner_dl', 'model_anno_obj'),
        'ner.dl.bert': ('ner_dl_bert', 'model_anno_obj'),  # points ner bert
        'ner.onto.glove.6B_100d': ('onto_100', 'model_anno_obj'),
        'ner.onto.glove.6B_300d': ('onto_300', 'model_anno_obj'),  # this uses multi lang embeds!
        'sentence_detector': ('sentence_detector_dl', 'model_anno_obj'),
        'sentence_detector.deep': ('sentence_detector_dl', 'model_anno_obj'),  # ALIAS

        'sentence_detector.pragmatic': ('pragmatic_sentence_detector', 'model_anno_obj'),

        'spell.symmetric': ('spellcheck_sd', 'model_anno_obj'),  # TODO erronous
        'spell.norivg': ('spellcheck_norvig', 'model_anno_obj'),
        'sentiment.vivekn': ('sentiment_vivekn', 'model_anno_obj'),
        'dep.untyped.conllu': ('dependency_conllu', 'model_anno_obj'),
        'dep.untyped': ('dependency_conllu', 'model_anno_obj'),  # default untyped dependency
        'dep': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency
        'dep.typed': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency dataset
        'dep.typed.conllu': ('dependency_typed_conllu', 'model_anno_obj'),
        'stopwords': ('stopwords_en', 'model_anno_obj'),

        # embeddings models
        'embed': ('glove_100d', 'model_anno_obj'),  # default overall embed
        'glove': ('glove_100d', 'model_anno_obj'),  # default glove
        'embed.glove': ('glove_100d', 'model_anno_obj'),  # default glove en
        'embed.glove.100d': ('glove_100d', 'model_anno_obj'),
        'bert': ('small_bert_L2_128', 'model_anno_obj'),  # default bert
        'covidbert': ('covidbert_large_uncased', 'model_anno_obj'),

        'embed.bert': ('bert_base_uncased', 'model_anno_obj'),  # default bert
        'embed.bert_base_uncased': ('bert_base_uncased', 'model_anno_obj'),
        'embed.bert_base_cased': ('bert_base_cased', 'model_anno_obj'),
        'embed.bert_large_uncased': ('bert_large_uncased', 'model_anno_obj'),
        'embed.bert_large_cased': ('bert_large_cased', 'model_anno_obj'),
        'biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # alias
        'embed.biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # default bio bert
        'embed.biobert_pubmed_base_cased': ('biobert_pubmed_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_large_cased': ('biobert_pubmed_large_cased', 'model_anno_obj'),
        'embed.biobert_pmc_base_cased': ('biobert_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_pmc_base_cased': ('biobert_pubmed_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_clinical_base_cased': ('biobert_clinical_base_cased', 'model_anno_obj'),
        'embed.biobert_discharge_base_cased': ('biobert_discharge_base_cased', 'model_anno_obj'),
        'elmo': ('elmo', 'model_anno_obj'),

        'embed.electra': ('electra_small_uncased', 'model_anno_obj'),
        'electra': ('electra_small_uncased', 'model_anno_obj'),
        'e2e': ('multiclassifierdl_use_e2e', 'model_anno_obj'),

        'embed.elmo': ('elmo', 'model_anno_obj'),
        'embed_sentence': ('tfhub_use', 'model_anno_obj'),  # default use
        'embed_sentence.small_bert_L2_128': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.bert': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.electra': ('sent_electra_small_uncased', 'model_anno_obj'),

        'embed_sentence.use': ('tfhub_use', 'model_anno_obj'),  # default use
        'use': ('tfhub_use', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use': ('tfhub_use', 'model_anno_obj'),
        'embed_sentence.use_lg': ('tfhub_use_lg', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use_lg': ('tfhub_use_lg', 'model_anno_obj'),
        'albert': ('albert_base_uncased', 'model_anno_obj'),  # albert alias en
        'embed.albert_base_uncased': ('albert_base_uncased', 'model_anno_obj'),
        'embed.albert_large_uncased': ('albert_large_uncased', 'model_anno_obj'),
        'embed.albert_xlarge_uncased': ('albert_xlarge_uncased', 'model_anno_obj'),
        'embed.albert_xxlarge_uncased': ('albert_xxlarge_uncased', 'model_anno_obj'),
        'embed.xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet default en
        'xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet alias
        'embed.xlnet_base_cased': ('xlnet_base_cased', 'model_anno_obj'),
        'embed.xlnet_large_cased': ('xlnet_large_cased', 'model_anno_obj'),

        # classifiers and sentiment models
        'classify.trec6.use': ('classifierdl_use_trec6', 'model_anno_obj'),
        'classify.trec50.use': ('classifierdl_use_trec50', 'model_anno_obj'),
        'classify.questions': ('classifierdl_use_trec50', 'model_anno_obj'),
        'questions': ('classifierdl_use_trec50', 'model_anno_obj'),

        'classify.spam.use': ('classifierdl_use_spam', 'model_anno_obj'),
        'classify.fakenews.use': ('classifierdl_use_fakenews', 'model_anno_obj'),
        'classify.emotion.use': ('classifierdl_use_emotion', 'model_anno_obj'),
        'classify.cyberbullying.use': ('classifierdl_use_cyberbullying', 'model_anno_obj'),
        'classify.sarcasm.use': ('classifierdl_use_sarcasm', 'model_anno_obj'),
        'sentiment.imdb.glove': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'classify.trec6': ('classifierdl_use_trec6', 'model_anno_obj'),  # Alias withouth embedding
        'classify.trec50': ('classifierdl_use_trec50', 'model_anno_obj'),  # Alias withouth embedding
        'classify.spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'toxic': ('multiclassifierdl_use_toxic', 'model_anno_obj'),

        'classify.fakenews': ('classifierdl_use_fakenews', 'model_anno_obj'),  # Alias withouth embedding
        'classify.emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # Alias withouth embedding
        'classify.cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding
        'cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding

        'classify.sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding
        'sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding

        'embed.glove.840B_300': ('glove_840B_300', 'model_anno_obj'),
        'yake': ('yake', 'model_anno_obj'),

        # # 2.7.0 new aliases
        't5': ('t5_base', 'model_anno_obj'),
        'summarize': ('t5_base', 'model_anno_obj', {'setTask': '"summarize: "'}),
        'grammar_correctness': ('t5_base', 'model_anno_obj', {'setTask': '"cola sentence: "'}),
        'answer_question': ('t5_base', 'model_anno_obj', {'setTask': '"question: "'}),
        'classify.sentiment_t5': ('t5_base', 'model_anno_obj', {'setTask': '"sst2 sentence: "'}),

    }
    # multi lang models
    pretrained_pipe_references = {

        'da': {
            'da.explain': 'explain_document_sm',
            'da.explain.sm': 'explain_document_sm',
            'da.explain.md': 'explain_document_md',
            'da.explain.lg': 'explain_document_lg',
            'da.ner': 'entity_recognizer_sm',
            'da.ner.sm': 'entity_recognizer_sm',
            'da.ner.md': 'entity_recognizer_md',
            'da.ner.lg': 'entity_recognizer_lg'},

        'nl': {
            'nl.explain': 'explain_document_sm',  # default
            'nl.explain.sm': 'explain_document_sm',
            'nl.explain.md': 'explain_document_md',
            'nl.explain.lg': 'explain_document_lg',
            'nl.ner': 'entity_recognizer_sm',
            # default,calling it nl.ner this makes creating actual NER object impossible!
            'nl.ner.sm': 'entity_recognizer_sm',
            'nl.ner.md': 'entity_recognizer_md',
            'nl.ner.lg': 'entity_recognizer_lg',
        },
        'en': {

            'en.classify': 'analyze_sentiment',  # default classifier
            'en.explain': 'explain_document_ml',  # default explain
            'en.explain.ml': 'explain_document_ml',
            'en.explain.dl': 'explain_document_dl',
            'en.ner': 'recognize_entities_dl',  # default ner
            'en.ner.conll': 'recognize_entities_dl',  # default ner

            'en.ner.dl': 'recognize_entities_dl',
            'en.ner.bert': 'recognize_entities_bert',
            # 'en.ner.onto': 'onto_recognize_entities_sm',  # default  ner.onto
            'en.ner.onto.sm': 'onto_recognize_entities_sm',
            'en.ner.onto.lg': 'onto_recognize_entities_lg',
            # 'en.match.datetime': 'match_datetime',
            'en.match.chunks': 'match_chunks',
            'en.clean.stop': 'clean_stop',
            # 'en.clean.pattern': 'clean_pattern',
            'en.clean.slang': 'clean_slang',
            'en.spell': 'check_spelling_dl',  # dfault spell

            'en.spell.dl': 'check_spelling_dl',
            'en.spell.context': 'check_spelling_dl',
            'en.sentiment': 'analyze_sentiment',
            'en.classify.sentiment': 'analyze_sentiment',

            'en.sentiment.imdb': 'analyze_sentimentdl_use_imdb',
            'en.sentiment.imdb.use': 'analyze_sentimentdl_use_imdb',
            # 'en.sentiment.twitter.use': 'analyze_sentimentdl_use_twitter',
            'en.sentiment.twitter': 'analyze_sentimentdl_use_twitter',
            # 'en.dependency': 'dependency_parse',

            # 2.7
            'en.ner.onto.bert.base': 'onto_recognize_entities_bert_base',
            'en.ner.onto.bert.large': 'onto_recognize_entities_bert_large',
            'en.ner.onto.bert.medium': 'onto_recognize_entities_bert_medium',
            'en.ner.onto.bert.mini': 'onto_recognize_entities_bert_mini',
            'en.ner.onto.bert.small': 'onto_recognize_entities_bert_small',
            'en.ner.onto.bert.tiny': 'onto_recognize_entities_bert_tiny',
            'en.ner.onto.electra.base': 'onto_recognize_entities_electra_base',
            'en.ner.onto.electra.small': 'onto_recognize_entities_electra_small',

            # 2.7.1 and 2.7.2
            "en.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.classify.trec50.component_list": "classifierdl_use_trec50_pipeline",
            "en.ner.onto.large": "onto_recognize_entities_electra_large",

        },
        'fa': {
            'fa.ner.dl': '	recognize_entities_dl',
        },
        'he': {
            'he.explain_document': '	explain_document_lg',
            'he.explain_document.lg': '	explain_document_lg',
        },
        'ko': {
            'ko.explain_document': '	explain_document_lg',
            'ko.explain_document.lg': '	explain_document_lg',

        },
        'sv': {
            'sv.explain': 'explain_document_sm',
            'sv.explain.sm': 'explain_document_sm',
            'sv.explain.md': 'explain_document_md',
            'sv.explain.lg': 'explain_document_lg',
            'sv.ner': 'entity_recognizer_sm',
            'sv.ner.sm': 'entity_recognizer_sm',
            'sv.ner.md': 'entity_recognizer_md',
            'sv.ner.lg': 'entity_recognizer_lg'},

        'fi': {
            'fi.explain': 'explain_document_sm',
            'fi.explain.sm': 'explain_document_sm',
            'fi.explain.md': 'explain_document_md',
            'fi.explain.lg': 'explain_document_lg',
            'fi.ner': 'entity_recognizer_sm',
            'fi.ner.sm': 'entity_recognizer_sm',
            'fi.ner.md': 'entity_recognizer_md',
            'fi.ner.lg': 'entity_recognizer_lg'},

        'fr': {
            'fr.explain': 'explain_document_lg',  # default fr explain
            'fr.explain.lg': 'explain_document_lg',
            'fr.explain.md': 'explain_document_md',
            'fr.ner': 'entity_recognizer_lg',  # default fr ner component_list
            'fr.ner.lg': 'entity_recognizer_lg',
            'fr.ner.md': 'entity_recognizer_md',
        },
        'de': {
            'de.explain.document': 'explain_document_md',  # default de explain
            'de.explain.document.md': 'explain_document_md',
            'de.explain.document.lg': 'explain_document_lg',
            'de.ner.recognizer': 'entity_recognizer_md',  # default de ner
            'de.ner.recognizer.md': 'entity_recognizer_md',
            'de.ner.recognizer.lg': 'entity_recognizer_lg',
        },
        'it': {
            'it.explain.document': 'explain_document_md',  # it default explain
            'it.explain.document.md': 'explain_document_md',
            'it.explain.document.lg': 'explain_document_lg',
            'it.ner': 'entity_recognizer_md',  # it default ner
            'it.ner.md': 'entity_recognizer_md',
            'it.ner.lg': 'entity_recognizer_lg',

        },
        'no': {
            'no.explain': 'explain_document_sm',  # default no explain
            'no.explain.sm': 'explain_document_sm',
            'no.explain.md': 'explain_document_md',
            'no.explain.lg': 'explain_document_lg',
            'no.ner': 'entity_recognizer_sm',  # default no ner
            'no.ner.sm': 'entity_recognizer_sm',
            'no.ner.md': 'entity_recognizer_md',
            'no.ner.lg': 'entity_recognizer_lg',
        },
        'pl': {
            'pl.explain': 'explain_document_sm',  # defaul pl explain
            'pl.explain.sm': 'explain_document_sm',
            'pl.explain.md': 'explain_document_md',
            'pl.explain.lg': 'explain_document_lg',
            'pl.ner': 'entity_recognizer_sm',  # default pl ner
            'pl.ner.sm': 'entity_recognizer_sm',
            'pl.ner.md': 'entity_recognizer_md',
            'pl.ner.lg': 'entity_recognizer_lg',
        },
        'pt': {
            'pt.explain': 'explain_document_sm',  # default explain pt
            'pt.explain.sm': 'explain_document_sm',
            'pt.explain.md': 'explain_document_md',
            'pt.explain.lg': 'explain_document_lg',
            'pt.ner': 'entity_recognizer_sm',  # default ner pt
            'pt.ner.sm': 'entity_recognizer_sm',
            'pt.ner.md': 'entity_recognizer_md',
            'pt.ner.lg': 'entity_recognizer_lg',

        },
        'ru': {
            'ru.explain': 'explain_document_sm',  # default ru explain
            'ru.explain.sm': 'explain_document_sm',
            'ru.explain.md': 'explain_document_md',
            'ru.explain.lg': 'explain_document_lg',
            'ru.ner': 'entity_recognizer_sm',  # default ru ner
            'ru.ner.sm': 'entity_recognizer_sm',
            'ru.ner.md': 'entity_recognizer_md',
            'ru.ner.lg': 'entity_recognizer_lg',
        },
        'es': {
            'es.explain': 'explain_document_sm',  # es expplain deflaut
            'es.explain.sm': 'explain_document_sm',
            'es.explain.md': 'explain_document_md',
            'es.explain.lg': 'explain_document_lg',
            'es.ner': 'entity_recognizer_sm',  # es ner default
            'es.ner.sm': 'entity_recognizer_sm',
            'es.ner.md': 'entity_recognizer_md',
            'es.ner.lg': 'entity_recognizer_lg',
        },
        'xx': {
            'lang': 'detect_language_375',  # default lang classifer
            'lang.7': 'detect_language_7',  # multi lang detector alias
            'lang.20': 'detect_language_20',  # multi lang detector alias
            'xx.classify.lang': 'detect_language_20',  # multi lang detector default
            'xx.classify.lang.20': 'detect_language_20',  # multi lang detector default
            'xx.classify.lang.7': 'detect_language_7',

            # 2.7 lang classifiers

            'xx.classify.lang': 'detect_language_375',  # default lang classifer
            'xx.classify.lang.21': 'detect_language_21',
            'xx.classify.lang.43': 'detect_language_43',
            'xx.classify.lang.95': 'detect_language_95',
            'xx.classify.lang.99': 'detect_language_99',
            'xx.classify.lang.220': 'detect_language_220',
            'xx.classify.lang.231': 'detect_language_231',
            'xx.classify.lang.bigru': 'detect_language_bigru_21',
            'lang.21': 'detect_language_21',
            'lang.43': 'detect_language_43',
            'lang.95': 'detect_language_95',
            'lang.99': 'detect_language_99',
            'lang.220': 'detect_language_220',
            'lang.231': 'detect_language_231',
            'lang.bigru': 'detect_language_bigru_21',

            # 2.7 marian translate component_list references
            "xx.zlw.translate_to.en": "translate_zlw_en",
            "xx.en.translate_to.ti": "translate_en_ti",
            "xx.bem.translate_to.en": "translate_bem_en",
            "xx.ny.translate_to.en": "translate_ny_en",
            "xx.en.translate_to.lu": "translate_en_lu",
            "xx.taw.translate_to.en": "translate_taw_en",
            "xx.en.translate_to.ga": "translate_en_ga",
            "xx.en.translate_to.sw": "translate_en_sw",
            "xx.war.translate_to.en": "translate_war_en",
            "xx.en.translate_to.hu": "translate_en_hu",
            "xx.pqe.translate_to.en": "translate_pqe_en",
            "xx.en.translate_to.bem": "translate_en_bem",
            "xx.en.translate_to.tiv": "translate_en_tiv",
            "xx.en.translate_to.tll": "translate_en_tll",
            "xx.en.translate_to.cpp": "translate_en_cpp",
            "xx.efi.translate_to.en": "translate_efi_en",
            "xx.en.translate_to.itc": "translate_en_itc",
            "xx.uk.translate_to.en": "translate_uk_en",
            "xx.ee.translate_to.en": "translate_ee_en",
            "xx.nso.translate_to.en": "translate_nso_en",
            "xx.urj.translate_to.en": "translate_urj_en",
            "xx.sv.translate_to.en": "translate_sv_en",
            "xx.en.translate_to.rn": "translate_en_rn",
            "xx.nic.translate_to.en": "translate_nic_en",
            "xx.en.translate_to.bcl": "translate_en_bcl",
            "xx.en.translate_to.lg": "translate_en_lg",
            "xx.kwy.translate_to.en": "translate_kwy_en",
            "xx.en.translate_to.gmq": "translate_en_gmq",
            "xx.en.translate_to.ts": "translate_en_ts",
            "xx.bnt.translate_to.en": "translate_bnt_en",
            "xx.en.translate_to.pis": "translate_en_pis",
            "xx.kwn.translate_to.en": "translate_kwn_en",
            "xx.fi.translate_to.en": "translate_fi_en",
            "xx.en.translate_to.gaa": "translate_en_gaa",
            "xx.afa.translate_to.en": "translate_afa_en",
            "xx.itc.translate_to.en": "translate_itc_en",
            "xx.mh.translate_to.en": "translate_mh_en",
            "xx.en.translate_to.ln": "translate_en_ln",
            "xx.en.translate_to.zls": "translate_en_zls",
            "xx.en.translate_to.cy": "translate_en_cy",
            "xx.et.translate_to.en": "translate_et_en",
            "xx.en.translate_to.dra": "translate_en_dra",
            "xx.en.translate_to.sn": "translate_en_sn",
            "xx.lua.translate_to.en": "translate_lua_en",
            "xx.ln.translate_to.en": "translate_ln_en",
            "xx.ja.translate_to.en": "translate_ja_en",
            "xx.loz.translate_to.en": "translate_loz_en",
            "xx.en.translate_to.bi": "translate_en_bi",
            "xx.mg.translate_to.en": "translate_mg_en",
            "xx.vi.translate_to.en": "translate_vi_en",
            "xx.en.translate_to.vi": "translate_en_vi",
            "xx.hy.translate_to.en": "translate_hy_en",
            "xx.en.translate_to.mt": "translate_en_mt",
            "xx.ng.translate_to.en": "translate_ng_en",
            "xx.mkh.translate_to.en": "translate_mkh_en",
            "xx.en.translate_to.cpf": "translate_en_cpf",
            "xx.wal.translate_to.en": "translate_wal_en",
            "xx.en.translate_to.crs": "translate_en_crs",
            "xx.en.translate_to.zle": "translate_en_zle",
            "xx.en.translate_to.phi": "translate_en_phi",
            "xx.ine.translate_to.en": "translate_ine_en",
            "xx.en.translate_to.pap": "translate_en_pap",
            "xx.en.translate_to.sit": "translate_en_sit",
            "xx.bg.translate_to.en": "translate_bg_en",
            "xx.en.translate_to.ml": "translate_en_ml",
            "xx.en.translate_to.ss": "translate_en_ss",
            "xx.en.translate_to.tw": "translate_en_tw",
            "xx.en.translate_to.gv": "translate_en_gv",
            "xx.ca.translate_to.en": "translate_ca_en",
            "xx.umb.translate_to.en": "translate_umb_en",
            "xx.alv.translate_to.en": "translate_alv_en",
            "xx.gem.translate_to.en": "translate_gem_en",
            "xx.chk.translate_to.en": "translate_chk_en",
            "xx.kqn.translate_to.en": "translate_kqn_en",
            "xx.en.translate_to.afa": "translate_en_afa",
            "xx.gl.translate_to.en": "translate_gl_en",
            "xx.en.translate_to.ber": "translate_en_ber",
            "xx.en.translate_to.ig": "translate_en_ig",
            "xx.ase.translate_to.en": "translate_ase_en",
            "xx.en.translate_to.cs": "translate_en_cs",
            "xx.en.translate_to.pag": "translate_en_pag",
            "xx.en.translate_to.nic": "translate_en_nic",
            "xx.en.translate_to.hil": "translate_en_hil",
            "xx.en.translate_to.cel": "translate_en_cel",
            "xx.nl.translate_to.en": "translate_nl_en",
            "xx.en.translate_to.ho": "translate_en_ho",
            "xx.en.translate_to.inc": "translate_en_inc",
            "xx.ts.translate_to.en": "translate_ts_en",
            "xx.en.translate_to.tl": "translate_en_tl",
            "xx.ve.translate_to.en": "translate_ve_en",
            "xx.ceb.translate_to.en": "translate_ceb_en",
            "xx.en.translate_to.iir": "translate_en_iir",
            "xx.en.translate_to.aav": "translate_en_aav",
            "xx.en.translate_to.bat": "translate_en_bat",
            "xx.en.translate_to.alv": "translate_en_alv",
            "xx.ar.translate_to.en": "translate_ar_en",
            "xx.fiu.translate_to.en": "translate_fiu_en",
            "xx.en.translate_to.eu": "translate_en_eu",
            "xx.is.translate_to.en": "translate_is_en",
            "xx.wa.translate_to.en": "translate_wa_en",
            "xx.en.translate_to.tn": "translate_en_tn",
            "xx.ig.translate_to.en": "translate_ig_en",
            "xx.luo.translate_to.en": "translate_luo_en",
            "xx.en.translate_to.kwn": "translate_en_kwn",
            "xx.niu.translate_to.en": "translate_niu_en",
            "xx.en.translate_to.gl": "translate_en_gl",
            "xx.en.translate_to.ilo": "translate_en_ilo",
            "xx.en.translate_to.ur": "translate_en_ur",
            "xx.cus.translate_to.en": "translate_cus_en",
            "xx.phi.translate_to.en": "translate_phi_en",
            "xx.en.translate_to.loz": "translate_en_loz",
            "xx.tiv.translate_to.en": "translate_tiv_en",
            "xx.en.translate_to.id": "translate_en_id",
            "xx.zle.translate_to.en": "translate_zle_en",
            "xx.en.translate_to.mfe": "translate_en_mfe",
            "xx.id.translate_to.en": "translate_id_en",
            "xx.lv.translate_to.en": "translate_lv_en",
            "xx.en.translate_to.pon": "translate_en_pon",
            "xx.en.translate_to.sq": "translate_en_sq",
            "xx.tum.translate_to.en": "translate_tum_en",
            "xx.pl.translate_to.en": "translate_pl_en",
            "xx.xh.translate_to.en": "translate_xh_en",
            "xx.kab.translate_to.en": "translate_kab_en",
            "xx.tvl.translate_to.en": "translate_tvl_en",
            "xx.pa.translate_to.en": "translate_pa_en",
            "xx.iso.translate_to.en": "translate_iso_en",
            "xx.ho.translate_to.en": "translate_ho_en",
            "xx.cel.translate_to.en": "translate_cel_en",
            "xx.en.translate_to.om": "translate_en_om",
            "xx.kg.translate_to.en": "translate_kg_en",
            "xx.en.translate_to.lus": "translate_en_lus",
            "xx.om.translate_to.en": "translate_om_en",
            "xx.lun.translate_to.en": "translate_lun_en",
            "xx.crs.translate_to.en": "translate_crs_en",
            "xx.cy.translate_to.en": "translate_cy_en",
            "xx.tll.translate_to.en": "translate_tll_en",
            "xx.gil.translate_to.en": "translate_gil_en",
            "xx.en.translate_to.mkh": "translate_en_mkh",
            "xx.en.translate_to.euq": "translate_en_euq",
            "xx.en.translate_to.sem": "translate_en_sem",
            "xx.cs.translate_to.en": "translate_cs_en",
            "xx.en.translate_to.sk": "translate_en_sk",
            "xx.en.translate_to.bzs": "translate_en_bzs",
            "xx.en.translate_to.trk": "translate_en_trk",
            "xx.cpf.translate_to.en": "translate_cpf_en",
            "xx.bi.translate_to.en": "translate_bi_en",
            "xx.en.translate_to.mul": "translate_en_mul",
            "xx.en.translate_to.gmw": "translate_en_gmw",
            "xx.en.translate_to.fi": "translate_en_fi",
            "xx.en.translate_to.zlw": "translate_en_zlw",
            "xx.lg.translate_to.en": "translate_lg_en",
            "xx.en.translate_to.pqe": "translate_en_pqe",
            "xx.en.translate_to.xh": "translate_en_xh",
            "xx.en.translate_to.hi": "translate_en_hi",
            "xx.en.translate_to.nyk": "translate_en_nyk",
            "xx.th.translate_to.en": "translate_th_en",
            "xx.en.translate_to.umb": "translate_en_umb",
            "xx.en.translate_to.af": "translate_en_af",
            "xx.tpi.translate_to.en": "translate_tpi_en",
            "xx.ti.translate_to.en": "translate_ti_en",
            "xx.en.translate_to.chk": "translate_en_chk",
            "xx.mos.translate_to.en": "translate_mos_en",
            "xx.en.translate_to.sm": "translate_en_sm",
            "xx.pon.translate_to.en": "translate_pon_en",
            "xx.en.translate_to.bg": "translate_en_bg",
            "xx.en.translate_to.ny": "translate_en_ny",
            "xx.kl.translate_to.en": "translate_kl_en",
            "xx.en.translate_to.hy": "translate_en_hy",
            "xx.nyk.translate_to.en": "translate_nyk_en",
            "xx.it.translate_to.en": "translate_it_en",
            "xx.mt.translate_to.en": "translate_mt_en",
            "xx.pap.translate_to.en": "translate_pap_en",
            "xx.srn.translate_to.en": "translate_srn_en",
            "xx.da.translate_to.en": "translate_da_en",
            "xx.en.translate_to.lue": "translate_en_lue",
            "xx.rn.translate_to.en": "translate_rn_en",
            "xx.en.translate_to.tut": "translate_en_tut",
            "xx.lu.translate_to.en": "translate_lu_en",
            "xx.ru.translate_to.en": "translate_ru_en",
            "xx.en.translate_to.toi": "translate_en_toi",
            "xx.ccs.translate_to.en": "translate_ccs_en",
            "xx.aav.translate_to.en": "translate_aav_en",
            "xx.en.translate_to.ha": "translate_en_ha",
            "xx.rnd.translate_to.en": "translate_rnd_en",
            "xx.de.translate_to.en": "translate_de_en",
            "xx.en.translate_to.luo": "translate_en_luo",
            "xx.fr.translate_to.en": "translate_fr_en",
            "xx.bcl.translate_to.en": "translate_bcl_en",
            "xx.ilo.translate_to.en": "translate_ilo_en",
            "xx.en.translate_to.jap": "translate_en_jap",
            "xx.en.translate_to.fj": "translate_en_fj",
            "xx.sk.translate_to.en": "translate_sk_en",
            "xx.bzs.translate_to.en": "translate_bzs_en",
            "xx.ka.translate_to.en": "translate_ka_en",
            "xx.ko.translate_to.en": "translate_ko_en",
            "xx.sq.translate_to.en": "translate_sq_en",
            "xx.mul.translate_to.en": "translate_mul_en",
            "xx.en.translate_to.run": "translate_en_run",
            "xx.sn.translate_to.en": "translate_sn_en",
            "xx.en.translate_to.pqw": "translate_en_pqw",
            "xx.ss.translate_to.en": "translate_ss_en",
            "xx.sm.translate_to.en": "translate_sm_en",
            "xx.en.translate_to.kwy": "translate_en_kwy",
            "xx.jap.translate_to.en": "translate_jap_en",
            "xx.en.translate_to.kqn": "translate_en_kqn",
            "xx.mk.translate_to.en": "translate_mk_en",
            "xx.hu.translate_to.en": "translate_hu_en",
            "xx.en.translate_to.map": "translate_en_map",
            "xx.yo.translate_to.en": "translate_yo_en",
            "xx.hi.translate_to.en": "translate_hi_en",
            "xx.iir.translate_to.en": "translate_iir_en",
            "xx.en.translate_to.guw": "translate_en_guw",
            "xx.en.translate_to.es": "translate_en_es",
            "xx.en.translate_to.gem": "translate_en_gem",
            "xx.en.translate_to.ht": "translate_en_ht",
            "xx.zls.translate_to.en": "translate_zls_en",
            "xx.sg.translate_to.en": "translate_sg_en",
            "xx.en.translate_to.ty": "translate_en_ty",
            "xx.en.translate_to.lun": "translate_en_lun",
            "xx.guw.translate_to.en": "translate_guw_en",
            "xx.trk.translate_to.en": "translate_trk_en",
            "xx.mfe.translate_to.en": "translate_mfe_en",
            "xx.en.translate_to.nl": "translate_en_nl",
            "xx.en.translate_to.sv": "translate_en_sv",
            "xx.ber.translate_to.en": "translate_ber_en",
            "xx.to.translate_to.en": "translate_to_en",
            "xx.en.translate_to.da": "translate_en_da",
            "xx.en.translate_to.urj": "translate_en_urj",
            "xx.inc.translate_to.en": "translate_inc_en",
            "xx.wls.translate_to.en": "translate_wls_en",
            "xx.pis.translate_to.en": "translate_pis_en",
            "xx.en.translate_to.mh": "translate_en_mh",
            "xx.en.translate_to.iso": "translate_en_iso",
            "xx.en.translate_to.ru": "translate_en_ru",
            "xx.swc.translate_to.en": "translate_swc_en",
            "xx.en.translate_to.rnd": "translate_en_rnd",
            "xx.en.translate_to.nso": "translate_en_nso",
            "xx.en.translate_to.swc": "translate_en_swc",
            "xx.ur.translate_to.en": "translate_ur_en",
            "xx.en.translate_to.ro": "translate_en_ro",
            "xx.ml.translate_to.en": "translate_ml_en",
            "xx.grk.translate_to.en": "translate_grk_en",
            "xx.rw.translate_to.en": "translate_rw_en",
            "xx.tr.translate_to.en": "translate_tr_en",
            "xx.gmq.translate_to.en": "translate_gmq_en",
            "xx.euq.translate_to.en": "translate_euq_en",
            "xx.en.translate_to.tdt": "translate_en_tdt",
            "xx.eo.translate_to.en": "translate_eo_en",
            "xx.cau.translate_to.en": "translate_cau_en",
            "xx.en.translate_to.mk": "translate_en_mk",
            "xx.en.translate_to.mr": "translate_en_mr",
            "xx.af.translate_to.en": "translate_af_en",
            "xx.run.translate_to.en": "translate_run_en",
            "xx.en.translate_to.ng": "translate_en_ng",
            "xx.en.translate_to.mg": "translate_en_mg",
            "xx.en.translate_to.bnt": "translate_en_bnt",
            "xx.en.translate_to.kj": "translate_en_kj",
            "xx.en.translate_to.he": "translate_en_he",
            "xx.en.translate_to.sla": "translate_en_sla",
            "xx.en.translate_to.el": "translate_en_el",
            "xx.ht.translate_to.en": "translate_ht_en",
            "xx.en.translate_to.et": "translate_en_et",
            "xx.en.translate_to.poz": "translate_en_poz",
            "xx.roa.translate_to.en": "translate_roa_en",
            "xx.en.translate_to.de": "translate_en_de",
            "xx.fj.translate_to.en": "translate_fj_en",
            "xx.en.translate_to.lua": "translate_en_lua",
            "xx.en.translate_to.kg": "translate_en_kg",
            "xx.en.translate_to.fiu": "translate_en_fiu",
            "xx.gv.translate_to.en": "translate_gv_en",
            "xx.cpp.translate_to.en": "translate_cpp_en",
            "xx.en.translate_to.tpi": "translate_en_tpi",
            "xx.en.translate_to.grk": "translate_en_grk",
            "xx.en.translate_to.sal": "translate_en_sal",
            "xx.en.translate_to.niu": "translate_en_niu",
            "xx.en.translate_to.ca": "translate_en_ca",
            "xx.en.translate_to.roa": "translate_en_roa",
            "xx.sal.translate_to.en": "translate_sal_en",
            "xx.ha.translate_to.en": "translate_ha_en",
            "xx.sem.translate_to.en": "translate_sem_en",
            "xx.tn.translate_to.en": "translate_tn_en",
            "xx.gaa.translate_to.en": "translate_gaa_en",
            "xx.en.translate_to.to": "translate_en_to",
            "xx.en.translate_to.ee": "translate_en_ee",
            "xx.toi.translate_to.en": "translate_toi_en",
            "xx.lue.translate_to.en": "translate_lue_en",
            "xx.en.translate_to.rw": "translate_en_rw",
            "xx.st.translate_to.en": "translate_st_en",
            "xx.dra.translate_to.en": "translate_dra_en",
            "xx.en.translate_to.mos": "translate_en_mos",
            "xx.eu.translate_to.en": "translate_eu_en",
            "xx.lus.translate_to.en": "translate_lus_en",
            "xx.sla.translate_to.en": "translate_sla_en",
            "xx.en.translate_to.ceb": "translate_en_ceb",
            "xx.art.translate_to.en": "translate_art_en",
            "xx.bat.translate_to.en": "translate_bat_en",
            "xx.az.translate_to.en": "translate_az_en",
            "xx.en.translate_to.ine": "translate_en_ine",
            "xx.pag.translate_to.en": "translate_pag_en",
            "xx.yap.translate_to.en": "translate_yap_en",
            "xx.en.translate_to.eo": "translate_en_eo",
            "xx.en.translate_to.tvl": "translate_en_tvl",
            "xx.kj.translate_to.en": "translate_kj_en",
            "xx.en.translate_to.st": "translate_en_st",
            "xx.gmw.translate_to.en": "translate_gmw_en",
            "xx.mr.translate_to.en": "translate_mr_en",
            "xx.es.translate_to.en": "translate_es_en",
            "xx.en.translate_to.sg": "translate_en_sg",
            "xx.en.translate_to.cus": "translate_en_cus",
            "xx.en.translate_to.it": "translate_en_it",
            "xx.ga.translate_to.en": "translate_ga_en",
            "xx.bn.translate_to.en": "translate_bn_en",
            "xx.en.translate_to.efi": "translate_en_efi",
            "xx.en.translate_to.az": "translate_en_az",
            "xx.en.translate_to.zh": "translate_en_zh",
            "xx.en.translate_to.is": "translate_en_is",
            "xx.zh.translate_to.en": "translate_zh_en",
            "xx.hil.translate_to.en": "translate_hil_en",
            "xx.en.translate_to.ar": "translate_en_ar",
            "xx.tl.translate_to.en": "translate_tl_en",
            "xx.en.translate_to.gil": "translate_en_gil",
            "xx.en.translate_to.uk": "translate_en_uk",
            "xx.en.translate_to.fr": "translate_en_fr",
            # 3.1 Translator Pipe references

            "xx.es.translate_to.af": "translate_af_es",
            "xx.nl.translate_to.af": "translate_af_nl",
            "xx.eo.translate_to.af": "translate_af_eo",
            "xx.afa.translate_to.afa": "translate_afa_afa",
            "xx.sv.translate_to.af": "translate_af_sv",
            "xx.es.translate_to.aed": "translate_aed_es",
            "xx.fr.translate_to.af": "translate_af_fr",
            "xx.fi.translate_to.af": "translate_af_fi",
            "xx.de.translate_to.af": "translate_af_de",
            "xx.ru.translate_to.af": "translate_af_ru",
            "xx.es.translate_to.az": "translate_az_es",
            "xx.de.translate_to.bcl": "translate_bcl_de",
            "xx.sv.translate_to.bem": "translate_bem_sv",
            "xx.tr.translate_to.az": "translate_az_tr",
            "xx.sv.translate_to.bcl": "translate_bcl_sv",
            "xx.es.translate_to.ar": "translate_ar_es",
            "xx.es.translate_to.bem": "translate_bem_es",
            "xx.ru.translate_to.ar": "translate_ar_ru",
            "xx.es.translate_to.be": "translate_be_es",
            "xx.fr.translate_to.bem": "translate_bem_fr",
            "xx.he.translate_to.ar": "translate_ar_he",
            "xx.es.translate_to.bcl": "translate_bcl_es",
            "xx.es.translate_to.ase": "translate_ase_es",
            "xx.de.translate_to.ar": "translate_ar_de",
            "xx.pl.translate_to.ar": "translate_ar_pl",
            "xx.tr.translate_to.ar": "translate_ar_tr",
            "xx.sv.translate_to.ase": "translate_ase_sv",
            "xx.fi.translate_to.bcl": "translate_bcl_fi",
            "xx.el.translate_to.ar": "translate_ar_el",
            "xx.fr.translate_to.bcl": "translate_bcl_fr",
            "xx.fi.translate_to.bem": "translate_bem_fi",
            "xx.fr.translate_to.ase": "translate_ase_fr",
            "xx.fr.translate_to.ar": "translate_ar_fr",
            "xx.eo.translate_to.ar": "translate_ar_eo",
            "xx.it.translate_to.ar": "translate_ar_it",
            "xx.sv.translate_to.am": "translate_am_sv",
            "xx.de.translate_to.ase": "translate_ase_de",
            "xx.uk.translate_to.bg": "translate_bg_uk",
            "xx.it.translate_to.bg": "translate_bg_it",
            "xx.sv.translate_to.bzs": "translate_bzs_sv",
            "xx.pt.translate_to.ca": "translate_ca_pt",
            "xx.es.translate_to.ber": "translate_ber_es",
            "xx.it.translate_to.ca": "translate_ca_it",
            "xx.eo.translate_to.bg": "translate_bg_eo",
            "xx.sv.translate_to.ceb": "translate_ceb_sv",
            "xx.fr.translate_to.bi": "translate_bi_fr",
            "xx.sv.translate_to.bg": "translate_bg_sv",
            "xx.fr.translate_to.ca": "translate_ca_fr",
            "xx.tr.translate_to.bg": "translate_bg_tr",
            "xx.es.translate_to.ceb": "translate_ceb_es",
            "xx.de.translate_to.ca": "translate_ca_de",
            "xx.fi.translate_to.ceb": "translate_ceb_fi",
            "xx.es.translate_to.ca": "translate_ca_es",
            "xx.es.translate_to.bg": "translate_bg_es",
            "xx.uk.translate_to.ca": "translate_ca_uk",
            "xx.sv.translate_to.bi": "translate_bi_sv",
            "xx.sv.translate_to.chk": "translate_chk_sv",
            "xx.fr.translate_to.ceb": "translate_ceb_fr",
            "xx.es.translate_to.bzs": "translate_bzs_es",
            "xx.de.translate_to.crs": "translate_crs_de",
            "xx.nl.translate_to.ca": "translate_ca_nl",
            "xx.es.translate_to.chk": "translate_chk_es",
            "xx.fr.translate_to.ber": "translate_ber_fr",
            "xx.fi.translate_to.bzs": "translate_bzs_fi",
            "xx.es.translate_to.crs": "translate_crs_es",
            "xx.fi.translate_to.bg": "translate_bg_fi",
            "xx.cpp.translate_to.cpp": "translate_cpp_cpp",
            "xx.de.translate_to.bg": "translate_bg_de",
            "xx.es.translate_to.bi": "translate_bi_es",
            "xx.fr.translate_to.bzs": "translate_bzs_fr",
            "xx.fr.translate_to.bg": "translate_bg_fr",
            "xx.fr.translate_to.chk": "translate_chk_fr",
            "xx.ru.translate_to.bg": "translate_bg_ru",
            "xx.fi.translate_to.cs": "translate_cs_fi",
            "xx.ha.translate_to.de": "translate_de_ha",
            "xx.ee.translate_to.de": "translate_de_ee",
            "xx.eo.translate_to.de": "translate_de_eo",
            "xx.gil.translate_to.de": "translate_de_gil",
            "xx.fj.translate_to.de": "translate_de_fj",
            "xx.fr.translate_to.de": "translate_de_fr",
            "xx.sv.translate_to.cs": "translate_cs_sv",
            "xx.es.translate_to.csn": "translate_csn_es",
            "xx.ru.translate_to.da": "translate_da_ru",
            "xx.no.translate_to.da": "translate_da_no",
            "xx.iso.translate_to.de": "translate_de_iso",
            "xx.eu.translate_to.de": "translate_de_eu",
            "xx.nl.translate_to.de": "translate_de_nl",
            "xx.ilo.translate_to.de": "translate_de_ilo",
            "xx.hr.translate_to.de": "translate_de_hr",
            "xx.mt.translate_to.de": "translate_de_mt",
            "xx.es.translate_to.da": "translate_da_es",
            "xx.ar.translate_to.de": "translate_de_ar",
            "xx.is.translate_to.de": "translate_de_is",
            "xx.sv.translate_to.crs": "translate_crs_sv",
            "xx.fr.translate_to.da": "translate_da_fr",
            "xx.gaa.translate_to.de": "translate_de_gaa",
            "xx.niu.translate_to.de": "translate_de_niu",
            "xx.da.translate_to.de": "translate_de_da",
            "xx.de.translate_to.da": "translate_da_de",
            "xx.ase.translate_to.de": "translate_de_ase",
            "xx.ig.translate_to.de": "translate_de_ig",
            "xx.lua.translate_to.de": "translate_de_lua",
            "xx.de.translate_to.de": "translate_de_de",
            "xx.bi.translate_to.de": "translate_de_bi",
            "xx.fr.translate_to.cs": "translate_cs_fr",
            "xx.ms.translate_to.de": "translate_de_ms",
            "xx.fi.translate_to.crs": "translate_crs_fi",
            "xx.eo.translate_to.da": "translate_da_eo",
            "xx.af.translate_to.de": "translate_de_af",
            "xx.uk.translate_to.cs": "translate_cs_uk",
            "xx.bg.translate_to.de": "translate_de_bg",
            "xx.no.translate_to.de": "translate_de_no",
            "xx.de.translate_to.cs": "translate_cs_de",
            "xx.it.translate_to.de": "translate_de_it",
            "xx.ho.translate_to.de": "translate_de_ho",
            "xx.ln.translate_to.de": "translate_de_ln",
            "xx.guw.translate_to.de": "translate_de_guw",
            "xx.efi.translate_to.de": "translate_de_efi",
            "xx.hil.translate_to.de": "translate_de_hil",
            "xx.cs.translate_to.de": "translate_de_cs",
            "xx.es.translate_to.csg": "translate_csg_es",
            "xx.es.translate_to.de": "translate_de_es",
            "xx.bcl.translate_to.de": "translate_de_bcl",
            "xx.ht.translate_to.de": "translate_de_ht",
            "xx.loz.translate_to.de": "translate_de_loz",
            "xx.kg.translate_to.de": "translate_de_kg",
            "xx.eo.translate_to.cs": "translate_cs_eo",
            "xx.el.translate_to.de": "translate_de_el",
            "xx.fi.translate_to.de": "translate_de_fi",
            "xx.he.translate_to.de": "translate_de_he",
            "xx.bzs.translate_to.de": "translate_de_bzs",
            "xx.fr.translate_to.crs": "translate_crs_fr",
            "xx.crs.translate_to.de": "translate_de_crs",
            "xx.fi.translate_to.da": "translate_da_fi",
            "xx.hu.translate_to.de": "translate_de_hu",
            "xx.et.translate_to.de": "translate_de_et",
            "xx.lt.translate_to.de": "translate_de_lt",
            "xx.ca.translate_to.de": "translate_de_ca",
            "xx.pl.translate_to.de": "translate_de_pl",
            "xx.sv.translate_to.el": "translate_el_sv",
            "xx.de.translate_to.ee": "translate_ee_de",
            "xx.pag.translate_to.de": "translate_de_pag",
            "xx.ar.translate_to.el": "translate_el_ar",
            "xx.nso.translate_to.de": "translate_de_nso",
            "xx.pon.translate_to.de": "translate_de_pon",
            "xx.pap.translate_to.de": "translate_de_pap",
            "xx.fr.translate_to.efi": "translate_efi_fr",
            "xx.pis.translate_to.de": "translate_de_pis",
            "xx.de.translate_to.efi": "translate_efi_de",
            "xx.eo.translate_to.el": "translate_el_eo",
            "xx.fi.translate_to.ee": "translate_ee_fi",
            "xx.es.translate_to.ee": "translate_ee_es",
            "xx.fr.translate_to.ee": "translate_ee_fr",
            "xx.fi.translate_to.efi": "translate_efi_fi",
            "xx.fr.translate_to.el": "translate_el_fr",
            "xx.tl.translate_to.de": "translate_de_tl",
            "xx.ny.translate_to.de": "translate_de_ny",
            "xx.uk.translate_to.de": "translate_de_uk",
            "xx.sv.translate_to.efi": "translate_efi_sv",
            "xx.sv.translate_to.ee": "translate_ee_sv",
            "xx.vi.translate_to.de": "translate_de_vi",
            "xx.fi.translate_to.el": "translate_el_fi",
            "xx.cs.translate_to.eo": "translate_eo_cs",
            "xx.bzs.translate_to.es": "translate_es_bzs",
            "xx.he.translate_to.eo": "translate_eo_he",
            "xx.hu.translate_to.eo": "translate_eo_hu",
            "xx.ro.translate_to.eo": "translate_eo_ro",
            "xx.ber.translate_to.es": "translate_es_ber",
            "xx.ca.translate_to.es": "translate_es_ca",
            "xx.bcl.translate_to.es": "translate_es_bcl",
            "xx.ceb.translate_to.es": "translate_es_ceb",
            "xx.da.translate_to.eo": "translate_eo_da",
            "xx.bi.translate_to.es": "translate_es_bi",
            "xx.ee.translate_to.es": "translate_es_ee",
            "xx.ru.translate_to.eo": "translate_eo_ru",
            "xx.csg.translate_to.es": "translate_es_csg",
            "xx.fi.translate_to.eo": "translate_eo_fi",
            "xx.it.translate_to.eo": "translate_eo_it",
            "xx.nl.translate_to.eo": "translate_eo_nl",
            "xx.et.translate_to.es": "translate_es_et",
            "xx.bg.translate_to.es": "translate_es_bg",
            "xx.de.translate_to.eo": "translate_eo_de",
            "xx.ar.translate_to.es": "translate_es_ar",
            "xx.cs.translate_to.es": "translate_es_cs",
            "xx.aed.translate_to.es": "translate_es_aed",
            "xx.ase.translate_to.es": "translate_es_ase",
            "xx.el.translate_to.es": "translate_es_el",
            "xx.eo.translate_to.es": "translate_es_eo",
            "xx.af.translate_to.eo": "translate_eo_af",
            "xx.af.translate_to.es": "translate_es_af",
            "xx.pl.translate_to.eo": "translate_eo_pl",
            "xx.de.translate_to.es": "translate_es_de",
            "xx.es.translate_to.eo": "translate_eo_es",
            "xx.da.translate_to.es": "translate_es_da",
            "xx.crs.translate_to.es": "translate_es_crs",
            "xx.pt.translate_to.eo": "translate_eo_pt",
            "xx.eu.translate_to.es": "translate_es_eu",
            "xx.es.translate_to.es": "translate_es_es",
            "xx.csn.translate_to.es": "translate_es_csn",
            "xx.sv.translate_to.eo": "translate_eo_sv",
            "xx.efi.translate_to.es": "translate_es_efi",
            "xx.sh.translate_to.eo": "translate_eo_sh",
            "xx.bg.translate_to.eo": "translate_eo_bg",
            "xx.fr.translate_to.eo": "translate_eo_fr",
            "xx.el.translate_to.eo": "translate_eo_el",
            "xx.pl.translate_to.es": "translate_es_pl",
            "xx.ro.translate_to.es": "translate_es_ro",
            "xx.is.translate_to.es": "translate_es_is",
            "xx.ln.translate_to.es": "translate_es_ln",
            "xx.to.translate_to.es": "translate_es_to",
            "xx.no.translate_to.es": "translate_es_no",
            "xx.nl.translate_to.es": "translate_es_nl",
            "xx.pag.translate_to.es": "translate_es_pag",
            "xx.tvl.translate_to.es": "translate_es_tvl",
            "xx.fr.translate_to.es": "translate_es_fr",
            "xx.he.translate_to.es": "translate_es_he",
            "xx.lus.translate_to.es": "translate_es_lus",
            "xx.hil.translate_to.es": "translate_es_hil",
            "xx.ny.translate_to.es": "translate_es_ny",
            "xx.pap.translate_to.es": "translate_es_pap",
            "xx.id.translate_to.es": "translate_es_id",
            "xx.wls.translate_to.es": "translate_es_wls",
            "xx.gaa.translate_to.es": "translate_es_gaa",
            "xx.nso.translate_to.es": "translate_es_nso",
            "xx.mk.translate_to.es": "translate_es_mk",
            "xx.mt.translate_to.es": "translate_es_mt",
            "xx.pis.translate_to.es": "translate_es_pis",
            "xx.gl.translate_to.es": "translate_es_gl",
            "xx.sn.translate_to.es": "translate_es_sn",
            "xx.hr.translate_to.es": "translate_es_hr",
            "xx.swc.translate_to.es": "translate_es_swc",
            "xx.lua.translate_to.es": "translate_es_lua",
            "xx.it.translate_to.es": "translate_es_it",
            "xx.fj.translate_to.es": "translate_es_fj",
            "xx.gil.translate_to.es": "translate_es_gil",
            "xx.sm.translate_to.es": "translate_es_sm",
            "xx.guw.translate_to.es": "translate_es_guw",
            "xx.kg.translate_to.es": "translate_es_kg",
            "xx.tl.translate_to.es": "translate_es_tl",
            "xx.rn.translate_to.es": "translate_es_rn",
            "xx.mfs.translate_to.es": "translate_es_mfs",
            "xx.iso.translate_to.es": "translate_es_iso",
            "xx.loz.translate_to.es": "translate_es_loz",
            "xx.tpi.translate_to.es": "translate_es_tpi",
            "xx.ha.translate_to.es": "translate_es_ha",
            "xx.ht.translate_to.es": "translate_es_ht",
            "xx.uk.translate_to.es": "translate_es_uk",
            "xx.tw.translate_to.es": "translate_es_tw",
            "xx.st.translate_to.es": "translate_es_st",
            "xx.sg.translate_to.es": "translate_es_sg",
            "xx.ilo.translate_to.es": "translate_es_ilo",
            "xx.ru.translate_to.es": "translate_es_ru",
            "xx.yo.translate_to.es": "translate_es_yo",
            "xx.pon.translate_to.es": "translate_es_pon",
            "xx.niu.translate_to.es": "translate_es_niu",
            "xx.lt.translate_to.es": "translate_es_lt",
            "xx.ty.translate_to.es": "translate_es_ty",
            "xx.ig.translate_to.es": "translate_es_ig",
            "xx.tzo.translate_to.es": "translate_es_tzo",
            "xx.rw.translate_to.es": "translate_es_rw",
            "xx.war.translate_to.es": "translate_es_war",
            "xx.tll.translate_to.es": "translate_es_tll",
            "xx.prl.translate_to.es": "translate_es_prl",
            "xx.xh.translate_to.es": "translate_es_xh",
            "xx.yua.translate_to.es": "translate_es_yua",
            "xx.ho.translate_to.es": "translate_es_ho",
            "xx.ve.translate_to.es": "translate_es_ve",
            "xx.sl.translate_to.es": "translate_es_sl",
            "xx.tn.translate_to.es": "translate_es_tn",
            "xx.vi.translate_to.es": "translate_es_vi",
            "xx.srn.translate_to.es": "translate_es_srn",
            "xx.fi.translate_to.es": "translate_es_fi",
            "xx.lua.translate_to.fi": "translate_fi_lua",
            "xx.ny.translate_to.fi": "translate_fi_ny",
            "xx.pon.translate_to.fi": "translate_fi_pon",
            "xx.crs.translate_to.fi": "translate_fi_crs",
            "xx.nso.translate_to.fi": "translate_fi_nso",
            "xx.iso.translate_to.fi": "translate_fi_iso",
            "xx.kqn.translate_to.fi": "translate_fi_kqn",
            "xx.gaa.translate_to.fi": "translate_fi_gaa",
            "xx.ru.translate_to.eu": "translate_eu_ru",
            "xx.eo.translate_to.fi": "translate_fi_eo",
            "xx.ig.translate_to.fi": "translate_fi_ig",
            "xx.bem.translate_to.fi": "translate_fi_bem",
            "xx.es.translate_to.et": "translate_et_es",
            "xx.fj.translate_to.fi": "translate_fi_fj",
            "xx.et.translate_to.fi": "translate_fi_et",
            "xx.bcl.translate_to.fi": "translate_fi_bcl",
            "xx.fi.translate_to.fi": "translate_fi_fi",
            "xx.el.translate_to.fi": "translate_fi_el",
            "xx.efi.translate_to.fi": "translate_fi_efi",
            "xx.ht.translate_to.fi": "translate_fi_ht",
            "xx.ceb.translate_to.fi": "translate_fi_ceb",
            "xx.lg.translate_to.fi": "translate_fi_lg",
            "xx.pap.translate_to.fi": "translate_fi_pap",
            "xx.kg.translate_to.fi": "translate_fi_kg",
            "xx.ee.translate_to.fi": "translate_fi_ee",
            "xx.lv.translate_to.fi": "translate_fi_lv",
            "xx.fr.translate_to.et": "translate_et_fr",
            "xx.de.translate_to.et": "translate_et_de",
            "xx.bzs.translate_to.fi": "translate_fi_bzs",
            "xx.mos.translate_to.fi": "translate_fi_mos",
            "xx.zh.translate_to.es": "translate_es_zh",
            "xx.id.translate_to.fi": "translate_fi_id",
            "xx.gil.translate_to.fi": "translate_fi_gil",
            "xx.pis.translate_to.fi": "translate_fi_pis",
            "xx.no.translate_to.fi": "translate_fi_no",
            "xx.it.translate_to.fi": "translate_fi_it",
            "xx.es.translate_to.fi": "translate_fi_es",
            "xx.ha.translate_to.fi": "translate_fi_ha",
            "xx.fr.translate_to.fi": "translate_fi_fr",
            "xx.de.translate_to.fi": "translate_fi_de",
            "xx.bg.translate_to.fi": "translate_fi_bg",
            "xx.zai.translate_to.es": "translate_es_zai",
            "xx.hil.translate_to.fi": "translate_fi_hil",
            "xx.cs.translate_to.fi": "translate_fi_cs",
            "xx.es.translate_to.eu": "translate_eu_es",
            "xx.ilo.translate_to.fi": "translate_fi_ilo",
            "xx.pag.translate_to.fi": "translate_fi_pag",
            "xx.ln.translate_to.fi": "translate_fi_ln",
            "xx.sv.translate_to.et": "translate_et_sv",
            "xx.niu.translate_to.fi": "translate_fi_niu",
            "xx.hr.translate_to.fi": "translate_fi_hr",
            "xx.de.translate_to.eu": "translate_eu_de",
            "xx.lus.translate_to.fi": "translate_fi_lus",
            "xx.ru.translate_to.et": "translate_et_ru",
            "xx.af.translate_to.fi": "translate_fi_af",
            "xx.mh.translate_to.fi": "translate_fi_mh",
            "xx.guw.translate_to.fi": "translate_fi_guw",
            "xx.mfe.translate_to.fi": "translate_fi_mfe",
            "xx.ho.translate_to.fi": "translate_fi_ho",
            "xx.fse.translate_to.fi": "translate_fi_fse",
            "xx.lu.translate_to.fi": "translate_fi_lu",
            "xx.hu.translate_to.fi": "translate_fi_hu",
            "xx.mk.translate_to.fi": "translate_fi_mk",
            "xx.nl.translate_to.fi": "translate_fi_nl",
            "xx.mg.translate_to.fi": "translate_fi_mg",
            "xx.mt.translate_to.fi": "translate_fi_mt",
            "xx.he.translate_to.fi": "translate_fi_he",
            "xx.fi.translate_to.et": "translate_et_fi",
            "xx.is.translate_to.fi": "translate_fi_is",
            "xx.lue.translate_to.fi": "translate_fi_lue",
            "xx.guw.translate_to.fr": "translate_fr_guw",
            "xx.ber.translate_to.fr": "translate_fr_ber",
            "xx.uk.translate_to.fi": "translate_fi_uk",
            "xx.efi.translate_to.fr": "translate_fr_efi",
            "xx.tr.translate_to.fi": "translate_fi_tr",
            "xx.tn.translate_to.fi": "translate_fi_tn",
            "xx.es.translate_to.fr": "translate_fr_es",
            "xx.srn.translate_to.fi": "translate_fi_srn",
            "xx.bcl.translate_to.fr": "translate_fr_bcl",
            "xx.sl.translate_to.fi": "translate_fi_sl",
            "xx.ht.translate_to.fr": "translate_fr_ht",
            "xx.zne.translate_to.fi": "translate_fi_zne",
            "xx.de.translate_to.fr": "translate_fr_de",
            "xx.war.translate_to.fi": "translate_fi_war",
            "xx.tpi.translate_to.fi": "translate_fi_tpi",
            "xx.ca.translate_to.fr": "translate_fr_ca",
            "xx.yap.translate_to.fi": "translate_fi_yap",
            "xx.sn.translate_to.fi": "translate_fi_sn",
            "xx.hr.translate_to.fr": "translate_fr_hr",
            "xx.gil.translate_to.fr": "translate_fr_gil",
            "xx.id.translate_to.fr": "translate_fr_id",
            "xx.sv.translate_to.fi": "translate_fi_sv",
            "xx.toi.translate_to.fi": "translate_fi_toi",
            "xx.sk.translate_to.fi": "translate_fi_sk",
            "xx.he.translate_to.fr": "translate_fr_he",
            "xx.sq.translate_to.fi": "translate_fi_sq",
            "xx.ve.translate_to.fi": "translate_fi_ve",
            "xx.tw.translate_to.fi": "translate_fi_tw",
            "xx.tvl.translate_to.fi": "translate_fi_tvl",
            "xx.hil.translate_to.fr": "translate_fr_hil",
            "xx.sw.translate_to.fi": "translate_fi_sw",
            "xx.eo.translate_to.fr": "translate_fr_eo",
            "xx.xh.translate_to.fi": "translate_fi_xh",
            "xx.bi.translate_to.fr": "translate_fr_bi",
            "xx.ru.translate_to.fi": "translate_fi_ru",
            "xx.ceb.translate_to.fr": "translate_fr_ceb",
            "xx.ig.translate_to.fr": "translate_fr_ig",
            "xx.el.translate_to.fr": "translate_fr_el",
            "xx.sm.translate_to.fi": "translate_fi_sm",
            "xx.to.translate_to.fi": "translate_fi_to",
            "xx.ase.translate_to.fr": "translate_fr_ase",
            "xx.yo.translate_to.fi": "translate_fi_yo",
            "xx.sg.translate_to.fi": "translate_fi_sg",
            "xx.rw.translate_to.fi": "translate_fi_rw",
            "xx.ts.translate_to.fi": "translate_fi_ts",
            "xx.wls.translate_to.fi": "translate_fi_wls",
            "xx.ho.translate_to.fr": "translate_fr_ho",
            "xx.tll.translate_to.fi": "translate_fi_tll",
            "xx.st.translate_to.fi": "translate_fi_st",
            "xx.fiu.translate_to.fiu": "translate_fiu_fiu",
            "xx.ro.translate_to.fi": "translate_fi_ro",
            "xx.tiv.translate_to.fi": "translate_fi_tiv",
            "xx.ha.translate_to.fr": "translate_fr_ha",
            "xx.ee.translate_to.fr": "translate_fr_ee",
            "xx.gaa.translate_to.fr": "translate_fr_gaa",
            "xx.hu.translate_to.fr": "translate_fr_hu",
            "xx.ty.translate_to.fi": "translate_fi_ty",
            "xx.fr.translate_to.fj": "translate_fj_fr",
            "xx.run.translate_to.fi": "translate_fi_run",
            "xx.bem.translate_to.fr": "translate_fr_bem",
            "xx.bzs.translate_to.fr": "translate_fr_bzs",
            "xx.fj.translate_to.fr": "translate_fr_fj",
            "xx.ar.translate_to.fr": "translate_fr_ar",
            "xx.swc.translate_to.fi": "translate_fi_swc",
            "xx.crs.translate_to.fr": "translate_fr_crs",
            "xx.bg.translate_to.fr": "translate_fr_bg",
            "xx.af.translate_to.fr": "translate_fr_af",
            "xx.loz.translate_to.fr": "translate_fr_loz",
            "xx.st.translate_to.fr": "translate_fr_st",
            "xx.tn.translate_to.fr": "translate_fr_tn",
            "xx.srn.translate_to.fr": "translate_fr_srn",
            "xx.to.translate_to.fr": "translate_fr_to",
            "xx.sk.translate_to.fr": "translate_fr_sk",
            "xx.tum.translate_to.fr": "translate_fr_tum",
            "xx.ts.translate_to.fr": "translate_fr_ts",
            "xx.iso.translate_to.fr": "translate_fr_iso",
            "xx.sv.translate_to.fr": "translate_fr_sv",
            "xx.mt.translate_to.fr": "translate_fr_mt",
            "xx.pap.translate_to.fr": "translate_fr_pap",
            "xx.wls.translate_to.fr": "translate_fr_wls",
            "xx.lua.translate_to.fr": "translate_fr_lua",
            "xx.ro.translate_to.fr": "translate_fr_ro",
            "xx.tll.translate_to.fr": "translate_fr_tll",
            "xx.ilo.translate_to.fr": "translate_fr_ilo",
            "xx.ve.translate_to.fr": "translate_fr_ve",
            "xx.ny.translate_to.fr": "translate_fr_ny",
            "xx.tpi.translate_to.fr": "translate_fr_tpi",
            "xx.uk.translate_to.fr": "translate_fr_uk",
            "xx.ln.translate_to.fr": "translate_fr_ln",
            "xx.mfe.translate_to.fr": "translate_fr_mfe",
            "xx.lue.translate_to.fr": "translate_fr_lue",
            "xx.mos.translate_to.fr": "translate_fr_mos",
            "xx.pon.translate_to.fr": "translate_fr_pon",
            "xx.tvl.translate_to.fr": "translate_fr_tvl",
            "xx.run.translate_to.fr": "translate_fr_run",
            "xx.pag.translate_to.fr": "translate_fr_pag",
            "xx.sg.translate_to.fr": "translate_fr_sg",
            "xx.no.translate_to.fr": "translate_fr_no",
            "xx.ty.translate_to.fr": "translate_fr_ty",
            "xx.tl.translate_to.fr": "translate_fr_tl",
            "xx.sl.translate_to.fr": "translate_fr_sl",
            "xx.tiv.translate_to.fr": "translate_fr_tiv",
            "xx.rw.translate_to.fr": "translate_fr_rw",
            "xx.lus.translate_to.fr": "translate_fr_lus",
            "xx.swc.translate_to.fr": "translate_fr_swc",
            "xx.sm.translate_to.fr": "translate_fr_sm",
            "xx.pl.translate_to.fr": "translate_fr_pl",
            "xx.kg.translate_to.fr": "translate_fr_kg",
            "xx.niu.translate_to.fr": "translate_fr_niu",
            "xx.lg.translate_to.fr": "translate_fr_lg",
            "xx.ms.translate_to.fr": "translate_fr_ms",
            "xx.nso.translate_to.fr": "translate_fr_nso",
            "xx.war.translate_to.fr": "translate_fr_war",
            "xx.xh.translate_to.fr": "translate_fr_xh",
            "xx.pis.translate_to.fr": "translate_fr_pis",
            "xx.tw.translate_to.fr": "translate_fr_tw",
            "xx.kwy.translate_to.fr": "translate_fr_kwy",
            "xx.rnd.translate_to.fr": "translate_fr_rnd",
            "xx.vi.translate_to.fr": "translate_fr_vi",
            "xx.lu.translate_to.fr": "translate_fr_lu",
            "xx.mh.translate_to.fr": "translate_fr_mh",
            "xx.ru.translate_to.fr": "translate_fr_ru",
            "xx.sn.translate_to.fr": "translate_fr_sn",
            "xx.kqn.translate_to.fr": "translate_fr_kqn",
            "xx.ar.translate_to.he": "translate_he_ar",
            "xx.de.translate_to.he": "translate_he_de",
            "xx.es.translate_to.gil": "translate_gil_es",
            "xx.de.translate_to.gaa": "translate_gaa_de",
            "xx.fr.translate_to.hu": "translate_hu_fr",
            "xx.fr.translate_to.gil": "translate_gil_fr",
            "xx.de.translate_to.guw": "translate_guw_de",
            "xx.fr.translate_to.ht": "translate_ht_fr",
            "xx.uk.translate_to.he": "translate_he_uk",
            "xx.fi.translate_to.hu": "translate_hu_fi",
            "xx.uk.translate_to.hu": "translate_hu_uk",
            "xx.zne.translate_to.fr": "translate_fr_zne",
            "xx.sv.translate_to.gaa": "translate_gaa_sv",
            "xx.es.translate_to.guw": "translate_guw_es",
            "xx.gmq.translate_to.gmq": "translate_gmq_gmq",
            "xx.fi.translate_to.hil": "translate_hil_fi",
            "xx.fi.translate_to.guw": "translate_guw_fi",
            "xx.es.translate_to.he": "translate_he_es",
            "xx.ur.translate_to.hi": "translate_hi_ur",
            "xx.de.translate_to.hil": "translate_hil_de",
            "xx.gmw.translate_to.gmw": "translate_gmw_gmw",
            "xx.fi.translate_to.gaa": "translate_gaa_fi",
            "xx.fi.translate_to.he": "translate_he_fi",
            "xx.eo.translate_to.hu": "translate_hu_eo",
            "xx.fi.translate_to.ht": "translate_ht_fi",
            "xx.yo.translate_to.fr": "translate_fr_yo",
            "xx.sv.translate_to.hr": "translate_hr_sv",
            "xx.fr.translate_to.ha": "translate_ha_fr",
            "xx.fi.translate_to.ha": "translate_ha_fi",
            "xx.sv.translate_to.ha": "translate_ha_sv",
            "xx.pt.translate_to.gl": "translate_gl_pt",
            "xx.fr.translate_to.guw": "translate_guw_fr",
            "xx.es.translate_to.ht": "translate_ht_es",
            "xx.de.translate_to.hu": "translate_hu_de",
            "xx.sv.translate_to.ht": "translate_ht_sv",
            "xx.es.translate_to.hr": "translate_hr_es",
            "xx.fr.translate_to.gaa": "translate_gaa_fr",
            "xx.ru.translate_to.he": "translate_he_ru",
            "xx.es.translate_to.gl": "translate_gl_es",
            "xx.ru.translate_to.hy": "translate_hy_ru",
            "xx.fi.translate_to.gil": "translate_gil_fi",
            "xx.sv.translate_to.hu": "translate_hu_sv",
            "xx.sv.translate_to.gil": "translate_gil_sv",
            "xx.fi.translate_to.fse": "translate_fse_fi",
            "xx.gem.translate_to.gem": "translate_gem_gem",
            "xx.es.translate_to.ha": "translate_ha_es",
            "xx.it.translate_to.he": "translate_he_it",
            "xx.sv.translate_to.guw": "translate_guw_sv",
            "xx.sv.translate_to.he": "translate_he_sv",
            "xx.yap.translate_to.fr": "translate_fr_yap",
            "xx.fr.translate_to.hr": "translate_hr_fr",
            "xx.eo.translate_to.he": "translate_he_eo",
            "xx.es.translate_to.gaa": "translate_gaa_es",
            "xx.fi.translate_to.hr": "translate_hr_fi",
            "xx.fr.translate_to.he": "translate_he_fr",
            "xx.fi.translate_to.ilo": "translate_ilo_fi",
            "xx.sv.translate_to.iso": "translate_iso_sv",
            "xx.he.translate_to.ja": "translate_ja_he",
            "xx.fi.translate_to.id": "translate_id_fi",
            "xx.de.translate_to.ja": "translate_ja_de",
            "xx.he.translate_to.it": "translate_it_he",
            "xx.it.translate_to.ja": "translate_ja_it",
            "xx.is.translate_to.it": "translate_it_is",
            "xx.bg.translate_to.ja": "translate_ja_bg",
            "xx.de.translate_to.ig": "translate_ig_de",
            "xx.bg.translate_to.it": "translate_it_bg",
            "xx.es.translate_to.id": "translate_id_es",
            "xx.fr.translate_to.id": "translate_id_fr",
            "xx.es.translate_to.ja": "translate_ja_es",
            "xx.sv.translate_to.ja": "translate_ja_sv",
            "xx.es.translate_to.iso": "translate_iso_es",
            "xx.es.translate_to.ilo": "translate_ilo_es",
            "xx.it.translate_to.is": "translate_is_it",
            "xx.sv.translate_to.it": "translate_it_sv",
            "xx.sv.translate_to.is": "translate_is_sv",
            "xx.ru.translate_to.ja": "translate_ja_ru",
            "xx.es.translate_to.kg": "translate_kg_es",
            "xx.fi.translate_to.ig": "translate_ig_fi",
            "xx.fr.translate_to.iso": "translate_iso_fr",
            "xx.de.translate_to.ko": "translate_ko_de",
            "xx.sv.translate_to.ilo": "translate_ilo_sv",
            "xx.es.translate_to.is": "translate_is_es",
            "xx.da.translate_to.ja": "translate_ja_da",
            "xx.nl.translate_to.ja": "translate_ja_nl",
            "xx.inc.translate_to.inc": "translate_inc_inc",
            "xx.de.translate_to.is": "translate_is_de",
            "xx.fr.translate_to.is": "translate_is_fr",
            "xx.lt.translate_to.it": "translate_it_lt",
            "xx.sv.translate_to.ig": "translate_ig_sv",
            "xx.de.translate_to.ilo": "translate_ilo_de",
            "xx.ar.translate_to.it": "translate_it_ar",
            "xx.fr.translate_to.kg": "translate_kg_fr",
            "xx.vi.translate_to.ja": "translate_ja_vi",
            "xx.ru.translate_to.ka": "translate_ka_ru",
            "xx.uk.translate_to.it": "translate_it_uk",
            "xx.vi.translate_to.it": "translate_it_vi",
            "xx.ms.translate_to.it": "translate_it_ms",
            "xx.ar.translate_to.ja": "translate_ja_ar",
            "xx.eo.translate_to.is": "translate_is_eo",
            "xx.ca.translate_to.it": "translate_it_ca",
            "xx.sh.translate_to.ja": "translate_ja_sh",
            "xx.fi.translate_to.ja": "translate_ja_fi",
            "xx.iir.translate_to.iir": "translate_iir_iir",
            "xx.itc.translate_to.itc": "translate_itc_itc",
            "xx.ms.translate_to.ja": "translate_ja_ms",
            "xx.fr.translate_to.it": "translate_it_fr",
            "xx.fr.translate_to.ja": "translate_ja_fr",
            "xx.pt.translate_to.ja": "translate_ja_pt",
            "xx.eo.translate_to.it": "translate_it_eo",
            "xx.fi.translate_to.iso": "translate_iso_fi",
            "xx.pl.translate_to.ja": "translate_ja_pl",
            "xx.tr.translate_to.ja": "translate_ja_tr",
            "xx.es.translate_to.ig": "translate_ig_es",
            "xx.fr.translate_to.ig": "translate_ig_fr",
            "xx.sv.translate_to.id": "translate_id_sv",
            "xx.hu.translate_to.ja": "translate_ja_hu",
            "xx.sv.translate_to.kg": "translate_kg_sv",
            "xx.es.translate_to.it": "translate_it_es",
            "xx.ine.translate_to.ine": "translate_ine_ine",
            "xx.de.translate_to.it": "translate_it_de",
            "xx.fi.translate_to.is": "translate_is_fi",
            "xx.es.translate_to.mk": "translate_mk_es",
            "xx.es.translate_to.lue": "translate_lue_es",
            "xx.es.translate_to.lv": "translate_lv_es",
            "xx.fi.translate_to.lue": "translate_lue_fi",
            "xx.es.translate_to.ln": "translate_ln_es",
            "xx.fr.translate_to.loz": "translate_loz_fr",
            "xx.sv.translate_to.kwy": "translate_kwy_sv",
            "xx.es.translate_to.lus": "translate_lus_es",
            "xx.fr.translate_to.lv": "translate_lv_fr",
            "xx.fr.translate_to.lu": "translate_lu_fr",
            "xx.de.translate_to.lt": "translate_lt_de",
            "xx.tr.translate_to.lt": "translate_lt_tr",
            "xx.fr.translate_to.lus": "translate_lus_fr",
            "xx.es.translate_to.mg": "translate_mg_es",
            "xx.sv.translate_to.lua": "translate_lua_sv",
            "xx.fr.translate_to.lg": "translate_lg_fr",
            "xx.fr.translate_to.kwy": "translate_kwy_fr",
            "xx.es.translate_to.lt": "translate_lt_es",
            "xx.sv.translate_to.ko": "translate_ko_sv",
            "xx.es.translate_to.kqn": "translate_kqn_es",
            "xx.fr.translate_to.ko": "translate_ko_fr",
            "xx.sv.translate_to.kqn": "translate_kqn_sv",
            "xx.fi.translate_to.ko": "translate_ko_fi",
            "xx.es.translate_to.mh": "translate_mh_es",
            "xx.fr.translate_to.lua": "translate_lua_fr",
            "xx.it.translate_to.lt": "translate_lt_it",
            "xx.sv.translate_to.lt": "translate_lt_sv",
            "xx.es.translate_to.lu": "translate_lu_es",
            "xx.fi.translate_to.lua": "translate_lua_fi",
            "xx.fr.translate_to.kqn": "translate_kqn_fr",
            "xx.de.translate_to.loz": "translate_loz_de",
            "xx.fr.translate_to.ms": "translate_ms_fr",
            "xx.fr.translate_to.lt": "translate_lt_fr",
            "xx.ru.translate_to.lv": "translate_lv_ru",
            "xx.ms.translate_to.ms": "translate_ms_ms",
            "xx.sv.translate_to.lus": "translate_lus_sv",
            "xx.fr.translate_to.lue": "translate_lue_fr",
            "xx.fi.translate_to.lu": "translate_lu_fi",
            "xx.eo.translate_to.lt": "translate_lt_eo",
            "xx.fi.translate_to.mk": "translate_mk_fi",
            "xx.es.translate_to.ko": "translate_ko_es",
            "xx.sv.translate_to.lue": "translate_lue_sv",
            "xx.pl.translate_to.lt": "translate_lt_pl",
            "xx.es.translate_to.mfe": "translate_mfe_es",
            "xx.fi.translate_to.loz": "translate_loz_fi",
            "xx.sv.translate_to.loz": "translate_loz_sv",
            "xx.ru.translate_to.ko": "translate_ko_ru",
            "xx.fi.translate_to.lg": "translate_lg_fi",
            "xx.fi.translate_to.mh": "translate_mh_fi",
            "xx.sv.translate_to.lv": "translate_lv_sv",
            "xx.hu.translate_to.ko": "translate_ko_hu",
            "xx.es.translate_to.lua": "translate_lua_es",
            "xx.fi.translate_to.lv": "translate_lv_fi",
            "xx.ru.translate_to.lt": "translate_lt_ru",
            "xx.de.translate_to.ms": "translate_ms_de",
            "xx.fi.translate_to.lus": "translate_lus_fi",
            "xx.es.translate_to.lg": "translate_lg_es",
            "xx.de.translate_to.ln": "translate_ln_de",
            "xx.es.translate_to.mfs": "translate_mfs_es",
            "xx.fr.translate_to.mk": "translate_mk_fr",
            "xx.fr.translate_to.ln": "translate_ln_fr",
            "xx.es.translate_to.loz": "translate_loz_es",
            "xx.sv.translate_to.lu": "translate_lu_sv",
            "xx.it.translate_to.ms": "translate_ms_it",
            "xx.sv.translate_to.lg": "translate_lg_sv",
            "xx.ar.translate_to.pl": "translate_pl_ar",
            "xx.fr.translate_to.ro": "translate_ro_fr",
            "xx.sv.translate_to.niu": "translate_niu_sv",
            "xx.eo.translate_to.pl": "translate_pl_eo",
            "xx.nl.translate_to.no": "translate_no_nl",
            "xx.es.translate_to.no": "translate_no_es",
            "xx.es.translate_to.pag": "translate_pag_es",
            "xx.ru.translate_to.rn": "translate_rn_ru",
            "xx.sv.translate_to.pag": "translate_pag_sv",
            "xx.uk.translate_to.pt": "translate_pt_uk",
            "xx.uk.translate_to.pl": "translate_pl_uk",
            "xx.de.translate_to.pl": "translate_pl_de",
            "xx.sv.translate_to.nl": "translate_nl_sv",
            "xx.fr.translate_to.no": "translate_no_fr",
            "xx.es.translate_to.niu": "translate_niu_es",
            "xx.uk.translate_to.no": "translate_no_uk",
            "xx.lt.translate_to.pl": "translate_pl_lt",
            "xx.tl.translate_to.pt": "translate_pt_tl",
            "xx.gl.translate_to.pt": "translate_pt_gl",
            "xx.da.translate_to.ru": "translate_ru_da",
            "xx.da.translate_to.no": "translate_no_da",
            "xx.uk.translate_to.nl": "translate_nl_uk",
            "xx.sv.translate_to.pon": "translate_pon_sv",
            "xx.fr.translate_to.pis": "translate_pis_fr",
            "xx.fr.translate_to.niu": "translate_niu_fr",
            "xx.af.translate_to.nl": "translate_nl_af",
            "xx.fi.translate_to.nso": "translate_nso_fi",
            "xx.fi.translate_to.pon": "translate_pon_fi",
            "xx.de.translate_to.pap": "translate_pap_de",
            "xx.de.translate_to.rn": "translate_rn_de",
            "xx.es.translate_to.pon": "translate_pon_es",
            "xx.es.translate_to.pis": "translate_pis_es",
            "xx.ca.translate_to.pt": "translate_pt_ca",
            "xx.sv.translate_to.rnd": "translate_rnd_sv",
            "xx.sv.translate_to.pl": "translate_pl_sv",
            "xx.ru.translate_to.no": "translate_no_ru",
            "xx.fi.translate_to.niu": "translate_niu_fi",
            "xx.de.translate_to.pag": "translate_pag_de",
            "xx.fr.translate_to.pl": "translate_pl_fr",
            "xx.fi.translate_to.no": "translate_no_fi",
            "xx.pl.translate_to.no": "translate_no_pl",
            "xx.de.translate_to.nso": "translate_nso_de",
            "xx.fr.translate_to.rn": "translate_rn_fr",
            "xx.sv.translate_to.nso": "translate_nso_sv",
            "xx.sv.translate_to.ro": "translate_ro_sv",
            "xx.no.translate_to.pl": "translate_pl_no",
            "xx.fr.translate_to.nl": "translate_nl_fr",
            "xx.es.translate_to.nso": "translate_nso_es",
            "xx.no.translate_to.nl": "translate_nl_no",
            "xx.fi.translate_to.pis": "translate_pis_fi",
            "xx.ca.translate_to.nl": "translate_nl_ca",
            "xx.es.translate_to.nl": "translate_nl_es",
            "xx.es.translate_to.ny": "translate_ny_es",
            "xx.fr.translate_to.pap": "translate_pap_fr",
            "xx.fi.translate_to.nl": "translate_nl_fi",
            "xx.sv.translate_to.no": "translate_no_sv",
            "xx.fr.translate_to.pon": "translate_pon_fr",
            "xx.fr.translate_to.rnd": "translate_rnd_fr",
            "xx.es.translate_to.pap": "translate_pap_es",
            "xx.es.translate_to.prl": "translate_prl_es",
            "xx.eo.translate_to.ro": "translate_ro_eo",
            "xx.sv.translate_to.pis": "translate_pis_sv",
            "xx.af.translate_to.ru": "translate_ru_af",
            "xx.fr.translate_to.nso": "translate_nso_fr",
            "xx.eo.translate_to.pt": "translate_pt_eo",
            "xx.ar.translate_to.ru": "translate_ru_ar",
            "xx.fr.translate_to.mt": "translate_mt_fr",
            "xx.es.translate_to.rn": "translate_rn_es",
            "xx.sv.translate_to.mt": "translate_mt_sv",
            "xx.de.translate_to.niu": "translate_niu_de",
            "xx.es.translate_to.mt": "translate_mt_es",
            "xx.es.translate_to.pl": "translate_pl_es",
            "xx.fi.translate_to.pag": "translate_pag_fi",
            "xx.de.translate_to.no": "translate_no_de",
            "xx.de.translate_to.ny": "translate_ny_de",
            "xx.fi.translate_to.mt": "translate_mt_fi",
            "xx.no.translate_to.no": "translate_no_no",
            "xx.eo.translate_to.nl": "translate_nl_eo",
            "xx.bg.translate_to.ru": "translate_ru_bg",
            "xx.fi.translate_to.pap": "translate_pap_fi",
            "xx.fi.translate_to.ro": "translate_ro_fi",
            "xx.sv.translate_to.st": "translate_st_sv",
            "xx.kg.translate_to.sv": "translate_sv_kg",
            "xx.sv.translate_to.sq": "translate_sq_sv",
            "xx.ee.translate_to.sv": "translate_sv_ee",
            "xx.es.translate_to.srn": "translate_srn_es",
            "xx.lv.translate_to.ru": "translate_ru_lv",
            "xx.cs.translate_to.sv": "translate_sv_cs",
            "xx.ha.translate_to.sv": "translate_sv_ha",
            "xx.kqn.translate_to.sv": "translate_sv_kqn",
            "xx.fr.translate_to.rw": "translate_rw_fr",
            "xx.fr.translate_to.sn": "translate_sn_fr",
            "xx.eu.translate_to.ru": "translate_ru_eu",
            "xx.fi.translate_to.st": "translate_st_fi",
            "xx.efi.translate_to.sv": "translate_sv_efi",
            "xx.ho.translate_to.sv": "translate_sv_ho",
            "xx.id.translate_to.sv": "translate_sv_id",
            "xx.eo.translate_to.sv": "translate_sv_eo",
            "xx.guw.translate_to.sv": "translate_sv_guw",
            "xx.sv.translate_to.sk": "translate_sk_sv",
            "xx.fr.translate_to.srn": "translate_srn_fr",
            "xx.ceb.translate_to.sv": "translate_sv_ceb",
            "xx.es.translate_to.sq": "translate_sq_es",
            "xx.sv.translate_to.rw": "translate_rw_sv",
            "xx.is.translate_to.sv": "translate_sv_is",
            "xx.es.translate_to.sm": "translate_sm_es",
            "xx.bcl.translate_to.sv": "translate_sv_bcl",
            "xx.kwy.translate_to.sv": "translate_sv_kwy",
            "xx.es.translate_to.run": "translate_run_es",
            "xx.el.translate_to.sv": "translate_sv_el",
            "xx.es.translate_to.sk": "translate_sk_es",
            "xx.iso.translate_to.sv": "translate_sv_iso",
            "xx.lu.translate_to.sv": "translate_sv_lu",
            "xx.af.translate_to.sv": "translate_sv_af",
            "xx.bg.translate_to.sv": "translate_sv_bg",
            "xx.fr.translate_to.sm": "translate_sm_fr",
            "xx.hr.translate_to.sv": "translate_sv_hr",
            "xx.sv.translate_to.sn": "translate_sn_sv",
            "xx.no.translate_to.ru": "translate_ru_no",
            "xx.fr.translate_to.sg": "translate_sg_fr",
            "xx.es.translate_to.sl": "translate_sl_es",
            "xx.bzs.translate_to.sv": "translate_sv_bzs",
            "xx.fr.translate_to.st": "translate_st_fr",
            "xx.hu.translate_to.sv": "translate_sv_hu",
            "xx.sv.translate_to.sg": "translate_sg_sv",
            "xx.sem.translate_to.sem": "translate_sem_sem",
            "xx.uk.translate_to.sh": "translate_sh_uk",
            "xx.ln.translate_to.sv": "translate_sv_ln",
            "xx.fi.translate_to.sk": "translate_sk_fi",
            "xx.ht.translate_to.sv": "translate_sv_ht",
            "xx.es.translate_to.st": "translate_st_es",
            "xx.fr.translate_to.ru": "translate_ru_fr",
            "xx.chk.translate_to.sv": "translate_sv_chk",
            "xx.fr.translate_to.sk": "translate_sk_fr",
            "xx.lg.translate_to.sv": "translate_sv_lg",
            "xx.sv.translate_to.srn": "translate_srn_sv",
            "xx.crs.translate_to.sv": "translate_sv_crs",
            "xx.uk.translate_to.ru": "translate_ru_uk",
            "xx.et.translate_to.ru": "translate_ru_et",
            "xx.et.translate_to.sv": "translate_sv_et",
            "xx.es.translate_to.rw": "translate_rw_es",
            "xx.sla.translate_to.sla": "translate_sla_sla",
            "xx.ru.translate_to.sl": "translate_sl_ru",
            "xx.fj.translate_to.sv": "translate_sv_fj",
            "xx.es.translate_to.sn": "translate_sn_es",
            "xx.lua.translate_to.sv": "translate_sv_lua",
            "xx.hil.translate_to.sv": "translate_sv_hil",
            "xx.es.translate_to.ru": "translate_ru_es",
            "xx.lue.translate_to.sv": "translate_sv_lue",
            "xx.gaa.translate_to.sv": "translate_sv_gaa",
            "xx.hy.translate_to.ru": "translate_ru_hy",
            "xx.bem.translate_to.sv": "translate_sv_bem",
            "xx.sv.translate_to.run": "translate_run_sv",
            "xx.gil.translate_to.sv": "translate_sv_gil",
            "xx.lus.translate_to.sv": "translate_sv_lus",
            "xx.he.translate_to.ru": "translate_ru_he",
            "xx.vi.translate_to.ru": "translate_ru_vi",
            "xx.he.translate_to.sv": "translate_sv_he",
            "xx.sv.translate_to.ru": "translate_ru_sv",
            "xx.fi.translate_to.ru": "translate_ru_fi",
            "xx.es.translate_to.sv": "translate_sv_es",
            "xx.es.translate_to.sg": "translate_sg_es",
            "xx.eo.translate_to.ru": "translate_ru_eo",
            "xx.lv.translate_to.sv": "translate_sv_lv",
            "xx.fi.translate_to.sg": "translate_sg_fi",
            "xx.es.translate_to.ssp": "translate_ssp_es",
            "xx.ilo.translate_to.sv": "translate_sv_ilo",
            "xx.fi.translate_to.sv": "translate_sv_fi",
            "xx.lt.translate_to.ru": "translate_ru_lt",
            "xx.bi.translate_to.sv": "translate_sv_bi",
            "xx.sv.translate_to.sl": "translate_sl_sv",
            "xx.fr.translate_to.sv": "translate_sv_fr",
            "xx.uk.translate_to.sl": "translate_sl_uk",
            "xx.fi.translate_to.sl": "translate_sl_fi",
            "xx.sl.translate_to.ru": "translate_ru_sl",
            "xx.ig.translate_to.sv": "translate_sv_ig",
            "xx.ase.translate_to.sv": "translate_sv_ase",
            "xx.eo.translate_to.sh": "translate_sh_eo",
            "xx.fr.translate_to.sl": "translate_sl_fr",
            "xx.es.translate_to.tl": "translate_tl_es",
            "xx.sv.translate_to.tw": "translate_tw_sv",
            "xx.lt.translate_to.tr": "translate_tr_lt",
            "xx.fi.translate_to.tll": "translate_tll_fi",
            "xx.sn.translate_to.sv": "translate_sv_sn",
            "xx.tn.translate_to.sv": "translate_sv_tn",
            "xx.sv.translate_to.toi": "translate_toi_sv",
            "xx.uk.translate_to.sv": "translate_sv_uk",
            "xx.tiv.translate_to.sv": "translate_sv_tiv",
            "xx.sk.translate_to.sv": "translate_sv_sk",
            "xx.ty.translate_to.sv": "translate_sv_ty",
            "xx.es.translate_to.toi": "translate_toi_es",
            "xx.rw.translate_to.sv": "translate_sv_rw",
            "xx.ny.translate_to.sv": "translate_sv_ny",
            "xx.rnd.translate_to.sv": "translate_sv_rnd",
            "xx.es.translate_to.tn": "translate_tn_es",
            "xx.sv.translate_to.tn": "translate_tn_sv",
            "xx.es.translate_to.tvl": "translate_tvl_es",
            "xx.pon.translate_to.sv": "translate_sv_pon",
            "xx.ve.translate_to.sv": "translate_sv_ve",
            "xx.fr.translate_to.tvl": "translate_tvl_fr",
            "xx.es.translate_to.tum": "translate_tum_es",
            "xx.run.translate_to.sv": "translate_sv_run",
            "xx.de.translate_to.tl": "translate_tl_de",
            "xx.fi.translate_to.tw": "translate_tw_fi",
            "xx.es.translate_to.ty": "translate_ty_es",
            "xx.fr.translate_to.toi": "translate_toi_fr",
            "xx.sv.translate_to.tll": "translate_tll_sv",
            "xx.sg.translate_to.sv": "translate_sv_sg",
            "xx.az.translate_to.tr": "translate_tr_az",
            "xx.es.translate_to.ts": "translate_ts_es",
            "xx.fr.translate_to.ts": "translate_ts_fr",
            "xx.fr.translate_to.th": "translate_th_fr",
            "xx.zne.translate_to.sv": "translate_sv_zne",
            "xx.tw.translate_to.sv": "translate_sv_tw",
            "xx.mh.translate_to.sv": "translate_sv_mh",
            "xx.pag.translate_to.sv": "translate_sv_pag",
            "xx.fr.translate_to.tum": "translate_tum_fr",
            "xx.no.translate_to.sv": "translate_sv_no",
            "xx.ts.translate_to.sv": "translate_sv_ts",
            "xx.mt.translate_to.sv": "translate_sv_mt",
            "xx.yo.translate_to.sv": "translate_sv_yo",
            "xx.fr.translate_to.to": "translate_to_fr",
            "xx.sv.translate_to.sv": "translate_sv_sv",
            "xx.fi.translate_to.toi": "translate_toi_fi",
            "xx.ro.translate_to.sv": "translate_sv_ro",
            "xx.es.translate_to.tw": "translate_tw_es",
            "xx.niu.translate_to.sv": "translate_sv_niu",
            "xx.uk.translate_to.tr": "translate_tr_uk",
            "xx.to.translate_to.sv": "translate_sv_to",
            "xx.fi.translate_to.ts": "translate_ts_fi",
            "xx.tll.translate_to.sv": "translate_sv_tll",
            "xx.fr.translate_to.tll": "translate_tll_fr",
            "xx.pt.translate_to.tl": "translate_tl_pt",
            "xx.nso.translate_to.sv": "translate_sv_nso",
            "xx.sq.translate_to.sv": "translate_sv_sq",
            "xx.sv.translate_to.tpi": "translate_tpi_sv",
            "xx.yap.translate_to.sv": "translate_sv_yap",
            "xx.sv.translate_to.tr": "translate_tr_sv",
            "xx.fr.translate_to.swc": "translate_swc_fr",
            "xx.nl.translate_to.sv": "translate_sv_nl",
            "xx.fi.translate_to.ty": "translate_ty_fi",
            "xx.fr.translate_to.tr": "translate_tr_fr",
            "xx.sv.translate_to.tum": "translate_tum_sv",
            "xx.swc.translate_to.sv": "translate_sv_swc",
            "xx.fi.translate_to.swc": "translate_swc_fi",
            "xx.eo.translate_to.tr": "translate_tr_eo",
            "xx.xh.translate_to.sv": "translate_sv_xh",
            "xx.sv.translate_to.tvl": "translate_tvl_sv",
            "xx.sl.translate_to.sv": "translate_sv_sl",
            "xx.tum.translate_to.sv": "translate_sv_tum",
            "xx.es.translate_to.to": "translate_to_es",
            "xx.fr.translate_to.tn": "translate_tn_fr",
            "xx.sv.translate_to.ty": "translate_ty_sv",
            "xx.sv.translate_to.swc": "translate_swc_sv",
            "xx.mos.translate_to.sv": "translate_sv_mos",
            "xx.ar.translate_to.tr": "translate_tr_ar",
            "xx.ru.translate_to.sv": "translate_sv_ru",
            "xx.srn.translate_to.sv": "translate_sv_srn",
            "xx.pis.translate_to.sv": "translate_sv_pis",
            "xx.pap.translate_to.sv": "translate_sv_pap",
            "xx.tvl.translate_to.sv": "translate_sv_tvl",
            "xx.sv.translate_to.to": "translate_to_sv",
            "xx.th.translate_to.sv": "translate_sv_th",
            "xx.war.translate_to.sv": "translate_sv_war",
            "xx.sv.translate_to.ts": "translate_ts_sv",
            "xx.fr.translate_to.tw": "translate_tw_fr",
            "xx.st.translate_to.sv": "translate_sv_st",
            "xx.fr.translate_to.tiv": "translate_tiv_fr",
            "xx.tpi.translate_to.sv": "translate_sv_tpi",
            "xx.fi.translate_to.tvl": "translate_tvl_fi",
            "xx.fr.translate_to.ty": "translate_ty_fr",
            "xx.sm.translate_to.sv": "translate_sv_sm",
            "xx.es.translate_to.swc": "translate_swc_es",
            "xx.sv.translate_to.tiv": "translate_tiv_sv",
            "xx.toi.translate_to.sv": "translate_sv_toi",
            "xx.mfe.translate_to.sv": "translate_sv_mfe",
            "xx.wls.translate_to.sv": "translate_sv_wls",
            "xx.umb.translate_to.sv": "translate_sv_umb",
            "xx.es.translate_to.tr": "translate_tr_es",
            "xx.es.translate_to.tll": "translate_tll_es",
            "xx.pt.translate_to.uk": "translate_uk_pt",
            "xx.it.translate_to.zh": "translate_zh_it",
            "xx.no.translate_to.uk": "translate_uk_no",
            "xx.sh.translate_to.uk": "translate_uk_sh",
            "xx.sv.translate_to.wls": "translate_wls_sv",
            "xx.pl.translate_to.uk": "translate_uk_pl",
            "xx.es.translate_to.yo": "translate_yo_es",
            "xx.es.translate_to.war": "translate_war_es",
            "xx.sv.translate_to.zh": "translate_zh_sv",
            "xx.tr.translate_to.uk": "translate_uk_tr",
            "xx.fi.translate_to.war": "translate_war_fi",
            "xx.de.translate_to.zh": "translate_zh_de",
            "xx.uk.translate_to.zh": "translate_zh_uk",
            "xx.eo.translate_to.vi": "translate_vi_eo",
            "xx.bg.translate_to.zh": "translate_zh_bg",
            "xx.es.translate_to.zne": "translate_zne_es",
            "xx.fr.translate_to.uk": "translate_uk_fr",
            "xx.zls.translate_to.zls": "translate_zls_zls",
            "xx.fr.translate_to.yo": "translate_yo_fr",
            "xx.bg.translate_to.uk": "translate_uk_bg",
            "xx.fr.translate_to.xh": "translate_xh_fr",
            "xx.ca.translate_to.uk": "translate_uk_ca",
            "xx.fi.translate_to.zh": "translate_zh_fi",
            "xx.es.translate_to.zai": "translate_zai_es",
            "xx.es.translate_to.uk": "translate_uk_es",
            "xx.nl.translate_to.uk": "translate_uk_nl",
            "xx.sv.translate_to.yap": "translate_yap_sv",
            "xx.he.translate_to.uk": "translate_uk_he",
            "xx.sl.translate_to.uk": "translate_uk_sl",
            "xx.es.translate_to.ve": "translate_ve_es",
            "xx.zlw.translate_to.zlw": "translate_zlw_zlw",
            "xx.es.translate_to.tzo": "translate_tzo_es",
            "xx.hu.translate_to.uk": "translate_uk_hu",
            "xx.de.translate_to.vi": "translate_vi_de",
            "xx.fi.translate_to.yo": "translate_yo_fi",
            "xx.ru.translate_to.uk": "translate_uk_ru",
            "xx.ms.translate_to.zh": "translate_zh_ms",
            "xx.urj.translate_to.urj": "translate_urj_urj",
            "xx.it.translate_to.uk": "translate_uk_it",
            "xx.sv.translate_to.war": "translate_war_sv",
            "xx.fr.translate_to.wls": "translate_wls_fr",
            "xx.zle.translate_to.zle": "translate_zle_zle",
            "xx.vi.translate_to.zh": "translate_zh_vi",
            "xx.es.translate_to.vsl": "translate_vsl_es",
            "xx.fi.translate_to.zne": "translate_zne_fi",
            "xx.fi.translate_to.uk": "translate_uk_fi",
            "xx.ru.translate_to.vi": "translate_vi_ru",
            "xx.nl.translate_to.zh": "translate_zh_nl",
            "xx.sv.translate_to.xh": "translate_xh_sv",
            "xx.es.translate_to.xh": "translate_xh_es",
            "xx.he.translate_to.zh": "translate_zh_he",
            "xx.fr.translate_to.war": "translate_war_fr",
            "xx.fr.translate_to.zne": "translate_zne_fr",
            "xx.sv.translate_to.yo": "translate_yo_sv",
            "xx.fr.translate_to.vi": "translate_vi_fr",
            "xx.it.translate_to.vi": "translate_vi_it",
            "xx.sv.translate_to.zne": "translate_zne_sv",
            "xx.fr.translate_to.yap": "translate_yap_fr",
            "xx.cs.translate_to.uk": "translate_uk_cs",
            "xx.es.translate_to.vi": "translate_vi_es",
            "xx.de.translate_to.uk": "translate_uk_de",
            "xx.sv.translate_to.uk": "translate_uk_sv",

        },

    }
    pretrained_models_references = {'vi': {'vi.embed.distilbert.cased': 'distilbert_base_cased',
                                           'vi.lemma': 'lemma',
                                           'vi.embed.bert_cased': 'bert_embeddings_bert_base_vi_cased',
                                           'vi.lemma.vtb': 'lemma_vtb'},
                                    'is': {'is.ner': 'roberta_token_classifier_icelandic_ner',
                                           'is.lemma.modern': 'lemma_modern',
                                           'is.pos.modern': 'pos_modern'},
                                    'mt': {'mt.lemma': 'lemma'},
                                    'ta': {'ta.lemma': 'lemma',
                                           'ta.detect_sentence': 'sentence_detector_dl',
                                           'ta.pos': 'pos_ttb',
                                           'ta.lemma.ttb': 'lemma_ttb'},
                                    'cy': {'cy.lemma': 'lemma',
                                           'cy.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'cy.lemma.ccg': 'lemma_ccg',
                                           'cy.pos.ccg': 'pos_ccg'},
                                    'nl': {'nl.lemma': 'lemma',
                                           'nl.pos': 'pos_ud_alpino',
                                           'nl.pos.ud_alpino': 'pos_ud_alpino',
                                           'nl.ner': 'wikiner_6B_100',
                                           'nl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'nl.ner.wikiner': 'wikiner_6B_300',
                                           'nl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'nl.embed.bert': 'bert_base_dutch_cased',
                                           'nl.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'nl.embed.bert.base_cased': 'bert_base_cased',
                                           'nl.ner.bert': 'bert_token_classifier_dutch_udlassy_ner',
                                           'nl.lemma_alpino': 'lemma_alpino',
                                           'nl.lemma.lassysmall': 'lemma_lassysmall',
                                           'nl.pos.alpino': 'pos_alpino',
                                           'nl.pos.lassysmall': 'pos_lassysmall'},
                                    'en': {'en.stem': 'stemmer',
                                           'en.tokenize': 'spark_nlp_tokenizer',
                                           'en.norm': 'norm',
                                           'en.chunk': 'default_chunker',
                                           'en.ngram': 'ngram',
                                           'en.embed_chunk': 'chunk_embeddings',
                                           'en.lemma': 'lemma_antbnc',
                                           'en.lemma.antbnc': 'lemma_antbnc',
                                           'en.pos': 'pos_anc',
                                           'en.pos.anc': 'pos_anc',
                                           'en.pos.ud_ewt': 'pos_ud_ewt',
                                           'en.ner': 'ner_dl',
                                           'en.ner.dl': 'ner_dl',
                                           'en.ner.dl.bert': 'ner_dl_bert',
                                           'en.ner.onto': 'onto_100',
                                           'en.ner.onto.glove.6B_100d': 'onto_100',
                                           'en.ner.onto.glove.840B_300d': 'onto_300',
                                           'en.ner.onto.bert.cased_base': 'onto_bert_base_cased',
                                           'en.ner.onto.bert.cased_large': 'onto_bert_large_cased',
                                           'en.ner.onto.electra.uncased_large': 'onto_electra_large_uncased',
                                           'en.ner.onto.bert.small_l2_128': 'onto_small_bert_L2_128',
                                           'en.ner.onto.bert.small_l4_256': 'onto_small_bert_L4_256',
                                           'en.ner.onto.bert.small_l4_512': 'onto_small_bert_L4_512',
                                           'en.ner.onto.bert.small_l8_512': 'onto_small_bert_L8_512',
                                           'en.ner.onto.electra.uncased_small': 'onto_electra_small_uncased',
                                           'en.ner.onto.electra.uncased_base': 'onto_electra_base_uncased',
                                           'en.ner.bert_base_cased': 'ner_dl_bert_base_cased',
                                           'en.ner.glove.100d': 'ner_dl_sentence',
                                           'en.ner.glove': 'ner_dl_sentence',
                                           'en.spell.norvig': 'spellcheck_norvig',
                                           'en.sentiment.vivekn': 'sentiment_vivekn',
                                           'en.dep.untyped.conllu': 'dependency_conllu',
                                           'en.dep.untyped': 'dependency_conllu',
                                           'en.dep': 'dependency_typed_conllu',
                                           'en.dep.typed': 'dependency_typed_conllu',
                                           'en.dep.typed.conllu': 'dependency_typed_conllu',
                                           'en.stopwords': 'stopwords_en',
                                           'en.ner.fewnerd': 'nerdl_fewnerd_100d',
                                           'en.ner.fewnerd_subentity': 'nerdl_fewnerd_subentity_100d',
                                           'en.ner.movie': 'ner_mit_movie_complex_bert_base_cased',
                                           'en.ner.movie_complex': 'ner_mit_movie_complex_bert_base_cased',
                                           'en.ner.movie_simple': 'ner_mit_movie_complex_bert_base_cased',
                                           'en.ner.mit_movie_complex_bert': 'ner_mit_movie_complex_bert_base_cased',
                                           'en.ner.mit_movie_complex_distilbert': 'ner_mit_movie_complex_distilbert_base_cased',
                                           'en.ner.mit_movie_simple': 'ner_mit_movie_simple_distilbert_base_cased',
                                           'en.embed_sentence.bert_use_cmlm_en_base': 'sent_bert_use_cmlm_en_base',
                                           'en.embed_sentence.bert_use_cmlm_en_large': 'sent_bert_use_cmlm_en_large',
                                           'en.glove': 'glove_100d',
                                           'en.embed': 'glove_100d',
                                           'en.embed.glove': 'glove_100d',
                                           'en.embed.glove.100d': 'glove_100d',
                                           'en.bert': 'bert_base_uncased',
                                           'en.embed.bert': 'bert_base_uncased',
                                           'en.embed.bert.base_uncased': 'bert_base_uncased',
                                           'en.embed.bert.base_cased': 'bert_base_cased',
                                           'en.embed.bert.large_uncased': 'bert_large_uncased',
                                           'en.embed.bert.large_cased': 'bert_large_cased',
                                           'en.embed.biobert': 'biobert_pubmed_base_cased',
                                           'en.embed.biobert.pubmed_base_cased': 'biobert_pubmed_base_cased',
                                           'en.embed.biobert.pubmed_large_cased': 'biobert_pubmed_large_cased',
                                           'en.embed.biobert.pmc_base_cased': 'biobert_pmc_base_cased',
                                           'en.embed.biobert.pubmed_pmc_base_cased': 'biobert_pubmed_pmc_base_cased',
                                           'en.embed.biobert.clinical_base_cased': 'biobert_clinical_base_cased',
                                           'en.embed.biobert.discharge_base_cased': 'biobert_discharge_base_cased',
                                           'en.embed.elmo': 'elmo',
                                           'en.embed_sentence': 'tfhub_use',
                                           'en.embed_sentence.use': 'tfhub_use',
                                           'en.use': 'tfhub_use',
                                           'en.embed_sentence.tfhub_use': 'tfhub_use',
                                           'en.embed_sentence.use.lg': 'tfhub_use_lg',
                                           'en.embed_sentence.tfhub_use.lg': 'tfhub_use_lg',
                                           'en.embed_sentence.albert': 'albert_base_uncased',
                                           'en.albert': 'albert_base_uncased',
                                           'en.embed.albert': 'albert_base_uncased',
                                           'en.embed.albert.base_uncased': 'albert_base_uncased',
                                           'en.embed.albert.large_uncased': 'albert_large_uncased',
                                           'en.embed.albert.xlarge_uncased': 'albert_xlarge_uncased',
                                           'en.embed.albert.xxlarge_uncased': 'albert_xxlarge_uncased',
                                           'en.embed.xlnet': 'xlnet_base_cased',
                                           'en.xlnet': 'xlnet_base_cased',
                                           'en.embed.xlnet_base_cased': 'xlnet_base_cased',
                                           'en.embed.xlnet_large_cased': 'xlnet_large_cased',
                                           'en.classify.trec6.use': 'classifierdl_use_trec6',
                                           'en.classify.trec50.use': 'classifierdl_use_trec50',
                                           'en.classify.question': 'classifierdl_use_trec50',
                                           'en.classify.questions': 'classifierdl_use_trec50',
                                           'en.classify.spam.use': 'classifierdl_use_spam',
                                           'en.classify.fakenews.use': 'classifierdl_use_fakenews',
                                           'en.classify.emotion.use': 'classifierdl_use_emotion',
                                           'en.classify.cyberbullying.use': 'classifierdl_use_cyberbullying',
                                           'en.classify.sarcasm.use': 'classifierdl_use_sarcasm',
                                           'en.sentiment.imdb.use.dl': 'sentimentdl_use_imdb',
                                           'en.sentiment.twitter.use.dl': 'sentimentdl_use_twitter',
                                           'en.sentiment.imdb.glove': 'sentimentdl_glove_imdb',
                                           'en.classify.trec6': 'classifierdl_use_trec6',
                                           'en.classify.trec50': 'classifierdl_use_trec50',
                                           'en.classify.spam': 'classifierdl_use_spam',
                                           'en.classify.fakenews': 'classifierdl_use_fakenews',
                                           'en.classify.emotion': 'classifierdl_use_emotion',
                                           'en.classify.cyberbullying': 'classifierdl_use_cyberbullying',
                                           'en.classify.sarcasm': 'classifierdl_use_sarcasm',
                                           'en.sentiment.twitter.dl': 'sentimentdl_use_twitter',
                                           'en.yake': 'yake',
                                           'en.embed.electra': 'electra_small_uncased',
                                           'en.embed.electra.small_uncased': 'electra_small_uncased',
                                           'en.embed.electra.base_uncased': 'electra_base_uncased',
                                           'en.embed.electra.large_uncased': 'electra_large_uncased',
                                           'en.embed.covidbert': 'covidbert_large_uncased',
                                           'en.embed.covidbert.large_uncased': 'covidbert_large_uncased',
                                           'en.embed.bert.small_L2_128': 'small_bert_L2_128',
                                           'en.embed.bert.small_L4_128': 'small_bert_L4_128',
                                           'en.embed.bert.small_L6_128': 'small_bert_L6_128',
                                           'en.embed.bert.small_L8_128': 'small_bert_L8_128',
                                           'en.embed.bert.small_L10_128': 'small_bert_L10_128',
                                           'en.embed.bert.small_L12_128': 'small_bert_L12_128',
                                           'en.embed.bert.small_L2_256': 'small_bert_L2_256',
                                           'en.embed.bert.small_L4_256': 'small_bert_L4_256',
                                           'en.embed.bert.small_L6_256': 'small_bert_L6_256',
                                           'en.embed.bert.small_L8_256': 'small_bert_L8_256',
                                           'en.embed.bert.small_L10_256': 'small_bert_L10_256',
                                           'en.embed.bert.small_L12_256': 'small_bert_L12_256',
                                           'en.embed.bert.small_L2_512': 'small_bert_L2_512',
                                           'en.embed.bert.small_L4_512': 'small_bert_L4_512',
                                           'en.embed.bert.small_L6_512': 'small_bert_L6_512',
                                           'en.embed.bert.small_L8_512': 'small_bert_L8_512',
                                           'en.embed.bert.small_L10_512': 'small_bert_L10_512',
                                           'en.embed.bert.small_L12_512': 'small_bert_L12_512',
                                           'en.embed.bert.small_L2_768': 'small_bert_L2_768',
                                           'en.embed.bert.small_L4_768': 'small_bert_L4_768',
                                           'en.embed.bert.small_L6_768': 'small_bert_L6_768',
                                           'en.embed.bert.small_L8_768': 'small_bert_L8_768',
                                           'en.embed.bert.small_L10_768': 'small_bert_L10_768',
                                           'en.embed.bert.small_L12_768': 'small_bert_L12_768',
                                           'en.embed_sentence.electra': 'sent_electra_small_uncased',
                                           'en.embed_sentence.electra_small_uncased': 'sent_electra_small_uncased',
                                           'en.embed_sentence.electra_base_uncased': 'sent_electra_base_uncased',
                                           'en.embed_sentence.electra_large_uncased': 'sent_electra_large_uncased',
                                           'en.embed_sentence.bert': 'sent_bert_base_uncased',
                                           'en.embed_sentence.bert_base_uncased': 'sent_bert_base_uncased',
                                           'en.embed_sentence.bert_base_cased': 'sent_bert_base_cased',
                                           'en.embed_sentence.bert_large_uncased': 'sent_bert_large_uncased',
                                           'en.embed_sentence.bert_large_cased': 'sent_bert_large_cased',
                                           'en.embed_sentence.biobert.pubmed_base_cased': 'sent_biobert_pubmed_base_cased',
                                           'en.embed_sentence.biobert.pubmed_large_cased': 'sent_biobert_pubmed_large_cased',
                                           'en.embed_sentence.biobert.pmc_base_cased': 'sent_biobert_pmc_base_cased',
                                           'en.embed_sentence.biobert.pubmed_pmc_base_cased': 'sent_biobert_pubmed_pmc_base_cased',
                                           'en.embed_sentence.biobert.clinical_base_cased': 'sent_biobert_clinical_base_cased',
                                           'en.embed_sentence.biobert.discharge_base_cased': 'sent_biobert_discharge_base_cased',
                                           'en.embed_sentence.covidbert.large_uncased': 'sent_covidbert_large_uncased',
                                           'en.embed_sentence.small_bert_L2_128': 'sent_small_bert_L2_128',
                                           'en.embed_sentence.small_bert_L4_128': 'sent_small_bert_L4_128',
                                           'en.embed_sentence.small_bert_L6_128': 'sent_small_bert_L6_128',
                                           'en.embed_sentence.small_bert_L8_128': 'sent_small_bert_L8_128',
                                           'en.embed_sentence.small_bert_L10_128': 'sent_small_bert_L10_128',
                                           'en.embed_sentence.small_bert_L12_128': 'sent_small_bert_L12_128',
                                           'en.embed_sentence.small_bert_L2_256': 'sent_small_bert_L2_256',
                                           'en.embed_sentence.small_bert_L4_256': 'sent_small_bert_L4_256',
                                           'en.embed_sentence.small_bert_L6_256': 'sent_small_bert_L6_256',
                                           'en.embed_sentence.small_bert_L8_256': 'sent_small_bert_L8_256',
                                           'en.embed_sentence.small_bert_L10_256': 'sent_small_bert_L10_256',
                                           'en.embed_sentence.small_bert_L12_256': 'sent_small_bert_L12_256',
                                           'en.embed_sentence.small_bert_L2_512': 'sent_small_bert_L2_512',
                                           'en.embed_sentence.small_bert_L4_512': 'sent_small_bert_L4_512',
                                           'en.embed_sentence.small_bert_L6_512': 'sent_small_bert_L6_512',
                                           'en.embed_sentence.small_bert_L8_512': 'sent_small_bert_L8_512',
                                           'en.embed_sentence.small_bert_L10_512': 'sent_small_bert_L10_512',
                                           'en.embed_sentence.small_bert_L12_512': 'sent_small_bert_L12_512',
                                           'en.embed_sentence.small_bert_L2_768': 'sent_small_bert_L2_768',
                                           'en.embed_sentence.small_bert_L4_768': 'sent_small_bert_L4_768',
                                           'en.embed_sentence.small_bert_L6_768': 'sent_small_bert_L6_768',
                                           'en.embed_sentence.small_bert_L8_768': 'sent_small_bert_L8_768',
                                           'en.embed_sentence.small_bert_L10_768': 'sent_small_bert_L10_768',
                                           'en.embed_sentence.small_bert_L12_768': 'sent_small_bert_L12_768',
                                           'en.classify.toxic': 'multiclassifierdl_use_toxic',
                                           'en.toxic': 'multiclassifierdl_use_toxic',
                                           'en.e2e': 'multiclassifierdl_use_e2e',
                                           'en.classify.toxic.sm': 'multiclassifierdl_use_toxic_sm',
                                           'en.classify.e2e': 'multiclassifierdl_use_e2e',
                                           'en.t5': 'google_t5_small_ssm_nq',
                                           'en.t5.small': 't5_small',
                                           'en.t5.base': 't5_base',
                                           'en.classify.questions.atis': 'classifierdl_use_atis',
                                           'en.classify.questions.airline': 'classifierdl_use_atis',
                                           'en.classify.intent.atis': 'classifierdl_use_atis',
                                           'en.classify.intent.airline': 'classifierdl_use_atis',
                                           'en.ner.atis': 'nerdl_atis_840b_300d',
                                           'en.ner.airline': 'nerdl_atis_840b_300d',
                                           'en.ner.aspect.airline': 'nerdl_atis_840b_300d',
                                           'en.ner.aspect.atis': 'nerdl_atis_840b_300d',
                                           'en.classify.snips': 'nerdl_snips_100d',
                                           'en.ner.snips': 'classifierdl_use_snips',
                                           'en.embed.distilbert': 'distilbert_base_cased',
                                           'en.embed.distilbert.base': 'distilbert_base_cased',
                                           'en.embed.distilbert.base.uncased': 'distilbert_base_uncased',
                                           'en.embed.distilroberta': 'distilroberta_base',
                                           'roberta': 'distilroberta_base',
                                           'en.embed.roberta': 'roberta_base',
                                           'en.embed.roberta.base': 'roberta_base',
                                           'en.embed.roberta.large': 'roberta_large',
                                           'en.classify.token_bert.conll03': 'bert_base_token_classifier_conll03',
                                           'en.classify.token_bert.large_conll03': 'bert_large_token_classifier_conll03',
                                           'en.classify.token_bert.ontonote': 'bert_base_token_classifier_ontonote',
                                           'en.classify.token_bert.large_ontonote': 'bert_large_token_classifier_ontonote',
                                           'en.classify.token_bert.few_nerd': 'bert_base_token_classifier_few_nerd',
                                           'en.embed.longformer': 'longformer_base_4096',
                                           'en.embed.longformer.large': 'longformer_large_4096',
                                           'en.ner.ontonotes_roberta_base': 'ner_ontonotes_roberta_base',
                                           'en.ner.ontonotes_roberta_large': 'ner_ontonotes_roberta_large',
                                           'en.ner.ontonotes_distilbert_base_cased': 'ner_ontonotes_distilbert_base_cased',
                                           'en.ner.conll_bert_base_cased': 'ner_conll_bert_base_cased',
                                           'en.ner.conll_distilbert_base_cased': 'ner_conll_distilbert_base_cased',
                                           'en.ner.conll_roberta_base': 'ner_conll_roberta_base',
                                           'en.ner.conll_roberta_large': 'ner_conll_roberta_large',
                                           'en.ner.conll_xlm_roberta_base': 'ner_conll_xlm_roberta_base',
                                           'en.ner.conll_longformer_large_4096': 'ner_conll_longformer_large_4096',
                                           'en.ner.conll_albert_base_uncased': 'ner_conll_albert_base_uncased',
                                           'en.ner.conll_albert_large_uncased': 'ner_conll_albert_large_uncased',
                                           'en.ner.conll_xlnet_base_cased': 'ner_conll_xlnet_base_cased',
                                           'en.embed.bert.wiki_books_sst2': 'bert_wiki_books_sst2',
                                           'en.embed.bert.wiki_books_squad2': 'bert_wiki_books_squad2',
                                           'en.embed.bert.wiki_books_qqp': 'bert_wiki_books_qqp',
                                           'en.embed.bert.wiki_books_qnli': 'bert_wiki_books_qnli',
                                           'en.embed.bert.wiki_books_mnli': 'bert_wiki_books_mnli',
                                           'en.embed.bert.wiki_books': 'bert_wiki_books',
                                           'en.embed.bert.pubmed_squad2': 'bert_pubmed_squad2',
                                           'en.embed.bert.pubmed': 'bert_pubmed',
                                           'en.embed_sentence.bert.wiki_books_sst2': 'sent_bert_wiki_books_sst2',
                                           'en.embed_sentence.bert.wiki_books_squad2': 'sent_bert_wiki_books_squad2',
                                           'en.embed_sentence.bert.wiki_books_qqp': 'sent_bert_wiki_books_qqp',
                                           'en.embed_sentence.bert.wiki_books_qnli': 'sent_bert_wiki_books_qnli',
                                           'en.embed_sentence.bert.wiki_books_mnli': 'sent_bert_wiki_books_mnli',
                                           'en.embed_sentence.bert.wiki_books': 'sent_bert_wiki_books',
                                           'en.embed_sentence.bert.pubmed_squad2': 'sent_bert_pubmed_squad2',
                                           'en.embed_sentence.bert.pubmed': 'sent_bert_pubmed',
                                           'en.embed.bert.base_uncased_legal': 'bert_base_uncased_legal',
                                           'en.embed_sentence.bert.base_uncased_legal': 'sent_bert_base_uncased_legal',
                                           'en.classify.token_bert.classifier_ner_btc': 'bert_token_classifier_ner_btc',
                                           'en.classify.token_roberta_large_token_classifier_conll03': 'roberta_large_token_classifier_conll03',
                                           'en.classify.token_roberta_base_token_classifier_ontonotes': 'roberta_base_token_classifier_ontonotes',
                                           'en.classify.token_roberta_base_token_classifier_conll03': 'roberta_base_token_classifier_conll03',
                                           'en.classify.token_distilroberta_base_token_classifier_ontonotes': 'distilroberta_base_token_classifier_ontonotes',
                                           'en.classify.token_albert_large_token_classifier_conll03': 'albert_large_token_classifier_conll03',
                                           'en.classify.token_albert_base_token_classifier_conll03': 'albert_base_token_classifier_conll03',
                                           'en.classify.token_xlnet_base_token_classifier_conll03': 'xlnet_base_token_classifier_conll03',
                                           'en.classify.token_roberta.large_token_classifier_ontonotes': 'roberta_large_token_classifier_ontonotes',
                                           'en.classify.token_albert.xlarge_token_classifier_conll03': 'albert_xlarge_token_classifier_conll03',
                                           'en.classify.token_xlnet.large_token_classifier_conll03': 'xlnet_large_token_classifier_conll03',
                                           'en.classify.token_longformer.base_token_classifier_conll03': 'longformer_base_token_classifier_conll03',
                                           'en.classify.bert_sequence.imdb_large': 'bert_large_sequence_classifier_imdb',
                                           'en.classify.bert_sequence.imdb': 'bert_base_sequence_classifier_imdb',
                                           'en.classify.bert_sequence.ag_news': 'bert_base_sequence_classifier_ag_news',
                                           'en.classify.bert_sequence.dbpedia_14': 'bert_base_sequence_classifier_dbpedia_14',
                                           'en.classify.bert_sequence.finbert': 'bert_sequence_classifier_finbert',
                                           'en.classify.bert_sequence.dehatebert_mono': 'bert_sequence_classifier_dehatebert_mono',
                                           'en.classify.distilbert_sequence.sst2': 'distilbert_sequence_classifier_sst2',
                                           'en.classify.distilbert_sequence.policy': 'distilbert_sequence_classifier_policy',
                                           'en.classify.distilbert_sequence.industry': 'distilbert_sequence_classifier_industry',
                                           'en.classify.distilbert_sequence.emotion': 'distilbert_sequence_classifier_emotion',
                                           'en.classify.distilbert_sequence.banking77': 'distilbert_sequence_classifier_banking77',
                                           'en.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
                                           'en.classify.distilbert_sequence.amazon_polarity': 'distilbert_base_sequence_classifier_amazon_polarity',
                                           'en.classify.distilbert_sequence.ag_news': 'distilbert_base_sequence_classifier_ag_news',
                                           'en.embed_sentence.doc2vec': 'doc2vec_gigaword_300',
                                           'en.embed_sentence.doc2vec.gigaword_300': 'doc2vec_gigaword_300',
                                           'en.embed_sentence.doc2vec.gigaword_wiki_300': 'doc2vec_gigaword_wiki_300',
                                           'en.gpt2.distilled': 'gpt2_distilled',
                                           'en.gpt2': 'gpt2',
                                           'en.gpt2.medium': 'gpt2_medium',
                                           'en.gpt2.large': 'gpt_large',
                                           'en.embed.electra.medical': 'electra_medal_acronym',
                                           'en.ner.restaurant': 'nerdl_restaurant_100d',
                                           'en.embed.word2vec.gigaword_wiki': 'word2vec_gigaword_wiki_300',
                                           'en.embed.word2vec.gigaword': 'word2vec_gigaword_300',
                                           'en.classify.xlm_roberta.imdb': 'xlm_roberta_base_sequence_classifier_imdb',
                                           'en.classify.xlm_roberta.ag_news': 'xlm_roberta_base_sequence_classifier_ag_news',
                                           'en.classify.roberta.imdb': 'roberta_base_sequence_classifier_imdb',
                                           'en.classify.roberta.ag_news': 'roberta_base_sequence_classifier_ag_news',
                                           'en.classify.albert.ag_news': 'albert_base_sequence_classifier_ag_news',
                                           'en.classify.albert.imdb': 'albert_base_sequence_classifier_imdb',
                                           'en.classify.ag_news.longformer': 'longformer_base_sequence_classifier_ag_news',
                                           'en.classify.imdb.longformer': 'longformer_base_sequence_classifier_imdb',
                                           'en.classify.finance_sentiment': 'bert_sequence_classifier_finbert_tone',
                                           'en.classify.imdb.xlnet': 'xlnet_base_sequence_classifier_imdb',
                                           'en.classify.ag_news.xlnet': 'xlnet_base_sequence_classifier_ag_news',
                                           'en.ner.time': 'roberta_token_classifier_timex_semeval',
                                           'en.ner.stocks_ticker': 'roberta_token_classifier_ticker',
                                           'en.t5.active_to_passive_styletransfer': 't5_active_to_passive_styletransfer',
                                           'en.t5.formal_to_informal_styletransfer': 't5_formal_to_informal_styletransfer',
                                           'en.t5.grammar_error_corrector': 't5_grammar_error_corrector',
                                           'en.t5.informal_to_formal_styletransfer': 't5_informal_to_formal_styletransfer',
                                           'en.t5.passive_to_active_styletransfer': 't5_passive_to_active_styletransfer',
                                           'en.t5.wikiSQL': 't5_small_wikiSQL',
                                           'en.embed.longformer.clinical': 'clinical_longformer',
                                           'en.classify.emotion.bert': 'bert_sequence_classifier_emotion',
                                           'en.classify.typos.distilbert': 'distilbert_token_classifier_typo_detector',
                                           'en.embed.deberta_v3_xsmall': 'deberta_v3_xsmall',
                                           'en.embed.deberta_v3_small': 'deberta_v3_small',
                                           'en.embed.deberta_v3_base': 'deberta_v3_base',
                                           'en.embed.deberta_v3_large': 'deberta_v3_large',
                                           'en.classify.sentiment.imdb.deberta': 'deberta_v3_xsmall_sequence_classifier_imdb',
                                           'en.classify.sentiment.imdb.deberta.small': 'deberta_v3_small_sequence_classifier_imdb',
                                           'en.classify.sentiment.imdb.deberta.base': 'deberta_v3_base_sequence_classifier_imdb',
                                           'en.classify.sentiment.imdb.deberta.large': 'deberta_v3_large_sequence_classifier_imdb',
                                           'en.classify.news.deberta': 'deberta_v3_xsmall_sequence_classifier_ag_news',
                                           'en.classify.news.deberta.small': 'deberta_v3_small_sequence_classifier_ag_news',
                                           'en.classify.dbpedia': 'deberta_v3_small_sequence_classifier_dbpedia_14',
                                           'en.lemma.atis': 'lemma_atis',
                                           'en.lemma.esl': 'lemma_esl',
                                           'en.lemma.gum': 'lemma_gum',
                                           'en.lemma.partut': 'lemma_partut',
                                           'en.pos.ewt': 'pos_ewt',
                                           'en.pos.partut': 'pos_partut',
                                           'en.pos.lines': 'pos_lines',
                                           'en.pos.gum': 'pos_gum'},
                                    'yi': {'yi.detect_sentence': 'sentence_detector_dl'},
                                    'fr': {'fr.embed.word2vec_wiki_1000': 'word2vec_wiki_1000',
                                           'fr.embed.word2vec_wac_200': 'word2vec_wac_200',
                                           'fr.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'fr.lemma': 'lemma',
                                           'fr.pos': 'pos_ud_gsd',
                                           'fr.pos.ud_gsd': 'pos_ud_gsd',
                                           'fr.ner': 'wikiner_840B_300',
                                           'fr.ner.wikiner': 'wikiner_840B_300',
                                           'fr.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'fr.stopwords': 'stopwords_fr',
                                           'fr.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'fr.classify.sentiment.bert': 'classifierdl_bert_sentiment',
                                           'fr.classify.distilbert_sequence.allocine': 'distilbert_multilingual_sequence_classifier_allocine',
                                           'fr.classify.xlm_roberta.allocine': 'xlm_roberta_base_sequence_classifier_allocine',
                                           'fr.classify.allocine': 'mdeberta_v3_base_sequence_classifier_allocine',
                                           'fr.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                           'fr.lemma.gsd': 'lemma_gsd',
                                           'fr.lemma.partut': 'lemma_partut',
                                           'fr.lemma.rhapsodie': 'lemma_rhapsodie',
                                           'fr.lemma.parisstories': 'lemma_parisstories',
                                           'fr.lemma.sequoia': 'lemma_sequoia',
                                           'fr.pos.gsd': 'pos_gsd',
                                           'fr.pos.parisstories': 'pos_parisstories',
                                           'fr.pos.partut': 'pos_partut'},
                                    'de': {'de.classify.news_sentiment.bert': 'bert_sequence_classifier_news_sentiment',
                                           'de.lemma': 'lemma',
                                           'de.pos.ud_hdt': 'pos_ud_hdt',
                                           'de.pos': 'pos_ud_hdt',
                                           'de.ner': 'wikiner_840B_300',
                                           'de.ner.wikiner': 'wikiner_840B_300',
                                           'de.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'de.stopwords': 'stopwords_de',
                                           'de.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'de.embed.bert': 'bert_base_german_cased',
                                           'de.embed.bert.uncased': 'bert_base_german_uncased',
                                           'de.classify.news': 'classifierdl_bert_news',
                                           'de.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'de.classify.sentiment.bert': 'classifierdl_bert_sentiment',
                                           'de.ner.xlm': 'xlm_roberta_large_token_classifier_conll03',
                                           'de.embed.medbert': 'bert_embeddings_German_MedBERT',
                                           'de.lemma.gsd': 'lemma_gsd',
                                           'de.lemma.hdt': 'lemma_hdt',
                                           'de.pos.gsd': 'pos_gsd',
                                           'de.pos.hdt': 'pos_hdt'},
                                    'it': {'it.lemma': 'lemma_dxc',
                                           'it.lemma.dxc': 'lemma_dxc',
                                           'it.embed.word2vec': 'w2v_cc_300d',
                                           'it.pos': 'pos_ud_isdt',
                                           'it.pos.ud_isdt': 'pos_ud_isdt',
                                           'it.ner': 'wikiner_840B_300',
                                           'it.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'it.stopwords': 'stopwords_it',
                                           'it.embed.bert': 'bert_base_italian_cased',
                                           'it.embed.bert.uncased': 'bert_base_italian_uncased',
                                           'it.classify.sentiment': 'bert_sequence_classifier_sentiment',
                                           'it.embed.bert_it_cased': 'bert_embeddings_bert_base_it_cased',
                                           'it.lemma.isdt': 'lemma_isdt',
                                           'it.lemma.partut': 'lemma_partut',
                                           'it.lemma.vit': 'lemma_vit',
                                           'it.pos.isdt': 'pos_isdt',
                                           'it.pos.postwita': 'pos_postwita',
                                           'it.pos.vit': 'pos_vit'},
                                    'nb': {'nb.lemma': 'lemma'},
                                    'no': {'no.ner.norne.100d': 'norne_6B_100',
                                           'no.ner.norne': 'norne_6B_100',
                                           'no.ner.norne.glove.6B_300': 'norne_6B_300',
                                           'no.ner.norne.glove.840B_300': 'norne_840B_300',
                                           'no.lemma.nynorsklia': 'lemma_nynorsklia'},
                                    'nn': {'nn.pos': 'pos_ud_nynorsk', 'nn.pos.ud_nynorsk': 'pos_ud_nynorsk'},
                                    'pl': {'pl.lemma': 'lemma',
                                           'pl.pos': 'pos_ud_lfg',
                                           'pl.pos.ud_lfg': 'pos_ud_lfg',
                                           'pl.ner': 'wikiner_6B_100',
                                           'pl.ner.wikiner': 'wikiner_6B_100',
                                           'pl.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                           'pl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'pl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'pl.stopwords': 'stopwords_pl',
                                           'pl.lemma.pdb': 'lemma_pdb',
                                           'pl.pos.pdb': 'pos_pdb'},
                                    'pt': {'pt.lemma': 'lemma',
                                           'pt.pos.ud_bosque': 'pos_ud_bosque',
                                           'pt.pos': 'pos_ud_bosque',
                                           'pt.ner': 'wikiner_6B_100',
                                           'pt.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                           'pt.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'pt.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'pt.stopwords': 'stopwords_pt',
                                           'pt.bert': 'bert_portuguese_base_cased',
                                           'pt.bert.cased': 'bert_portuguese_base_cased',
                                           'pt.bert.cased.large': 'bert_portuguese_large_cased',
                                           'pt.lemma.gsd': 'lemma_gsd',
                                           'pt.pos.bosque': 'pos_bosque',
                                           'pt.pos.gsd': 'pos_gsd'},
                                    'ru': {'ru.lemma': 'lemma',
                                           'ru.pos.ud_gsd': 'pos_ud_gsd',
                                           'ru.pos': 'pos_ud_gsd',
                                           'ru.ner': 'wikiner_6B_100',
                                           'ru.ner.wikiner': 'wikiner_6B_100',
                                           'ru.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                           'ru.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'ru.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'ru.stopwords': 'stopwords_ru',
                                           'ru.detect_sentence': 'sentence_detector_dl',
                                           'ru.classify.toxic': 'bert_sequence_classifier_toxicity',
                                           'ru.lemma.syntagrus': 'lemma_syntagrus',
                                           'ru.lemma.taiga': 'lemma_taiga',
                                           'ru.pos.taiga': 'pos_taiga'},
                                    'pa': {'pa.detect_sentence': 'sentence_detector_dl'},
                                    'ne': {'ne.detect_sentence': 'sentence_detector_dl'},
                                    'es': {'es.lemma': 'lemma',
                                           'es.pos': 'pos_ud_gsd',
                                           'es.pos.ud_gsd': 'pos_ud_gsd',
                                           'es.ner': 'wikiner_6B_100',
                                           'es.ner.wikiner': 'wikiner_6B_100',
                                           'es.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
                                           'es.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
                                           'es.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
                                           'es.stopwords_es': 'stopwords_es',
                                           'es.classify.token_bert.spanish_ner': 'bert_token_classifier_spanish_ner',
                                           'es.embed.bert.base_uncased': 'bert_base_uncased',
                                           'es.embed.bert.base_cased': 'bert_base_cased',
                                           'es.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
                                           'es.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'es.embed.w2v_cc_300d': 'w2v_cc_300d',
                                           'es.lemma.ancora': 'lemma_ancora',
                                           'es.lemma.gsd': 'lemma_gsd',
                                           'es.pos.gsd': 'pos_gsd'},
                                    'af': {'af.stopwords': 'stopwords_af',
                                           'af.lemma': 'lemma',
                                           'af.pos': 'pos_afribooms',
                                           'af.lemma.afribooms': 'lemma_afribooms'},
                                    'ar': {'ar.stopwords': 'stopwords_ar',
                                           'ar.lemma': 'lemma',
                                           'ar.pos': 'pos_ud_padt',
                                           'ar.embed': 'arabic_w2v_cc_300d',
                                           'ar.embed.cbow': 'arabic_w2v_cc_300d',
                                           'ar.embed.cbow.300d': 'arabic_w2v_cc_300d',
                                           'ar.embed.aner': 'arabic_w2v_cc_300d',
                                           'ar.embed.aner.300d': 'arabic_w2v_cc_300d',
                                           'ar.embed.glove': 'arabic_w2v_cc_300d',
                                           'ar.ner': 'aner_cc_300d',
                                           'ar.ner.aner': 'aner_cc_300d',
                                           'ar.embed.arbert': 'bert_embeddings_ARBERT'},
                                    'hy': {'hy.stopwords': 'stopwords_hy',
                                           'hy.lemma': 'lemma',
                                           'hy.pos': 'pos_ud_armtdp',
                                           'hy.pos.armtdp': 'pos_armtdp'},
                                    'eu': {'eu.stopwords': 'stopwords_eu',
                                           'eu.lemma': 'lemma',
                                           'eu.pos': 'pos_ud_bdt',
                                           'eu.pos.bdt': 'pos_bdt'},
                                    'bn': {'bn.stopwords': 'stopwords_bn',
                                           'bn.lemma': 'lemma',
                                           'bn.pos': 'pos_msri',
                                           'bn.ner': 'bengaliner_cc_300d',
                                           'bn.ner.jifs': 'ner_jifs_glove_840B_300d',
                                           'bn.ner.glove': 'ner_jifs_glove_840B_300d',
                                           'bn.embed.glove': 'bengali_cc_300d',
                                           'bn.embed': 'bengali_cc_300d',
                                           'bn.embed.bangala_bert': 'bert_embeddings_bangla_bert_base'},
                                    'br': {'br.stopwords': 'stopwords_br',
                                           'br.lemma': 'lemma',
                                           'br.pos': 'pos_ud_keb'},
                                    'bg': {'bg.lemma': 'lemma',
                                           'bg.pos': 'pos_btb',
                                           'bg.pos.ud_btb': 'pos_ud_btb',
                                           'bg.stopwords': 'stopwords_bg',
                                           'bg.lemma.btb': 'lemma_btb'},
                                    'ca': {'ca.stopwords': 'stopwords_ca',
                                           'ca.lemma': 'lemma',
                                           'ca.pos': 'pos_ud_ancora',
                                           'ca.lemma.ancora': 'lemma_ancora',
                                           'ca.pos.ancora': 'pos_ancora'},
                                    'cs': {'cs.lemma': 'lemma',
                                           'cs.pos': 'pos_ud_pdt',
                                           'cs.pos.ud_pdt': 'pos_ud_pdt',
                                           'cs.stopwords': 'stopwords_cs',
                                           'cs.pos.cac': 'pos_cac',
                                           'cs.lemma.cac': 'lemma_cac',
                                           'cs.lemma.pdt': 'lemma_pdt',
                                           'cs.pos.cltt': 'pos_cltt',
                                           'cs.pos.pdt': 'pos_pdt'},
                                    'eo': {'eo.stopwords': 'stopwords_eo'},
                                    'fi': {'fi.lemma': 'lemma',
                                           'fi.pos.ud_tdt': 'pos_ud_tdt',
                                           'fi.pos': 'pos_ud_tdt',
                                           'fi.stopwords': 'stopwords_fi',
                                           'fi.ner': 'wikiner_6B_100',
                                           'fi.ner.6B_100d': 'finnish_ner_6B_100',
                                           'fi.ner.6B_300d': 'finnish_ner_6B_300',
                                           'fi.ner.840B_300d': 'finnish_ner_840B_300',
                                           'fi.embed_sentence.bert.uncased': 'bert_base_finnish_uncased',
                                           'fi.embed_sentence.bert': 'bert_base_finnish_uncased',
                                           'fi.embed_sentence.bert.cased': 'bert_base_finnish_cased',
                                           'fi.pos.ftb': 'pos_ftb'},
                                    'gl': {'gl.stopwords': 'stopwords_gl',
                                           'gl.lemma': 'lemma',
                                           'gl.pos': 'pos_ud_treegal',
                                           'gl.lemma.ctg': 'lemma_ctg',
                                           'gl.pos.ctg': 'pos_ctg',
                                           'gl.pos.treegal': 'pos_treegal'},
                                    'el': {'el.lemma': 'lemma',
                                           'el.pos': 'pos_ud_gdt',
                                           'el.pos.ud_gdt': 'pos_ud_gdt',
                                           'el.stopwords': 'stopwords_el',
                                           'el.embed.bert.base_uncased': 'bert_base_uncased',
                                           'el.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
                                           'el.lemma.gdt': 'lemma_gdt',
                                           'el.pos.gdt': 'pos_gdt'},
                                    'ha': {'ha.stopwords': 'stopwords_ha',
                                           'ha.embed.xlm_roberta': 'xlm_roberta_base_finetuned_hausa',
                                           'ha.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_hausa'},
                                    'he': {'he.stopwords': 'stopwords_he',
                                           'he.embed': 'hebrew_cc_300d',
                                           'he.embed.glove': 'hebrew_cc_300d',
                                           'he.embed.cbow_300d': 'hebrew_cc_300d',
                                           'he.ner': 'hebrewner_cc_300d',
                                           'he.ner.cc_300d': 'hebrewner_cc_300d',
                                           'he.pos': 'pos_ud_htb',
                                           'he.pos.ud_htb': 'pos_ud_htb',
                                           'he.lemma': 'lemma',
                                           'he.lemma.htb': 'lemma_htb',
                                           'he.pos.htb': 'pos_htb'},
                                    'hi': {'hi.stopwords': 'stopwords_hi',
                                           'hi.lemma': 'lemma',
                                           'hi.pos': 'pos_ud_hdtb',
                                           'hi.embed': 'hindi_cc_300d',
                                           'hi.ner': 'bert_hi_en_ner',
                                           'hi.ner.bert': 'bert_token_classifier_hi_en_ner',
                                           'hi.embed.bert_hi_cased': 'bert_embeddings_bert_base_hi_cased',
                                           'hi.lemma.hdtb': 'lemma_hdtb',
                                           'hi.pos.hdtb': 'pos_hdtb'},
                                    'hif': {'hif.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'hu': {'hu.lemma': 'lemma',
                                           'hu.pos': 'pos_ud_szeged',
                                           'hu.pos.ud_szeged': 'pos_ud_szeged',
                                           'hu.stopwords': 'stopwords_hu',
                                           'hu.lemma.szeged': 'lemma_szeged',
                                           'hu.pos.szeged': 'pos_szeged'},
                                    'id': {'id.stopwords': 'stopwords_id',
                                           'id.lemma': 'lemma',
                                           'id.pos': 'roberta_token_classifier_pos_tagger',
                                           'id.detect_sentence': 'sentence_detector_dl',
                                           'id.ner': 'xlm_roberta_large_token_classification_ner',
                                           'id.lemma.csui': 'lemma_csui',
                                           'id.pos.gsd': 'pos_gsd'},
                                    'ga': {'ga.stopwords': 'stopwords_ga',
                                           'ga.lemma': 'lemma',
                                           'ga.pos': 'pos_ud_idt',
                                           'ga.lemma.idt': 'lemma_idt'},
                                    'da': {'da.lemma': 'lemma',
                                           'da.pos': 'pos_ud_ddt',
                                           'da.ner': 'dane_ner_6B_100',
                                           'da.ner.6B_100D': 'dane_ner_6B_100',
                                           'da.ner.6B_300D': 'dane_ner_6B_300',
                                           'da.ner.840B_300D': 'dane_ner_840B_300',
                                           'da.lemma.ddt': 'lemma_ddt',
                                           'da.pos.ddt': 'pos_ddt'},
                                    'ja': {'ja.stopwords': 'stopwords_ja',
                                           'ja.segment_words': 'wordseg_gsd_ud',
                                           'ja.ner': 'ner_ud_gsd_glove_840B_300d',
                                           'ja.pos': 'pos_ud_gsd',
                                           'ja.ner.ud_gsd': 'ner_ud_gsd_glove_840B_300d',
                                           'ja.ner.ud_gsd.glove_840B_300D': 'ner_ud_gsd_glove_840B_300d',
                                           'ja.pos.ud_gsd': 'pos_ud_gsd',
                                           'ja.lemma': 'lemma',
                                           'ja.embed.glove.cc_300d': 'japanese_cc_300d',
                                           'ja.ner.ud_gsd_cc_300d': 'ner_ud_gsd_cc_300d',
                                           'ja.ner.ud_gsd_xlm_roberta_base': 'ner_ud_gsd_xlm_roberta_base',
                                           'ja.classify.token_bert.classifier_ner_ud_gsd': 'bert_token_classifier_ner_ud_gsd',
                                           'ja.lemma.gsdluw': 'lemma_gsdluw',
                                           'ja.lemma.gsd': 'lemma_gsd',
                                           'ja.pos.gsdluw': 'pos_gsdluw'},
                                    'la': {'la.stopwords': 'stopwords_la',
                                           'la.lemma': 'lemma',
                                           'la.pos': 'pos_ud_llct',
                                           'la.lemma.ittb': 'lemma_ittb',
                                           'la.lemma.perseus': 'lemma_perseus',
                                           'la.lemma.udante': 'lemma_udante',
                                           'la.pos.ittb': 'pos_ittb',
                                           'la.pos.llct': 'pos_llct',
                                           'la.pos.proiel': 'pos_proiel'},
                                    'lv': {'lv.stopwords': 'stopwords_lv',
                                           'lv.lemma': 'lemma',
                                           'lv.pos': 'pos_ud_lvtb',
                                           'lv.lemma.lvtb': 'lemma_lvtb'},
                                    'mr': {'mr.stopwords': 'stopwords_mr',
                                           'mr.lemma': 'lemma',
                                           'mr.pos': 'pos_ud_ufal',
                                           'mr.detect_sentence': 'sentence_detector_dl'},
                                    'ml': {'ml.detect_sentence': 'sentence_detector_dl'},
                                    'kn': {'ml.detect_sentence': 'sentence_detector_dl'},
                                    'gu': {'gu.detect_sentence': 'sentence_detector_dl'},
                                    'bs': {'bs.detect_sentence': 'sentence_detector_dl'},
                                    'fa': {'fa.stopwords': 'stopwords_fa',
                                           'fa.lemma': 'lemma',
                                           'fa.pos': 'pos_ud_perdt',
                                           'fa.ner': 'personer_cc_300d',
                                           'fa.ner.person': 'personer_cc_300d',
                                           'fa.ner.person.cc_300d': 'personer_cc_300d',
                                           'fa.embed': 'persian_w2v_cc_300d',
                                           'fa.embed.word2vec': 'persian_w2v_cc_300d',
                                           'fa.embed.word2vec.300d': 'persian_w2v_cc_300d',
                                           'fa.classify.token_bert.parsbert_armanner': 'bert_token_classifier_parsbert_armanner',
                                           'fa.classify.token_bert.parsbert_ner': 'bert_token_classifier_parsbert_ner',
                                           'fa.classify.token_bert.parsbert_peymaner': 'bert_token_classifier_parsbert_peymaner',
                                           'fa.classify.token_roberta_token_classifier_zwnj_base_ner': 'roberta_token_classifier_zwnj_base_ner',
                                           'fa.lemma.perdt': 'lemma_perdt',
                                           'fa.lemma.seraji': 'lemma_seraji',
                                           'fa.pos.seraji': 'pos_seraji'},
                                    'ro': {'ro.lemma': 'lemma',
                                           'ro.pos': 'pos_ud_rrt',
                                           'ro.pos.ud_rrt': 'pos_ud_rrt',
                                           'ro.stopwords': 'stopwords_ro',
                                           'ro.lemma.nonstandard': 'lemma_nonstandard',
                                           'ro.lemma.rrt': 'lemma_rrt',
                                           'ro.lemma.simonero': 'lemma_simonero',
                                           'ro.pos.simonero': 'pos_simonero',
                                           'ro.pos.rrt': 'pos_rrt'},
                                    'sk': {'sk.lemma': 'lemma',
                                           'sk.pos': 'pos_ud_snk',
                                           'sk.pos.ud_snk': 'pos_ud_snk',
                                           'sk.stopwords': 'stopwords_sk',
                                           'sk.pos.snk': 'pos_snk'},
                                    'sl': {'sl.stopwords': 'stopwords_sl',
                                           'sl.lemma': 'lemma',
                                           'sl.pos': 'pos_ud_ssj',
                                           'sl.lemma.ssj': 'lemma_ssj',
                                           'sl.pos.ssj': 'pos_ssj'},
                                    'so': {'so.stopwords': 'stopwords_so',
                                           'so.detect_sentence': 'sentence_detector_dl'},
                                    'sd': {'sd.detect_sentence': 'sentence_detector_dl'},
                                    'st': {'st.stopwords': 'stopwords_st'},
                                    'sw': {'sw.stopwords': 'stopwords_sw',
                                           'sw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_swahili',
                                           'sw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_swahili'},
                                    'sv': {'sv.lemma': 'lemma',
                                           'sv.pos': 'pos_ud_tal',
                                           'sv.pos.ud_tal': 'pos_ud_tal',
                                           'sv.stopwords': 'stopwords_sv',
                                           'sv.ner': 'swedish_ner_6B_100',
                                           'sv.ner.6B_100': 'swedish_ner_6B_100',
                                           'sv.ner.6B_300': 'swedish_ner_6B_300',
                                           'sv.ner.840B_300': 'swedish_ner_840B_300',
                                           'sv.classify.token_bert.swedish_ner': 'bert_token_classifier_swedish_ner',
                                           'sv.embed.bert.base_cased': 'bert_base_cased',
                                           'sv.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
                                           'sv.lemma.talbanken': 'lemma_talbanken',
                                           'sv.pos.lines': 'pos_lines',
                                           'sv.pos.talbanken': 'pos_talbanken'},
                                    'th': {'th.stopwords': 'stopwords_th',
                                           'th.ner.lst20.glove_840B_300D': 'ner_lst20_glove_840B_300d',
                                           'th.segment_words': 'wordseg_best',
                                           'th.pos': 'pos_lst20',
                                           'th.sentiment': 'sentiment_jager_use',
                                           'th.classify.sentiment': 'sentiment_jager_use'},
                                    'tr': {'tr.lemma': 'lemma',
                                           'tr.pos': 'pos_ud_imst',
                                           'tr.pos.ud_imst': 'pos_ud_imst',
                                           'tr.stopwords': 'stopwords_tr',
                                           'tr.ner': 'turkish_ner_840B_300',
                                           'tr.ner.bert': 'turkish_ner_bert',
                                           'tr.classify.news': 'classifierdl_bert_news',
                                           'tr.embed.bert': 'bert_base_turkish_cased',
                                           'tr.embed.bert.uncased': 'bert_base_turkish_uncased',
                                           'tr.classify.cyberbullying': 'classifierdl_berturk_cyberbullying',
                                           'tr.classify.token_bert.turkish_ner': 'bert_token_classifier_turkish_ner',
                                           'tr.ner.xlm_roberta': 'xlm_roberta_base_token_classifier_ner',
                                           'tr.embed.bert_cased': 'bert_embeddings_bert_base_tr_cased',
                                           'tr.lemma.boun': 'lemma_boun',
                                           'tr.lemma.atis': 'lemma_atis',
                                           'tr.lemma.tourism': 'lemma_tourism',
                                           'tr.pos.framenet': 'pos_framenet',
                                           'tr.pos.atis': 'pos_atis',
                                           'tr.pos.kenet': 'pos_kenet',
                                           'tr.pos.penn': 'pos_penn'},
                                    'uk': {'uk.lemma': 'lemma',
                                           'uk.pos': 'pos_ud_iu',
                                           'uk.pos.ud_iu': 'pos_ud_iu',
                                           'uk.detect_sentence': 'sentence_detector_dl',
                                           'uk.lemma.iu': 'lemma_iu',
                                           'uk.pos.iu': 'pos_iu'},
                                    'te': {'te.detect_sentence': 'sentence_detector_dl',
                                           'te.embed.distilbert': 'distilbert_uncased',
                                           'te.pos': 'pos_mtg'},
                                    'yo': {'yo.stopwords': 'stopwords_yo',
                                           'yo.lemma': 'lemma',
                                           'yo.pos': 'pos_ud_ytb',
                                           'yo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_yoruba',
                                           'yo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_yoruba'},
                                    'ig': {'ig.embed.xlm_roberta': 'xlm_roberta_base_finetuned_igbo',
                                           'ig.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_igbo'},
                                    'lg': {'lg.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luganda',
                                           'lg.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_luganda'},
                                    'lou': {'lou.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luo'},
                                    'pcm': {'pcm.embed.xlm_roberta': 'xlm_roberta_base_finetuned_naija',
                                            'pcm.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_naija',
                                            'pcm.lemma.nsc': 'lemma_nsc',
                                            'pcm.pos.nsc': 'pos_nsc'},
                                    'wo': {'wo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_wolof',
                                           'wo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_wolof',
                                           'wo.lemma.wtb': 'lemma_wtb'},
                                    'rw': {
                                        'rw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_kinyarwanda',
                                        'rw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_kinyarwanda'},
                                    'zu': {'zu.stopwords': 'stopwords_zu'},
                                    'zh': {'zh.segment_words': 'wordseg_weibo',
                                           'zh.tokenize': 'wordseg_weibo',
                                           'zh.segment_words.weibo': 'wordseg_weibo',
                                           'zh.segment_words.pku': 'wordseg_pku',
                                           'zh.segment_words.msra': 'wordseg_msra',
                                           'zh.segment_words.large': 'wordseg_large',
                                           'zh.segment_words.ctb9': 'wordseg_ctb9',
                                           'zh.segment_words.gsd': 'wordseg_gsd_ud_trad',
                                           'zh.pos': 'pos_ud_gsd',
                                           'zh.pos.ud_gsd': 'pos_ud_gsd',
                                           'zh.pos.ud_gsd_trad': 'pos_ud_gsd_trad',
                                           'zh.ner': 'ner_msra_bert_768d',
                                           'zh.ner.bert': 'ner_msra_bert_768d',
                                           'zh.ner.msra.bert_768D': 'ner_msra_bert_768d',
                                           'zh.ner.weibo.bert_768d': 'ner_weibo_bert_768d',
                                           'zh.lemma': 'lemma',
                                           'zh.embed': 'bert_base_chinese',
                                           'zh.embed.bert': 'bert_base_chinese',
                                           'zh.embed.bert.wwm': 'chinese_bert_wwm',
                                           'zh.embed.xlnet': 'chinese_xlnet_base',
                                           'zh.ner.bert_token': 'bert_token_classifier_chinese_ner',
                                           'zh.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
                                           'zh.lemma.gsd': 'lemma_gsd',
                                           'zh.lemma.gsdsimp': 'lemma_gsdsimp'},
                                    'et': {'et.lemma': 'lemma', 'et.pos.ewt': 'pos_ewt'},
                                    'ur': {'ur.lemma': 'lemma',
                                           'ur.pos': 'pos_ud_udtb',
                                           'ur.pos.ud_udtb': 'pos_ud_udtb',
                                           'ur.sentiment': 'sentimentdl_urduvec_imdb',
                                           'ur.embed': 'urduvec_140M_300d',
                                           'ur.embed.glove.300d': 'urduvec_140M_300d',
                                           'ur.embed.urdu_vec_140M_300d': 'urduvec_140M_300d',
                                           'ur.ner': 'uner_mk_140M_300d',
                                           'ur.ner.mk_140M_300d': 'uner_mk_140M_300d',
                                           'ur.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
                                           'ur.classify.fakenews': 'classifierdl_urduvec_fakenews',
                                           'ur.classify.news': 'classifierdl_bert_news',
                                           'ur.classify.sentiment.imdb': 'mdeberta_v3_base_sequence_classifier_imdb',
                                           'ur.embed.bert_cased': 'bert_embeddings_bert_base_ur_cased'},
                                    'ko': {'ko.segment_words': 'wordseg_kaist_ud',
                                           'ko.pos': 'pos_ud_kaist',
                                           'ko.ner': 'ner_kmou_glove_840B_300d',
                                           'ko.pos.ud_kaist': 'pos_ud_kaist',
                                           'ko.ner.kmou': 'ner_kmou_glove_840B_300d',
                                           'ko.ner.kmou.glove_840B_300d': 'ner_kmou_glove_840B_300d',
                                           'ko.lemma': 'lemma',
                                           'ko.embed.bert': 'bert_embeddings_bert_base',
                                           'ko.pos.kaist': 'pos_kaist'},
                                    'bh': {'bh.pos': 'pos_ud_bhtb', 'bh.lemma': 'lemma'},
                                    'am': {'am.pos': 'pos_ud_att',
                                           'am.lemma': 'lemma',
                                           'am.embed.xlm_roberta': 'xlm_roberta_base_finetuned_amharic',
                                           'am.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_amharic'},
                                    'azb': {'azb.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'xx': {'xx.embed.mdeberta_v3_base': 'mdeberta_v3_base',
                                           'xx.embed.albert.indic': 'albert_indic',
                                           'xx.ner.masakhaner.distilbert': 'distilbert_base_token_classifier_masakhaner',
                                           'xx.ner.masakhaner': 'xlm_roberta_large_token_classifier_masakhaner',
                                           'xx.ner.masakhaner.xlm_roberta': 'xlm_roberta_large_token_classifier_masakhaner',
                                           'xx.ner.high_resourced_lang': 'xlm_roberta_large_token_classifier_hrl',
                                           'xx.ner.scandinavian': 'bert_token_classifier_scandi_ner',
                                           'xx.embed.xlm_roberta_large': 'xlm_roberta_large',
                                           'xx.classify.token_xlm_roberta.token_classifier_ner_40_lang': 'xlm_roberta_token_classifier_ner_40_lang',
                                           'xx.embed.bert.muril': 'bert_muril',
                                           'xx.embed_sentence.bert.muril': 'sent_bert_muril',
                                           'xx.ner.xtreme_glove_840B_300': 'ner_xtreme_glove_840B_300',
                                           'xx.ner.xtreme_xlm_roberta_xtreme_base': 'ner_xtreme_xlm_roberta_xtreme_base',
                                           'xx.ner.wikiner_glove_840B_300': 'ner_wikiner_glove_840B_300',
                                           'xx.ner.wikiner_xlm_roberta_base': 'ner_wikiner_xlm_roberta_base',
                                           'xx.embed_sentence.bert_use_cmlm_multi_base_br': 'sent_bert_use_cmlm_multi_base_br',
                                           'xx.embed_sentence.bert_use_cmlm_multi_base': 'sent_bert_use_cmlm_multi_base',
                                           'xx.embed.xlm_roberta_xtreme_base': 'xlm_roberta_xtreme_base',
                                           'xx.embed.bert_base_multilingual_cased': 'bert_base_multilingual_cased',
                                           'xx.embed.bert_base_multilingual_uncased': 'bert_base_multilingual_uncased',
                                           'xx.embed': 'glove_840B_300',
                                           'xx.embed.glove.840B_300': 'glove_840B_300',
                                           'xx.embed.glove.6B_300': 'glove_6B_300',
                                           'xx.embed.glove.glove_6B_100': 'glove_6B_100',
                                           'xx.embed.bert_multi_cased': 'bert_multi_cased',
                                           'xx.embed.bert': 'bert_multi_cased',
                                           'xx.classify.wiki_21': 'ld_wiki_tatoeba_cnn_21',
                                           'xx.classify.wiki_21.bigru': 'ld_tatoeba_bigru_21',
                                           'xx.classify.wiki_99': 'ld_tatoeba_cnn_99',
                                           'xx.classify.wiki_231': 'ld_wiki_cnn_231',
                                           'xx.classify.wiki_43': 'ld_wiki_tatoeba_cnn_43',
                                           'xx.classify.wiki_95': 'ld_wiki_tatoeba_cnn_95',
                                           'xx.classify.wiki_220': 'ld_wiki_tatoeba_cnn_220',
                                           'xx.classify.wiki_375': 'ld_wiki_tatoeba_cnn_375',
                                           'xx.embed_sentence': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.bert': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.bert.cased': 'sent_bert_multi_cased',
                                           'xx.embed_sentence.labse': 'labse',
                                           'xx.sentence_detector': 'sentence_detector_dl',
                                           'xx.marian': 'opus_mt_en_fr',
                                           'xx.embed.distilbert': 'distilbert_base_multilingual_cased',
                                           'xx.embed.xlm': 'xlm_roberta_base',
                                           'xx.embed.xlm.base': 'xlm_roberta_base',
                                           'xx.embed.xlm.twitter': 'twitter_xlm_roberta_base',
                                           'xx.use.multi': 'tfhub_use_multi',
                                           'xx.use.multi_lg': 'tfhub_use_multi_lg',
                                           'xx.swc.marian.translate_to.en': 'opus_mt_swc_en',
                                           'xx.en.marian.translate_to.umb': 'opus_mt_en_umb',
                                           'xx.en.marian.translate_to.bem': 'opus_mt_en_bem',
                                           'xx.kwy.marian.translate_to.en': 'opus_mt_kwy_en',
                                           'xx.en.marian.translate_to.ti': 'opus_mt_en_ti',
                                           'xx.efi.marian.translate_to.en': 'opus_mt_efi_en',
                                           'xx.taw.marian.translate_to.en': 'opus_mt_taw_en',
                                           'xx.bem.marian.translate_to.en': 'opus_mt_bem_en',
                                           'xx.en.marian.translate_to.sw': 'opus_mt_en_sw',
                                           'xx.en.marian.translate_to.sn': 'opus_mt_en_sn',
                                           'xx.pqe.marian.translate_to.en': 'opus_mt_pqe_en',
                                           'xx.ny.marian.translate_to.en': 'opus_mt_ny_en',
                                           'xx.urj.marian.translate_to.en': 'opus_mt_urj_en',
                                           'xx.war.marian.translate_to.en': 'opus_mt_war_en',
                                           'xx.nso.marian.translate_to.en': 'opus_mt_nso_en',
                                           'xx.en.marian.translate_to.hu': 'opus_mt_en_hu',
                                           'xx.en.marian.translate_to.cpp': 'opus_mt_en_cpp',
                                           'xx.ja.marian.translate_to.en': 'opus_mt_ja_en',
                                           'xx.en.marian.translate_to.rn': 'opus_mt_en_rn',
                                           'xx.en.marian.translate_to.bcl': 'opus_mt_en_bcl',
                                           'xx.en.marian.translate_to.bi': 'opus_mt_en_bi',
                                           'xx.vi.marian.translate_to.en': 'opus_mt_vi_en',
                                           'xx.ln.marian.translate_to.en': 'opus_mt_ln_en',
                                           'xx.en.marian.translate_to.itc': 'opus_mt_en_itc',
                                           'xx.itc.marian.translate_to.en': 'opus_mt_itc_en',
                                           'xx.uk.marian.translate_to.en': 'opus_mt_uk_en',
                                           'xx.en.marian.translate_to.gmq': 'opus_mt_en_gmq',
                                           'xx.loz.marian.translate_to.en': 'opus_mt_loz_en',
                                           'xx.mg.marian.translate_to.en': 'opus_mt_mg_en',
                                           'xx.bnt.marian.translate_to.en': 'opus_mt_bnt_en',
                                           'xx.en.marian.translate_to.zls': 'opus_mt_en_zls',
                                           'xx.mkh.marian.translate_to.en': 'opus_mt_mkh_en',
                                           'xx.en.marian.translate_to.lg': 'opus_mt_en_lg',
                                           'xx.et.marian.translate_to.en': 'opus_mt_et_en',
                                           'xx.fi.marian.translate_to.en': 'opus_mt_fi_en',
                                           'xx.en.marian.translate_to.vi': 'opus_mt_en_vi',
                                           'xx.en.marian.translate_to.ga': 'opus_mt_en_ga',
                                           'xx.nic.marian.translate_to.en': 'opus_mt_nic_en',
                                           'xx.lua.marian.translate_to.en': 'opus_mt_lua_en',
                                           'xx.afa.marian.translate_to.en': 'opus_mt_afa_en',
                                           'xx.en.marian.translate_to.pis': 'opus_mt_en_pis',
                                           'xx.en.marian.translate_to.ts': 'opus_mt_en_ts',
                                           'xx.sv.marian.translate_to.en': 'opus_mt_sv_en',
                                           'xx.en.marian.translate_to.dra': 'opus_mt_en_dra',
                                           'xx.en.marian.translate_to.pag': 'opus_mt_en_pag',
                                           'xx.en.marian.translate_to.ln': 'opus_mt_en_ln',
                                           'xx.alv.marian.translate_to.en': 'opus_mt_alv_en',
                                           'xx.ee.marian.translate_to.en': 'opus_mt_ee_en',
                                           'xx.bg.marian.translate_to.en': 'opus_mt_bg_en',
                                           'xx.en.marian.translate_to.tw': 'opus_mt_en_tw',
                                           'xx.en.marian.translate_to.gaa': 'opus_mt_en_gaa',
                                           'xx.en.marian.translate_to.tll': 'opus_mt_en_tll',
                                           'xx.en.marian.translate_to.phi': 'opus_mt_en_phi',
                                           'xx.en.marian.translate_to.tiv': 'opus_mt_en_tiv',
                                           'xx.en.marian.translate_to.ss': 'opus_mt_en_ss',
                                           'xx.en.marian.translate_to.cs': 'opus_mt_en_cs',
                                           'xx.kwn.marian.translate_to.en': 'opus_mt_kwn_en',
                                           'xx.mh.marian.translate_to.en': 'opus_mt_mh_en',
                                           'xx.en.marian.translate_to.cy': 'opus_mt_en_cy',
                                           'xx.en.marian.translate_to.mt': 'opus_mt_en_mt',
                                           'xx.en.marian.translate_to.ber': 'opus_mt_en_ber',
                                           'xx.ine.marian.translate_to.en': 'opus_mt_ine_en',
                                           'xx.ng.marian.translate_to.en': 'opus_mt_ng_en',
                                           'xx.ase.marian.translate_to.en': 'opus_mt_ase_en',
                                           'xx.en.marian.translate_to.afa': 'opus_mt_en_afa',
                                           'xx.en.marian.translate_to.ml': 'opus_mt_en_ml',
                                           'xx.en.marian.translate_to.zle': 'opus_mt_en_zle',
                                           'xx.wal.marian.translate_to.en': 'opus_mt_wal_en',
                                           'xx.en.marian.translate_to.sit': 'opus_mt_en_sit',
                                           'xx.hy.marian.translate_to.en': 'opus_mt_hy_en',
                                           'xx.umb.marian.translate_to.en': 'opus_mt_umb_en',
                                           'xx.en.marian.translate_to.cpf': 'opus_mt_en_cpf',
                                           'xx.en.marian.translate_to.gv': 'opus_mt_en_gv',
                                           'xx.en.marian.translate_to.pap': 'opus_mt_en_pap',
                                           'xx.gl.marian.translate_to.en': 'opus_mt_gl_en',
                                           'xx.kqn.marian.translate_to.en': 'opus_mt_kqn_en',
                                           'xx.ca.marian.translate_to.en': 'opus_mt_ca_en',
                                           'xx.gem.marian.translate_to.en': 'opus_mt_gem_en',
                                           'xx.en.marian.translate_to.crs': 'opus_mt_en_crs',
                                           'xx.en.marian.translate_to.rw': 'opus_mt_en_rw',
                                           'xx.en.marian.translate_to.ig': 'opus_mt_en_ig',
                                           'xx.en.marian.translate_to.aav': 'opus_mt_en_aav',
                                           'xx.en.marian.translate_to.tl': 'opus_mt_en_tl',
                                           'xx.sm.marian.translate_to.en': 'opus_mt_sm_en',
                                           'xx.en.marian.translate_to.hi': 'opus_mt_en_hi',
                                           'xx.chk.marian.translate_to.en': 'opus_mt_chk_en',
                                           'xx.en.marian.translate_to.kwy': 'opus_mt_en_kwy',
                                           'xx.en.marian.translate_to.ho': 'opus_mt_en_ho',
                                           'xx.ve.marian.translate_to.en': 'opus_mt_ve_en',
                                           'xx.ceb.marian.translate_to.en': 'opus_mt_ceb_en',
                                           'xx.aav.marian.translate_to.en': 'opus_mt_aav_en',
                                           'xx.st.marian.translate_to.en': 'opus_mt_st_en',
                                           'xx.en.marian.translate_to.cus': 'opus_mt_en_cus',
                                           'xx.en.marian.translate_to.bnt': 'opus_mt_en_bnt',
                                           'xx.iso.marian.translate_to.en': 'opus_mt_iso_en',
                                           'xx.tr.marian.translate_to.en': 'opus_mt_tr_en',
                                           'xx.om.marian.translate_to.en': 'opus_mt_om_en',
                                           'xx.fj.marian.translate_to.en': 'opus_mt_fj_en',
                                           'xx.ml.marian.translate_to.en': 'opus_mt_ml_en',
                                           'xx.en.marian.translate_to.ro': 'opus_mt_en_ro',
                                           'xx.en.marian.translate_to.ny': 'opus_mt_en_ny',
                                           'xx.en.marian.translate_to.ty': 'opus_mt_en_ty',
                                           'xx.cel.marian.translate_to.en': 'opus_mt_cel_en',
                                           'xx.ccs.marian.translate_to.en': 'opus_mt_ccs_en',
                                           'xx.hu.marian.translate_to.en': 'opus_mt_hu_en',
                                           'xx.art.marian.translate_to.en': 'opus_mt_art_en',
                                           'xx.en.marian.translate_to.ar': 'opus_mt_en_ar',
                                           'xx.en.marian.translate_to.mfe': 'opus_mt_en_mfe',
                                           'xx.yap.marian.translate_to.en': 'opus_mt_yap_en',
                                           'xx.ha.marian.translate_to.en': 'opus_mt_ha_en',
                                           'xx.cpf.marian.translate_to.en': 'opus_mt_cpf_en',
                                           'xx.en.marian.translate_to.hy': 'opus_mt_en_hy',
                                           'xx.en.marian.translate_to.roa': 'opus_mt_en_roa',
                                           'xx.crs.marian.translate_to.en': 'opus_mt_crs_en',
                                           'xx.en.marian.translate_to.lun': 'opus_mt_en_lun',
                                           'xx.zls.marian.translate_to.en': 'opus_mt_zls_en',
                                           'xx.en.marian.translate_to.mk': 'opus_mt_en_mk',
                                           'xx.en.marian.translate_to.fiu': 'opus_mt_en_fiu',
                                           'xx.en.marian.translate_to.sv': 'opus_mt_en_sv',
                                           'xx.gmw.marian.translate_to.en': 'opus_mt_gmw_en',
                                           'xx.en.marian.translate_to.st': 'opus_mt_en_st',
                                           'xx.en.marian.translate_to.om': 'opus_mt_en_om',
                                           'xx.en.marian.translate_to.pqw': 'opus_mt_en_pqw',
                                           'xx.en.marian.translate_to.hil': 'opus_mt_en_hil',
                                           'xx.sk.marian.translate_to.en': 'opus_mt_sk_en',
                                           'xx.en.marian.translate_to.mr': 'opus_mt_en_mr',
                                           'xx.tll.marian.translate_to.en': 'opus_mt_tll_en',
                                           'xx.en.marian.translate_to.jap': 'opus_mt_en_jap',
                                           'xx.en.marian.translate_to.chk': 'opus_mt_en_chk',
                                           'xx.tum.marian.translate_to.en': 'opus_mt_tum_en',
                                           'xx.dra.marian.translate_to.en': 'opus_mt_dra_en',
                                           'xx.en.marian.translate_to.kqn': 'opus_mt_en_kqn',
                                           'xx.en.marian.translate_to.tdt': 'opus_mt_en_tdt',
                                           'xx.en.marian.translate_to.tvl': 'opus_mt_en_tvl',
                                           'xx.en.marian.translate_to.lue': 'opus_mt_en_lue',
                                           'xx.en.marian.translate_to.ilo': 'opus_mt_en_ilo',
                                           'xx.en.marian.translate_to.poz': 'opus_mt_en_poz',
                                           'xx.pap.marian.translate_to.en': 'opus_mt_pap_en',
                                           'xx.af.marian.translate_to.en': 'opus_mt_af_en',
                                           'xx.en.marian.translate_to.bzs': 'opus_mt_en_bzs',
                                           'xx.toi.marian.translate_to.en': 'opus_mt_toi_en',
                                           'xx.en.marian.translate_to.mg': 'opus_mt_en_mg',
                                           'xx.ber.marian.translate_to.en': 'opus_mt_ber_en',
                                           'xx.kj.marian.translate_to.en': 'opus_mt_kj_en',
                                           'xx.ko.marian.translate_to.en': 'opus_mt_ko_en',
                                           'xx.inc.marian.translate_to.en': 'opus_mt_inc_en',
                                           'xx.en.marian.translate_to.is': 'opus_mt_en_is',
                                           'xx.mr.marian.translate_to.en': 'opus_mt_mr_en',
                                           'xx.ka.marian.translate_to.en': 'opus_mt_ka_en',
                                           'xx.en.marian.translate_to.nic': 'opus_mt_en_nic',
                                           'xx.en.marian.translate_to.eu': 'opus_mt_en_eu',
                                           'xx.pl.marian.translate_to.en': 'opus_mt_pl_en',
                                           'xx.hil.marian.translate_to.en': 'opus_mt_hil_en',
                                           'xx.en.marian.translate_to.luo': 'opus_mt_en_luo',
                                           'xx.en.marian.translate_to.zh': 'opus_mt_en_zh',
                                           'xx.en.marian.translate_to.fi': 'opus_mt_en_fi',
                                           'xx.en.marian.translate_to.kg': 'opus_mt_en_kg',
                                           'xx.bi.marian.translate_to.en': 'opus_mt_bi_en',
                                           'xx.sg.marian.translate_to.en': 'opus_mt_sg_en',
                                           'xx.en.marian.translate_to.ng': 'opus_mt_en_ng',
                                           'xx.en.marian.translate_to.inc': 'opus_mt_en_inc',
                                           'xx.en.marian.translate_to.uk': 'opus_mt_en_uk',
                                           'xx.en.marian.translate_to.es': 'opus_mt_en_es',
                                           'xx.en.marian.translate_to.swc': 'opus_mt_en_swc',
                                           'xx.sq.marian.translate_to.en': 'opus_mt_sq_en',
                                           'xx.en.marian.translate_to.niu': 'opus_mt_en_niu',
                                           'xx.trk.marian.translate_to.en': 'opus_mt_trk_en',
                                           'xx.en.marian.translate_to.mh': 'opus_mt_en_mh',
                                           'xx.luo.marian.translate_to.en': 'opus_mt_luo_en',
                                           'xx.mt.marian.translate_to.en': 'opus_mt_mt_en',
                                           'xx.to.marian.translate_to.en': 'opus_mt_to_en',
                                           'xx.tiv.marian.translate_to.en': 'opus_mt_tiv_en',
                                           'xx.en.marian.translate_to.ca': 'opus_mt_en_ca',
                                           'xx.en.marian.translate_to.iso': 'opus_mt_en_iso',
                                           'xx.gil.marian.translate_to.en': 'opus_mt_gil_en',
                                           'xx.en.marian.translate_to.trk': 'opus_mt_en_trk',
                                           'xx.ga.marian.translate_to.en': 'opus_mt_ga_en',
                                           'xx.en.marian.translate_to.sem': 'opus_mt_en_sem',
                                           'xx.da.marian.translate_to.en': 'opus_mt_da_en',
                                           'xx.is.marian.translate_to.en': 'opus_mt_is_en',
                                           'xx.en.marian.translate_to.mul': 'opus_mt_en_mul',
                                           'xx.en.marian.translate_to.nyk': 'opus_mt_en_nyk',
                                           'xx.de.marian.translate_to.en': 'opus_mt_de_en',
                                           'xx.rn.marian.translate_to.en': 'opus_mt_rn_en',
                                           'xx.yo.marian.translate_to.en': 'opus_mt_yo_en',
                                           'xx.sn.marian.translate_to.en': 'opus_mt_sn_en',
                                           'xx.lun.marian.translate_to.en': 'opus_mt_lun_en',
                                           'xx.en.marian.translate_to.iir': 'opus_mt_en_iir',
                                           'xx.en.marian.translate_to.toi': 'opus_mt_en_toi',
                                           'xx.pag.marian.translate_to.en': 'opus_mt_pag_en',
                                           'xx.en.marian.translate_to.ee': 'opus_mt_en_ee',
                                           'xx.grk.marian.translate_to.en': 'opus_mt_grk_en',
                                           'xx.zle.marian.translate_to.en': 'opus_mt_zle_en',
                                           'xx.zh.marian.translate_to.en': 'opus_mt_zh_en',
                                           'xx.en.marian.translate_to.tn': 'opus_mt_en_tn',
                                           'xx.en.marian.translate_to.az': 'opus_mt_en_az',
                                           'xx.en.marian.translate_to.bat': 'opus_mt_en_bat',
                                           'xx.en.marian.translate_to.tut': 'opus_mt_en_tut',
                                           'xx.eu.marian.translate_to.en': 'opus_mt_eu_en',
                                           'xx.kab.marian.translate_to.en': 'opus_mt_kab_en',
                                           'xx.en.marian.translate_to.fr': 'opus_mt_en_fr',
                                           'xx.rnd.marian.translate_to.en': 'opus_mt_rnd_en',
                                           'xx.ur.marian.translate_to.en': 'opus_mt_ur_en',
                                           'xx.ss.marian.translate_to.en': 'opus_mt_ss_en',
                                           'xx.cau.marian.translate_to.en': 'opus_mt_cau_en',
                                           'xx.cs.marian.translate_to.en': 'opus_mt_cs_en',
                                           'xx.en.marian.translate_to.de': 'opus_mt_en_de',
                                           'xx.en.marian.translate_to.sq': 'opus_mt_en_sq',
                                           'xx.roa.marian.translate_to.en': 'opus_mt_roa_en',
                                           'xx.eo.marian.translate_to.en': 'opus_mt_eo_en',
                                           'xx.wa.marian.translate_to.en': 'opus_mt_wa_en',
                                           'xx.zlw.marian.translate_to.en': 'opus_mt_zlw_en',
                                           'xx.lg.marian.translate_to.en': 'opus_mt_lg_en',
                                           'xx.en.marian.translate_to.gmw': 'opus_mt_en_gmw',
                                           'xx.fr.marian.translate_to.en': 'opus_mt_fr_en',
                                           'xx.en.marian.translate_to.it': 'opus_mt_en_it',
                                           'xx.tpi.marian.translate_to.en': 'opus_mt_tpi_en',
                                           'xx.bcl.marian.translate_to.en': 'opus_mt_bcl_en',
                                           'xx.id.marian.translate_to.en': 'opus_mt_id_en',
                                           'xx.ht.marian.translate_to.en': 'opus_mt_ht_en',
                                           'xx.en.marian.translate_to.run': 'opus_mt_en_run',
                                           'xx.en.marian.translate_to.bg': 'opus_mt_en_bg',
                                           'xx.mul.marian.translate_to.en': 'opus_mt_mul_en',
                                           'xx.mk.marian.translate_to.en': 'opus_mt_mk_en',
                                           'xx.en.marian.translate_to.gil': 'opus_mt_en_gil',
                                           'xx.en.marian.translate_to.nso': 'opus_mt_en_nso',
                                           'xx.gv.marian.translate_to.en': 'opus_mt_gv_en',
                                           'xx.es.marian.translate_to.en': 'opus_mt_es_en',
                                           'xx.ilo.marian.translate_to.en': 'opus_mt_ilo_en',
                                           'xx.srn.marian.translate_to.en': 'opus_mt_srn_en',
                                           'xx.guw.marian.translate_to.en': 'opus_mt_guw_en',
                                           'xx.fiu.marian.translate_to.en': 'opus_mt_fiu_en',
                                           'xx.wls.marian.translate_to.en': 'opus_mt_wls_en',
                                           'xx.en.marian.translate_to.nl': 'opus_mt_en_nl',
                                           'xx.rw.marian.translate_to.en': 'opus_mt_rw_en',
                                           'xx.en.marian.translate_to.ceb': 'opus_mt_en_ceb',
                                           'xx.run.marian.translate_to.en': 'opus_mt_run_en',
                                           'xx.nyk.marian.translate_to.en': 'opus_mt_nyk_en',
                                           'xx.ho.marian.translate_to.en': 'opus_mt_ho_en',
                                           'xx.en.marian.translate_to.urj': 'opus_mt_en_urj',
                                           'xx.en.marian.translate_to.pon': 'opus_mt_en_pon',
                                           'xx.phi.marian.translate_to.en': 'opus_mt_phi_en',
                                           'xx.kl.marian.translate_to.en': 'opus_mt_kl_en',
                                           'xx.bn.marian.translate_to.en': 'opus_mt_bn_en',
                                           'xx.en.marian.translate_to.efi': 'opus_mt_en_efi',
                                           'xx.en.marian.translate_to.pqe': 'opus_mt_en_pqe',
                                           'xx.en.marian.translate_to.rnd': 'opus_mt_en_rnd',
                                           'xx.en.marian.translate_to.id': 'opus_mt_en_id',
                                           'xx.nl.marian.translate_to.en': 'opus_mt_nl_en',
                                           'xx.ru.marian.translate_to.en': 'opus_mt_ru_en',
                                           'xx.en.marian.translate_to.sla': 'opus_mt_en_sla',
                                           'xx.en.marian.translate_to.guw': 'opus_mt_en_guw',
                                           'xx.euq.marian.translate_to.en': 'opus_mt_euq_en',
                                           'xx.lu.marian.translate_to.en': 'opus_mt_lu_en',
                                           'xx.en.marian.translate_to.fj': 'opus_mt_en_fj',
                                           'xx.en.marian.translate_to.ru': 'opus_mt_en_ru',
                                           'xx.en.marian.translate_to.gem': 'opus_mt_en_gem',
                                           'xx.en.marian.translate_to.map': 'opus_mt_en_map',
                                           'xx.en.marian.translate_to.euq': 'opus_mt_en_euq',
                                           'xx.en.marian.translate_to.kwn': 'opus_mt_en_kwn',
                                           'xx.en.marian.translate_to.gl': 'opus_mt_en_gl',
                                           'xx.en.marian.translate_to.ha': 'opus_mt_en_ha',
                                           'xx.cpp.marian.translate_to.en': 'opus_mt_cpp_en',
                                           'xx.en.marian.translate_to.mkh': 'opus_mt_en_mkh',
                                           'xx.en.marian.translate_to.kj': 'opus_mt_en_kj',
                                           'xx.bat.marian.translate_to.en': 'opus_mt_bat_en',
                                           'xx.en.marian.translate_to.sal': 'opus_mt_en_sal',
                                           'xx.pa.marian.translate_to.en': 'opus_mt_pa_en',
                                           'xx.jap.marian.translate_to.en': 'opus_mt_jap_en',
                                           'xx.sla.marian.translate_to.en': 'opus_mt_sla_en',
                                           'xx.ar.marian.translate_to.en': 'opus_mt_ar_en',
                                           'xx.xh.marian.translate_to.en': 'opus_mt_xh_en',
                                           'xx.mfe.marian.translate_to.en': 'opus_mt_mfe_en',
                                           'xx.en.marian.translate_to.zlw': 'opus_mt_en_zlw',
                                           'xx.en.marian.translate_to.lua': 'opus_mt_en_lua',
                                           'xx.en.marian.translate_to.ine': 'opus_mt_en_ine',
                                           'xx.en.marian.translate_to.loz': 'opus_mt_en_loz',
                                           'xx.lus.marian.translate_to.en': 'opus_mt_lus_en',
                                           'xx.lv.marian.translate_to.en': 'opus_mt_lv_en',
                                           'xx.en.marian.translate_to.af': 'opus_mt_en_af',
                                           'xx.sal.marian.translate_to.en': 'opus_mt_sal_en',
                                           'xx.hi.marian.translate_to.en': 'opus_mt_hi_en',
                                           'xx.gaa.marian.translate_to.en': 'opus_mt_gaa_en',
                                           'xx.pon.marian.translate_to.en': 'opus_mt_pon_en',
                                           'xx.ig.marian.translate_to.en': 'opus_mt_ig_en',
                                           'xx.en.marian.translate_to.lus': 'opus_mt_en_lus',
                                           'xx.th.marian.translate_to.en': 'opus_mt_th_en',
                                           'xx.kg.marian.translate_to.en': 'opus_mt_kg_en',
                                           'xx.cus.marian.translate_to.en': 'opus_mt_cus_en',
                                           'xx.cy.marian.translate_to.en': 'opus_mt_cy_en',
                                           'xx.en.marian.translate_to.alv': 'opus_mt_en_alv',
                                           'xx.sem.marian.translate_to.en': 'opus_mt_sem_en',
                                           'xx.en.marian.translate_to.tpi': 'opus_mt_en_tpi',
                                           'xx.en.marian.translate_to.grk': 'opus_mt_en_grk',
                                           'xx.gmq.marian.translate_to.en': 'opus_mt_gmq_en',
                                           'xx.tn.marian.translate_to.en': 'opus_mt_tn_en',
                                           'xx.en.marian.translate_to.sg': 'opus_mt_en_sg',
                                           'xx.pis.marian.translate_to.en': 'opus_mt_pis_en',
                                           'xx.en.marian.translate_to.sm': 'opus_mt_en_sm',
                                           'xx.en.marian.translate_to.ht': 'opus_mt_en_ht',
                                           'xx.mos.marian.translate_to.en': 'opus_mt_mos_en',
                                           'xx.iir.marian.translate_to.en': 'opus_mt_iir_en',
                                           'xx.en.marian.translate_to.mos': 'opus_mt_en_mos',
                                           'xx.ts.marian.translate_to.en': 'opus_mt_ts_en',
                                           'xx.en.marian.translate_to.he': 'opus_mt_en_he',
                                           'xx.en.marian.translate_to.da': 'opus_mt_en_da',
                                           'xx.it.marian.translate_to.en': 'opus_mt_it_en',
                                           'xx.en.marian.translate_to.cel': 'opus_mt_en_cel',
                                           'xx.en.marian.translate_to.el': 'opus_mt_en_el',
                                           'xx.en.marian.translate_to.xh': 'opus_mt_en_xh',
                                           'xx.en.marian.translate_to.eo': 'opus_mt_en_eo',
                                           'xx.az.marian.translate_to.en': 'opus_mt_az_en',
                                           'xx.tvl.marian.translate_to.en': 'opus_mt_tvl_en',
                                           'xx.tl.marian.translate_to.en': 'opus_mt_tl_en',
                                           'xx.bzs.marian.translate_to.en': 'opus_mt_bzs_en',
                                           'xx.en.marian.translate_to.et': 'opus_mt_en_et',
                                           'xx.en.marian.translate_to.sk': 'opus_mt_en_sk',
                                           'xx.en.marian.translate_to.to': 'opus_mt_en_to',
                                           'xx.en.marian.translate_to.ur': 'opus_mt_en_ur',
                                           'xx.lue.marian.translate_to.en': 'opus_mt_lue_en',
                                           'xx.niu.marian.translate_to.en': 'opus_mt_niu_en',
                                           'xx.ti.marian.translate_to.en': 'opus_mt_ti_en',
                                           'xx.en.marian.translate_to.lu': 'opus_mt_en_lu',
                                           'xx.fr.marian.translate_to.bcl': 'opus_mt_bcl_fr',
                                           'xx.tr.marian.translate_to.ar': 'opus_mt_ar_tr',
                                           'xx.sv.marian.translate_to.af': 'opus_mt_af_sv',
                                           'xx.de.marian.translate_to.ar': 'opus_mt_ar_de',
                                           'xx.fr.marian.translate_to.bi': 'opus_mt_bi_fr',
                                           'xx.es.marian.translate_to.bi': 'opus_mt_bi_es',
                                           'xx.fi.marian.translate_to.af': 'opus_mt_af_fi',
                                           'xx.fi.marian.translate_to.crs': 'opus_mt_crs_fi',
                                           'xx.fi.marian.translate_to.bem': 'opus_mt_bem_fi',
                                           'xx.sv.marian.translate_to.bem': 'opus_mt_bem_sv',
                                           'xx.it.marian.translate_to.ca': 'opus_mt_ca_it',
                                           'xx.fr.marian.translate_to.ca': 'opus_mt_ca_fr',
                                           'xx.es.marian.translate_to.bcl': 'opus_mt_bcl_es',
                                           'xx.uk.marian.translate_to.ca': 'opus_mt_ca_uk',
                                           'xx.fr.marian.translate_to.bem': 'opus_mt_bem_fr',
                                           'xx.de.marian.translate_to.af': 'opus_mt_af_de',
                                           'xx.nl.marian.translate_to.af': 'opus_mt_af_nl',
                                           'xx.fr.marian.translate_to.ase': 'opus_mt_ase_fr',
                                           'xx.es.marian.translate_to.az': 'opus_mt_az_es',
                                           'xx.es.marian.translate_to.chk': 'opus_mt_chk_es',
                                           'xx.sv.marian.translate_to.ceb': 'opus_mt_ceb_sv',
                                           'xx.es.marian.translate_to.ceb': 'opus_mt_ceb_es',
                                           'xx.es.marian.translate_to.aed': 'opus_mt_aed_es',
                                           'xx.pl.marian.translate_to.ar': 'opus_mt_ar_pl',
                                           'xx.es.marian.translate_to.bem': 'opus_mt_bem_es',
                                           'xx.eo.marian.translate_to.af': 'opus_mt_af_eo',
                                           'xx.fr.marian.translate_to.cs': 'opus_mt_cs_fr',
                                           'xx.fi.marian.translate_to.bcl': 'opus_mt_bcl_fi',
                                           'xx.es.marian.translate_to.crs': 'opus_mt_crs_es',
                                           'xx.sv.marian.translate_to.bi': 'opus_mt_bi_sv',
                                           'xx.de.marian.translate_to.bg': 'opus_mt_bg_de',
                                           'xx.ru.marian.translate_to.ar': 'opus_mt_ar_ru',
                                           'xx.es.marian.translate_to.bg': 'opus_mt_bg_es',
                                           'xx.uk.marian.translate_to.cs': 'opus_mt_cs_uk',
                                           'xx.sv.marian.translate_to.bzs': 'opus_mt_bzs_sv',
                                           'xx.es.marian.translate_to.be': 'opus_mt_be_es',
                                           'xx.es.marian.translate_to.bzs': 'opus_mt_bzs_es',
                                           'xx.fr.marian.translate_to.af': 'opus_mt_af_fr',
                                           'xx.pt.marian.translate_to.ca': 'opus_mt_ca_pt',
                                           'xx.fr.marian.translate_to.chk': 'opus_mt_chk_fr',
                                           'xx.de.marian.translate_to.ase': 'opus_mt_ase_de',
                                           'xx.it.marian.translate_to.ar': 'opus_mt_ar_it',
                                           'xx.fi.marian.translate_to.ceb': 'opus_mt_ceb_fi',
                                           'xx.cpp.marian.translate_to.cpp': 'opus_mt_cpp_cpp',
                                           'xx.fr.marian.translate_to.ber': 'opus_mt_ber_fr',
                                           'xx.ru.marian.translate_to.bg': 'opus_mt_bg_ru',
                                           'xx.es.marian.translate_to.ase': 'opus_mt_ase_es',
                                           'xx.es.marian.translate_to.af': 'opus_mt_af_es',
                                           'xx.it.marian.translate_to.bg': 'opus_mt_bg_it',
                                           'xx.sv.marian.translate_to.am': 'opus_mt_am_sv',
                                           'xx.eo.marian.translate_to.ar': 'opus_mt_ar_eo',
                                           'xx.fr.marian.translate_to.ceb': 'opus_mt_ceb_fr',
                                           'xx.es.marian.translate_to.ca': 'opus_mt_ca_es',
                                           'xx.fi.marian.translate_to.bzs': 'opus_mt_bzs_fi',
                                           'xx.de.marian.translate_to.crs': 'opus_mt_crs_de',
                                           'xx.fi.marian.translate_to.cs': 'opus_mt_cs_fi',
                                           'xx.afa.marian.translate_to.afa': 'opus_mt_afa_afa',
                                           'xx.sv.marian.translate_to.bg': 'opus_mt_bg_sv',
                                           'xx.tr.marian.translate_to.bg': 'opus_mt_bg_tr',
                                           'xx.fr.marian.translate_to.crs': 'opus_mt_crs_fr',
                                           'xx.sv.marian.translate_to.ase': 'opus_mt_ase_sv',
                                           'xx.de.marian.translate_to.cs': 'opus_mt_cs_de',
                                           'xx.eo.marian.translate_to.cs': 'opus_mt_cs_eo',
                                           'xx.sv.marian.translate_to.chk': 'opus_mt_chk_sv',
                                           'xx.sv.marian.translate_to.bcl': 'opus_mt_bcl_sv',
                                           'xx.fr.marian.translate_to.ar': 'opus_mt_ar_fr',
                                           'xx.ru.marian.translate_to.af': 'opus_mt_af_ru',
                                           'xx.he.marian.translate_to.ar': 'opus_mt_ar_he',
                                           'xx.fi.marian.translate_to.bg': 'opus_mt_bg_fi',
                                           'xx.es.marian.translate_to.ber': 'opus_mt_ber_es',
                                           'xx.es.marian.translate_to.ar': 'opus_mt_ar_es',
                                           'xx.uk.marian.translate_to.bg': 'opus_mt_bg_uk',
                                           'xx.fr.marian.translate_to.bzs': 'opus_mt_bzs_fr',
                                           'xx.el.marian.translate_to.ar': 'opus_mt_ar_el',
                                           'xx.nl.marian.translate_to.ca': 'opus_mt_ca_nl',
                                           'xx.de.marian.translate_to.bcl': 'opus_mt_bcl_de',
                                           'xx.eo.marian.translate_to.bg': 'opus_mt_bg_eo',
                                           'xx.de.marian.translate_to.efi': 'opus_mt_efi_de',
                                           'xx.bzs.marian.translate_to.de': 'opus_mt_de_bzs',
                                           'xx.fj.marian.translate_to.de': 'opus_mt_de_fj',
                                           'xx.fi.marian.translate_to.da': 'opus_mt_da_fi',
                                           'xx.no.marian.translate_to.da': 'opus_mt_da_no',
                                           'xx.cs.marian.translate_to.de': 'opus_mt_de_cs',
                                           'xx.efi.marian.translate_to.de': 'opus_mt_de_efi',
                                           'xx.gil.marian.translate_to.de': 'opus_mt_de_gil',
                                           'xx.bcl.marian.translate_to.de': 'opus_mt_de_bcl',
                                           'xx.pag.marian.translate_to.de': 'opus_mt_de_pag',
                                           'xx.kg.marian.translate_to.de': 'opus_mt_de_kg',
                                           'xx.fi.marian.translate_to.efi': 'opus_mt_efi_fi',
                                           'xx.is.marian.translate_to.de': 'opus_mt_de_is',
                                           'xx.fr.marian.translate_to.da': 'opus_mt_da_fr',
                                           'xx.pl.marian.translate_to.de': 'opus_mt_de_pl',
                                           'xx.ln.marian.translate_to.de': 'opus_mt_de_ln',
                                           'xx.pap.marian.translate_to.de': 'opus_mt_de_pap',
                                           'xx.vi.marian.translate_to.de': 'opus_mt_de_vi',
                                           'xx.no.marian.translate_to.de': 'opus_mt_de_no',
                                           'xx.eo.marian.translate_to.el': 'opus_mt_el_eo',
                                           'xx.af.marian.translate_to.de': 'opus_mt_de_af',
                                           'xx.es.marian.translate_to.ee': 'opus_mt_ee_es',
                                           'xx.eo.marian.translate_to.de': 'opus_mt_de_eo',
                                           'xx.bi.marian.translate_to.de': 'opus_mt_de_bi',
                                           'xx.mt.marian.translate_to.de': 'opus_mt_de_mt',
                                           'xx.lt.marian.translate_to.de': 'opus_mt_de_lt',
                                           'xx.bg.marian.translate_to.de': 'opus_mt_de_bg',
                                           'xx.hil.marian.translate_to.de': 'opus_mt_de_hil',
                                           'xx.eu.marian.translate_to.de': 'opus_mt_de_eu',
                                           'xx.da.marian.translate_to.de': 'opus_mt_de_da',
                                           'xx.ms.marian.translate_to.de': 'opus_mt_de_ms',
                                           'xx.he.marian.translate_to.de': 'opus_mt_de_he',
                                           'xx.et.marian.translate_to.de': 'opus_mt_de_et',
                                           'xx.es.marian.translate_to.de': 'opus_mt_de_es',
                                           'xx.fr.marian.translate_to.el': 'opus_mt_el_fr',
                                           'xx.fr.marian.translate_to.ee': 'opus_mt_ee_fr',
                                           'xx.el.marian.translate_to.de': 'opus_mt_de_el',
                                           'xx.sv.marian.translate_to.el': 'opus_mt_el_sv',
                                           'xx.es.marian.translate_to.csn': 'opus_mt_csn_es',
                                           'xx.tl.marian.translate_to.de': 'opus_mt_de_tl',
                                           'xx.pon.marian.translate_to.de': 'opus_mt_de_pon',
                                           'xx.fr.marian.translate_to.efi': 'opus_mt_efi_fr',
                                           'xx.uk.marian.translate_to.de': 'opus_mt_de_uk',
                                           'xx.ar.marian.translate_to.el': 'opus_mt_el_ar',
                                           'xx.fi.marian.translate_to.el': 'opus_mt_el_fi',
                                           'xx.ig.marian.translate_to.de': 'opus_mt_de_ig',
                                           'xx.guw.marian.translate_to.de': 'opus_mt_de_guw',
                                           'xx.iso.marian.translate_to.de': 'opus_mt_de_iso',
                                           'xx.sv.marian.translate_to.efi': 'opus_mt_efi_sv',
                                           'xx.ha.marian.translate_to.de': 'opus_mt_de_ha',
                                           'xx.fr.marian.translate_to.de': 'opus_mt_de_fr',
                                           'xx.gaa.marian.translate_to.de': 'opus_mt_de_gaa',
                                           'xx.nso.marian.translate_to.de': 'opus_mt_de_nso',
                                           'xx.ht.marian.translate_to.de': 'opus_mt_de_ht',
                                           'xx.nl.marian.translate_to.de': 'opus_mt_de_nl',
                                           'xx.sv.marian.translate_to.ee': 'opus_mt_ee_sv',
                                           'xx.fi.marian.translate_to.ee': 'opus_mt_ee_fi',
                                           'xx.de.marian.translate_to.ee': 'opus_mt_ee_de',
                                           'xx.eo.marian.translate_to.da': 'opus_mt_da_eo',
                                           'xx.es.marian.translate_to.csg': 'opus_mt_csg_es',
                                           'xx.de.marian.translate_to.da': 'opus_mt_da_de',
                                           'xx.ar.marian.translate_to.de': 'opus_mt_de_ar',
                                           'xx.hu.marian.translate_to.de': 'opus_mt_de_hu',
                                           'xx.ca.marian.translate_to.de': 'opus_mt_de_ca',
                                           'xx.pis.marian.translate_to.de': 'opus_mt_de_pis',
                                           'xx.ho.marian.translate_to.de': 'opus_mt_de_ho',
                                           'xx.de.marian.translate_to.de': 'opus_mt_de_de',
                                           'xx.lua.marian.translate_to.de': 'opus_mt_de_lua',
                                           'xx.loz.marian.translate_to.de': 'opus_mt_de_loz',
                                           'xx.crs.marian.translate_to.de': 'opus_mt_de_crs',
                                           'xx.es.marian.translate_to.da': 'opus_mt_da_es',
                                           'xx.ee.marian.translate_to.de': 'opus_mt_de_ee',
                                           'xx.it.marian.translate_to.de': 'opus_mt_de_it',
                                           'xx.ilo.marian.translate_to.de': 'opus_mt_de_ilo',
                                           'xx.ny.marian.translate_to.de': 'opus_mt_de_ny',
                                           'xx.fi.marian.translate_to.de': 'opus_mt_de_fi',
                                           'xx.ase.marian.translate_to.de': 'opus_mt_de_ase',
                                           'xx.hr.marian.translate_to.de': 'opus_mt_de_hr',
                                           'xx.sl.marian.translate_to.fi': 'opus_mt_fi_sl',
                                           'xx.sk.marian.translate_to.fi': 'opus_mt_fi_sk',
                                           'xx.ru.marian.translate_to.es': 'opus_mt_es_ru',
                                           'xx.sn.marian.translate_to.fi': 'opus_mt_fi_sn',
                                           'xx.pl.marian.translate_to.eo': 'opus_mt_eo_pl',
                                           'xx.cs.marian.translate_to.es': 'opus_mt_es_cs',
                                           'xx.wls.marian.translate_to.fi': 'opus_mt_fi_wls',
                                           'xx.gaa.marian.translate_to.fi': 'opus_mt_fi_gaa',
                                           'xx.is.marian.translate_to.fi': 'opus_mt_fi_is',
                                           'xx.ha.marian.translate_to.es': 'opus_mt_es_ha',
                                           'xx.nl.marian.translate_to.es': 'opus_mt_es_nl',
                                           'xx.ha.marian.translate_to.fi': 'opus_mt_fi_ha',
                                           'xx.fj.marian.translate_to.fi': 'opus_mt_fi_fj',
                                           'xx.ber.marian.translate_to.es': 'opus_mt_es_ber',
                                           'xx.ho.marian.translate_to.fi': 'opus_mt_fi_ho',
                                           'xx.ny.marian.translate_to.fi': 'opus_mt_fi_ny',
                                           'xx.sl.marian.translate_to.es': 'opus_mt_es_sl',
                                           'xx.ts.marian.translate_to.fi': 'opus_mt_fi_ts',
                                           'xx.el.marian.translate_to.eo': 'opus_mt_eo_el',
                                           'xx.war.marian.translate_to.fi': 'opus_mt_fi_war',
                                           'xx.cs.marian.translate_to.fi': 'opus_mt_fi_cs',
                                           'xx.loz.marian.translate_to.es': 'opus_mt_es_loz',
                                           'xx.mk.marian.translate_to.fi': 'opus_mt_fi_mk',
                                           'xx.bg.marian.translate_to.es': 'opus_mt_es_bg',
                                           'xx.srn.marian.translate_to.fi': 'opus_mt_fi_srn',
                                           'xx.is.marian.translate_to.es': 'opus_mt_es_is',
                                           'xx.hu.marian.translate_to.eo': 'opus_mt_eo_hu',
                                           'xx.tw.marian.translate_to.fi': 'opus_mt_fi_tw',
                                           'xx.mt.marian.translate_to.fi': 'opus_mt_fi_mt',
                                           'xx.fr.marian.translate_to.es': 'opus_mt_es_fr',
                                           'xx.yo.marian.translate_to.es': 'opus_mt_es_yo',
                                           'xx.xh.marian.translate_to.fi': 'opus_mt_fi_xh',
                                           'xx.lv.marian.translate_to.fi': 'opus_mt_fi_lv',
                                           'xx.de.marian.translate_to.fi': 'opus_mt_fi_de',
                                           'xx.ve.marian.translate_to.es': 'opus_mt_es_ve',
                                           'xx.es.marian.translate_to.fi': 'opus_mt_fi_es',
                                           'xx.eo.marian.translate_to.es': 'opus_mt_es_eo',
                                           'xx.cs.marian.translate_to.eo': 'opus_mt_eo_cs',
                                           'xx.mt.marian.translate_to.es': 'opus_mt_es_mt',
                                           'xx.el.marian.translate_to.es': 'opus_mt_es_el',
                                           'xx.ee.marian.translate_to.es': 'opus_mt_es_ee',
                                           'xx.de.marian.translate_to.eu': 'opus_mt_eu_de',
                                           'xx.et.marian.translate_to.es': 'opus_mt_es_et',
                                           'xx.fi.marian.translate_to.et': 'opus_mt_et_fi',
                                           'xx.wls.marian.translate_to.es': 'opus_mt_es_wls',
                                           'xx.mg.marian.translate_to.fi': 'opus_mt_fi_mg',
                                           'xx.eu.marian.translate_to.es': 'opus_mt_es_eu',
                                           'xx.lua.marian.translate_to.es': 'opus_mt_es_lua',
                                           'xx.pon.marian.translate_to.es': 'opus_mt_es_pon',
                                           'xx.mfe.marian.translate_to.fi': 'opus_mt_fi_mfe',
                                           'xx.he.marian.translate_to.eo': 'opus_mt_eo_he',
                                           'xx.id.marian.translate_to.es': 'opus_mt_es_id',
                                           'xx.xh.marian.translate_to.es': 'opus_mt_es_xh',
                                           'xx.ar.marian.translate_to.es': 'opus_mt_es_ar',
                                           'xx.crs.marian.translate_to.es': 'opus_mt_es_crs',
                                           'xx.es.marian.translate_to.eu': 'opus_mt_eu_es',
                                           'xx.tpi.marian.translate_to.fi': 'opus_mt_fi_tpi',
                                           'xx.pis.marian.translate_to.fi': 'opus_mt_fi_pis',
                                           'xx.vi.marian.translate_to.es': 'opus_mt_es_vi',
                                           'xx.es.marian.translate_to.et': 'opus_mt_et_es',
                                           'xx.rw.marian.translate_to.fi': 'opus_mt_fi_rw',
                                           'xx.gl.marian.translate_to.es': 'opus_mt_es_gl',
                                           'xx.pt.marian.translate_to.eo': 'opus_mt_eo_pt',
                                           'xx.he.marian.translate_to.fi': 'opus_mt_fi_he',
                                           'xx.af.marian.translate_to.fi': 'opus_mt_fi_af',
                                           'xx.ru.marian.translate_to.fi': 'opus_mt_fi_ru',
                                           'xx.ve.marian.translate_to.fi': 'opus_mt_fi_ve',
                                           'xx.ca.marian.translate_to.es': 'opus_mt_es_ca',
                                           'xx.tr.marian.translate_to.fi': 'opus_mt_fi_tr',
                                           'xx.ht.marian.translate_to.fi': 'opus_mt_fi_ht',
                                           'xx.nl.marian.translate_to.fi': 'opus_mt_fi_nl',
                                           'xx.iso.marian.translate_to.fi': 'opus_mt_fi_iso',
                                           'xx.fi.marian.translate_to.es': 'opus_mt_es_fi',
                                           'xx.da.marian.translate_to.eo': 'opus_mt_eo_da',
                                           'xx.ln.marian.translate_to.es': 'opus_mt_es_ln',
                                           'xx.csn.marian.translate_to.es': 'opus_mt_es_csn',
                                           'xx.pon.marian.translate_to.fi': 'opus_mt_fi_pon',
                                           'xx.af.marian.translate_to.eo': 'opus_mt_eo_af',
                                           'xx.bzs.marian.translate_to.fi': 'opus_mt_fi_bzs',
                                           'xx.no.marian.translate_to.es': 'opus_mt_es_no',
                                           'xx.es.marian.translate_to.es': 'opus_mt_es_es',
                                           'xx.lua.marian.translate_to.fi': 'opus_mt_fi_lua',
                                           'xx.yua.marian.translate_to.es': 'opus_mt_es_yua',
                                           'xx.ru.marian.translate_to.eu': 'opus_mt_eu_ru',
                                           'xx.tpi.marian.translate_to.es': 'opus_mt_es_tpi',
                                           'xx.lue.marian.translate_to.fi': 'opus_mt_fi_lue',
                                           'xx.sv.marian.translate_to.eo': 'opus_mt_eo_sv',
                                           'xx.niu.marian.translate_to.es': 'opus_mt_es_niu',
                                           'xx.tiv.marian.translate_to.fi': 'opus_mt_fi_tiv',
                                           'xx.pag.marian.translate_to.es': 'opus_mt_es_pag',
                                           'xx.run.marian.translate_to.fi': 'opus_mt_fi_run',
                                           'xx.ty.marian.translate_to.es': 'opus_mt_es_ty',
                                           'xx.gil.marian.translate_to.es': 'opus_mt_es_gil',
                                           'xx.ln.marian.translate_to.fi': 'opus_mt_fi_ln',
                                           'xx.ty.marian.translate_to.fi': 'opus_mt_fi_ty',
                                           'xx.prl.marian.translate_to.es': 'opus_mt_es_prl',
                                           'xx.kg.marian.translate_to.es': 'opus_mt_es_kg',
                                           'xx.rw.marian.translate_to.es': 'opus_mt_es_rw',
                                           'xx.kqn.marian.translate_to.fi': 'opus_mt_fi_kqn',
                                           'xx.sq.marian.translate_to.fi': 'opus_mt_fi_sq',
                                           'xx.sw.marian.translate_to.fi': 'opus_mt_fi_sw',
                                           'xx.csg.marian.translate_to.es': 'opus_mt_es_csg',
                                           'xx.ro.marian.translate_to.es': 'opus_mt_es_ro',
                                           'xx.ee.marian.translate_to.fi': 'opus_mt_fi_ee',
                                           'xx.ilo.marian.translate_to.fi': 'opus_mt_fi_ilo',
                                           'xx.eo.marian.translate_to.fi': 'opus_mt_fi_eo',
                                           'xx.iso.marian.translate_to.es': 'opus_mt_es_iso',
                                           'xx.bem.marian.translate_to.fi': 'opus_mt_fi_bem',
                                           'xx.tn.marian.translate_to.fi': 'opus_mt_fi_tn',
                                           'xx.da.marian.translate_to.es': 'opus_mt_es_da',
                                           'xx.es.marian.translate_to.eo': 'opus_mt_eo_es',
                                           'xx.ru.marian.translate_to.eo': 'opus_mt_eo_ru',
                                           'xx.rn.marian.translate_to.es': 'opus_mt_es_rn',
                                           'xx.lt.marian.translate_to.es': 'opus_mt_es_lt',
                                           'xx.guw.marian.translate_to.es': 'opus_mt_es_guw',
                                           'xx.tvl.marian.translate_to.es': 'opus_mt_es_tvl',
                                           'xx.fr.marian.translate_to.et': 'opus_mt_et_fr',
                                           'xx.ht.marian.translate_to.es': 'opus_mt_es_ht',
                                           'xx.mos.marian.translate_to.fi': 'opus_mt_fi_mos',
                                           'xx.ase.marian.translate_to.es': 'opus_mt_es_ase',
                                           'xx.crs.marian.translate_to.fi': 'opus_mt_fi_crs',
                                           'xx.bcl.marian.translate_to.fi': 'opus_mt_fi_bcl',
                                           'xx.tvl.marian.translate_to.fi': 'opus_mt_fi_tvl',
                                           'xx.lus.marian.translate_to.fi': 'opus_mt_fi_lus',
                                           'xx.he.marian.translate_to.es': 'opus_mt_es_he',
                                           'xx.pis.marian.translate_to.es': 'opus_mt_es_pis',
                                           'xx.it.marian.translate_to.es': 'opus_mt_es_it',
                                           'xx.fi.marian.translate_to.eo': 'opus_mt_eo_fi',
                                           'xx.tw.marian.translate_to.es': 'opus_mt_es_tw',
                                           'xx.aed.marian.translate_to.es': 'opus_mt_es_aed',
                                           'xx.bzs.marian.translate_to.es': 'opus_mt_es_bzs',
                                           'xx.nso.marian.translate_to.fi': 'opus_mt_fi_nso',
                                           'xx.gaa.marian.translate_to.es': 'opus_mt_es_gaa',
                                           'xx.zai.marian.translate_to.es': 'opus_mt_es_zai',
                                           'xx.no.marian.translate_to.fi': 'opus_mt_fi_no',
                                           'xx.uk.marian.translate_to.fi': 'opus_mt_fi_uk',
                                           'xx.sg.marian.translate_to.es': 'opus_mt_es_sg',
                                           'xx.ilo.marian.translate_to.es': 'opus_mt_es_ilo',
                                           'xx.bg.marian.translate_to.eo': 'opus_mt_eo_bg',
                                           'xx.pap.marian.translate_to.fi': 'opus_mt_fi_pap',
                                           'xx.ho.marian.translate_to.es': 'opus_mt_es_ho',
                                           'xx.toi.marian.translate_to.fi': 'opus_mt_fi_toi',
                                           'xx.st.marian.translate_to.es': 'opus_mt_es_st',
                                           'xx.to.marian.translate_to.fi': 'opus_mt_fi_to',
                                           'xx.kg.marian.translate_to.fi': 'opus_mt_fi_kg',
                                           'xx.sv.marian.translate_to.fi': 'opus_mt_fi_sv',
                                           'xx.tll.marian.translate_to.fi': 'opus_mt_fi_tll',
                                           'xx.ceb.marian.translate_to.es': 'opus_mt_es_ceb',
                                           'xx.ig.marian.translate_to.es': 'opus_mt_es_ig',
                                           'xx.sv.marian.translate_to.et': 'opus_mt_et_sv',
                                           'xx.af.marian.translate_to.es': 'opus_mt_es_af',
                                           'xx.pl.marian.translate_to.es': 'opus_mt_es_pl',
                                           'xx.ro.marian.translate_to.eo': 'opus_mt_eo_ro',
                                           'xx.tn.marian.translate_to.es': 'opus_mt_es_tn',
                                           'xx.sm.marian.translate_to.fi': 'opus_mt_fi_sm',
                                           'xx.mk.marian.translate_to.es': 'opus_mt_es_mk',
                                           'xx.id.marian.translate_to.fi': 'opus_mt_fi_id',
                                           'xx.hr.marian.translate_to.fi': 'opus_mt_fi_hr',
                                           'xx.sg.marian.translate_to.fi': 'opus_mt_fi_sg',
                                           'xx.hil.marian.translate_to.fi': 'opus_mt_fi_hil',
                                           'xx.nl.marian.translate_to.eo': 'opus_mt_eo_nl',
                                           'xx.pap.marian.translate_to.es': 'opus_mt_es_pap',
                                           'xx.fr.marian.translate_to.fi': 'opus_mt_fi_fr',
                                           'xx.bi.marian.translate_to.es': 'opus_mt_es_bi',
                                           'xx.fi.marian.translate_to.fi': 'opus_mt_fi_fi',
                                           'xx.nso.marian.translate_to.es': 'opus_mt_es_nso',
                                           'xx.et.marian.translate_to.fi': 'opus_mt_fi_et',
                                           'xx.uk.marian.translate_to.es': 'opus_mt_es_uk',
                                           'xx.sh.marian.translate_to.eo': 'opus_mt_eo_sh',
                                           'xx.lu.marian.translate_to.fi': 'opus_mt_fi_lu',
                                           'xx.gil.marian.translate_to.fi': 'opus_mt_fi_gil',
                                           'xx.ro.marian.translate_to.fi': 'opus_mt_fi_ro',
                                           'xx.it.marian.translate_to.eo': 'opus_mt_eo_it',
                                           'xx.hu.marian.translate_to.fi': 'opus_mt_fi_hu',
                                           'xx.bcl.marian.translate_to.es': 'opus_mt_es_bcl',
                                           'xx.fse.marian.translate_to.fi': 'opus_mt_fi_fse',
                                           'xx.hil.marian.translate_to.es': 'opus_mt_es_hil',
                                           'xx.ig.marian.translate_to.fi': 'opus_mt_fi_ig',
                                           'xx.tl.marian.translate_to.es': 'opus_mt_es_tl',
                                           'xx.pag.marian.translate_to.fi': 'opus_mt_fi_pag',
                                           'xx.guw.marian.translate_to.fi': 'opus_mt_fi_guw',
                                           'xx.swc.marian.translate_to.es': 'opus_mt_es_swc',
                                           'xx.swc.marian.translate_to.fi': 'opus_mt_fi_swc',
                                           'xx.lg.marian.translate_to.fi': 'opus_mt_fi_lg',
                                           'xx.srn.marian.translate_to.es': 'opus_mt_es_srn',
                                           'xx.hr.marian.translate_to.es': 'opus_mt_es_hr',
                                           'xx.sm.marian.translate_to.es': 'opus_mt_es_sm',
                                           'xx.de.marian.translate_to.es': 'opus_mt_es_de',
                                           'xx.st.marian.translate_to.fi': 'opus_mt_fi_st',
                                           'xx.fr.marian.translate_to.eo': 'opus_mt_eo_fr',
                                           'xx.de.marian.translate_to.et': 'opus_mt_et_de',
                                           'xx.niu.marian.translate_to.fi': 'opus_mt_fi_niu',
                                           'xx.el.marian.translate_to.fi': 'opus_mt_fi_el',
                                           'xx.efi.marian.translate_to.fi': 'opus_mt_fi_efi',
                                           'xx.war.marian.translate_to.es': 'opus_mt_es_war',
                                           'xx.mfs.marian.translate_to.es': 'opus_mt_es_mfs',
                                           'xx.bg.marian.translate_to.fi': 'opus_mt_fi_bg',
                                           'xx.lus.marian.translate_to.es': 'opus_mt_es_lus',
                                           'xx.de.marian.translate_to.eo': 'opus_mt_eo_de',
                                           'xx.it.marian.translate_to.fi': 'opus_mt_fi_it',
                                           'xx.efi.marian.translate_to.es': 'opus_mt_es_efi',
                                           'xx.ny.marian.translate_to.es': 'opus_mt_es_ny',
                                           'xx.fj.marian.translate_to.es': 'opus_mt_es_fj',
                                           'xx.ru.marian.translate_to.et': 'opus_mt_et_ru',
                                           'xx.mh.marian.translate_to.fi': 'opus_mt_fi_mh',
                                           'xx.es.marian.translate_to.ig': 'opus_mt_ig_es',
                                           'xx.sv.marian.translate_to.hu': 'opus_mt_hu_sv',
                                           'xx.lue.marian.translate_to.fr': 'opus_mt_fr_lue',
                                           'xx.fi.marian.translate_to.ha': 'opus_mt_ha_fi',
                                           'xx.ca.marian.translate_to.it': 'opus_mt_it_ca',
                                           'xx.de.marian.translate_to.ilo': 'opus_mt_ilo_de',
                                           'xx.it.marian.translate_to.he': 'opus_mt_he_it',
                                           'xx.loz.marian.translate_to.fr': 'opus_mt_fr_loz',
                                           'xx.ms.marian.translate_to.fr': 'opus_mt_fr_ms',
                                           'xx.uk.marian.translate_to.it': 'opus_mt_it_uk',
                                           'xx.gaa.marian.translate_to.fr': 'opus_mt_fr_gaa',
                                           'xx.pap.marian.translate_to.fr': 'opus_mt_fr_pap',
                                           'xx.fi.marian.translate_to.ilo': 'opus_mt_ilo_fi',
                                           'xx.lg.marian.translate_to.fr': 'opus_mt_fr_lg',
                                           'xx.it.marian.translate_to.is': 'opus_mt_is_it',
                                           'xx.ms.marian.translate_to.it': 'opus_mt_it_ms',
                                           'xx.es.marian.translate_to.fr': 'opus_mt_fr_es',
                                           'xx.ar.marian.translate_to.he': 'opus_mt_he_ar',
                                           'xx.ro.marian.translate_to.fr': 'opus_mt_fr_ro',
                                           'xx.ru.marian.translate_to.fr': 'opus_mt_fr_ru',
                                           'xx.fi.marian.translate_to.ht': 'opus_mt_ht_fi',
                                           'xx.bg.marian.translate_to.it': 'opus_mt_it_bg',
                                           'xx.mh.marian.translate_to.fr': 'opus_mt_fr_mh',
                                           'xx.to.marian.translate_to.fr': 'opus_mt_fr_to',
                                           'xx.sl.marian.translate_to.fr': 'opus_mt_fr_sl',
                                           'xx.fr.marian.translate_to.gil': 'opus_mt_gil_fr',
                                           'xx.es.marian.translate_to.hr': 'opus_mt_hr_es',
                                           'xx.ilo.marian.translate_to.fr': 'opus_mt_fr_ilo',
                                           'xx.ee.marian.translate_to.fr': 'opus_mt_fr_ee',
                                           'xx.sv.marian.translate_to.he': 'opus_mt_he_sv',
                                           'xx.fr.marian.translate_to.ha': 'opus_mt_ha_fr',
                                           'xx.gil.marian.translate_to.fr': 'opus_mt_fr_gil',
                                           'xx.fi.marian.translate_to.id': 'opus_mt_id_fi',
                                           'xx.iir.marian.translate_to.iir': 'opus_mt_iir_iir',
                                           'xx.pl.marian.translate_to.fr': 'opus_mt_fr_pl',
                                           'xx.tw.marian.translate_to.fr': 'opus_mt_fr_tw',
                                           'xx.sv.marian.translate_to.gaa': 'opus_mt_gaa_sv',
                                           'xx.ar.marian.translate_to.it': 'opus_mt_it_ar',
                                           'xx.es.marian.translate_to.gil': 'opus_mt_gil_es',
                                           'xx.ase.marian.translate_to.fr': 'opus_mt_fr_ase',
                                           'xx.fr.marian.translate_to.gaa': 'opus_mt_gaa_fr',
                                           'xx.lus.marian.translate_to.fr': 'opus_mt_fr_lus',
                                           'xx.fr.marian.translate_to.iso': 'opus_mt_iso_fr',
                                           'xx.sm.marian.translate_to.fr': 'opus_mt_fr_sm',
                                           'xx.mfe.marian.translate_to.fr': 'opus_mt_fr_mfe',
                                           'xx.af.marian.translate_to.fr': 'opus_mt_fr_af',
                                           'xx.de.marian.translate_to.ig': 'opus_mt_ig_de',
                                           'xx.es.marian.translate_to.id': 'opus_mt_id_es',
                                           'xx.kqn.marian.translate_to.fr': 'opus_mt_fr_kqn',
                                           'xx.zne.marian.translate_to.fi': 'opus_mt_fi_zne',
                                           'xx.rw.marian.translate_to.fr': 'opus_mt_fr_rw',
                                           'xx.ny.marian.translate_to.fr': 'opus_mt_fr_ny',
                                           'xx.ig.marian.translate_to.fr': 'opus_mt_fr_ig',
                                           'xx.ur.marian.translate_to.hi': 'opus_mt_hi_ur',
                                           'xx.lt.marian.translate_to.it': 'opus_mt_it_lt',
                                           'xx.srn.marian.translate_to.fr': 'opus_mt_fr_srn',
                                           'xx.tiv.marian.translate_to.fr': 'opus_mt_fr_tiv',
                                           'xx.war.marian.translate_to.fr': 'opus_mt_fr_war',
                                           'xx.fr.marian.translate_to.is': 'opus_mt_is_fr',
                                           'xx.de.marian.translate_to.gaa': 'opus_mt_gaa_de',
                                           'xx.kwy.marian.translate_to.fr': 'opus_mt_fr_kwy',
                                           'xx.sv.marian.translate_to.gil': 'opus_mt_gil_sv',
                                           'xx.hr.marian.translate_to.fr': 'opus_mt_fr_hr',
                                           'xx.fr.marian.translate_to.ig': 'opus_mt_ig_fr',
                                           'xx.sv.marian.translate_to.ht': 'opus_mt_ht_sv',
                                           'xx.de.marian.translate_to.fr': 'opus_mt_fr_de',
                                           'xx.fiu.marian.translate_to.fiu': 'opus_mt_fiu_fiu',
                                           'xx.wls.marian.translate_to.fr': 'opus_mt_fr_wls',
                                           'xx.eo.marian.translate_to.hu': 'opus_mt_hu_eo',
                                           'xx.guw.marian.translate_to.fr': 'opus_mt_fr_guw',
                                           'xx.de.marian.translate_to.is': 'opus_mt_is_de',
                                           'xx.tvl.marian.translate_to.fr': 'opus_mt_fr_tvl',
                                           'xx.zne.marian.translate_to.fr': 'opus_mt_fr_zne',
                                           'xx.ha.marian.translate_to.fr': 'opus_mt_fr_ha',
                                           'xx.fi.marian.translate_to.guw': 'opus_mt_guw_fi',
                                           'xx.es.marian.translate_to.is': 'opus_mt_is_es',
                                           'xx.sv.marian.translate_to.it': 'opus_mt_it_sv',
                                           'xx.uk.marian.translate_to.fr': 'opus_mt_fr_uk',
                                           'xx.uk.marian.translate_to.hu': 'opus_mt_hu_uk',
                                           'xx.mt.marian.translate_to.fr': 'opus_mt_fr_mt',
                                           'xx.gem.marian.translate_to.gem': 'opus_mt_gem_gem',
                                           'xx.fr.marian.translate_to.fj': 'opus_mt_fj_fr',
                                           'xx.fi.marian.translate_to.gil': 'opus_mt_gil_fi',
                                           'xx.fr.marian.translate_to.hu': 'opus_mt_hu_fr',
                                           'xx.bcl.marian.translate_to.fr': 'opus_mt_fr_bcl',
                                           'xx.gmq.marian.translate_to.gmq': 'opus_mt_gmq_gmq',
                                           'xx.kg.marian.translate_to.fr': 'opus_mt_fr_kg',
                                           'xx.sn.marian.translate_to.fr': 'opus_mt_fr_sn',
                                           'xx.bg.marian.translate_to.fr': 'opus_mt_fr_bg',
                                           'xx.fr.marian.translate_to.guw': 'opus_mt_guw_fr',
                                           'xx.ts.marian.translate_to.fr': 'opus_mt_fr_ts',
                                           'xx.pis.marian.translate_to.fr': 'opus_mt_fr_pis',
                                           'xx.bi.marian.translate_to.fr': 'opus_mt_fr_bi',
                                           'xx.ln.marian.translate_to.fr': 'opus_mt_fr_ln',
                                           'xx.de.marian.translate_to.hil': 'opus_mt_hil_de',
                                           'xx.nso.marian.translate_to.fr': 'opus_mt_fr_nso',
                                           'xx.es.marian.translate_to.iso': 'opus_mt_iso_es',
                                           'xx.crs.marian.translate_to.fr': 'opus_mt_fr_crs',
                                           'xx.niu.marian.translate_to.fr': 'opus_mt_fr_niu',
                                           'xx.fr.marian.translate_to.ht': 'opus_mt_ht_fr',
                                           'xx.fi.marian.translate_to.he': 'opus_mt_he_fi',
                                           'xx.gmw.marian.translate_to.gmw': 'opus_mt_gmw_gmw',
                                           'xx.fr.marian.translate_to.hr': 'opus_mt_hr_fr',
                                           'xx.sg.marian.translate_to.fr': 'opus_mt_fr_sg',
                                           'xx.pon.marian.translate_to.fr': 'opus_mt_fr_pon',
                                           'xx.fi.marian.translate_to.gaa': 'opus_mt_gaa_fi',
                                           'xx.pag.marian.translate_to.fr': 'opus_mt_fr_pag',
                                           'xx.fi.marian.translate_to.is': 'opus_mt_is_fi',
                                           'xx.sk.marian.translate_to.fr': 'opus_mt_fr_sk',
                                           'xx.yap.marian.translate_to.fr': 'opus_mt_fr_yap',
                                           'xx.es.marian.translate_to.ha': 'opus_mt_ha_es',
                                           'xx.no.marian.translate_to.fr': 'opus_mt_fr_no',
                                           'xx.ine.marian.translate_to.ine': 'opus_mt_ine_ine',
                                           'xx.fr.marian.translate_to.id': 'opus_mt_id_fr',
                                           'xx.bzs.marian.translate_to.fr': 'opus_mt_fr_bzs',
                                           'xx.he.marian.translate_to.fr': 'opus_mt_fr_he',
                                           'xx.sv.marian.translate_to.fr': 'opus_mt_fr_sv',
                                           'xx.uk.marian.translate_to.he': 'opus_mt_he_uk',
                                           'xx.fr.marian.translate_to.it': 'opus_mt_it_fr',
                                           'xx.fi.marian.translate_to.ig': 'opus_mt_ig_fi',
                                           'xx.vi.marian.translate_to.fr': 'opus_mt_fr_vi',
                                           'xx.fi.marian.translate_to.fse': 'opus_mt_fse_fi',
                                           'xx.es.marian.translate_to.guw': 'opus_mt_guw_es',
                                           'xx.tll.marian.translate_to.fr': 'opus_mt_fr_tll',
                                           'xx.lua.marian.translate_to.fr': 'opus_mt_fr_lua',
                                           'xx.yap.marian.translate_to.fi': 'opus_mt_fi_yap',
                                           'xx.es.marian.translate_to.gaa': 'opus_mt_gaa_es',
                                           'xx.sv.marian.translate_to.ig': 'opus_mt_ig_sv',
                                           'xx.ht.marian.translate_to.fr': 'opus_mt_fr_ht',
                                           'xx.el.marian.translate_to.fr': 'opus_mt_fr_el',
                                           'xx.inc.marian.translate_to.inc': 'opus_mt_inc_inc',
                                           'xx.swc.marian.translate_to.fr': 'opus_mt_fr_swc',
                                           'xx.ar.marian.translate_to.fr': 'opus_mt_fr_ar',
                                           'xx.es.marian.translate_to.ilo': 'opus_mt_ilo_es',
                                           'xx.fi.marian.translate_to.hr': 'opus_mt_hr_fi',
                                           'xx.tpi.marian.translate_to.fr': 'opus_mt_fr_tpi',
                                           'xx.ve.marian.translate_to.fr': 'opus_mt_fr_ve',
                                           'xx.sv.marian.translate_to.guw': 'opus_mt_guw_sv',
                                           'xx.sv.marian.translate_to.iso': 'opus_mt_iso_sv',
                                           'xx.sv.marian.translate_to.is': 'opus_mt_is_sv',
                                           'xx.tum.marian.translate_to.fr': 'opus_mt_fr_tum',
                                           'xx.es.marian.translate_to.ht': 'opus_mt_ht_es',
                                           'xx.ho.marian.translate_to.fr': 'opus_mt_fr_ho',
                                           'xx.efi.marian.translate_to.fr': 'opus_mt_fr_efi',
                                           'xx.es.marian.translate_to.gl': 'opus_mt_gl_es',
                                           'xx.ru.marian.translate_to.he': 'opus_mt_he_ru',
                                           'xx.fi.marian.translate_to.hil': 'opus_mt_hil_fi',
                                           'xx.eo.marian.translate_to.he': 'opus_mt_he_eo',
                                           'xx.lu.marian.translate_to.fr': 'opus_mt_fr_lu',
                                           'xx.sv.marian.translate_to.ha': 'opus_mt_ha_sv',
                                           'xx.rnd.marian.translate_to.fr': 'opus_mt_fr_rnd',
                                           'xx.st.marian.translate_to.fr': 'opus_mt_fr_st',
                                           'xx.tl.marian.translate_to.fr': 'opus_mt_fr_tl',
                                           'xx.bem.marian.translate_to.fr': 'opus_mt_fr_bem',
                                           'xx.eo.marian.translate_to.is': 'opus_mt_is_eo',
                                           'xx.is.marian.translate_to.it': 'opus_mt_it_is',
                                           'xx.hu.marian.translate_to.fr': 'opus_mt_fr_hu',
                                           'xx.yo.marian.translate_to.fi': 'opus_mt_fi_yo',
                                           'xx.iso.marian.translate_to.fr': 'opus_mt_fr_iso',
                                           'xx.de.marian.translate_to.it': 'opus_mt_it_de',
                                           'xx.ty.marian.translate_to.fr': 'opus_mt_fr_ty',
                                           'xx.hil.marian.translate_to.fr': 'opus_mt_fr_hil',
                                           'xx.eo.marian.translate_to.it': 'opus_mt_it_eo',
                                           'xx.sv.marian.translate_to.hr': 'opus_mt_hr_sv',
                                           'xx.ber.marian.translate_to.fr': 'opus_mt_fr_ber',
                                           'xx.de.marian.translate_to.guw': 'opus_mt_guw_de',
                                           'xx.fi.marian.translate_to.hu': 'opus_mt_hu_fi',
                                           'xx.es.marian.translate_to.it': 'opus_mt_it_es',
                                           'xx.de.marian.translate_to.hu': 'opus_mt_hu_de',
                                           'xx.fj.marian.translate_to.fr': 'opus_mt_fr_fj',
                                           'xx.sv.marian.translate_to.id': 'opus_mt_id_sv',
                                           'xx.xh.marian.translate_to.fr': 'opus_mt_fr_xh',
                                           'xx.yo.marian.translate_to.fr': 'opus_mt_fr_yo',
                                           'xx.ca.marian.translate_to.fr': 'opus_mt_fr_ca',
                                           'xx.es.marian.translate_to.he': 'opus_mt_he_es',
                                           'xx.de.marian.translate_to.he': 'opus_mt_he_de',
                                           'xx.pt.marian.translate_to.gl': 'opus_mt_gl_pt',
                                           'xx.ru.marian.translate_to.hy': 'opus_mt_hy_ru',
                                           'xx.mos.marian.translate_to.fr': 'opus_mt_fr_mos',
                                           'xx.ceb.marian.translate_to.fr': 'opus_mt_fr_ceb',
                                           'xx.sh.marian.translate_to.ja': 'opus_mt_ja_sh',
                                           'xx.bg.marian.translate_to.ja': 'opus_mt_ja_bg',
                                           'xx.sv.marian.translate_to.ja': 'opus_mt_ja_sv',
                                           'xx.ru.marian.translate_to.lv': 'opus_mt_lv_ru',
                                           'xx.fr.marian.translate_to.ms': 'opus_mt_ms_fr',
                                           'xx.sv.marian.translate_to.mt': 'opus_mt_mt_sv',
                                           'xx.da.marian.translate_to.ja': 'opus_mt_ja_da',
                                           'xx.de.marian.translate_to.niu': 'opus_mt_niu_de',
                                           'xx.es.marian.translate_to.niu': 'opus_mt_niu_es',
                                           'xx.sv.marian.translate_to.lus': 'opus_mt_lus_sv',
                                           'xx.sv.marian.translate_to.lg': 'opus_mt_lg_sv',
                                           'xx.sv.marian.translate_to.pon': 'opus_mt_pon_sv',
                                           'xx.ru.marian.translate_to.lt': 'opus_mt_lt_ru',
                                           'xx.fi.marian.translate_to.lg': 'opus_mt_lg_fi',
                                           'xx.sv.marian.translate_to.kg': 'opus_mt_kg_sv',
                                           'xx.fr.marian.translate_to.nl': 'opus_mt_nl_fr',
                                           'xx.ms.marian.translate_to.ms': 'opus_mt_ms_ms',
                                           'xx.es.marian.translate_to.lg': 'opus_mt_lg_es',
                                           'xx.fr.marian.translate_to.lu': 'opus_mt_lu_fr',
                                           'xx.fr.marian.translate_to.loz': 'opus_mt_loz_fr',
                                           'xx.ca.marian.translate_to.nl': 'opus_mt_nl_ca',
                                           'xx.sv.marian.translate_to.lue': 'opus_mt_lue_sv',
                                           'xx.vi.marian.translate_to.ja': 'opus_mt_ja_vi',
                                           'xx.fr.marian.translate_to.ja': 'opus_mt_ja_fr',
                                           'xx.fi.marian.translate_to.pap': 'opus_mt_pap_fi',
                                           'xx.pl.marian.translate_to.lt': 'opus_mt_lt_pl',
                                           'xx.de.marian.translate_to.ny': 'opus_mt_ny_de',
                                           'xx.fr.marian.translate_to.lue': 'opus_mt_lue_fr',
                                           'xx.gl.marian.translate_to.pt': 'opus_mt_pt_gl',
                                           'xx.fr.marian.translate_to.pap': 'opus_mt_pap_fr',
                                           'xx.uk.marian.translate_to.pl': 'opus_mt_pl_uk',
                                           'xx.fi.marian.translate_to.niu': 'opus_mt_niu_fi',
                                           'xx.ar.marian.translate_to.ja': 'opus_mt_ja_ar',
                                           'xx.es.marian.translate_to.mh': 'opus_mt_mh_es',
                                           'xx.ar.marian.translate_to.pl': 'opus_mt_pl_ar',
                                           'xx.de.marian.translate_to.pag': 'opus_mt_pag_de',
                                           'xx.es.marian.translate_to.no': 'opus_mt_no_es',
                                           'xx.es.marian.translate_to.mfs': 'opus_mt_mfs_es',
                                           'xx.fr.marian.translate_to.pis': 'opus_mt_pis_fr',
                                           'xx.eo.marian.translate_to.pt': 'opus_mt_pt_eo',
                                           'xx.de.marian.translate_to.lt': 'opus_mt_lt_de',
                                           'xx.fr.marian.translate_to.ln': 'opus_mt_ln_fr',
                                           'xx.es.marian.translate_to.pag': 'opus_mt_pag_es',
                                           'xx.fi.marian.translate_to.nl': 'opus_mt_nl_fi',
                                           'xx.vi.marian.translate_to.it': 'opus_mt_it_vi',
                                           'xx.fi.marian.translate_to.ko': 'opus_mt_ko_fi',
                                           'xx.de.marian.translate_to.nso': 'opus_mt_nso_de',
                                           'xx.fr.marian.translate_to.niu': 'opus_mt_niu_fr',
                                           'xx.ca.marian.translate_to.pt': 'opus_mt_pt_ca',
                                           'xx.fr.marian.translate_to.kwy': 'opus_mt_kwy_fr',
                                           'xx.ru.marian.translate_to.no': 'opus_mt_no_ru',
                                           'xx.fi.marian.translate_to.pon': 'opus_mt_pon_fi',
                                           'xx.fi.marian.translate_to.lu': 'opus_mt_lu_fi',
                                           'xx.es.marian.translate_to.ko': 'opus_mt_ko_es',
                                           'xx.es.marian.translate_to.ny': 'opus_mt_ny_es',
                                           'xx.itc.marian.translate_to.itc': 'opus_mt_itc_itc',
                                           'xx.es.marian.translate_to.ja': 'opus_mt_ja_es',
                                           'xx.fr.marian.translate_to.mk': 'opus_mt_mk_fr',
                                           'xx.it.marian.translate_to.ms': 'opus_mt_ms_it',
                                           'xx.sv.marian.translate_to.lu': 'opus_mt_lu_sv',
                                           'xx.fr.marian.translate_to.nso': 'opus_mt_nso_fr',
                                           'xx.uk.marian.translate_to.pt': 'opus_mt_pt_uk',
                                           'xx.no.marian.translate_to.no': 'opus_mt_no_no',
                                           'xx.sv.marian.translate_to.lua': 'opus_mt_lua_sv',
                                           'xx.es.marian.translate_to.pl': 'opus_mt_pl_es',
                                           'xx.es.marian.translate_to.lu': 'opus_mt_lu_es',
                                           'xx.fr.marian.translate_to.lus': 'opus_mt_lus_fr',
                                           'xx.tr.marian.translate_to.ja': 'opus_mt_ja_tr',
                                           'xx.fi.marian.translate_to.pag': 'opus_mt_pag_fi',
                                           'xx.fr.marian.translate_to.kqn': 'opus_mt_kqn_fr',
                                           'xx.fi.marian.translate_to.ja': 'opus_mt_ja_fi',
                                           'xx.af.marian.translate_to.nl': 'opus_mt_nl_af',
                                           'xx.sv.marian.translate_to.pag': 'opus_mt_pag_sv',
                                           'xx.sv.marian.translate_to.nl': 'opus_mt_nl_sv',
                                           'xx.uk.marian.translate_to.no': 'opus_mt_no_uk',
                                           'xx.es.marian.translate_to.lua': 'opus_mt_lua_es',
                                           'xx.fi.marian.translate_to.mt': 'opus_mt_mt_fi',
                                           'xx.eo.marian.translate_to.lt': 'opus_mt_lt_eo',
                                           'xx.de.marian.translate_to.no': 'opus_mt_no_de',
                                           'xx.eo.marian.translate_to.pl': 'opus_mt_pl_eo',
                                           'xx.es.marian.translate_to.loz': 'opus_mt_loz_es',
                                           'xx.ru.marian.translate_to.ja': 'opus_mt_ja_ru',
                                           'xx.sv.marian.translate_to.pl': 'opus_mt_pl_sv',
                                           'xx.fi.marian.translate_to.mh': 'opus_mt_mh_fi',
                                           'xx.hu.marian.translate_to.ja': 'opus_mt_ja_hu',
                                           'xx.fi.marian.translate_to.mk': 'opus_mt_mk_fi',
                                           'xx.es.marian.translate_to.lue': 'opus_mt_lue_es',
                                           'xx.sv.marian.translate_to.lt': 'opus_mt_lt_sv',
                                           'xx.fr.marian.translate_to.pon': 'opus_mt_pon_fr',
                                           'xx.es.marian.translate_to.pap': 'opus_mt_pap_es',
                                           'xx.es.marian.translate_to.ln': 'opus_mt_ln_es',
                                           'xx.de.marian.translate_to.loz': 'opus_mt_loz_de',
                                           'xx.ru.marian.translate_to.ka': 'opus_mt_ka_ru',
                                           'xx.sv.marian.translate_to.kwy': 'opus_mt_kwy_sv',
                                           'xx.fi.marian.translate_to.lv': 'opus_mt_lv_fi',
                                           'xx.pl.marian.translate_to.ja': 'opus_mt_ja_pl',
                                           'xx.hu.marian.translate_to.ko': 'opus_mt_ko_hu',
                                           'xx.de.marian.translate_to.ja': 'opus_mt_ja_de',
                                           'xx.de.marian.translate_to.ko': 'opus_mt_ko_de',
                                           'xx.es.marian.translate_to.kg': 'opus_mt_kg_es',
                                           'xx.de.marian.translate_to.pap': 'opus_mt_pap_de',
                                           'xx.fi.marian.translate_to.no': 'opus_mt_no_fi',
                                           'xx.fi.marian.translate_to.lue': 'opus_mt_lue_fi',
                                           'xx.no.marian.translate_to.pl': 'opus_mt_pl_no',
                                           'xx.fr.marian.translate_to.mt': 'opus_mt_mt_fr',
                                           'xx.es.marian.translate_to.mg': 'opus_mt_mg_es',
                                           'xx.es.marian.translate_to.pis': 'opus_mt_pis_es',
                                           'xx.fr.marian.translate_to.pl': 'opus_mt_pl_fr',
                                           'xx.sv.marian.translate_to.ko': 'opus_mt_ko_sv',
                                           'xx.sv.marian.translate_to.loz': 'opus_mt_loz_sv',
                                           'xx.fi.marian.translate_to.loz': 'opus_mt_loz_fi',
                                           'xx.pl.marian.translate_to.no': 'opus_mt_no_pl',
                                           'xx.nl.marian.translate_to.ja': 'opus_mt_ja_nl',
                                           'xx.de.marian.translate_to.pl': 'opus_mt_pl_de',
                                           'xx.lt.marian.translate_to.pl': 'opus_mt_pl_lt',
                                           'xx.ru.marian.translate_to.ko': 'opus_mt_ko_ru',
                                           'xx.fr.marian.translate_to.lv': 'opus_mt_lv_fr',
                                           'xx.he.marian.translate_to.ja': 'opus_mt_ja_he',
                                           'xx.sv.marian.translate_to.niu': 'opus_mt_niu_sv',
                                           'xx.de.marian.translate_to.ms': 'opus_mt_ms_de',
                                           'xx.es.marian.translate_to.lt': 'opus_mt_lt_es',
                                           'xx.sv.marian.translate_to.no': 'opus_mt_no_sv',
                                           'xx.nl.marian.translate_to.no': 'opus_mt_no_nl',
                                           'xx.fi.marian.translate_to.lua': 'opus_mt_lua_fi',
                                           'xx.fr.marian.translate_to.lt': 'opus_mt_lt_fr',
                                           'xx.ms.marian.translate_to.ja': 'opus_mt_ja_ms',
                                           'xx.es.marian.translate_to.kqn': 'opus_mt_kqn_es',
                                           'xx.fr.marian.translate_to.lg': 'opus_mt_lg_fr',
                                           'xx.es.marian.translate_to.mk': 'opus_mt_mk_es',
                                           'xx.da.marian.translate_to.no': 'opus_mt_no_da',
                                           'xx.it.marian.translate_to.lt': 'opus_mt_lt_it',
                                           'xx.es.marian.translate_to.prl': 'opus_mt_prl_es',
                                           'xx.fr.marian.translate_to.lua': 'opus_mt_lua_fr',
                                           'xx.es.marian.translate_to.nso': 'opus_mt_nso_es',
                                           'xx.sv.marian.translate_to.lv': 'opus_mt_lv_sv',
                                           'xx.fi.marian.translate_to.pis': 'opus_mt_pis_fi',
                                           'xx.es.marian.translate_to.pon': 'opus_mt_pon_es',
                                           'xx.fr.marian.translate_to.ko': 'opus_mt_ko_fr',
                                           'xx.de.marian.translate_to.ln': 'opus_mt_ln_de',
                                           'xx.uk.marian.translate_to.nl': 'opus_mt_nl_uk',
                                           'xx.eo.marian.translate_to.nl': 'opus_mt_nl_eo',
                                           'xx.es.marian.translate_to.lv': 'opus_mt_lv_es',
                                           'xx.tr.marian.translate_to.lt': 'opus_mt_lt_tr',
                                           'xx.es.marian.translate_to.mt': 'opus_mt_mt_es',
                                           'xx.fi.marian.translate_to.lus': 'opus_mt_lus_fi',
                                           'xx.tl.marian.translate_to.pt': 'opus_mt_pt_tl',
                                           'xx.no.marian.translate_to.nl': 'opus_mt_nl_no',
                                           'xx.sv.marian.translate_to.kqn': 'opus_mt_kqn_sv',
                                           'xx.pt.marian.translate_to.ja': 'opus_mt_ja_pt',
                                           'xx.fi.marian.translate_to.nso': 'opus_mt_nso_fi',
                                           'xx.fr.marian.translate_to.kg': 'opus_mt_kg_fr',
                                           'xx.sv.marian.translate_to.pis': 'opus_mt_pis_sv',
                                           'xx.is.marian.translate_to.sv': 'opus_mt_sv_is',
                                           'xx.sla.marian.translate_to.sla': 'opus_mt_sla_sla',
                                           'xx.sv.marian.translate_to.srn': 'opus_mt_srn_sv',
                                           'xx.niu.marian.translate_to.sv': 'opus_mt_sv_niu',
                                           'xx.to.marian.translate_to.sv': 'opus_mt_sv_to',
                                           'xx.guw.marian.translate_to.sv': 'opus_mt_sv_guw',
                                           'xx.sn.marian.translate_to.sv': 'opus_mt_sv_sn',
                                           'xx.sv.marian.translate_to.rnd': 'opus_mt_rnd_sv',
                                           'xx.tum.marian.translate_to.sv': 'opus_mt_sv_tum',
                                           'xx.mos.marian.translate_to.sv': 'opus_mt_sv_mos',
                                           'xx.srn.marian.translate_to.sv': 'opus_mt_sv_srn',
                                           'xx.ht.marian.translate_to.sv': 'opus_mt_sv_ht',
                                           'xx.no.marian.translate_to.ru': 'opus_mt_ru_no',
                                           'xx.sl.marian.translate_to.sv': 'opus_mt_sv_sl',
                                           'xx.fr.marian.translate_to.sv': 'opus_mt_sv_fr',
                                           'xx.uk.marian.translate_to.ru': 'opus_mt_ru_uk',
                                           'xx.tiv.marian.translate_to.sv': 'opus_mt_sv_tiv',
                                           'xx.es.marian.translate_to.ru': 'opus_mt_ru_es',
                                           'xx.pag.marian.translate_to.sv': 'opus_mt_sv_pag',
                                           'xx.gaa.marian.translate_to.sv': 'opus_mt_sv_gaa',
                                           'xx.kqn.marian.translate_to.sv': 'opus_mt_sv_kqn',
                                           'xx.fr.marian.translate_to.sg': 'opus_mt_sg_fr',
                                           'xx.st.marian.translate_to.sv': 'opus_mt_sv_st',
                                           'xx.ase.marian.translate_to.sv': 'opus_mt_sv_ase',
                                           'xx.es.marian.translate_to.rn': 'opus_mt_rn_es',
                                           'xx.ru.marian.translate_to.sl': 'opus_mt_sl_ru',
                                           'xx.lu.marian.translate_to.sv': 'opus_mt_sv_lu',
                                           'xx.eu.marian.translate_to.ru': 'opus_mt_ru_eu',
                                           'xx.no.marian.translate_to.sv': 'opus_mt_sv_no',
                                           'xx.sq.marian.translate_to.sv': 'opus_mt_sv_sq',
                                           'xx.da.marian.translate_to.ru': 'opus_mt_ru_da',
                                           'xx.ny.marian.translate_to.sv': 'opus_mt_sv_ny',
                                           'xx.kg.marian.translate_to.sv': 'opus_mt_sv_kg',
                                           'xx.pis.marian.translate_to.sv': 'opus_mt_sv_pis',
                                           'xx.sv.marian.translate_to.sk': 'opus_mt_sk_sv',
                                           'xx.lus.marian.translate_to.sv': 'opus_mt_sv_lus',
                                           'xx.fi.marian.translate_to.sl': 'opus_mt_sl_fi',
                                           'xx.tn.marian.translate_to.sv': 'opus_mt_sv_tn',
                                           'xx.fr.marian.translate_to.srn': 'opus_mt_srn_fr',
                                           'xx.lv.marian.translate_to.sv': 'opus_mt_sv_lv',
                                           'xx.uk.marian.translate_to.sl': 'opus_mt_sl_uk',
                                           'xx.sg.marian.translate_to.sv': 'opus_mt_sv_sg',
                                           'xx.he.marian.translate_to.sv': 'opus_mt_sv_he',
                                           'xx.eo.marian.translate_to.ru': 'opus_mt_ru_eo',
                                           'xx.fr.marian.translate_to.ru': 'opus_mt_ru_fr',
                                           'xx.lv.marian.translate_to.ru': 'opus_mt_ru_lv',
                                           'xx.lua.marian.translate_to.sv': 'opus_mt_sv_lua',
                                           'xx.ar.marian.translate_to.ru': 'opus_mt_ru_ar',
                                           'xx.tll.marian.translate_to.sv': 'opus_mt_sv_tll',
                                           'xx.lue.marian.translate_to.sv': 'opus_mt_sv_lue',
                                           'xx.bi.marian.translate_to.sv': 'opus_mt_sv_bi',
                                           'xx.hu.marian.translate_to.sv': 'opus_mt_sv_hu',
                                           'xx.bzs.marian.translate_to.sv': 'opus_mt_sv_bzs',
                                           'xx.ru.marian.translate_to.sv': 'opus_mt_sv_ru',
                                           'xx.eo.marian.translate_to.ro': 'opus_mt_ro_eo',
                                           'xx.es.marian.translate_to.st': 'opus_mt_st_es',
                                           'xx.mt.marian.translate_to.sv': 'opus_mt_sv_mt',
                                           'xx.af.marian.translate_to.sv': 'opus_mt_sv_af',
                                           'xx.ts.marian.translate_to.sv': 'opus_mt_sv_ts',
                                           'xx.af.marian.translate_to.ru': 'opus_mt_ru_af',
                                           'xx.efi.marian.translate_to.sv': 'opus_mt_sv_efi',
                                           'xx.es.marian.translate_to.sv': 'opus_mt_sv_es',
                                           'xx.fi.marian.translate_to.sk': 'opus_mt_sk_fi',
                                           'xx.fr.marian.translate_to.rw': 'opus_mt_rw_fr',
                                           'xx.sv.marian.translate_to.run': 'opus_mt_run_sv',
                                           'xx.th.marian.translate_to.sv': 'opus_mt_sv_th',
                                           'xx.ln.marian.translate_to.sv': 'opus_mt_sv_ln',
                                           'xx.es.marian.translate_to.sk': 'opus_mt_sk_es',
                                           'xx.lt.marian.translate_to.ru': 'opus_mt_ru_lt',
                                           'xx.mfe.marian.translate_to.sv': 'opus_mt_sv_mfe',
                                           'xx.cs.marian.translate_to.sv': 'opus_mt_sv_cs',
                                           'xx.vi.marian.translate_to.ru': 'opus_mt_ru_vi',
                                           'xx.ee.marian.translate_to.sv': 'opus_mt_sv_ee',
                                           'xx.bg.marian.translate_to.ru': 'opus_mt_ru_bg',
                                           'xx.nso.marian.translate_to.sv': 'opus_mt_sv_nso',
                                           'xx.mh.marian.translate_to.sv': 'opus_mt_sv_mh',
                                           'xx.iso.marian.translate_to.sv': 'opus_mt_sv_iso',
                                           'xx.fi.marian.translate_to.st': 'opus_mt_st_fi',
                                           'xx.bg.marian.translate_to.sv': 'opus_mt_sv_bg',
                                           'xx.sv.marian.translate_to.sq': 'opus_mt_sq_sv',
                                           'xx.sv.marian.translate_to.sn': 'opus_mt_sn_sv',
                                           'xx.de.marian.translate_to.rn': 'opus_mt_rn_de',
                                           'xx.pon.marian.translate_to.sv': 'opus_mt_sv_pon',
                                           'xx.ha.marian.translate_to.sv': 'opus_mt_sv_ha',
                                           'xx.fi.marian.translate_to.ru': 'opus_mt_ru_fi',
                                           'xx.sk.marian.translate_to.sv': 'opus_mt_sv_sk',
                                           'xx.es.marian.translate_to.run': 'opus_mt_run_es',
                                           'xx.et.marian.translate_to.ru': 'opus_mt_ru_et',
                                           'xx.swc.marian.translate_to.sv': 'opus_mt_sv_swc',
                                           'xx.hil.marian.translate_to.sv': 'opus_mt_sv_hil',
                                           'xx.ro.marian.translate_to.sv': 'opus_mt_sv_ro',
                                           'xx.fr.marian.translate_to.rnd': 'opus_mt_rnd_fr',
                                           'xx.kwy.marian.translate_to.sv': 'opus_mt_sv_kwy',
                                           'xx.uk.marian.translate_to.sh': 'opus_mt_sh_uk',
                                           'xx.sm.marian.translate_to.sv': 'opus_mt_sv_sm',
                                           'xx.sv.marian.translate_to.rw': 'opus_mt_rw_sv',
                                           'xx.et.marian.translate_to.sv': 'opus_mt_sv_et',
                                           'xx.eo.marian.translate_to.sv': 'opus_mt_sv_eo',
                                           'xx.rnd.marian.translate_to.sv': 'opus_mt_sv_rnd',
                                           'xx.eo.marian.translate_to.sh': 'opus_mt_sh_eo',
                                           'xx.ru.marian.translate_to.rn': 'opus_mt_rn_ru',
                                           'xx.rw.marian.translate_to.sv': 'opus_mt_sv_rw',
                                           'xx.fr.marian.translate_to.sn': 'opus_mt_sn_fr',
                                           'xx.ig.marian.translate_to.sv': 'opus_mt_sv_ig',
                                           'xx.fj.marian.translate_to.sv': 'opus_mt_sv_fj',
                                           'xx.sl.marian.translate_to.ru': 'opus_mt_ru_sl',
                                           'xx.ho.marian.translate_to.sv': 'opus_mt_sv_ho',
                                           'xx.sv.marian.translate_to.sl': 'opus_mt_sl_sv',
                                           'xx.pap.marian.translate_to.sv': 'opus_mt_sv_pap',
                                           'xx.fr.marian.translate_to.sl': 'opus_mt_sl_fr',
                                           'xx.es.marian.translate_to.sl': 'opus_mt_sl_es',
                                           'xx.run.marian.translate_to.sv': 'opus_mt_sv_run',
                                           'xx.el.marian.translate_to.sv': 'opus_mt_sv_el',
                                           'xx.gil.marian.translate_to.sv': 'opus_mt_sv_gil',
                                           'xx.crs.marian.translate_to.sv': 'opus_mt_sv_crs',
                                           'xx.fr.marian.translate_to.sk': 'opus_mt_sk_fr',
                                           'xx.es.marian.translate_to.sq': 'opus_mt_sq_es',
                                           'xx.sv.marian.translate_to.sg': 'opus_mt_sg_sv',
                                           'xx.es.marian.translate_to.srn': 'opus_mt_srn_es',
                                           'xx.fr.marian.translate_to.ro': 'opus_mt_ro_fr',
                                           'xx.fr.marian.translate_to.rn': 'opus_mt_rn_fr',
                                           'xx.fr.marian.translate_to.st': 'opus_mt_st_fr',
                                           'xx.es.marian.translate_to.rw': 'opus_mt_rw_es',
                                           'xx.hr.marian.translate_to.sv': 'opus_mt_sv_hr',
                                           'xx.es.marian.translate_to.sm': 'opus_mt_sm_es',
                                           'xx.es.marian.translate_to.ssp': 'opus_mt_ssp_es',
                                           'xx.nl.marian.translate_to.sv': 'opus_mt_sv_nl',
                                           'xx.bem.marian.translate_to.sv': 'opus_mt_sv_bem',
                                           'xx.sem.marian.translate_to.sem': 'opus_mt_sem_sem',
                                           'xx.sv.marian.translate_to.sv': 'opus_mt_sv_sv',
                                           'xx.sv.marian.translate_to.st': 'opus_mt_st_sv',
                                           'xx.lg.marian.translate_to.sv': 'opus_mt_sv_lg',
                                           'xx.bcl.marian.translate_to.sv': 'opus_mt_sv_bcl',
                                           'xx.toi.marian.translate_to.sv': 'opus_mt_sv_toi',
                                           'xx.id.marian.translate_to.sv': 'opus_mt_sv_id',
                                           'xx.he.marian.translate_to.ru': 'opus_mt_ru_he',
                                           'xx.ceb.marian.translate_to.sv': 'opus_mt_sv_ceb',
                                           'xx.tw.marian.translate_to.sv': 'opus_mt_sv_tw',
                                           'xx.chk.marian.translate_to.sv': 'opus_mt_sv_chk',
                                           'xx.fr.marian.translate_to.sm': 'opus_mt_sm_fr',
                                           'xx.tvl.marian.translate_to.sv': 'opus_mt_sv_tvl',
                                           'xx.es.marian.translate_to.sg': 'opus_mt_sg_es',
                                           'xx.ilo.marian.translate_to.sv': 'opus_mt_sv_ilo',
                                           'xx.sv.marian.translate_to.ro': 'opus_mt_ro_sv',
                                           'xx.fi.marian.translate_to.sg': 'opus_mt_sg_fi',
                                           'xx.hy.marian.translate_to.ru': 'opus_mt_ru_hy',
                                           'xx.fi.marian.translate_to.ro': 'opus_mt_ro_fi',
                                           'xx.tpi.marian.translate_to.sv': 'opus_mt_sv_tpi',
                                           'xx.fi.marian.translate_to.sv': 'opus_mt_sv_fi',
                                           'xx.sv.marian.translate_to.ru': 'opus_mt_ru_sv',
                                           'xx.es.marian.translate_to.toi': 'opus_mt_toi_es',
                                           'xx.no.marian.translate_to.uk': 'opus_mt_uk_no',
                                           'xx.ar.marian.translate_to.tr': 'opus_mt_tr_ar',
                                           'xx.he.marian.translate_to.uk': 'opus_mt_uk_he',
                                           'xx.sv.marian.translate_to.tvl': 'opus_mt_tvl_sv',
                                           'xx.uk.marian.translate_to.sv': 'opus_mt_sv_uk',
                                           'xx.fr.marian.translate_to.tvl': 'opus_mt_tvl_fr',
                                           'xx.bg.marian.translate_to.uk': 'opus_mt_uk_bg',
                                           'xx.fi.marian.translate_to.toi': 'opus_mt_toi_fi',
                                           'xx.ca.marian.translate_to.uk': 'opus_mt_uk_ca',
                                           'xx.fr.marian.translate_to.uk': 'opus_mt_uk_fr',
                                           'xx.eo.marian.translate_to.tr': 'opus_mt_tr_eo',
                                           'xx.uk.marian.translate_to.tr': 'opus_mt_tr_uk',
                                           'xx.es.marian.translate_to.tl': 'opus_mt_tl_es',
                                           'xx.es.marian.translate_to.tr': 'opus_mt_tr_es',
                                           'xx.it.marian.translate_to.uk': 'opus_mt_uk_it',
                                           'xx.fi.marian.translate_to.uk': 'opus_mt_uk_fi',
                                           'xx.lt.marian.translate_to.tr': 'opus_mt_tr_lt',
                                           'xx.es.marian.translate_to.swc': 'opus_mt_swc_es',
                                           'xx.umb.marian.translate_to.sv': 'opus_mt_sv_umb',
                                           'xx.sv.marian.translate_to.tw': 'opus_mt_tw_sv',
                                           'xx.urj.marian.translate_to.urj': 'opus_mt_urj_urj',
                                           'xx.yap.marian.translate_to.sv': 'opus_mt_sv_yap',
                                           'xx.fr.marian.translate_to.ty': 'opus_mt_ty_fr',
                                           'xx.fr.marian.translate_to.swc': 'opus_mt_swc_fr',
                                           'xx.pt.marian.translate_to.tl': 'opus_mt_tl_pt',
                                           'xx.tr.marian.translate_to.uk': 'opus_mt_uk_tr',
                                           'xx.sv.marian.translate_to.tr': 'opus_mt_tr_sv',
                                           'xx.fi.marian.translate_to.tvl': 'opus_mt_tvl_fi',
                                           'xx.es.marian.translate_to.tn': 'opus_mt_tn_es',
                                           'xx.fi.marian.translate_to.swc': 'opus_mt_swc_fi',
                                           'xx.fr.marian.translate_to.toi': 'opus_mt_toi_fr',
                                           'xx.fi.marian.translate_to.ts': 'opus_mt_ts_fi',
                                           'xx.de.marian.translate_to.uk': 'opus_mt_uk_de',
                                           'xx.sv.marian.translate_to.uk': 'opus_mt_uk_sv',
                                           'xx.fi.marian.translate_to.tw': 'opus_mt_tw_fi',
                                           'xx.sv.marian.translate_to.to': 'opus_mt_to_sv',
                                           'xx.sv.marian.translate_to.tll': 'opus_mt_tll_sv',
                                           'xx.fr.marian.translate_to.th': 'opus_mt_th_fr',
                                           'xx.es.marian.translate_to.ty': 'opus_mt_ty_es',
                                           'xx.fr.marian.translate_to.tw': 'opus_mt_tw_fr',
                                           'xx.fr.marian.translate_to.to': 'opus_mt_to_fr',
                                           'xx.sl.marian.translate_to.uk': 'opus_mt_uk_sl',
                                           'xx.xh.marian.translate_to.sv': 'opus_mt_sv_xh',
                                           'xx.war.marian.translate_to.sv': 'opus_mt_sv_war',
                                           'xx.hu.marian.translate_to.uk': 'opus_mt_uk_hu',
                                           'xx.ru.marian.translate_to.uk': 'opus_mt_uk_ru',
                                           'xx.sv.marian.translate_to.tn': 'opus_mt_tn_sv',
                                           'xx.fr.marian.translate_to.tum': 'opus_mt_tum_fr',
                                           'xx.sv.marian.translate_to.toi': 'opus_mt_toi_sv',
                                           'xx.sv.marian.translate_to.ty': 'opus_mt_ty_sv',
                                           'xx.fr.marian.translate_to.tr': 'opus_mt_tr_fr',
                                           'xx.fr.marian.translate_to.tn': 'opus_mt_tn_fr',
                                           'xx.cs.marian.translate_to.uk': 'opus_mt_uk_cs',
                                           'xx.fr.marian.translate_to.ts': 'opus_mt_ts_fr',
                                           'xx.sv.marian.translate_to.swc': 'opus_mt_swc_sv',
                                           'xx.es.marian.translate_to.to': 'opus_mt_to_es',
                                           'xx.es.marian.translate_to.uk': 'opus_mt_uk_es',
                                           'xx.nl.marian.translate_to.uk': 'opus_mt_uk_nl',
                                           'xx.zne.marian.translate_to.sv': 'opus_mt_sv_zne',
                                           'xx.es.marian.translate_to.tvl': 'opus_mt_tvl_es',
                                           'xx.pt.marian.translate_to.uk': 'opus_mt_uk_pt',
                                           'xx.fr.marian.translate_to.tiv': 'opus_mt_tiv_fr',
                                           'xx.fr.marian.translate_to.tll': 'opus_mt_tll_fr',
                                           'xx.sh.marian.translate_to.uk': 'opus_mt_uk_sh',
                                           'xx.wls.marian.translate_to.sv': 'opus_mt_sv_wls',
                                           'xx.ve.marian.translate_to.sv': 'opus_mt_sv_ve',
                                           'xx.es.marian.translate_to.tum': 'opus_mt_tum_es',
                                           'xx.fi.marian.translate_to.tll': 'opus_mt_tll_fi',
                                           'xx.es.marian.translate_to.tw': 'opus_mt_tw_es',
                                           'xx.sv.marian.translate_to.tiv': 'opus_mt_tiv_sv',
                                           'xx.fi.marian.translate_to.ty': 'opus_mt_ty_fi',
                                           'xx.pl.marian.translate_to.uk': 'opus_mt_uk_pl',
                                           'xx.sv.marian.translate_to.tpi': 'opus_mt_tpi_sv',
                                           'xx.az.marian.translate_to.tr': 'opus_mt_tr_az',
                                           'xx.es.marian.translate_to.tll': 'opus_mt_tll_es',
                                           'xx.ty.marian.translate_to.sv': 'opus_mt_sv_ty',
                                           'xx.tzo.marian.translate_to.es': 'opus_mt_es_tzo',
                                           'xx.sv.marian.translate_to.crs': 'opus_mt_crs_sv',
                                           'xx.es.marian.translate_to.zai': 'opus_mt_zai_es',
                                           'xx.niu.marian.translate_to.de': 'opus_mt_de_niu',
                                           'xx.sv.marian.translate_to.nso': 'opus_mt_nso_sv',
                                           'xx.fr.marian.translate_to.bg': 'opus_mt_bg_fr',
                                           'xx.es.marian.translate_to.lus': 'opus_mt_lus_es',
                                           'xx.es.marian.translate_to.nl': 'opus_mt_nl_es',
                                           'xx.fr.marian.translate_to.yo': 'opus_mt_yo_fr',
                                           'xx.sv.marian.translate_to.ilo': 'opus_mt_ilo_sv',
                                           'xx.es.marian.translate_to.ts': 'opus_mt_ts_es',
                                           'xx.run.marian.translate_to.fr': 'opus_mt_fr_run',
                                           'xx.to.marian.translate_to.es': 'opus_mt_es_to',
                                           'xx.ceb.marian.translate_to.fi': 'opus_mt_fi_ceb',
                                           'xx.it.marian.translate_to.ja': 'opus_mt_ja_it',
                                           'xx.es.marian.translate_to.sn': 'opus_mt_sn_es',
                                           'xx.yo.marian.translate_to.sv': 'opus_mt_sv_yo',
                                           'xx.tr.marian.translate_to.az': 'opus_mt_az_tr',
                                           'xx.fr.marian.translate_to.no': 'opus_mt_no_fr',
                                           'xx.tn.marian.translate_to.fr': 'opus_mt_fr_tn',
                                           'xx.id.marian.translate_to.fr': 'opus_mt_fr_id',
                                           'xx.de.marian.translate_to.ca': 'opus_mt_ca_de',
                                           'xx.sv.marian.translate_to.tum': 'opus_mt_tum_sv',
                                           'xx.ru.marian.translate_to.da': 'opus_mt_da_ru',
                                           'xx.de.marian.translate_to.tl': 'opus_mt_tl_de',
                                           'xx.eo.marian.translate_to.fr': 'opus_mt_fr_eo',
                                           'xx.vi.marian.translate_to.zh': 'opus_mt_zh_vi',
                                           'xx.es.marian.translate_to.vi': 'opus_mt_vi_es',
                                           'xx.es.marian.translate_to.mfe': 'opus_mt_mfe_es',
                                           'xx.fi.marian.translate_to.iso': 'opus_mt_iso_fi',
                                           'xx.es.marian.translate_to.tzo': 'opus_mt_tzo_es',
                                           'xx.sn.marian.translate_to.es': 'opus_mt_es_sn',
                                           'xx.es.marian.translate_to.xh': 'opus_mt_xh_es',
                                           'xx.sv.marian.translate_to.zne': 'opus_mt_zne_sv',
                                           'xx.sv.marian.translate_to.ts': 'opus_mt_ts_sv',
                                           'xx.it.marian.translate_to.zh': 'opus_mt_zh_it',
                                           'xx.uk.marian.translate_to.zh': 'opus_mt_zh_uk',
                                           'xx.fi.marian.translate_to.yo': 'opus_mt_yo_fi',
                                           'xx.sv.marian.translate_to.war': 'opus_mt_war_sv',
                                           'xx.sv.marian.translate_to.yo': 'opus_mt_yo_sv',
                                           'xx.tll.marian.translate_to.es': 'opus_mt_es_tll',
                                           'xx.nl.marian.translate_to.zh': 'opus_mt_zh_nl',
                                           'xx.fr.marian.translate_to.wls': 'opus_mt_wls_fr',
                                           'xx.it.marian.translate_to.vi': 'opus_mt_vi_it',
                                           'xx.bg.marian.translate_to.zh': 'opus_mt_zh_bg',
                                           'xx.sv.marian.translate_to.xh': 'opus_mt_xh_sv',
                                           'xx.es.marian.translate_to.zne': 'opus_mt_zne_es',
                                           'xx.zlw.marian.translate_to.zlw': 'opus_mt_zlw_zlw',
                                           'xx.sv.marian.translate_to.yap': 'opus_mt_yap_sv',
                                           'xx.he.marian.translate_to.zh': 'opus_mt_zh_he',
                                           'xx.fr.marian.translate_to.xh': 'opus_mt_xh_fr',
                                           'xx.fi.marian.translate_to.war': 'opus_mt_war_fi',
                                           'xx.sv.marian.translate_to.zh': 'opus_mt_zh_sv',
                                           'xx.zls.marian.translate_to.zls': 'opus_mt_zls_zls',
                                           'xx.fi.marian.translate_to.zne': 'opus_mt_zne_fi',
                                           'xx.es.marian.translate_to.ve': 'opus_mt_ve_es',
                                           'xx.de.marian.translate_to.vi': 'opus_mt_vi_de',
                                           'xx.eo.marian.translate_to.vi': 'opus_mt_vi_eo',
                                           'xx.sv.marian.translate_to.wls': 'opus_mt_wls_sv',
                                           'xx.es.marian.translate_to.war': 'opus_mt_war_es',
                                           'xx.ru.marian.translate_to.vi': 'opus_mt_vi_ru',
                                           'xx.ms.marian.translate_to.zh': 'opus_mt_zh_ms',
                                           'xx.fr.marian.translate_to.zne': 'opus_mt_zne_fr',
                                           'xx.fr.marian.translate_to.yap': 'opus_mt_yap_fr',
                                           'xx.de.marian.translate_to.zh': 'opus_mt_zh_de',
                                           'xx.es.marian.translate_to.yo': 'opus_mt_yo_es',
                                           'xx.es.marian.translate_to.vsl': 'opus_mt_vsl_es',
                                           'xx.zle.marian.translate_to.zle': 'opus_mt_zle_zle',
                                           'xx.fr.marian.translate_to.vi': 'opus_mt_vi_fr',
                                           'xx.fr.marian.translate_to.war': 'opus_mt_war_fr',
                                           'xx.fi.marian.translate_to.zh': 'opus_mt_zh_fi',
                                           'xx.he.marian.translate_to.it': 'opus_tatoeba_he_it',
                                           'xx.es.marian.translate_to.zh': 'opus_tatoeba_es_zh',
                                           'xx.af.translate_to.ru': 'opus_tatoeba_af_ru',
                                           'xx.he.translate_to.fr': 'opus_tatoeba_he_fr',
                                           'xx.it.translate_to.he': 'opus_tatoeba_it_he',
                                           'xx.cs.translate_to.sv': 'opus_mt_cs_sv'},
                                    'bo': {'bo.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'diq': {'diq.embed.w2v_cc_300d': 'w2v_cc_300d'},
                                    'ckb': {},
                                    'lt': {'lt.lemma': 'lemma_alksnis', 'lt.pos.alksnis': 'pos_alksnis'},
                                    'gd': {'gd.lemma': 'lemma_arcosg', 'gd.pos.arcosg': 'pos_arcosg'},
                                    'fo': {'fo.lemma': 'lemma_farpahc', 'fo.lemma.farpahc': 'lemma_farpahc'},
                                    'lzh': {'lzh.lemma': 'lemma_kyoto',
                                            'lzh.lemma.kyoto': 'lemma_kyoto',
                                            'lzh.pos.kyoto': 'pos_kyoto'},
                                    'grc': {'grc.lemma': 'lemma_perseus',
                                            'grc.lemma.perseus': 'lemma_perseus',
                                            'grc.pos.perseus': 'pos_perseus'},
                                    'got': {'got.lemma': 'lemma_proiel',
                                            'got.lemma.proiel': 'lemma_proiel',
                                            'got.pos.proiel': 'pos_proiel'},
                                    'orv': {'orv.lemma': 'lemma_rnc',
                                            'orv.lemma.rnc': 'lemma_rnc',
                                            'orv.pos.rnc': 'pos_rnc',
                                            'orv.pos.torot': 'pos_torot'},
                                    'cu': {'cu.lemma': 'lemma_proiel', 'cu.lemma.proiel': 'lemma_proiel'},
                                    'fro': {'fro.lemma': 'lemma_srcmf',
                                            'fro.lemma.srcmf': 'lemma_srcmf',
                                            'fro.pos.srcmf': 'pos_srcmf'},
                                    'qtd': {'qtd.lemma': 'lemma_sagt', 'qtd.lemma.sagt': 'lemma_sagt'},
                                    'ug': {'ug.lemma': 'lemma_udt',
                                           'ug.lemma.udt': 'lemma_udt',
                                           'ug.pos.udt': 'pos_udt'},
                                    'cop': {'cop.lemma': 'lemma_scriptorium',
                                            'cop.lemma.scriptorium': 'lemma_scriptorium'},
                                    'hr': {'hr.lemma': 'lemma_set',
                                           'hr.lemma.set': 'lemma_set',
                                           'hr.pos.set': 'pos_set'},
                                    'be': {'be.pos': 'pos_hse', 'be.pos.hse': 'pos_hse'},
                                    'qhe': {'qhe.pos': 'pos_hiencs', 'qhe.pos.hiencs': 'pos_hiencs'},
                                    'sr': {'sr.pos': 'pos_set', 'sr.pos.set': 'pos_set'}}

    healthcare_component_alias_references = {}
    pretrained_healthcare_pipe_references = {
        'en': {
            'en.med_ner.profiling_clinical': 'ner_profiling_clinical',
            'en.med_ner.profiling_biobert': 'ner_profiling_biobert',
            'en.resolve.icd10cm.umls': 'icd10cm_umls_mapping',
            'en.resolve.mesh.umls': 'mesh_umls_mapping',
            'en.resolve.rxnorm.umls': 'rxnorm_umls_mapping',
            'en.resolve.rxnorm.mesh': 'rxnorm_mesh_mapping',
            'en.resolve.snomed.umls': 'snomed_umls_mapping',

            # '' :'clinical_analysis', # Not 3+ compatible
            # '' :'clinical_deidentification', # todo to big ner consumer stack for NLU to handle..
            # '' :'clinical_ner_assertion', Not 3+ compatible

            # Explain Pipes
            'en.explain_doc.carp': 'explain_clinical_doc_carp',
            'en.explain_doc.era': 'explain_clinical_doc_era',
            # 'en.explain_doc.ade':'explain_clinical_doc_ade', # todo wierd 2x Converter 1x NER component_list, messes up component_list logic

            'en.recognize_entities.posology': 'recognize_entities_posology',  # PIPE

        },
        'fr': {
            'fr.deid_obfuscated' : 'clinical_deidentification' #need finisher support first

        }
    }
    pretrained_healthcare_model_references = {
        'fr': {
            'fr.med_ner.deid_generic': 'ner_deid_generic',
            'fr.med_ner.deid_subentity': 'ner_deid_subentity',

        },
        'it':
            {
                'it.med_ner.deid_generic': 'ner_deid_generic',
                'it.med_ner.deid_subentity': 'ner_deid_subentity',

            },
        'en':
            {

                # 3.4.3
                'en.relation.zeroshot_biobert': 're_zeroshot_biobert',

                # 3.4.2
                'en.med_ner.clinical_trials': 'bert_sequence_classifier_rct_biobert',

                # 3.4.1
                'en.med_ner.supplement_clinical': 'ner_supplement_clinical',
                'en.resolve.rxnorm.augmented_re': 'sbiobertresolve_rxnorm_augmented_re',
                'en.classify.ade.seq_biobert': 'bert_sequence_classifier_ade',
                'en.classify.gender.seq_biobert': 'bert_sequence_classifier_gender_biobert',
                'en.classify.pico.seq_biobert': 'bert_sequence_classifier_pico_biobert',
                'en.classify.ade.seq_distilbert': 'distilbert_sequence_classifier_ade',
                'en.relation.temporal_events_clinical': 're_temporal_events_clinical',
                'en.relation.adverse_drug_events.clinical': 're_ade_clinical',
                'en.relation.adverse_drug_events.clinical.biobert': 'redl_ade_biobert',

                # 3.4.0
                'en.med_ner.abbreviation_clinical': 'ner_abbreviation_clinical',
                'en.med_ner.drugprot_clinical': 'ner_drugprot_clinical',
                'en.ner.drug_development_trials': 'bert_token_classifier_drug_development_trials',
                'en.med_ner.chemprot.bert': 'bert_token_classifier_ner_chemprot',
                'en.relation.drugprot': 'redl_drugprot_biobert',
                'en.relation.drugprot.clinical': 're_drugprot_clinical',
                'en.resolve.clinical_abbreviation_acronym': 'sbiobertresolve_clinical_abbreviation_acronym',
                'en.resolve.umls_drug_substance': 'sbiobertresolve_umls_drug_substance',
                'en.resolve.loinc_cased': 'sbiobertresolve_loinc_cased',
                'en.resolve.loinc_uncased': 'sbluebertresolve_loinc_uncased',
                'en.embed_sentence.biobert.rxnorm': 'sbiobert_jsl_rxnorm_cased',
                'en.embed_sentence.bert_uncased.rxnorm': 'sbert_jsl_medium_rxnorm_uncased',
                'en.resolve.snomed_drug': 'sbiobertresolve_snomed_drug',

                # clinical spellchecker
                # 'en.spell.clinical':   'spellcheck_clinical',  #todo crashing
                # 'en.spell.med':        'context_spell_med', #todo crashing
                # 'en.spell.context.med':'context_spell_med', #todo crashing Byteerror

                # 3.3.0 Healthcare
                'en.spell.drug_norvig': 'spellcheck_drug_norvig',
                'en.classify.token_bert.ner_bacteria': 'bert_token_classifier_ner_bacteria',
                'en.classify.token_bert.ner_anatomy': 'bert_token_classifier_ner_anatomy',
                'en.classify.token_bert.ner_drugs': 'bert_token_classifier_ner_drugs',
                'en.classify.token_bert.ner_jsl_slim': 'bert_token_classifier_ner_jsl_slim',
                'en.classify.token_bert.ner_ade': 'bert_token_classifier_ner_ade',
                'en.resolve.rxnorm_ndc': 'sbiobertresolve_rxnorm_ndc',
                'en.resolve.icd10cm_generalised': 'sbiobertresolve_icd10cm_generalised',
                'en.resolve.hcpcs': 'sbiobertresolve_hcpcs',
                'en.med_ner.chexpert': 'ner_chexpert',

                # 3.2.3 Healthcare
                'en.classify.token_bert.ner_deid': 'bert_token_classifier_ner_deid',

                'en.detect_sentence.clinical': 'sentence_detector_dl_healthcare',
                'en.norm_drugs': 'drug_normalizer',  # TODO!?!??!
                # T5
                'en.t5.mediqa': 't5_base_mediqa_mnli',

                # AssertionDLModel
                'en.assert': 'assertion_dl',
                'en.assert.biobert': 'assertion_dl_biobert',
                'en.assert.healthcare': 'assertion_dl_healthcare',
                'en.assert.large': 'assertion_dl_large',

                # 2.7.6
                'en.assert.radiology': 'assertion_dl_radiology',

                # WordEmbedding Model Glove Embeddings
                'en.embed.glove.clinical': 'embeddings_clinical',
                'en.embed.glove.biovec': 'embeddings_biovec',
                'en.embed.glove.healthcare': 'embeddings_healthcare',
                'en.embed.glove.healthcare_100d': 'embeddings_healthcare_100d',
                # 'en.embed.glove.icd10': 'embeddings_icd10_base', # Broken in JSL
                'en.embed.glove.icdoem': 'embeddings_icdoem',
                'en.embed.glove.icdoem_2ng': 'embeddings_icdoem_2ng',

                # 3.1.1
                'en.embed_sentence.biobert.jsl_cased': 'sbiobert_jsl_cased',
                'en.embed_sentence.biobert.jsl_umls_cased': 'sbiobert_jsl_umls_cased',
                'en.embed_sentence.bert.jsl_medium_uncased': 'sbert_jsl_medium_uncased',
                'en.embed_sentence.bert.jsl_medium_umls_uncased': 'sbert_jsl_medium_umls_uncased',
                'en.embed_sentence.bert.jsl_mini_uncased': 'sbert_jsl_mini_uncased',
                'en.embed_sentence.bert.jsl_mini_umlsuncased': 'sbert_jsl_mini_umls_uncased',
                'en.embed_sentence.bert.jsl_tiny_uncased': 'sbert_jsl_tiny_uncased',
                'en.embed_sentence.bert.jsl_tiny_umls_uncased': 'sbert_jsl_tiny_umls_uncased',

                # BIOBERT embeddings

                # Todo errors with biobert embeds
                # 'en.embed.biobert.clinical': 'biobert_clinical_base_cased', # broken
                # 'en.embed.biobert.discharge': 'biobert_discharge_base_cased',# broken
                # 'en.embed.biobert.pmc': 'biobert_pmc_base_cased', Broken
                # 'en.embed.biobert.pubmed': 'biobert_pubmed_base_cased', # broken
                # 'en.embed.biobert.pubmed_large': 'biobert_pubmed_large_cased', # broken
                # 'en.embed.biobert.pubmed_pmc': 'biobert_pubmed_pmc_base_cased', # broken

                # Sentence Entity resolvers

                # BertSEntenceEmbeddings MLI
                'en.embed_sentence.biobert.mli': 'sbiobert_base_cased_mli',
                'en.embed_sentence.bluebert.mli': 'sbluebert_base_uncased_mli',  # Broken

                # 'en.embed_sentence.bluebert.mednli': 'sent_bluebert_base_uncased_mednli', # broken  : java.util.NoSuchElementException: Param isSBert does not exist.
                # 'en.embed_sentence.biobert.mednli': 'sent_biobert_base_uncased_mednli',  # broken

                # resolve sentence cpt
                'en.resolve': 'sbiobertresolve_cpt',
                'en.resolve.cpt': 'sbiobertresolve_cpt',
                'en.resolve.cpt.augmented': 'sbiobertresolve_cpt_augmented',
                'en.resolve.cpt.procedures_augmented': 'sbiobertresolve_cpt_procedures_augmented',
                # resolve sentence hcc
                'en.resolve.hcc': 'sbiobertresolve_hcc_augmented',
                'en.resolve.hcc.augmented': 'sbiobertresolve_hcc_augmented',
                # resolve sentence icdf
                'en.resolve.icd10cm': 'sbiobertresolve_icd10cm',
                'en.resolve.icd10cm.augmented': 'sbiobertresolve_icd10cm_augmented',
                'en.resolve.icd10cm.augmented_billable': 'sbiobertresolve_icd10cm_augmented_billable_hcc',
                'en.resolve.icd10pcs': 'sbiobertresolve_icd10pcs',
                'en.resolve.icdo': 'sbiobertresolve_icdo',
                # rewsolve sentence rx
                'en.resolve.rxcui': 'sbiobertresolve_rxcui',
                'en.resolve.rxnorm': 'sbiobertresolve_rxnorm',
                # resolve sentence snomed s
                'en.resolve.snomed': 'sbiobertresolve_snomed_auxConcepts',  # alias
                'en.resolve.snomed.aux_concepts': 'sbiobertresolve_snomed_auxConcepts',
                'en.resolve.snomed.aux_concepts_int': 'sbiobertresolve_snomed_auxConcepts_int',
                'en.resolve.snomed.findings': 'sbiobertresolve_snomed_findings',
                'en.resolve.snomed.findings_int': 'sbiobertresolve_snomed_findings_int',
                'en.resolve.cpt.procedures_measurements': 'sbiobertresolve_cpt_procedures_measurements_augmented',
                'en.resolve.icdo.base': 'sbiobertresolve_icdo_base',
                'en.resolve.rxnorm.disposition': 'sbertresolve_rxnorm_disposition',
                'en.resolve.rxnorm.disposition.sbert': 'sbertresolve_rxnorm_disposition',

                # 3.1.1
                'en.resolve.snomed_body_structure_med': 'sbertresolve_snomed_bodyStructure_med',
                'en.resolve.snomed_body_structure': 'sbiobertresolve_snomed_bodyStructure',
                'en.resolve.icdo_augmented': 'sbiobertresolve_icdo_augmented',

                'en.resolve.icd10cm.slim_billable_hcc': 'sbiobertresolve_icd10cm_slim_billable_hcc',
                'en.resolve.icd10cm.slim_billable_hcc_med': 'sbertresolve_icd10cm_slim_billable_hcc_med',

                # Greedy Relation extracction
                # 'en.relation.posology': 'posology_re',  # TODo OCRASHES SOME STRINGS!

                # RelationExtractionModel

                # These biobert analogus models which are better or some are broken
                # 'en.relation':'re_clinical',
                # 'en.relation.bodypart.direction':'re_bodypart_directions',
                # 'en.relation.bodypart.problem':'re_bodypart_problem',
                # 'en.relation.bodypart.proceduretest':'re_bodypart_proceduretest',
                # 'en.relation.chemprot':'re_chemprot_clinical',
                # 'en.relation.clinical':'re_clinical',
                # 'en.relation.date_clinical':'re_date_clinical',
                # 'en.relation.drug_drug_interaction':'re_drug_drug_interaction_clinical',
                # 'en.relation.human_phenotype_gene':'re_human_phenotype_gene_clinical',
                # 'en.relation.temporal_events':'re_temporal_events_clinical',
                # 'en.relation.temporal_events.enriched':'re_temporal_events_enriched_clinical',
                # RelationExtractionDL

                'en.relation': 'redl_bodypart_direction_biobert',
                'en.relation.bodypart.direction': 'redl_bodypart_direction_biobert',
                'en.relation.bodypart.problem': 'redl_bodypart_problem_biobert',
                'en.relation.bodypart.procedure': 'redl_bodypart_procedure_test_biobert',
                'en.relation.chemprot': 'redl_chemprot_biobert',
                'en.relation.clinical': 'redl_clinical_biobert',
                'en.relation.date': 'redl_date_clinical_biobert',
                'en.relation.drug_drug_interaction': 'redl_drug_drug_interaction_biobert',
                'en.relation.humen_phenotype_gene': 'redl_human_phenotype_gene_biobert',
                'en.relation.temporal_events': 'redl_temporal_events_biobert',

                # 2.7.5
                'en.relation.test_result_date': 're_test_result_date',
                # 2.7.3
                # 'en.relation.chemport'   :'re_chemprot',

                # PartOfSpeechModels
                'en.pos.clinical': 'pos_clinical',  # DEFAULT POS HC|| RELATION EXTRACTION TRAIN ON THIS!

                # NERDLModels
                # 'en.med_ner.ade.biobert':'ner_ade_biobert', # Todo error param pooling layer does not exist
                'en.med_ner': 'jsl_ner_wip_clinical',
                'en.med_ner.ade.clinical': 'ner_ade_clinical',
                'en.med_ner.ade.clinical_bert': 'ner_ade_clinicalbert',
                'en.med_ner.ade.ade_healthcare': 'ner_ade_healthcare',
                'en.med_ner.anatomy': 'ner_anatomy',
                'en.med_ner.anatomy.biobert': 'ner_anatomy_biobert',
                'en.med_ner.anatomy.coarse': 'ner_anatomy_coarse',
                'en.med_ner.anatomy.coarse_biobert': 'ner_anatomy_coarse_biobert',
                'en.med_ner.aspect_sentiment': 'ner_aspect_based_sentiment',
                'en.med_ner.bacterial_species': 'ner_bacterial_species',
                'en.med_ner.bionlp': 'ner_bionlp',
                'en.med_ner.bionlp.biobert': 'ner_bionlp_biobert',
                'en.med_ner.cancer': 'ner_cancer_genetics',
                'en.med_ner.cellular': 'ner_cellular',
                'en.med_ner.cellular.biobert': 'ner_cellular_biobert',
                'en.med_ner.chemicals': 'ner_chemicals',
                'en.med_ner.genetic_variants': 'ner_genetic_variants',
                'en.med_ner.chemprot': 'ner_chemprot_biobert',
                'en.med_ner.chemprot.clinical': 'ner_chemprot_clinical',
                'en.med_ner.clinical': 'ner_clinical',
                'en.med_ner.clinical.biobert': 'ner_clinical_biobert',
                # 'en.med_ner.clinical.noncontrib': 'ner_clinical_noncontrib', # outtaded, NER model_anno_obj it is not MedNER
                'en.med_ner.diseases': 'ner_diseases',
                'en.med_ner.diseases.biobert': 'ner_diseases_biobert',
                'en.med_ner.diseases.large': 'ner_diseases_large',
                'en.med_ner.drugs': 'ner_drugs',
                'en.med_ner.drugsgreedy': 'ner_drugs_greedy',
                'en.med_ner.drugs.large': 'ner_drugs_large',
                'en.med_ner.events_biobert': 'ner_events_biobert',
                'en.med_ner.events_clinical': 'ner_events_clinical',
                'en.med_ner.events_healthcre': 'ner_events_healthcare',
                'en.med_ner.financial_contract': 'ner_financial_contract',
                'en.med_ner.healthcare': 'ner_healthcare',
                'en.med_ner.human_phenotype.gene_biobert': 'ner_human_phenotype_gene_biobert',
                'en.med_ner.human_phenotype.gene_clinical': 'ner_human_phenotype_gene_clinical',
                'en.med_ner.human_phenotype.go_biobert': 'ner_human_phenotype_go_biobert',
                'en.med_ner.human_phenotype.go_clinical': 'ner_human_phenotype_go_clinical',
                'en.med_ner.jsl': 'ner_jsl',
                'en.med_ner.jsl.biobert': 'ner_jsl_biobert',
                'en.med_ner.jsl.enriched': 'ner_jsl_enriched',
                'en.med_ner.jsl.enriched_biobert': 'ner_jsl_enriched_biobert',
                'en.med_ner.measurements': 'ner_measurements_clinical',
                'en.med_ner.medmentions': 'ner_medmentions_coarse',
                'en.med_ner.posology': 'ner_posology',
                'en.med_ner.posology.biobert': 'ner_posology_biobert',
                'en.med_ner.posology.greedy': 'ner_posology_greedy',
                'en.med_ner.posology.healthcare': 'ner_posology_healthcare',
                'en.med_ner.posology.large': 'ner_posology_large',
                'en.med_ner.posology.large_biobert': 'ner_posology_large_biobert',
                'en.med_ner.posology.small': 'ner_posology_small',
                'en.med_ner.radiology': 'ner_radiology',
                'en.med_ner.radiology.wip_clinical': 'ner_radiology_wip_clinical',
                'en.med_ner.risk_factors': 'ner_risk_factors',
                'en.med_ner.risk_factors.biobert': 'ner_risk_factors_biobert',
                'en.med_ner.posology.experimental': 'ner_posology_experimental',
                'en.med_ner.radiology.wip_greedy_biobert': 'jsl_rd_ner_wip_greedy_biobert',

                # 'en.med_ner.i2b2': 'nerdl_i2b2', #  broken
                'en.med_ner.tumour': 'nerdl_tumour_demo',
                'en.med_ner.jsl.wip.clinical': 'jsl_ner_wip_clinical',
                'en.med_ner.jsl.wip.clinical.greedy': 'jsl_ner_wip_greedy_clinical',
                'en.med_ner.jsl.wip.clinical.modifier': 'jsl_ner_wip_modifier_clinical',
                'en.med_ner.jsl.wip.clinical.rd': 'jsl_rd_ner_wip_greedy_clinical',
                'en.med_ner.deid.augmented': 'ner_deid_augmented',
                'en.med_ner.deid.biobert': 'ner_deid_biobert',
                'en.med_ner.deid.enriched': 'ner_deid_enriched',
                'en.med_ner.deid.enriched_biobert': 'ner_deid_enriched_biobert',
                'en.med_ner.deid.large': 'ner_deid_large',
                'en.med_ner.deid.sd': 'ner_deid_sd',
                'en.med_ner.deid.sd_large': 'ner_deid_sd_large',
                'en.med_ner.deid.synthetic': 'ner_deid_synthetic',
                'en.med_ner.deid': 'ner_deidentify_dl',
                # 2.7.5
                'en.med_ner.admission_events': 'ner_events_admission_clinical',

                # 3.1.1

                'en.med_ner.deid.generic_augmented': 'ner_deid_generic_augmented',
                'en.med_ner.deid.subentity_augmented': 'ner_deid_subentity_augmented',
                # 'med_ner.deid.generic_glove':'ner_deid_generic_glove',
                # 'med_ner.deid.subentity_glove':'ner_deid_subentity_glove',

                # 'en.med_ner.clinical.icdem': 'ner_clinical_icdem', # TODO UNRESOLVable storageref
                # 'en.med_ner.clinical.large': 'ner_clinical_large',# TODO URNESOLVED, PIPE?

                # NLU 3.1.2

                'en.med_ner.ade_biobert': 'ner_ade_biobert',
                'en.classify.ade.clinicalbert': 'classifierdl_ade_clinicalbert',
                # 'en.med_ner.large': 'ner_large_clinical', # Deprecated

                # DeIdentificationModel

                # 'en.de_identify':'deidentify_dl', # todo ????    lOAD AS ner moadel??? THIS ENEDS EMEBDDINGS??
                'en.de_identify': 'deidentify_rb',
                'en.de_identify.rules': 'deid_rules',
                'en.de_identify.clinical': 'deidentify_enriched_clinical',
                'en.de_identify.large': 'deidentify_large',
                'en.de_identify.rb': 'deidentify_rb',
                'en.de_identify.rb_no_regex': 'deidentify_rb_no_regex',

                # 'en.classify.icd10.clinical':'classifier_icd10cm_hcc_clinical',      #  WHCIH CLASS? # TODO NOT LAODING
                # 'en.classify.icd10.healthcare':'classifier_icd10cm_hcc_healthcare', # TODO NOT LOADING CORRECt
                'en.classify.ade.biobert': 'classifierdl_ade_biobert',
                'en.classify.ade.clinical': 'classifierdl_ade_clinicalbert',
                'en.classify.ade.conversational': 'classifierdl_ade_conversational_biobert',
                'en.classify.gender.biobert': 'classifierdl_gender_biobert',
                'en.classify.gender.sbert': 'classifierdl_gender_sbert',  # ok!
                'en.classify.pico': 'classifierdl_pico_biobert',
                # 'en.classify.icd10.use':'useclassifier_icd10cm_hcc', buggy

                # 3.0.3 healthcare
                'en.resolve.umls': 'sbiobertresolve_umls_major_concepts',
                'en.resolve.umls.findings': 'sbiobertresolve_umls_findings',
                'en.resolve.loinc': 'sbiobertresolve_loinc',
                'en.resolve.loinc.biobert': 'sbiobertresolve_loinc',
                'en.resolve.HPO': 'sbiobertresolve_HPO',
                'en.resolve.snomed_conditions': 'sbertresolve_snomed_conditions',

                # Healthcare 3.1.2 to 3.2.0
                'en.relation.ade': 'redl_ade_biobert',
                'en.relation.ade_clinical': 're_ade_clinical',
                'en.relation.ade_biobert': 're_ade_biobert',
                'en.assert.jsl': 'assertion_jsl',
                'en.assert.jsl_large': 'assertion_jsl_large',
                # 'en.resolve.snomed_findings_aux_concepts': 'sbiobertresolve_snomed_findings_aux_concepts', # bad storage  sbiobert_base_cased_mli, but the model_anno_obj does not have that ref
                'en.resolve.rxnorm_disposition': 'sbiobertresolve_rxnorm_disposition',
                'en.resolve.rxnorm_disposition.sbert': 'sbertresolve_rxnorm_disposition',

                'en.med_ner.jsl_slim': 'ner_jsl_slim',
                'en.med_ner.jsl_greedy_biobert': 'ner_jsl_greedy_biobert',
                'en.classify.token_bert.ner_clinical': 'bert_token_classifier_ner_clinical',
                'en.classify.token_bert.ner_jsl': 'bert_token_classifier_ner_jsl',

                # 3.3.1 healthcare
                'en.classify.token_bert.ner_chemical': 'bert_token_classifier_ner_chemicals',

                ## 3.3.3 HC
                'en.med_ner.deid_subentity_augmented_i2b2': 'ner_deid_subentity_augmented_i2b2',
                'en.med_ner.biomarker': 'ner_biomarker',
                'en.med_ner.nihss': 'ner_nihss',
                'en.extract_relation.nihss': 'redl_nihss_biobert',
                'en.resolve.mesh': 'sbiobertresolve_mesh',
                'en.resolve.ndc': 'sbiobertresolve_ndc',
                'en.resolve.loinc.augmented': 'sbiobertresolve_loinc_augmented',
                'en.resolve.clinical_snomed_procedures_measurements': 'sbiobertresolve_clinical_snomed_procedures_measurements',
                'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
                'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
                'es.resolve.snomed': 'robertaresolve_snomed',
                'en.med_ner.covid_trials': 'ner_covid_trials',
                'en.med_ner.chemd': 'ner_chemd_clinical',
                'en.classify.token_bert.bionlp': 'bert_token_classifier_ner_bionlp',
                'en.classify.token_bert.cellular': 'bert_token_classifier_ner_cellular',
                'en.classify.token_bert.chemicals': 'bert_token_classifier_ner_chemicals',
                'en.resolve.rxnen.med_ner.deid_subentityorm_augmented': 'sbiobertresolve_rxnorm_augmented',
                'en.resolve.umls_disease_syndrome': 'sbiobertresolve_umls_disease_syndrome',
                'en.resolve.umls_clinical_drugs': 'sbiobertresolve_umls_clinical_drugs',
                'en.classify.bert_sequence.question_statement_clinical': 'bert_sequence_classifier_question_statement_clinical',

            },

        'de':
            {

                'de.med_ner.deid_subentity': 'ner_deid_subentity',
                'de.med_ner.deid_generic': 'ner_deid_generic',
                'de.embed.w2v': 'w2v_cc_300d',
                'de.embed': 'w2v_cc_300d',
                'de.med_ner.legal': 'ner_legal',
                # 'de.med_ner' :'ner_healthcare', # BAD NER TRAINED ON STORAGE_REF embeddings_healthcare_100d which only exist in EN
                #  'de.med_ner.healthcare' :'ner_healthcare', # BAD NER TRAINED ON STORAGE_REF embeddings_healthcare_100d which only exist in EN
                'de.med_ner': 'ner_healthcare_slim',
                'de.med_ner.traffic': 'ner_traffic',
                'de.resolve.icd10gm': 'sbertresolve_icd10gm',
                'de.resolve.snomed': 'sbertresolve_snomed',

            },

        'es': {
            # 3.4.2
            'es.med_ner.deid.generic.roberta': 'ner_deid_generic_roberta_augmented',
            'es.med_ner.deid.subentity.roberta': 'ner_deid_subentity_roberta_augmented',

            # 3.4.1
            'es.embed.sciwiki_300d': 'embeddings_sciwiki_300d',
            'es.med_ner.deid.generic': 'ner_deid_generic',
            'es.med_ner.deid.subentity': 'ner_deid_subentity',

            'es.embed.scielo.150d': 'embeddings_scielo_150d',
            'es.embed.scielo.300d': 'embeddings_scielo_300d',
            'es.embed.scielo.50d': 'embeddings_scielo_50d',
            'es.embed.scielowiki.150d': 'embeddings_scielowiki_150d',
            'es.embed.scielowiki.300d': 'embeddings_scielowiki_300d',
            'es.embed.scielowiki.50d': 'embeddings_scielowiki_50d',
            'es.embed.sciwiki.150d': 'embeddings_sciwiki_150d',
            'es.embed.sciwiki.300d': 'embeddings_sciwiki_300d',
            'es.embed.sciwiki.50d': 'embeddings_sciwiki_50d',
            'es.med_ner': 'ner_diag_proc',
            'es.med_ner.neoplasm': 'ner_neoplasms',
            'es.med_ner.diag_proc': 'ner_diag_proc',

            'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
            'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
            'es.resolve.snomed': 'robertaresolve_snomed',
        }
    }

    ocr_model_references = {
        'img2text': OCR_NODE_IDS.IMAGE2TEXT,
        'png2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'jpg2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'pdf2text': OCR_NODE_IDS.PDF2TEXT,
        'doc2text': OCR_NODE_IDS.DOC2TEXT,

        'pdf2table': OCR_NODE_IDS.PDF2TEXT_TABLE,
        'doc2table': OCR_NODE_IDS.DOC2TEXT_TABLE,
        'ppt2table': OCR_NODE_IDS.PPT2TEXT_TABLE,

    }
    # map storage ref to nlu refner_jsl
    storage_ref_2_nlu_ref = {
        'it': {
            'glove_6B_300': 'xx.embed.glove.6B_300',

        },

        'nl': {
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',

        },

        'en': {
            'tfhub_use': 'en.embed_sentence.use',
            'glove_100d': 'en.embed.glove.100d',
            'xlm_roberta_base': 'xx.embed.xlm',
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',
            'bert_large_cased': "en.embed.bert.large_cased",
            'albert_base_uncased': 'en.embed_sentence.albert',
            'small_bert_L2_128': 'en.embed.bert.small_L2_128',
            'elmo': 'en.embed.elmo',
            'distilbert_base_cased': 'en.embed.distilbert.base',
            'electra_base_uncased': 'en.embed.electra.base_uncased',

            'roberta_large': 'en.embed.roberta.large',
            'roberta_base': 'en.embed.roberta.base',

            'small_bert_L4_256': 'en.embed.bert.small_L4_256',
            'small_bert_L4_512': 'en.embed.bert.small_L4_512',
            'small_bert_L8_512': 'en.embed.bert.small_L8_512',

            'albert_large_uncased': 'en.embed.albert.large_uncased',

            'electra_small_uncased': 'en.embed.electra.small_uncased',
            'xlnet_base_cased': 'en.embed.xlnet_base_cased',

            'longformer_large_4096': 'en.embed.longformer.large',
            'electra_large_uncased': 'en.embed.electra.large_uncased',
            'xlm_roberta_xtreme_base': 'xx.embed.xlm_roberta_xtreme_base',

        },
        'zh': {
            'bert_base_chinese': 'zh.embed',
            'glove_6B_300': 'xx.embed.glove.6B_300',
        },
        'th': {
            'tfhub_use_multi_lg': 'xx.use.multi',
            'labse': 'xx.embed_sentence.labse',

        },
        'ur': {
            'glove_300d': 'ur.embed',
            'labse': 'xx.embed_sentence.labse',
        },
        'fr':
            {
                'labse': 'xx.embed_sentence.labse',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'tr':
            {'bert_multi_cased': 'xx.embed.bert',
             'labse': 'xx.embed_sentence.labse',
             'glove_840B_300': 'xx.embed.glove.840B_300',
             'bert_base_turkish_uncased': 'tr.embed.bert.uncased',
             },
        'sv':
            {
                'glove_100d': 'xx.embed.glove.glove_6B_100',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'fa':
            {'glove_300d': 'fa.embed',
             },
        'he':
            {'glove_300d': 'he.embed',
             },
        'fi':
            {

                'glove_100d': 'xx.embed.glove.glove_6B_100',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',

            },
        'bn':
            {
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'bengali_cc_300d': 'bn.embed.glove',
            },
        'ar':
            {'glove_300d': 'ar.embed',
             },
        'de':
            {
                'sent_bert_multi_cased': 'xx.embed_sentence',
                'labse': 'xx.embed_sentence.labse',
                'clinical': 'de.embed_sentence.bert.base_cased',
                'glove_840B_300': 'xx.embed.glove.840B_300',
                'glove_6B_300': 'xx.embed.glove.6B_300',
                'w2v_cc_300d': 'de.embed.w2v',
                'sent_bert_base_cased': 'de.embed_sentence.bert.base_cased',

            },
        'ja':
            {
                'fasttext_300_ja': 'ja.embed.glove.cc_300d',
                'xlm_roberta_base': 'xx.embed.xlm',
                'glove_840B_300': 'xx.embed.glove.840B_300',

            },
        'no': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_6B_300': 'xx.embed.glove.6B_300',
            'glove_840B_300': 'xx.embed.glove.840B_300',
        },
        'pl': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',

        },
        'pt': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_840B_300': 'xx.embed.glove.840B_300',

        },
        'ru': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'glove_840B_300': 'xx.embed.glove.840B_300',
        },
        'es': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
            'es.ner': 'roberta_token_classifier_bne_capitel_ner',
            'glove_840B_300': 'xx.embed.glove.840B_300',
            'glove_6B_300': 'xx.embed.glove.6B_300',

        },

        'da': {
            'glove_100d': 'xx.embed.glove.glove_6B_100',
        },

    }  #

    bad_storage_refs = [

        'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5',
        'RelationExtractionModel_ce79d77d1bf1',
        'RelationExtractionModel_1fb1dfa024c7',
        'RelationExtractionModel_6a65c9992836',
        'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc',
        'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4',
        'RelationExtractionModel_3ab4750ad5b6',
        'RelationExtractionModel_6b61602c8303',
        'RelationExtractionModel_9c255241fec3',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',
        'RelationExtractionModel_14b00157fc1a',
        'RelationExtractionModel_53a12cc975cb',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',

    ]
    licensed_storage_ref_2_nlu_ref = {
        'en': {
            'clinical': 'en.embed.glove.clinical',
            'biobert_pubmed_base_cased': 'en.embed.biobert',
            'embeddings_healthcare100': 'en.embed.glove.healthcare_100d',
            'bert_base_cased': 'en.embed.bert.base_cased',
            'sent_bluebert_base_uncased_mednli': 'en.embed_sentence.bluebert.mli',

            'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5': 'en.embed_sentence.bert.jsl_medium_uncased',
            'RelationExtractionModel_ce79d77d1bf1': 'en.embed.glove.clinical',
            'RelationExtractionModel_1fb1dfa024c7': 'en.embed.glove.clinical',
            'RelationExtractionModel_6a65c9992836': 'en.embed.biobert',
            'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc': 'en.embed_sentence.biobert.mli',
            'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4': 'en.embed_sentence.bluebert.mli',
            'RelationExtractionModel_3ab4750ad5b6': 'en.embed.glove.clinical',
            'RelationExtractionModel_6b61602c8303': 'en.embed.glove.clinical',
            'RelationExtractionModel_9c255241fec3': 'en.embed.glove.clinical',
            'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'en.embed_sentence.biobert.clinical_base_cased',
            'RelationExtractionModel_14b00157fc1a': 'en.embed.glove.clinical',
            'RelationExtractionModel_53a12cc975cb': 'en.embed.glove.clinical',
            'biobert_clinical_base_cased': 'en.embed.biobert.clinical_base_cased',
            'sent_biobert_clinical_base_cased': 'en.embed_sentence.biobert.clinical_base_cased',

        },
        'es': {
            'embeddings_scielowiki300': 'es.embed.scielowiki.300d',
            'embeddings_wiki300': 'es.embed.sciwiki_300d',
            'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'es.embed.roberta_base_biomedical',
            'clinical': 'es.embed.roberta_base_biomedical',
            # 'clinical' : 'es.embed.roberta_base_biomedical',

        },
        'de': {
            'clinical': 'de.embed_sentence.bert.base_cased',

        },
        'fr': {
            'WordEmbeddings_b266d1e5126a': 'fr.embed.w2v_cc_300d',

        },
        'it': {
            'w2v_cc_300d_it': 'it.embed.word2vec'

        }
    }

    # Map NLU train references to JSL Anno IDs
    traianble_nlu_ref_to_jsl_anno_id = {
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.word_seg': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.word_segmenter': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

    }

    # Map every nlp_ref to an Annotator class. Language Agnostic and includes HC+OS
    # For models with no pretrained weight, i.e. most OCR annotators, it maps AnnoId to Class

    nlp_ref_to_anno_class = {
        # HC
        # NLP_HC_NODE_IDS.DE_IDENTIFICATION: 'DeIdentification',
        # # OCR
        OCR_NODE_IDS.IMAGE2TEXT: 'ImageToText',
        OCR_NODE_IDS.PDF2TEXT: 'PdfToText',
        OCR_NODE_IDS.DOC2TEXT: 'DocToText',
        OCR_NODE_IDS.BINARY2IMAGE: 'BinaryToImage',
        OCR_NODE_IDS.PDF2TEXT_TABLE: 'PdfToTextTable',
        OCR_NODE_IDS.PPT2TEXT_TABLE: 'PptToTextTable',
        OCR_NODE_IDS.DOC2TEXT_TABLE: 'DocToTextTable',
        'albert_base_sequence_classifier_ag_news': 'AlbertForSequenceClassification',
        'albert_base_sequence_classifier_imdb': 'AlbertForSequenceClassification',
        'albert_base_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_base_uncased': 'AlbertEmbeddings',
        'albert_indic': 'AlbertEmbeddings',
        'albert_large_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_large_uncased': 'AlbertEmbeddings',
        'albert_xlarge_token_classifier_conll03': 'AlbertForTokenClassification',
        'albert_xlarge_uncased': 'AlbertEmbeddings',
        'albert_xxlarge_uncased': 'AlbertEmbeddings',
        'aner_cc_300d': 'NerDLModel',
        'arabic_w2v_cc_300d': 'WordEmbeddingsModel',
        'assertion_dl': 'AssertionDLModel',
        'assertion_dl_biobert': 'AssertionDLModel',
        'assertion_dl_healthcare': 'AssertionDLModel',
        'assertion_dl_large': 'AssertionDLModel',
        'assertion_dl_radiology': 'AssertionDLModel',
        'assertion_jsl': 'AssertionDLModel',
        'assertion_jsl_large': 'AssertionDLModel',
        'bengali_cc_300d': 'WordEmbeddingsModel',
        'bengaliner_cc_300d': 'NerDLModel',
        'bert_base_cased': 'BertEmbeddings',
        'bert_base_chinese': 'BertEmbeddings',
        'bert_base_dutch_cased': 'BertEmbeddings',
        'bert_base_finnish_cased': 'BertSentenceEmbeddings',
        'bert_base_finnish_uncased': 'BertSentenceEmbeddings',
        'bert_base_german_cased': 'BertEmbeddings',
        'bert_base_german_uncased': 'BertEmbeddings',
        'bert_base_italian_cased': 'BertEmbeddings',
        'bert_base_italian_uncased': 'BertEmbeddings',
        'bert_base_multilingual_cased': 'BertEmbeddings',
        'bert_base_multilingual_uncased': 'BertEmbeddings',
        'bert_base_sequence_classifier_ag_news': 'BertForSequenceClassification',
        'bert_base_sequence_classifier_dbpedia_14': 'BertForSequenceClassification',
        'bert_base_sequence_classifier_imdb': 'BertForSequenceClassification',
        'bert_base_token_classifier_conll03': 'BertForTokenClassification',
        'bert_base_token_classifier_few_nerd': 'BertForTokenClassification',
        'bert_base_token_classifier_ontonote': 'BertForTokenClassification',
        'bert_base_turkish_cased': 'BertEmbeddings',
        'bert_base_turkish_uncased': 'BertEmbeddings',
        'bert_base_uncased': 'BertEmbeddings',
        'bert_base_uncased_legal': 'BertEmbeddings',
        'bert_embeddings_ARBERT': 'BertEmbeddings',
        'bert_embeddings_German_MedBERT': 'BertEmbeddings',
        'bert_embeddings_bangla_bert_base': 'BertEmbeddings',
        'bert_embeddings_bert_base': 'BertEmbeddings',
        'bert_embeddings_bert_base_5lang_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_hi_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_it_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_tr_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_ur_cased': 'BertEmbeddings',
        'bert_embeddings_bert_base_vi_cased': 'BertEmbeddings',
        'bert_finnish_cased': 'BertEmbeddings',
        'bert_finnish_uncased': 'BertEmbeddings',
        'bert_hi_en_ner': 'BertForTokenClassification',
        'bert_large_cased': 'BertEmbeddings',
        'bert_large_sequence_classifier_imdb': 'BertForSequenceClassification',
        'bert_large_token_classifier_conll03': 'BertForTokenClassification',
        'bert_large_token_classifier_ontonote': 'BertForTokenClassification',
        'bert_large_uncased': 'BertEmbeddings',
        'bert_multi_cased': 'BertEmbeddings',
        'bert_muril': 'BertEmbeddings',
        'bert_portuguese_base_cased': 'BertEmbeddings',
        'bert_portuguese_large_cased': 'BertEmbeddings',
        'bert_pubmed': 'BertEmbeddings',
        'bert_pubmed_squad2': 'BertEmbeddings',
        'bert_sequence_classifier_ade': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_dehatebert_mono': 'BertForSequenceClassification',
        'bert_sequence_classifier_emotion': 'BertForSequenceClassification',
        'bert_sequence_classifier_finbert': 'BertForSequenceClassification',
        'bert_sequence_classifier_finbert_tone': 'BertForSequenceClassification',
        'bert_sequence_classifier_gender_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_news_sentiment': 'BertForSequenceClassification',
        'bert_sequence_classifier_pico_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_question_statement_clinical': 'BertForSequenceClassification',
        'bert_sequence_classifier_rct_biobert': 'MedicalBertForSequenceClassification',
        'bert_sequence_classifier_sentiment': 'BertForSequenceClassification',
        'bert_sequence_classifier_toxicity': 'BertForSequenceClassification',
        'bert_token_classifier_chinese_ner': 'BertForTokenClassification',
        'bert_token_classifier_drug_development_trials': 'BertForTokenClassification',
        'bert_token_classifier_dutch_udlassy_ner': 'BertForTokenClassification',
        'bert_token_classifier_hi_en_ner': 'BertForTokenClassification',
        'bert_token_classifier_ner_ade': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_anatomy': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_bacteria': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_bionlp': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_btc': 'BertForTokenClassification',
        'bert_token_classifier_ner_cellular': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_chemicals': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_chemprot': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_clinical': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_deid': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_drugs': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_jsl': 'BertForTokenClassification',
        'bert_token_classifier_ner_jsl_slim': 'MedicalBertForTokenClassifier',
        'bert_token_classifier_ner_ud_gsd': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_armanner': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_ner': 'BertForTokenClassification',
        'bert_token_classifier_parsbert_peymaner': 'BertForTokenClassification',
        'bert_token_classifier_scandi_ner': 'BertForTokenClassification',
        'bert_token_classifier_spanish_ner': 'BertForTokenClassification',
        'bert_token_classifier_swedish_ner': 'BertForTokenClassification',
        'bert_token_classifier_turkish_ner': 'BertForTokenClassification',
        'bert_wiki_books': 'BertEmbeddings',
        'bert_wiki_books_mnli': 'BertEmbeddings',
        'bert_wiki_books_qnli': 'BertEmbeddings',
        'bert_wiki_books_qqp': 'BertEmbeddings',
        'bert_wiki_books_squad2': 'BertEmbeddings',
        'bert_wiki_books_sst2': 'BertEmbeddings',
        'biobert_clinical_base_cased': 'BertEmbeddings',
        'biobert_discharge_base_cased': 'BertEmbeddings',
        'biobert_pmc_base_cased': 'BertEmbeddings',
        'biobert_pubmed_base_cased': 'BertEmbeddings',
        'biobert_pubmed_large_cased': 'BertEmbeddings',
        'biobert_pubmed_pmc_base_cased': 'BertEmbeddings',
        'chinese_bert_wwm': 'BertEmbeddings',
        'chinese_xlnet_base': 'XlnetEmbeddings',
        'chunk_embeddings': 'ChunkEmbeddings',
        'classifierdl_ade_biobert': 'ClassifierDLModel',
        'classifierdl_ade_clinicalbert': 'ClassifierDLModel',
        'classifierdl_ade_conversational_biobert': 'ClassifierDLModel',
        'classifierdl_bert_news': 'ClassifierDLModel',
        'classifierdl_bert_sentiment': 'ClassifierDLModel',
        'classifierdl_berturk_cyberbullying': 'ClassifierDLModel',
        'classifierdl_gender_biobert': 'ClassifierDLModel',
        'classifierdl_gender_sbert': 'ClassifierDLModel',
        'classifierdl_pico_biobert': 'ClassifierDLModel',
        'classifierdl_urduvec_fakenews': 'ClassifierDLModel',
        'classifierdl_use_atis': 'ClassifierDLModel',
        'classifierdl_use_cyberbullying': 'ClassifierDLModel',
        'classifierdl_use_emotion': 'ClassifierDLModel',
        'classifierdl_use_fakenews': 'ClassifierDLModel',
        'classifierdl_use_sarcasm': 'ClassifierDLModel',
        'classifierdl_use_snips': 'ClassifierDLModel',
        'classifierdl_use_spam': 'ClassifierDLModel',
        'classifierdl_use_trec50': 'ClassifierDLModel',
        'classifierdl_use_trec6': 'ClassifierDLModel',
        'clinical_longformer': 'LongformerEmbeddings',
        'context_parser': 'ContextualParserModel',
        'covidbert_large_uncased': 'BertEmbeddings',
        'dane_ner_6B_100': 'NerDLModel',
        'dane_ner_6B_300': 'NerDLModel',
        'dane_ner_840B_300': 'NerDLModel',
        'date_matcher': 'DateMatcher',
        'deberta_v3_base': 'DeBertaEmbeddings',
        'deberta_v3_base_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_large': 'DeBertaEmbeddings',
        'deberta_v3_large_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_small': 'DeBertaEmbeddings',
        'deberta_v3_small_sequence_classifier_ag_news': 'DeBertaForSequenceClassification',
        'deberta_v3_small_sequence_classifier_dbpedia_14': 'DeBertaForSequenceClassification',
        'deberta_v3_small_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'deberta_v3_xsmall': 'DeBertaEmbeddings',
        'deberta_v3_xsmall_sequence_classifier_ag_news': 'DeBertaForSequenceClassification',
        'deberta_v3_xsmall_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'defaen.resolve.loinc.bluebertult_chunker': 'Chunker',
        'default_chunker': 'Chunker',
        'deid_rules': 'DeIdentificationModel',
        'deidentify_enriched_clinical': 'DeIdentificationModel',
        'deidentify_large': 'DeIdentificationModel',
        'deidentify_rb': 'DeIdentificationModel',
        'deidentify_rb_no_regex': 'DeIdentificationModel',
        'dependency_conllu': 'DependencyParserModel',
        'dependency_conllu.untyped': 'DependencyParserModel',
        'dependency_typed_conllu': 'TypedDependencyParserModel',
        'distilbert_base_cased': 'DistilBertEmbeddings',
        'distilbert_base_multilingual_cased': 'DistilBertEmbeddings',
        'distilbert_base_sequence_classifier_ag_news': 'DistilBertForSequenceClassification',
        'distilbert_base_sequence_classifier_amazon_polarity': 'DistilBertForSequenceClassification',
        'distilbert_base_sequence_classifier_imdb': 'DistilBertForSequenceClassification',
        'distilbert_base_token_classifier_masakhaner': 'DistilBertForTokenClassification',
        'distilbert_base_uncased': 'DistilBertEmbeddings',
        'distilbert_multilingual_sequence_classifier_allocine': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_ade': 'MedicalDistilBertForSequenceClassification',
        'distilbert_sequence_classifier_banking77': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_emotion': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_industry': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_policy': 'DistilBertForSequenceClassification',
        'distilbert_sequence_classifier_sst2': 'DistilBertForSequenceClassification',
        'distilbert_token_classifier_typo_detector': 'DistilBertForTokenClassification',
        'distilbert_uncased': 'DistilBertEmbeddings',
        'distilroberta_base': 'RoBertaEmbeddings',
        'distilroberta_base_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'doc2vec_gigaword_300': 'Doc2VecModel',
        'doc2vec_gigaword_wiki_300': 'Doc2VecModel',
        'drug_normalizer': 'NormalizerModel',
        'electra_base_uncased': 'BertEmbeddings',
        'electra_large_uncased': 'BertEmbeddings',
        'electra_medal_acronym': 'BertEmbeddings',
        'electra_small_uncased': 'BertEmbeddings',
        'elmo': 'ElmoEmbeddings',
        'embeddings_biovec': 'WordEmbeddingsModel',
        'embeddings_clinical': 'WordEmbeddingsModel',
        'embeddings_healthcare': 'WordEmbeddingsModel',
        'embeddings_healthcare_100d': 'WordEmbeddingsModel',
        'embeddings_icdoem': 'WordEmbeddingsModel',
        'embeddings_icdoem_2ng': 'WordEmbeddingsModel',
        'embeddings_scielo_150d': 'WordEmbeddingsModel',
        'embeddings_scielo_300d': 'WordEmbeddingsModel',
        'embeddings_scielo_50d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_150d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_300d': 'WordEmbeddingsModel',
        'embeddings_scielowiki_50d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_150d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_300d': 'WordEmbeddingsModel',
        'embeddings_sciwiki_50d': 'WordEmbeddingsModel',
        'finnish_ner_6B_100': 'NerDLModel',
        'finnish_ner_6B_300': 'NerDLModel',
        'finnish_ner_840B_300': 'NerDLModel',
        'glove_100d': 'WordEmbeddingsModel',
        'glove_6B_100': 'WordEmbeddingsModel',
        'glove_6B_300': 'WordEmbeddingsModel',
        'glove_840B_300': 'WordEmbeddingsModel',
        'google_t5_small_ssm_nq': 'T5Transformer',
        'gpt2': 'GPT2Transformer',
        'gpt2_distilled': 'GPT2Transformer',
        'gpt2_medium': 'GPT2Transformer',
        'gpt_large': 'GPT2Transformer',
        'hebrew_cc_300d': 'WordEmbeddingsModel',
        'hebrewner_cc_300d': 'NerDLModel',
        'hindi_cc_300d': 'WordEmbeddingsModel',
        'japanese_cc_300d': 'WordEmbeddingsModel',
        'jsl_ner_wip_clinical': 'MedicalNerModel',
        'jsl_ner_wip_greedy_clinical': 'MedicalNerModel',
        'jsl_ner_wip_modifier_clinical': 'MedicalNerModel',
        'jsl_rd_ner_wip_greedy_biobert': 'MedicalNerModel',
        'jsl_rd_ner_wip_greedy_clinical': 'MedicalNerModel',
        'labse': 'BertSentenceEmbeddings',
        'ld_tatoeba_bigru_21': 'LanguageDetectorDL',
        'ld_tatoeba_cnn_99': 'LanguageDetectorDL',
        'ld_wiki_20': 'LanguageDetectorDL',
        'ld_wiki_7': 'LanguageDetectorDL',
        'ld_wiki_cnn_231': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_21': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_220': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_375': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_43': 'LanguageDetectorDL',
        'ld_wiki_tatoeba_cnn_95': 'LanguageDetectorDL',
        'lemma': 'LemmatizerModel',
        'lemma_afribooms': 'LemmatizerModel',
        'lemma_alksnis': 'LemmatizerModel',
        'lemma_alpino': 'LemmatizerModel',
        'lemma_ancora': 'LemmatizerModel',
        'lemma_antbnc': 'LemmatizerModel',
        'lemma_arcosg': 'LemmatizerModel',
        'lemma_atis': 'LemmatizerModel',
        'lemma_boun': 'LemmatizerModel',
        'lemma_btb': 'LemmatizerModel',
        'lemma_cac': 'LemmatizerModel',
        'lemma_ccg': 'LemmatizerModel',
        'lemma_csui': 'LemmatizerModel',
        'lemma_ctg': 'LemmatizerModel',
        'lemma_ddt': 'LemmatizerModel',
        'lemma_dxc': 'LemmatizerModel',
        'lemma_esl': 'LemmatizerModel',
        'lemma_farpahc': 'LemmatizerModel',
        'lemma_gdt': 'LemmatizerModel',
        'lemma_gsd': 'LemmatizerModel',
        'lemma_gsdluw': 'LemmatizerModel',
        'lemma_gsdsimp': 'LemmatizerModel',
        'lemma_gum': 'LemmatizerModel',
        'lemma_hdt': 'LemmatizerModel',
        'lemma_hdtb': 'LemmatizerModel',
        'lemma_htb': 'LemmatizerModel',
        'lemma_idt': 'LemmatizerModel',
        'lemma_isdt': 'LemmatizerModel',
        'lemma_ittb': 'LemmatizerModel',
        'lemma_iu': 'LemmatizerModel',
        'lemma_kyoto': 'LemmatizerModel',
        'lemma_lassysmall': 'LemmatizerModel',
        'lemma_lvtb': 'LemmatizerModel',
        'lemma_modern': 'LemmatizerModel',
        'lemma_nonstandard': 'LemmatizerModel',
        'lemma_nsc': 'LemmatizerModel',
        'lemma_nynorsklia': 'LemmatizerModel',
        'lemma_parisstories': 'LemmatizerModel',
        'lemma_partut': 'LemmatizerModel',
        'lemma_pdb': 'LemmatizerModel',
        'lemma_pdt': 'LemmatizerModel',
        'lemma_perdt': 'LemmatizerModel',
        'lemma_perseus': 'LemmatizerModel',
        'lemma_proiel': 'LemmatizerModel',
        'lemma_rhapsodie': 'LemmatizerModel',
        'lemma_rnc': 'LemmatizerModel',
        'lemma_rrt': 'LemmatizerModel',
        'lemma_sagt': 'LemmatizerModel',
        'lemma_scriptorium': 'LemmatizerModel',
        'lemma_sequoia': 'LemmatizerModel',
        'lemma_seraji': 'LemmatizerModel',
        'lemma_set': 'LemmatizerModel',
        'lemma_simonero': 'LemmatizerModel',
        'lemma_srcmf': 'LemmatizerModel',
        'lemma_ssj': 'LemmatizerModel',
        'lemma_syntagrus': 'LemmatizerModel',
        'lemma_szeged': 'LemmatizerModel',
        'lemma_taiga': 'LemmatizerModel',
        'lemma_talbanken': 'LemmatizerModel',
        'lemma_tourism': 'LemmatizerModel',
        'lemma_ttb': 'LemmatizerModel',
        'lemma_udante': 'LemmatizerModel',
        'lemma_udt': 'LemmatizerModel',
        'lemma_vit': 'LemmatizerModel',
        'lemma_vtb': 'LemmatizerModel',
        'lemma_wtb': 'LemmatizerModel',
        'longformer_base_4096': 'LongformerEmbeddings',
        'longformer_base_sequence_classifier_ag_news': 'LongformerForSequenceClassification',
        'longformer_base_sequence_classifier_imdb': 'LongformerForSequenceClassification',
        'longformer_base_token_classifier_conll03': 'LongformerForTokenClassification',
        'longformer_large_4096': 'LongformerEmbeddings',
        'mdeberta_v3_base': 'DeBertaEmbeddings',
        'mdeberta_v3_base_sequence_classifier_allocine': 'DeBertaForSequenceClassification',
        'mdeberta_v3_base_sequence_classifier_imdb': 'DeBertaForSequenceClassification',
        'multiclassifierdl_use_e2e': 'MultiClassifierDLModel',
        'multiclassifierdl_use_toxic': 'MultiClassifierDLModel',
        'multiclassifierdl_use_toxic_sm': 'MultiClassifierDLModel',
        'ner_abbreviation_clinical': 'MedicalNerModel',
        'ner_ade_biobert': 'MedicalNerModel',
        'ner_ade_clinical': 'MedicalNerModel',
        'ner_ade_clinicalbert': 'MedicalNerModel',
        'ner_ade_healthcare': 'MedicalNerModel',
        'ner_anatomy': 'MedicalNerModel',
        'ner_anatomy_biobert': 'MedicalNerModel',
        'ner_anatomy_coarse': 'MedicalNerModel',
        'ner_anatomy_coarse_biobert': 'MedicalNerModel',
        'ner_aspect_based_sentiment': 'MedicalNerModel',
        'ner_bacterial_species': 'MedicalNerModel',
        'ner_biomarker': 'MedicalNerModel',
        'ner_bionlp': 'MedicalNerModel',
        'ner_bionlp_biobert': 'MedicalNerModel',
        'ner_cancer_genetics': 'MedicalNerModel',
        'ner_cellular': 'MedicalNerModel',
        'ner_cellular_biobert': 'MedicalNerModel',
        'ner_chemd_clinical': 'MedicalNerModel',
        'ner_chemicals': 'MedicalNerModel',
        'ner_chemprot_biobert': 'MedicalNerModel',
        'ner_chemprot_clinical': 'MedicalNerModel',
        'ner_chexpert': 'MedicalNerModel',
        'ner_clinical': 'MedicalNerModel',
        'ner_clinical_biobert': 'MedicalNerModel',
        'ner_conll_albert_base_uncased': 'NerDLModel',
        'ner_conll_albert_large_uncased': 'NerDLModel',
        'ner_conll_bert_base_cased': 'NerDLModel',
        'ner_conll_distilbert_base_cased': 'NerDLModel',
        'ner_conll_longformer_large_4096': 'NerDLModel',
        'ner_conll_roberta_base': 'NerDLModel',
        'ner_conll_roberta_large': 'NerDLModel',
        'ner_conll_xlm_roberta_base': 'NerDLModel',
        'ner_conll_xlnet_base_cased': 'NerDLModel',
        'ner_covid_trials': 'MedicalNerModel',
        'ner_deid_augmented': 'MedicalNerModel',
        'ner_deid_biobert': 'MedicalNerModel',
        'ner_deid_enriched': 'MedicalNerModel',
        'ner_deid_enriched_biobert': 'MedicalNerModel',
        'ner_deid_generic': 'MedicalNerModel',
        'ner_deid_generic_augmented': 'MedicalNerModel',
        'ner_deid_generic_roberta_augmented': 'MedicalNerModel',
        'ner_deid_large': 'MedicalNerModel',
        'ner_deid_sd': 'MedicalNerModel',
        'ner_deid_sd_large': 'MedicalNerModel',
        'ner_deid_subentity': 'MedicalNerModel',
        'ner_deid_subentity_augmented': 'MedicalNerModel',
        'ner_deid_subentity_augmented_i2b2': 'MedicalNerModel',
        'ner_deid_subentity_roberta_augmented': 'MedicalNerModel',
        'ner_deid_synthetic': 'MedicalNerModel',
        'ner_deidentify_dl': 'MedicalNerModel',
        'ner_diag_proc': 'MedicalNerModel',
        'ner_diseases': 'MedicalNerModel',
        'ner_diseases_biobert': 'MedicalNerModel',
        'ner_diseases_large': 'MedicalNerModel',
        'ner_dl': 'NerDLModel',
        'ner_dl_bert': 'NerDLModel',
        'ner_dl_bert_base_cased': 'NerDLModel',
        'ner_dl_sentence': 'NerDLModel',
        'ner_drugprot_clinical': 'MedicalNerModel',
        'ner_drugs': 'MedicalNerModel',
        'ner_drugs_greedy': 'MedicalNerModel',
        'ner_drugs_large': 'MedicalNerModel',
        'ner_events_admission_clinical': 'MedicalNerModel',
        'ner_events_biobert': 'MedicalNerModel',
        'ner_events_clinical': 'MedicalNerModel',
        'ner_events_healthcare': 'MedicalNerModel',
        'ner_financial_contract': 'MedicalNerModel',
        'ner_genetic_variants': 'MedicalNerModel',
        'ner_healthcare': 'MedicalNerModel',
        'ner_healthcare_slim': 'MedicalNerModel',
        'ner_human_phenotype_gene_biobert': 'MedicalNerModel',
        'ner_human_phenotype_gene_clinical': 'MedicalNerModel',
        'ner_human_phenotype_go_biobert': 'MedicalNerModel',
        'ner_human_phenotype_go_clinical': 'MedicalNerModel',
        'ner_jifs_glove_840B_300d': 'NerDLModel',
        'ner_jsl': 'MedicalNerModel',
        'ner_jsl_biobert': 'MedicalNerModel',
        'ner_jsl_enriched': 'MedicalNerModel',
        'ner_jsl_enriched_biobert': 'MedicalNerModel',
        'ner_jsl_greedy_biobert': 'MedicalNerModel',
        'ner_jsl_slim': 'MedicalNerModel',
        'ner_kmou_glove_840B_300d': 'NerDLModel',
        'ner_legal': 'MedicalNerModel',
        'ner_lst20_glove_840B_300d': 'NerDLModel',
        'ner_measurements_clinical': 'MedicalNerModel',
        'ner_medmentions_coarse': 'MedicalNerModel',
        'ner_mit_movie_complex_bert_base_cased': 'NerDLModel',
        'ner_mit_movie_complex_distilbert_base_cased': 'NerDLModel',
        'ner_mit_movie_simple_distilbert_base_cased': 'NerDLModel',
        'ner_msra_bert_768d': 'NerDLModel',
        'ner_neoplasms': 'NerDLModel',
        'ner_nihss': 'MedicalNerModel',
        'ner_ontonotes_distilbert_base_cased': 'NerDLModel',
        'ner_ontonotes_roberta_base': 'NerDLModel',
        'ner_ontonotes_roberta_large': 'NerDLModel',
        'ner_posology': 'MedicalNerModel',
        'ner_posology_biobert': 'MedicalNerModel',
        'ner_posology_experimental': 'MedicalNerModel',
        'ner_posology_greedy': 'MedicalNerModel',
        'ner_posology_healthcare': 'MedicalNerModel',
        'ner_posology_large': 'MedicalNerModel',
        'ner_posology_large_biobert': 'MedicalNerModel',
        'ner_posology_small': 'MedicalNerModel',
        'ner_radiology': 'MedicalNerModel',
        'ner_radiology_wip_clinical': 'MedicalNerModel',
        'ner_risk_factors': 'MedicalNerModel',
        'ner_risk_factors_biobert': 'MedicalNerModel',
        'ner_supplement_clinical': 'MedicalNerModel',
        'ner_traffic': 'MedicalNerModel',
        'ner_ud_gsd_cc_300d': 'NerDLModel',
        'ner_ud_gsd_glove_840B_300d': 'NerDLModel',
        'ner_ud_gsd_xlm_roberta_base': 'NerDLModel',
        'ner_weibo_bert_768d': 'NerDLModel',
        'ner_wikiner_glove_840B_300': 'NerDLModel',
        'ner_wikiner_xlm_roberta_base': 'NerDLModel',
        'ner_xtreme_glove_840B_300': 'NerDLModel',
        'ner_xtreme_xlm_roberta_xtreme_base': 'NerDLModel',
        'nerdl_atis_840b_300d': 'NerDLModel',
        'nerdl_fewnerd_100d': 'NerDLModel',
        'nerdl_fewnerd_subentity_100d': 'NerDLModel',
        'nerdl_restaurant_100d': 'NerDLModel',
        'nerdl_snips_100d': 'NerDLModel',
        'nerdl_tumour_demo': 'MedicalNerModel',
        'ngram': 'NGramGenerator',
        'norm': 'NormalizerModel',
        'normalizer': 'NormalizerModel',
        'norne_6B_100': 'NerDLModel',
        'norne_6B_300': 'NerDLModel',
        'norne_840B_300': 'NerDLModel',
        'onto_100': 'NerDLModel',
        'onto_300': 'NerDLModel',
        'onto_bert_base_cased': 'NerDLModel',
        'onto_bert_large_cased': 'NerDLModel',
        'onto_electra_base_uncased': 'NerDLModel',
        'onto_electra_large_uncased': 'NerDLModel',
        'onto_electra_small_uncased': 'NerDLModel',
        'onto_small_bert_L2_128': 'NerDLModel',
        'onto_small_bert_L4_256': 'NerDLModel',
        'onto_small_bert_L4_512': 'NerDLModel',
        'onto_small_bert_L8_512': 'NerDLModel',
        'opus_mt_aav_en': 'MarianTransformer',
        'opus_mt_aed_es': 'MarianTransformer',
        'opus_mt_af_de': 'MarianTransformer',
        'opus_mt_af_en': 'MarianTransformer',
        'opus_mt_af_eo': 'MarianTransformer',
        'opus_mt_af_es': 'MarianTransformer',
        'opus_mt_af_fi': 'MarianTransformer',
        'opus_mt_af_fr': 'MarianTransformer',
        'opus_mt_af_nl': 'MarianTransformer',
        'opus_mt_af_ru': 'MarianTransformer',
        'opus_mt_af_sv': 'MarianTransformer',
        'opus_mt_afa_afa': 'MarianTransformer',
        'opus_mt_afa_en': 'MarianTransformer',
        'opus_mt_alv_en': 'MarianTransformer',
        'opus_mt_am_sv': 'MarianTransformer',
        'opus_mt_ar_de': 'MarianTransformer',
        'opus_mt_ar_el': 'MarianTransformer',
        'opus_mt_ar_en': 'MarianTransformer',
        'opus_mt_ar_eo': 'MarianTransformer',
        'opus_mt_ar_es': 'MarianTransformer',
        'opus_mt_ar_fr': 'MarianTransformer',
        'opus_mt_ar_he': 'MarianTransformer',
        'opus_mt_ar_it': 'MarianTransformer',
        'opus_mt_ar_pl': 'MarianTransformer',
        'opus_mt_ar_ru': 'MarianTransformer',
        'opus_mt_ar_tr': 'MarianTransformer',
        'opus_mt_art_en': 'MarianTransformer',
        'opus_mt_ase_de': 'MarianTransformer',
        'opus_mt_ase_en': 'MarianTransformer',
        'opus_mt_ase_es': 'MarianTransformer',
        'opus_mt_ase_fr': 'MarianTransformer',
        'opus_mt_ase_sv': 'MarianTransformer',
        'opus_mt_az_en': 'MarianTransformer',
        'opus_mt_az_es': 'MarianTransformer',
        'opus_mt_az_tr': 'MarianTransformer',
        'opus_mt_bat_en': 'MarianTransformer',
        'opus_mt_bcl_de': 'MarianTransformer',
        'opus_mt_bcl_en': 'MarianTransformer',
        'opus_mt_bcl_es': 'MarianTransformer',
        'opus_mt_bcl_fi': 'MarianTransformer',
        'opus_mt_bcl_fr': 'MarianTransformer',
        'opus_mt_bcl_sv': 'MarianTransformer',
        'opus_mt_be_es': 'MarianTransformer',
        'opus_mt_bem_en': 'MarianTransformer',
        'opus_mt_bem_es': 'MarianTransformer',
        'opus_mt_bem_fi': 'MarianTransformer',
        'opus_mt_bem_fr': 'MarianTransformer',
        'opus_mt_bem_sv': 'MarianTransformer',
        'opus_mt_ber_en': 'MarianTransformer',
        'opus_mt_ber_es': 'MarianTransformer',
        'opus_mt_ber_fr': 'MarianTransformer',
        'opus_mt_bg_de': 'MarianTransformer',
        'opus_mt_bg_en': 'MarianTransformer',
        'opus_mt_bg_eo': 'MarianTransformer',
        'opus_mt_bg_es': 'MarianTransformer',
        'opus_mt_bg_fi': 'MarianTransformer',
        'opus_mt_bg_fr': 'MarianTransformer',
        'opus_mt_bg_it': 'MarianTransformer',
        'opus_mt_bg_ru': 'MarianTransformer',
        'opus_mt_bg_sv': 'MarianTransformer',
        'opus_mt_bg_tr': 'MarianTransformer',
        'opus_mt_bg_uk': 'MarianTransformer',
        'opus_mt_bi_en': 'MarianTransformer',
        'opus_mt_bi_es': 'MarianTransformer',
        'opus_mt_bi_fr': 'MarianTransformer',
        'opus_mt_bi_sv': 'MarianTransformer',
        'opus_mt_bn_en': 'MarianTransformer',
        'opus_mt_bnt_en': 'MarianTransformer',
        'opus_mt_bzs_en': 'MarianTransformer',
        'opus_mt_bzs_es': 'MarianTransformer',
        'opus_mt_bzs_fi': 'MarianTransformer',
        'opus_mt_bzs_fr': 'MarianTransformer',
        'opus_mt_bzs_sv': 'MarianTransformer',
        'opus_mt_ca_de': 'MarianTransformer',
        'opus_mt_ca_en': 'MarianTransformer',
        'opus_mt_ca_es': 'MarianTransformer',
        'opus_mt_ca_fr': 'MarianTransformer',
        'opus_mt_ca_it': 'MarianTransformer',
        'opus_mt_ca_nl': 'MarianTransformer',
        'opus_mt_ca_pt': 'MarianTransformer',
        'opus_mt_ca_uk': 'MarianTransformer',
        'opus_mt_cau_en': 'MarianTransformer',
        'opus_mt_ccs_en': 'MarianTransformer',
        'opus_mt_ceb_en': 'MarianTransformer',
        'opus_mt_ceb_es': 'MarianTransformer',
        'opus_mt_ceb_fi': 'MarianTransformer',
        'opus_mt_ceb_fr': 'MarianTransformer',
        'opus_mt_ceb_sv': 'MarianTransformer',
        'opus_mt_cel_en': 'MarianTransformer',
        'opus_mt_chk_en': 'MarianTransformer',
        'opus_mt_chk_es': 'MarianTransformer',
        'opus_mt_chk_fr': 'MarianTransformer',
        'opus_mt_chk_sv': 'MarianTransformer',
        'opus_mt_cpf_en': 'MarianTransformer',
        'opus_mt_cpp_cpp': 'MarianTransformer',
        'opus_mt_cpp_en': 'MarianTransformer',
        'opus_mt_crs_de': 'MarianTransformer',
        'opus_mt_crs_en': 'MarianTransformer',
        'opus_mt_crs_es': 'MarianTransformer',
        'opus_mt_crs_fi': 'MarianTransformer',
        'opus_mt_crs_fr': 'MarianTransformer',
        'opus_mt_crs_sv': 'MarianTransformer',
        'opus_mt_cs_de': 'MarianTransformer',
        'opus_mt_cs_en': 'MarianTransformer',
        'opus_mt_cs_eo': 'MarianTransformer',
        'opus_mt_cs_fi': 'MarianTransformer',
        'opus_mt_cs_fr': 'MarianTransformer',
        'opus_mt_cs_sv': 'MarianTransformer',
        'opus_mt_cs_uk': 'MarianTransformer',
        'opus_mt_csg_es': 'MarianTransformer',
        'opus_mt_csn_es': 'MarianTransformer',
        'opus_mt_cus_en': 'MarianTransformer',
        'opus_mt_cy_en': 'MarianTransformer',
        'opus_mt_da_de': 'MarianTransformer',
        'opus_mt_da_en': 'MarianTransformer',
        'opus_mt_da_eo': 'MarianTransformer',
        'opus_mt_da_es': 'MarianTransformer',
        'opus_mt_da_fi': 'MarianTransformer',
        'opus_mt_da_fr': 'MarianTransformer',
        'opus_mt_da_no': 'MarianTransformer',
        'opus_mt_da_ru': 'MarianTransformer',
        'opus_mt_de_af': 'MarianTransformer',
        'opus_mt_de_ar': 'MarianTransformer',
        'opus_mt_de_ase': 'MarianTransformer',
        'opus_mt_de_bcl': 'MarianTransformer',
        'opus_mt_de_bg': 'MarianTransformer',
        'opus_mt_de_bi': 'MarianTransformer',
        'opus_mt_de_bzs': 'MarianTransformer',
        'opus_mt_de_ca': 'MarianTransformer',
        'opus_mt_de_crs': 'MarianTransformer',
        'opus_mt_de_cs': 'MarianTransformer',
        'opus_mt_de_da': 'MarianTransformer',
        'opus_mt_de_de': 'MarianTransformer',
        'opus_mt_de_ee': 'MarianTransformer',
        'opus_mt_de_efi': 'MarianTransformer',
        'opus_mt_de_el': 'MarianTransformer',
        'opus_mt_de_en': 'MarianTransformer',
        'opus_mt_de_eo': 'MarianTransformer',
        'opus_mt_de_es': 'MarianTransformer',
        'opus_mt_de_et': 'MarianTransformer',
        'opus_mt_de_eu': 'MarianTransformer',
        'opus_mt_de_fi': 'MarianTransformer',
        'opus_mt_de_fj': 'MarianTransformer',
        'opus_mt_de_fr': 'MarianTransformer',
        'opus_mt_de_gaa': 'MarianTransformer',
        'opus_mt_de_gil': 'MarianTransformer',
        'opus_mt_de_guw': 'MarianTransformer',
        'opus_mt_de_ha': 'MarianTransformer',
        'opus_mt_de_he': 'MarianTransformer',
        'opus_mt_de_hil': 'MarianTransformer',
        'opus_mt_de_ho': 'MarianTransformer',
        'opus_mt_de_hr': 'MarianTransformer',
        'opus_mt_de_ht': 'MarianTransformer',
        'opus_mt_de_hu': 'MarianTransformer',
        'opus_mt_de_ig': 'MarianTransformer',
        'opus_mt_de_ilo': 'MarianTransformer',
        'opus_mt_de_is': 'MarianTransformer',
        'opus_mt_de_iso': 'MarianTransformer',
        'opus_mt_de_it': 'MarianTransformer',
        'opus_mt_de_kg': 'MarianTransformer',
        'opus_mt_de_ln': 'MarianTransformer',
        'opus_mt_de_loz': 'MarianTransformer',
        'opus_mt_de_lt': 'MarianTransformer',
        'opus_mt_de_lua': 'MarianTransformer',
        'opus_mt_de_ms': 'MarianTransformer',
        'opus_mt_de_mt': 'MarianTransformer',
        'opus_mt_de_niu': 'MarianTransformer',
        'opus_mt_de_nl': 'MarianTransformer',
        'opus_mt_de_no': 'MarianTransformer',
        'opus_mt_de_nso': 'MarianTransformer',
        'opus_mt_de_ny': 'MarianTransformer',
        'opus_mt_de_pag': 'MarianTransformer',
        'opus_mt_de_pap': 'MarianTransformer',
        'opus_mt_de_pis': 'MarianTransformer',
        'opus_mt_de_pl': 'MarianTransformer',
        'opus_mt_de_pon': 'MarianTransformer',
        'opus_mt_de_tl': 'MarianTransformer',
        'opus_mt_de_uk': 'MarianTransformer',
        'opus_mt_de_vi': 'MarianTransformer',
        'opus_mt_dra_en': 'MarianTransformer',
        'opus_mt_ee_de': 'MarianTransformer',
        'opus_mt_ee_en': 'MarianTransformer',
        'opus_mt_ee_es': 'MarianTransformer',
        'opus_mt_ee_fi': 'MarianTransformer',
        'opus_mt_ee_fr': 'MarianTransformer',
        'opus_mt_ee_sv': 'MarianTransformer',
        'opus_mt_efi_de': 'MarianTransformer',
        'opus_mt_efi_en': 'MarianTransformer',
        'opus_mt_efi_fi': 'MarianTransformer',
        'opus_mt_efi_fr': 'MarianTransformer',
        'opus_mt_efi_sv': 'MarianTransformer',
        'opus_mt_el_ar': 'MarianTransformer',
        'opus_mt_el_eo': 'MarianTransformer',
        'opus_mt_el_fi': 'MarianTransformer',
        'opus_mt_el_fr': 'MarianTransformer',
        'opus_mt_el_sv': 'MarianTransformer',
        'opus_mt_en_aav': 'MarianTransformer',
        'opus_mt_en_af': 'MarianTransformer',
        'opus_mt_en_afa': 'MarianTransformer',
        'opus_mt_en_alv': 'MarianTransformer',
        'opus_mt_en_ar': 'MarianTransformer',
        'opus_mt_en_az': 'MarianTransformer',
        'opus_mt_en_bat': 'MarianTransformer',
        'opus_mt_en_bcl': 'MarianTransformer',
        'opus_mt_en_bem': 'MarianTransformer',
        'opus_mt_en_ber': 'MarianTransformer',
        'opus_mt_en_bg': 'MarianTransformer',
        'opus_mt_en_bi': 'MarianTransformer',
        'opus_mt_en_bnt': 'MarianTransformer',
        'opus_mt_en_bzs': 'MarianTransformer',
        'opus_mt_en_ca': 'MarianTransformer',
        'opus_mt_en_ceb': 'MarianTransformer',
        'opus_mt_en_cel': 'MarianTransformer',
        'opus_mt_en_chk': 'MarianTransformer',
        'opus_mt_en_cpf': 'MarianTransformer',
        'opus_mt_en_cpp': 'MarianTransformer',
        'opus_mt_en_crs': 'MarianTransformer',
        'opus_mt_en_cs': 'MarianTransformer',
        'opus_mt_en_cus': 'MarianTransformer',
        'opus_mt_en_cy': 'MarianTransformer',
        'opus_mt_en_da': 'MarianTransformer',
        'opus_mt_en_de': 'MarianTransformer',
        'opus_mt_en_dra': 'MarianTransformer',
        'opus_mt_en_ee': 'MarianTransformer',
        'opus_mt_en_efi': 'MarianTransformer',
        'opus_mt_en_el': 'MarianTransformer',
        'opus_mt_en_eo': 'MarianTransformer',
        'opus_mt_en_es': 'MarianTransformer',
        'opus_mt_en_et': 'MarianTransformer',
        'opus_mt_en_eu': 'MarianTransformer',
        'opus_mt_en_euq': 'MarianTransformer',
        'opus_mt_en_fi': 'MarianTransformer',
        'opus_mt_en_fiu': 'MarianTransformer',
        'opus_mt_en_fj': 'MarianTransformer',
        'opus_mt_en_fr': 'MarianTransformer',
        'opus_mt_en_ga': 'MarianTransformer',
        'opus_mt_en_gaa': 'MarianTransformer',
        'opus_mt_en_gem': 'MarianTransformer',
        'opus_mt_en_gil': 'MarianTransformer',
        'opus_mt_en_gl': 'MarianTransformer',
        'opus_mt_en_gmq': 'MarianTransformer',
        'opus_mt_en_gmw': 'MarianTransformer',
        'opus_mt_en_grk': 'MarianTransformer',
        'opus_mt_en_guw': 'MarianTransformer',
        'opus_mt_en_gv': 'MarianTransformer',
        'opus_mt_en_ha': 'MarianTransformer',
        'opus_mt_en_he': 'MarianTransformer',
        'opus_mt_en_hi': 'MarianTransformer',
        'opus_mt_en_hil': 'MarianTransformer',
        'opus_mt_en_ho': 'MarianTransformer',
        'opus_mt_en_ht': 'MarianTransformer',
        'opus_mt_en_hu': 'MarianTransformer',
        'opus_mt_en_hy': 'MarianTransformer',
        'opus_mt_en_id': 'MarianTransformer',
        'opus_mt_en_ig': 'MarianTransformer',
        'opus_mt_en_iir': 'MarianTransformer',
        'opus_mt_en_ilo': 'MarianTransformer',
        'opus_mt_en_inc': 'MarianTransformer',
        'opus_mt_en_ine': 'MarianTransformer',
        'opus_mt_en_is': 'MarianTransformer',
        'opus_mt_en_iso': 'MarianTransformer',
        'opus_mt_en_it': 'MarianTransformer',
        'opus_mt_en_itc': 'MarianTransformer',
        'opus_mt_en_jap': 'MarianTransformer',
        'opus_mt_en_kg': 'MarianTransformer',
        'opus_mt_en_kj': 'MarianTransformer',
        'opus_mt_en_kqn': 'MarianTransformer',
        'opus_mt_en_kwn': 'MarianTransformer',
        'opus_mt_en_kwy': 'MarianTransformer',
        'opus_mt_en_lg': 'MarianTransformer',
        'opus_mt_en_ln': 'MarianTransformer',
        'opus_mt_en_loz': 'MarianTransformer',
        'opus_mt_en_lu': 'MarianTransformer',
        'opus_mt_en_lua': 'MarianTransformer',
        'opus_mt_en_lue': 'MarianTransformer',
        'opus_mt_en_lun': 'MarianTransformer',
        'opus_mt_en_luo': 'MarianTransformer',
        'opus_mt_en_lus': 'MarianTransformer',
        'opus_mt_en_map': 'MarianTransformer',
        'opus_mt_en_mfe': 'MarianTransformer',
        'opus_mt_en_mg': 'MarianTransformer',
        'opus_mt_en_mh': 'MarianTransformer',
        'opus_mt_en_mk': 'MarianTransformer',
        'opus_mt_en_mkh': 'MarianTransformer',
        'opus_mt_en_ml': 'MarianTransformer',
        'opus_mt_en_mos': 'MarianTransformer',
        'opus_mt_en_mr': 'MarianTransformer',
        'opus_mt_en_mt': 'MarianTransformer',
        'opus_mt_en_mul': 'MarianTransformer',
        'opus_mt_en_ng': 'MarianTransformer',
        'opus_mt_en_nic': 'MarianTransformer',
        'opus_mt_en_niu': 'MarianTransformer',
        'opus_mt_en_nl': 'MarianTransformer',
        'opus_mt_en_nso': 'MarianTransformer',
        'opus_mt_en_ny': 'MarianTransformer',
        'opus_mt_en_nyk': 'MarianTransformer',
        'opus_mt_en_om': 'MarianTransformer',
        'opus_mt_en_pag': 'MarianTransformer',
        'opus_mt_en_pap': 'MarianTransformer',
        'opus_mt_en_phi': 'MarianTransformer',
        'opus_mt_en_pis': 'MarianTransformer',
        'opus_mt_en_pon': 'MarianTransformer',
        'opus_mt_en_poz': 'MarianTransformer',
        'opus_mt_en_pqe': 'MarianTransformer',
        'opus_mt_en_pqw': 'MarianTransformer',
        'opus_mt_en_rn': 'MarianTransformer',
        'opus_mt_en_rnd': 'MarianTransformer',
        'opus_mt_en_ro': 'MarianTransformer',
        'opus_mt_en_roa': 'MarianTransformer',
        'opus_mt_en_ru': 'MarianTransformer',
        'opus_mt_en_run': 'MarianTransformer',
        'opus_mt_en_rw': 'MarianTransformer',
        'opus_mt_en_sal': 'MarianTransformer',
        'opus_mt_en_sem': 'MarianTransformer',
        'opus_mt_en_sg': 'MarianTransformer',
        'opus_mt_en_sit': 'MarianTransformer',
        'opus_mt_en_sk': 'MarianTransformer',
        'opus_mt_en_sla': 'MarianTransformer',
        'opus_mt_en_sm': 'MarianTransformer',
        'opus_mt_en_sn': 'MarianTransformer',
        'opus_mt_en_sq': 'MarianTransformer',
        'opus_mt_en_ss': 'MarianTransformer',
        'opus_mt_en_st': 'MarianTransformer',
        'opus_mt_en_sv': 'MarianTransformer',
        'opus_mt_en_sw': 'MarianTransformer',
        'opus_mt_en_swc': 'MarianTransformer',
        'opus_mt_en_tdt': 'MarianTransformer',
        'opus_mt_en_ti': 'MarianTransformer',
        'opus_mt_en_tiv': 'MarianTransformer',
        'opus_mt_en_tl': 'MarianTransformer',
        'opus_mt_en_tll': 'MarianTransformer',
        'opus_mt_en_tn': 'MarianTransformer',
        'opus_mt_en_to': 'MarianTransformer',
        'opus_mt_en_toi': 'MarianTransformer',
        'opus_mt_en_tpi': 'MarianTransformer',
        'opus_mt_en_trk': 'MarianTransformer',
        'opus_mt_en_ts': 'MarianTransformer',
        'opus_mt_en_tut': 'MarianTransformer',
        'opus_mt_en_tvl': 'MarianTransformer',
        'opus_mt_en_tw': 'MarianTransformer',
        'opus_mt_en_ty': 'MarianTransformer',
        'opus_mt_en_uk': 'MarianTransformer',
        'opus_mt_en_umb': 'MarianTransformer',
        'opus_mt_en_ur': 'MarianTransformer',
        'opus_mt_en_urj': 'MarianTransformer',
        'opus_mt_en_vi': 'MarianTransformer',
        'opus_mt_en_xh': 'MarianTransformer',
        'opus_mt_en_zh': 'MarianTransformer',
        'opus_mt_en_zle': 'MarianTransformer',
        'opus_mt_en_zls': 'MarianTransformer',
        'opus_mt_en_zlw': 'MarianTransformer',
        'opus_mt_eo_af': 'MarianTransformer',
        'opus_mt_eo_bg': 'MarianTransformer',
        'opus_mt_eo_cs': 'MarianTransformer',
        'opus_mt_eo_da': 'MarianTransformer',
        'opus_mt_eo_de': 'MarianTransformer',
        'opus_mt_eo_el': 'MarianTransformer',
        'opus_mt_eo_en': 'MarianTransformer',
        'opus_mt_eo_es': 'MarianTransformer',
        'opus_mt_eo_fi': 'MarianTransformer',
        'opus_mt_eo_fr': 'MarianTransformer',
        'opus_mt_eo_he': 'MarianTransformer',
        'opus_mt_eo_hu': 'MarianTransformer',
        'opus_mt_eo_it': 'MarianTransformer',
        'opus_mt_eo_nl': 'MarianTransformer',
        'opus_mt_eo_pl': 'MarianTransformer',
        'opus_mt_eo_pt': 'MarianTransformer',
        'opus_mt_eo_ro': 'MarianTransformer',
        'opus_mt_eo_ru': 'MarianTransformer',
        'opus_mt_eo_sh': 'MarianTransformer',
        'opus_mt_eo_sv': 'MarianTransformer',
        'opus_mt_es_aed': 'MarianTransformer',
        'opus_mt_es_af': 'MarianTransformer',
        'opus_mt_es_ar': 'MarianTransformer',
        'opus_mt_es_ase': 'MarianTransformer',
        'opus_mt_es_bcl': 'MarianTransformer',
        'opus_mt_es_ber': 'MarianTransformer',
        'opus_mt_es_bg': 'MarianTransformer',
        'opus_mt_es_bi': 'MarianTransformer',
        'opus_mt_es_bzs': 'MarianTransformer',
        'opus_mt_es_ca': 'MarianTransformer',
        'opus_mt_es_ceb': 'MarianTransformer',
        'opus_mt_es_crs': 'MarianTransformer',
        'opus_mt_es_cs': 'MarianTransformer',
        'opus_mt_es_csg': 'MarianTransformer',
        'opus_mt_es_csn': 'MarianTransformer',
        'opus_mt_es_da': 'MarianTransformer',
        'opus_mt_es_de': 'MarianTransformer',
        'opus_mt_es_ee': 'MarianTransformer',
        'opus_mt_es_efi': 'MarianTransformer',
        'opus_mt_es_el': 'MarianTransformer',
        'opus_mt_es_en': 'MarianTransformer',
        'opus_mt_es_eo': 'MarianTransformer',
        'opus_mt_es_es': 'MarianTransformer',
        'opus_mt_es_et': 'MarianTransformer',
        'opus_mt_es_eu': 'MarianTransformer',
        'opus_mt_es_fi': 'MarianTransformer',
        'opus_mt_es_fj': 'MarianTransformer',
        'opus_mt_es_fr': 'MarianTransformer',
        'opus_mt_es_gaa': 'MarianTransformer',
        'opus_mt_es_gil': 'MarianTransformer',
        'opus_mt_es_gl': 'MarianTransformer',
        'opus_mt_es_guw': 'MarianTransformer',
        'opus_mt_es_ha': 'MarianTransformer',
        'opus_mt_es_he': 'MarianTransformer',
        'opus_mt_es_hil': 'MarianTransformer',
        'opus_mt_es_ho': 'MarianTransformer',
        'opus_mt_es_hr': 'MarianTransformer',
        'opus_mt_es_ht': 'MarianTransformer',
        'opus_mt_es_id': 'MarianTransformer',
        'opus_mt_es_ig': 'MarianTransformer',
        'opus_mt_es_ilo': 'MarianTransformer',
        'opus_mt_es_is': 'MarianTransformer',
        'opus_mt_es_iso': 'MarianTransformer',
        'opus_mt_es_it': 'MarianTransformer',
        'opus_mt_es_kg': 'MarianTransformer',
        'opus_mt_es_ln': 'MarianTransformer',
        'opus_mt_es_loz': 'MarianTransformer',
        'opus_mt_es_lt': 'MarianTransformer',
        'opus_mt_es_lua': 'MarianTransformer',
        'opus_mt_es_lus': 'MarianTransformer',
        'opus_mt_es_mfs': 'MarianTransformer',
        'opus_mt_es_mk': 'MarianTransformer',
        'opus_mt_es_mt': 'MarianTransformer',
        'opus_mt_es_niu': 'MarianTransformer',
        'opus_mt_es_nl': 'MarianTransformer',
        'opus_mt_es_no': 'MarianTransformer',
        'opus_mt_es_nso': 'MarianTransformer',
        'opus_mt_es_ny': 'MarianTransformer',
        'opus_mt_es_pag': 'MarianTransformer',
        'opus_mt_es_pap': 'MarianTransformer',
        'opus_mt_es_pis': 'MarianTransformer',
        'opus_mt_es_pl': 'MarianTransformer',
        'opus_mt_es_pon': 'MarianTransformer',
        'opus_mt_es_prl': 'MarianTransformer',
        'opus_mt_es_rn': 'MarianTransformer',
        'opus_mt_es_ro': 'MarianTransformer',
        'opus_mt_es_ru': 'MarianTransformer',
        'opus_mt_es_rw': 'MarianTransformer',
        'opus_mt_es_sg': 'MarianTransformer',
        'opus_mt_es_sl': 'MarianTransformer',
        'opus_mt_es_sm': 'MarianTransformer',
        'opus_mt_es_sn': 'MarianTransformer',
        'opus_mt_es_srn': 'MarianTransformer',
        'opus_mt_es_st': 'MarianTransformer',
        'opus_mt_es_swc': 'MarianTransformer',
        'opus_mt_es_tl': 'MarianTransformer',
        'opus_mt_es_tll': 'MarianTransformer',
        'opus_mt_es_tn': 'MarianTransformer',
        'opus_mt_es_to': 'MarianTransformer',
        'opus_mt_es_tpi': 'MarianTransformer',
        'opus_mt_es_tvl': 'MarianTransformer',
        'opus_mt_es_tw': 'MarianTransformer',
        'opus_mt_es_ty': 'MarianTransformer',
        'opus_mt_es_tzo': 'MarianTransformer',
        'opus_mt_es_uk': 'MarianTransformer',
        'opus_mt_es_ve': 'MarianTransformer',
        'opus_mt_es_vi': 'MarianTransformer',
        'opus_mt_es_war': 'MarianTransformer',
        'opus_mt_es_wls': 'MarianTransformer',
        'opus_mt_es_xh': 'MarianTransformer',
        'opus_mt_es_yo': 'MarianTransformer',
        'opus_mt_es_yua': 'MarianTransformer',
        'opus_mt_es_zai': 'MarianTransformer',
        'opus_mt_et_de': 'MarianTransformer',
        'opus_mt_et_en': 'MarianTransformer',
        'opus_mt_et_es': 'MarianTransformer',
        'opus_mt_et_fi': 'MarianTransformer',
        'opus_mt_et_fr': 'MarianTransformer',
        'opus_mt_et_ru': 'MarianTransformer',
        'opus_mt_et_sv': 'MarianTransformer',
        'opus_mt_eu_de': 'MarianTransformer',
        'opus_mt_eu_en': 'MarianTransformer',
        'opus_mt_eu_es': 'MarianTransformer',
        'opus_mt_eu_ru': 'MarianTransformer',
        'opus_mt_euq_en': 'MarianTransformer',
        'opus_mt_fi_af': 'MarianTransformer',
        'opus_mt_fi_bcl': 'MarianTransformer',
        'opus_mt_fi_bem': 'MarianTransformer',
        'opus_mt_fi_bg': 'MarianTransformer',
        'opus_mt_fi_bzs': 'MarianTransformer',
        'opus_mt_fi_ceb': 'MarianTransformer',
        'opus_mt_fi_crs': 'MarianTransformer',
        'opus_mt_fi_cs': 'MarianTransformer',
        'opus_mt_fi_de': 'MarianTransformer',
        'opus_mt_fi_ee': 'MarianTransformer',
        'opus_mt_fi_efi': 'MarianTransformer',
        'opus_mt_fi_el': 'MarianTransformer',
        'opus_mt_fi_en': 'MarianTransformer',
        'opus_mt_fi_eo': 'MarianTransformer',
        'opus_mt_fi_es': 'MarianTransformer',
        'opus_mt_fi_et': 'MarianTransformer',
        'opus_mt_fi_fi': 'MarianTransformer',
        'opus_mt_fi_fj': 'MarianTransformer',
        'opus_mt_fi_fr': 'MarianTransformer',
        'opus_mt_fi_fse': 'MarianTransformer',
        'opus_mt_fi_gaa': 'MarianTransformer',
        'opus_mt_fi_gil': 'MarianTransformer',
        'opus_mt_fi_guw': 'MarianTransformer',
        'opus_mt_fi_ha': 'MarianTransformer',
        'opus_mt_fi_he': 'MarianTransformer',
        'opus_mt_fi_hil': 'MarianTransformer',
        'opus_mt_fi_ho': 'MarianTransformer',
        'opus_mt_fi_hr': 'MarianTransformer',
        'opus_mt_fi_ht': 'MarianTransformer',
        'opus_mt_fi_hu': 'MarianTransformer',
        'opus_mt_fi_id': 'MarianTransformer',
        'opus_mt_fi_ig': 'MarianTransformer',
        'opus_mt_fi_ilo': 'MarianTransformer',
        'opus_mt_fi_is': 'MarianTransformer',
        'opus_mt_fi_iso': 'MarianTransformer',
        'opus_mt_fi_it': 'MarianTransformer',
        'opus_mt_fi_kg': 'MarianTransformer',
        'opus_mt_fi_kqn': 'MarianTransformer',
        'opus_mt_fi_lg': 'MarianTransformer',
        'opus_mt_fi_ln': 'MarianTransformer',
        'opus_mt_fi_lu': 'MarianTransformer',
        'opus_mt_fi_lua': 'MarianTransformer',
        'opus_mt_fi_lue': 'MarianTransformer',
        'opus_mt_fi_lus': 'MarianTransformer',
        'opus_mt_fi_lv': 'MarianTransformer',
        'opus_mt_fi_mfe': 'MarianTransformer',
        'opus_mt_fi_mg': 'MarianTransformer',
        'opus_mt_fi_mh': 'MarianTransformer',
        'opus_mt_fi_mk': 'MarianTransformer',
        'opus_mt_fi_mos': 'MarianTransformer',
        'opus_mt_fi_mt': 'MarianTransformer',
        'opus_mt_fi_niu': 'MarianTransformer',
        'opus_mt_fi_nl': 'MarianTransformer',
        'opus_mt_fi_no': 'MarianTransformer',
        'opus_mt_fi_nso': 'MarianTransformer',
        'opus_mt_fi_ny': 'MarianTransformer',
        'opus_mt_fi_pag': 'MarianTransformer',
        'opus_mt_fi_pap': 'MarianTransformer',
        'opus_mt_fi_pis': 'MarianTransformer',
        'opus_mt_fi_pon': 'MarianTransformer',
        'opus_mt_fi_ro': 'MarianTransformer',
        'opus_mt_fi_ru': 'MarianTransformer',
        'opus_mt_fi_run': 'MarianTransformer',
        'opus_mt_fi_rw': 'MarianTransformer',
        'opus_mt_fi_sg': 'MarianTransformer',
        'opus_mt_fi_sk': 'MarianTransformer',
        'opus_mt_fi_sl': 'MarianTransformer',
        'opus_mt_fi_sm': 'MarianTransformer',
        'opus_mt_fi_sn': 'MarianTransformer',
        'opus_mt_fi_sq': 'MarianTransformer',
        'opus_mt_fi_srn': 'MarianTransformer',
        'opus_mt_fi_st': 'MarianTransformer',
        'opus_mt_fi_sv': 'MarianTransformer',
        'opus_mt_fi_sw': 'MarianTransformer',
        'opus_mt_fi_swc': 'MarianTransformer',
        'opus_mt_fi_tiv': 'MarianTransformer',
        'opus_mt_fi_tll': 'MarianTransformer',
        'opus_mt_fi_tn': 'MarianTransformer',
        'opus_mt_fi_to': 'MarianTransformer',
        'opus_mt_fi_toi': 'MarianTransformer',
        'opus_mt_fi_tpi': 'MarianTransformer',
        'opus_mt_fi_tr': 'MarianTransformer',
        'opus_mt_fi_ts': 'MarianTransformer',
        'opus_mt_fi_tvl': 'MarianTransformer',
        'opus_mt_fi_tw': 'MarianTransformer',
        'opus_mt_fi_ty': 'MarianTransformer',
        'opus_mt_fi_uk': 'MarianTransformer',
        'opus_mt_fi_ve': 'MarianTransformer',
        'opus_mt_fi_war': 'MarianTransformer',
        'opus_mt_fi_wls': 'MarianTransformer',
        'opus_mt_fi_xh': 'MarianTransformer',
        'opus_mt_fi_yap': 'MarianTransformer',
        'opus_mt_fi_yo': 'MarianTransformer',
        'opus_mt_fi_zne': 'MarianTransformer',
        'opus_mt_fiu_en': 'MarianTransformer',
        'opus_mt_fiu_fiu': 'MarianTransformer',
        'opus_mt_fj_en': 'MarianTransformer',
        'opus_mt_fj_fr': 'MarianTransformer',
        'opus_mt_fr_af': 'MarianTransformer',
        'opus_mt_fr_ar': 'MarianTransformer',
        'opus_mt_fr_ase': 'MarianTransformer',
        'opus_mt_fr_bcl': 'MarianTransformer',
        'opus_mt_fr_bem': 'MarianTransformer',
        'opus_mt_fr_ber': 'MarianTransformer',
        'opus_mt_fr_bg': 'MarianTransformer',
        'opus_mt_fr_bi': 'MarianTransformer',
        'opus_mt_fr_bzs': 'MarianTransformer',
        'opus_mt_fr_ca': 'MarianTransformer',
        'opus_mt_fr_ceb': 'MarianTransformer',
        'opus_mt_fr_crs': 'MarianTransformer',
        'opus_mt_fr_de': 'MarianTransformer',
        'opus_mt_fr_ee': 'MarianTransformer',
        'opus_mt_fr_efi': 'MarianTransformer',
        'opus_mt_fr_el': 'MarianTransformer',
        'opus_mt_fr_en': 'MarianTransformer',
        'opus_mt_fr_eo': 'MarianTransformer',
        'opus_mt_fr_es': 'MarianTransformer',
        'opus_mt_fr_fj': 'MarianTransformer',
        'opus_mt_fr_gaa': 'MarianTransformer',
        'opus_mt_fr_gil': 'MarianTransformer',
        'opus_mt_fr_guw': 'MarianTransformer',
        'opus_mt_fr_ha': 'MarianTransformer',
        'opus_mt_fr_he': 'MarianTransformer',
        'opus_mt_fr_hil': 'MarianTransformer',
        'opus_mt_fr_ho': 'MarianTransformer',
        'opus_mt_fr_hr': 'MarianTransformer',
        'opus_mt_fr_ht': 'MarianTransformer',
        'opus_mt_fr_hu': 'MarianTransformer',
        'opus_mt_fr_id': 'MarianTransformer',
        'opus_mt_fr_ig': 'MarianTransformer',
        'opus_mt_fr_ilo': 'MarianTransformer',
        'opus_mt_fr_iso': 'MarianTransformer',
        'opus_mt_fr_kg': 'MarianTransformer',
        'opus_mt_fr_kqn': 'MarianTransformer',
        'opus_mt_fr_kwy': 'MarianTransformer',
        'opus_mt_fr_lg': 'MarianTransformer',
        'opus_mt_fr_ln': 'MarianTransformer',
        'opus_mt_fr_loz': 'MarianTransformer',
        'opus_mt_fr_lu': 'MarianTransformer',
        'opus_mt_fr_lua': 'MarianTransformer',
        'opus_mt_fr_lue': 'MarianTransformer',
        'opus_mt_fr_lus': 'MarianTransformer',
        'opus_mt_fr_mfe': 'MarianTransformer',
        'opus_mt_fr_mh': 'MarianTransformer',
        'opus_mt_fr_mos': 'MarianTransformer',
        'opus_mt_fr_ms': 'MarianTransformer',
        'opus_mt_fr_mt': 'MarianTransformer',
        'opus_mt_fr_niu': 'MarianTransformer',
        'opus_mt_fr_no': 'MarianTransformer',
        'opus_mt_fr_nso': 'MarianTransformer',
        'opus_mt_fr_ny': 'MarianTransformer',
        'opus_mt_fr_pag': 'MarianTransformer',
        'opus_mt_fr_pap': 'MarianTransformer',
        'opus_mt_fr_pis': 'MarianTransformer',
        'opus_mt_fr_pl': 'MarianTransformer',
        'opus_mt_fr_pon': 'MarianTransformer',
        'opus_mt_fr_rnd': 'MarianTransformer',
        'opus_mt_fr_ro': 'MarianTransformer',
        'opus_mt_fr_ru': 'MarianTransformer',
        'opus_mt_fr_run': 'MarianTransformer',
        'opus_mt_fr_rw': 'MarianTransformer',
        'opus_mt_fr_sg': 'MarianTransformer',
        'opus_mt_fr_sk': 'MarianTransformer',
        'opus_mt_fr_sl': 'MarianTransformer',
        'opus_mt_fr_sm': 'MarianTransformer',
        'opus_mt_fr_sn': 'MarianTransformer',
        'opus_mt_fr_srn': 'MarianTransformer',
        'opus_mt_fr_st': 'MarianTransformer',
        'opus_mt_fr_sv': 'MarianTransformer',
        'opus_mt_fr_swc': 'MarianTransformer',
        'opus_mt_fr_tiv': 'MarianTransformer',
        'opus_mt_fr_tl': 'MarianTransformer',
        'opus_mt_fr_tll': 'MarianTransformer',
        'opus_mt_fr_tn': 'MarianTransformer',
        'opus_mt_fr_to': 'MarianTransformer',
        'opus_mt_fr_tpi': 'MarianTransformer',
        'opus_mt_fr_ts': 'MarianTransformer',
        'opus_mt_fr_tum': 'MarianTransformer',
        'opus_mt_fr_tvl': 'MarianTransformer',
        'opus_mt_fr_tw': 'MarianTransformer',
        'opus_mt_fr_ty': 'MarianTransformer',
        'opus_mt_fr_uk': 'MarianTransformer',
        'opus_mt_fr_ve': 'MarianTransformer',
        'opus_mt_fr_vi': 'MarianTransformer',
        'opus_mt_fr_war': 'MarianTransformer',
        'opus_mt_fr_wls': 'MarianTransformer',
        'opus_mt_fr_xh': 'MarianTransformer',
        'opus_mt_fr_yap': 'MarianTransformer',
        'opus_mt_fr_yo': 'MarianTransformer',
        'opus_mt_fr_zne': 'MarianTransformer',
        'opus_mt_fse_fi': 'MarianTransformer',
        'opus_mt_ga_en': 'MarianTransformer',
        'opus_mt_gaa_de': 'MarianTransformer',
        'opus_mt_gaa_en': 'MarianTransformer',
        'opus_mt_gaa_es': 'MarianTransformer',
        'opus_mt_gaa_fi': 'MarianTransformer',
        'opus_mt_gaa_fr': 'MarianTransformer',
        'opus_mt_gaa_sv': 'MarianTransformer',
        'opus_mt_gem_en': 'MarianTransformer',
        'opus_mt_gem_gem': 'MarianTransformer',
        'opus_mt_gil_en': 'MarianTransformer',
        'opus_mt_gil_es': 'MarianTransformer',
        'opus_mt_gil_fi': 'MarianTransformer',
        'opus_mt_gil_fr': 'MarianTransformer',
        'opus_mt_gil_sv': 'MarianTransformer',
        'opus_mt_gl_en': 'MarianTransformer',
        'opus_mt_gl_es': 'MarianTransformer',
        'opus_mt_gl_pt': 'MarianTransformer',
        'opus_mt_gmq_en': 'MarianTransformer',
        'opus_mt_gmq_gmq': 'MarianTransformer',
        'opus_mt_gmw_en': 'MarianTransformer',
        'opus_mt_gmw_gmw': 'MarianTransformer',
        'opus_mt_grk_en': 'MarianTransformer',
        'opus_mt_guw_de': 'MarianTransformer',
        'opus_mt_guw_en': 'MarianTransformer',
        'opus_mt_guw_es': 'MarianTransformer',
        'opus_mt_guw_fi': 'MarianTransformer',
        'opus_mt_guw_fr': 'MarianTransformer',
        'opus_mt_guw_sv': 'MarianTransformer',
        'opus_mt_gv_en': 'MarianTransformer',
        'opus_mt_ha_en': 'MarianTransformer',
        'opus_mt_ha_es': 'MarianTransformer',
        'opus_mt_ha_fi': 'MarianTransformer',
        'opus_mt_ha_fr': 'MarianTransformer',
        'opus_mt_ha_sv': 'MarianTransformer',
        'opus_mt_he_ar': 'MarianTransformer',
        'opus_mt_he_de': 'MarianTransformer',
        'opus_mt_he_eo': 'MarianTransformer',
        'opus_mt_he_es': 'MarianTransformer',
        'opus_mt_he_fi': 'MarianTransformer',
        'opus_mt_he_it': 'MarianTransformer',
        'opus_mt_he_ru': 'MarianTransformer',
        'opus_mt_he_sv': 'MarianTransformer',
        'opus_mt_he_uk': 'MarianTransformer',
        'opus_mt_hi_en': 'MarianTransformer',
        'opus_mt_hi_ur': 'MarianTransformer',
        'opus_mt_hil_de': 'MarianTransformer',
        'opus_mt_hil_en': 'MarianTransformer',
        'opus_mt_hil_fi': 'MarianTransformer',
        'opus_mt_ho_en': 'MarianTransformer',
        'opus_mt_hr_es': 'MarianTransformer',
        'opus_mt_hr_fi': 'MarianTransformer',
        'opus_mt_hr_fr': 'MarianTransformer',
        'opus_mt_hr_sv': 'MarianTransformer',
        'opus_mt_ht_en': 'MarianTransformer',
        'opus_mt_ht_es': 'MarianTransformer',
        'opus_mt_ht_fi': 'MarianTransformer',
        'opus_mt_ht_fr': 'MarianTransformer',
        'opus_mt_ht_sv': 'MarianTransformer',
        'opus_mt_hu_de': 'MarianTransformer',
        'opus_mt_hu_en': 'MarianTransformer',
        'opus_mt_hu_eo': 'MarianTransformer',
        'opus_mt_hu_fi': 'MarianTransformer',
        'opus_mt_hu_fr': 'MarianTransformer',
        'opus_mt_hu_sv': 'MarianTransformer',
        'opus_mt_hu_uk': 'MarianTransformer',
        'opus_mt_hy_en': 'MarianTransformer',
        'opus_mt_hy_ru': 'MarianTransformer',
        'opus_mt_id_en': 'MarianTransformer',
        'opus_mt_id_es': 'MarianTransformer',
        'opus_mt_id_fi': 'MarianTransformer',
        'opus_mt_id_fr': 'MarianTransformer',
        'opus_mt_id_sv': 'MarianTransformer',
        'opus_mt_ig_de': 'MarianTransformer',
        'opus_mt_ig_en': 'MarianTransformer',
        'opus_mt_ig_es': 'MarianTransformer',
        'opus_mt_ig_fi': 'MarianTransformer',
        'opus_mt_ig_fr': 'MarianTransformer',
        'opus_mt_ig_sv': 'MarianTransformer',
        'opus_mt_iir_en': 'MarianTransformer',
        'opus_mt_iir_iir': 'MarianTransformer',
        'opus_mt_ilo_de': 'MarianTransformer',
        'opus_mt_ilo_en': 'MarianTransformer',
        'opus_mt_ilo_es': 'MarianTransformer',
        'opus_mt_ilo_fi': 'MarianTransformer',
        'opus_mt_ilo_sv': 'MarianTransformer',
        'opus_mt_inc_en': 'MarianTransformer',
        'opus_mt_inc_inc': 'MarianTransformer',
        'opus_mt_ine_en': 'MarianTransformer',
        'opus_mt_ine_ine': 'MarianTransformer',
        'opus_mt_is_de': 'MarianTransformer',
        'opus_mt_is_en': 'MarianTransformer',
        'opus_mt_is_eo': 'MarianTransformer',
        'opus_mt_is_es': 'MarianTransformer',
        'opus_mt_is_fi': 'MarianTransformer',
        'opus_mt_is_fr': 'MarianTransformer',
        'opus_mt_is_it': 'MarianTransformer',
        'opus_mt_is_sv': 'MarianTransformer',
        'opus_mt_iso_en': 'MarianTransformer',
        'opus_mt_iso_es': 'MarianTransformer',
        'opus_mt_iso_fi': 'MarianTransformer',
        'opus_mt_iso_fr': 'MarianTransformer',
        'opus_mt_iso_sv': 'MarianTransformer',
        'opus_mt_it_ar': 'MarianTransformer',
        'opus_mt_it_bg': 'MarianTransformer',
        'opus_mt_it_ca': 'MarianTransformer',
        'opus_mt_it_de': 'MarianTransformer',
        'opus_mt_it_en': 'MarianTransformer',
        'opus_mt_it_eo': 'MarianTransformer',
        'opus_mt_it_es': 'MarianTransformer',
        'opus_mt_it_fr': 'MarianTransformer',
        'opus_mt_it_is': 'MarianTransformer',
        'opus_mt_it_lt': 'MarianTransformer',
        'opus_mt_it_ms': 'MarianTransformer',
        'opus_mt_it_sv': 'MarianTransformer',
        'opus_mt_it_uk': 'MarianTransformer',
        'opus_mt_it_vi': 'MarianTransformer',
        'opus_mt_itc_en': 'MarianTransformer',
        'opus_mt_itc_itc': 'MarianTransformer',
        'opus_mt_ja_ar': 'MarianTransformer',
        'opus_mt_ja_bg': 'MarianTransformer',
        'opus_mt_ja_da': 'MarianTransformer',
        'opus_mt_ja_de': 'MarianTransformer',
        'opus_mt_ja_en': 'MarianTransformer',
        'opus_mt_ja_es': 'MarianTransformer',
        'opus_mt_ja_fi': 'MarianTransformer',
        'opus_mt_ja_fr': 'MarianTransformer',
        'opus_mt_ja_he': 'MarianTransformer',
        'opus_mt_ja_hu': 'MarianTransformer',
        'opus_mt_ja_it': 'MarianTransformer',
        'opus_mt_ja_ms': 'MarianTransformer',
        'opus_mt_ja_nl': 'MarianTransformer',
        'opus_mt_ja_pl': 'MarianTransformer',
        'opus_mt_ja_pt': 'MarianTransformer',
        'opus_mt_ja_ru': 'MarianTransformer',
        'opus_mt_ja_sh': 'MarianTransformer',
        'opus_mt_ja_sv': 'MarianTransformer',
        'opus_mt_ja_tr': 'MarianTransformer',
        'opus_mt_ja_vi': 'MarianTransformer',
        'opus_mt_jap_en': 'MarianTransformer',
        'opus_mt_ka_en': 'MarianTransformer',
        'opus_mt_ka_ru': 'MarianTransformer',
        'opus_mt_kab_en': 'MarianTransformer',
        'opus_mt_kg_en': 'MarianTransformer',
        'opus_mt_kg_es': 'MarianTransformer',
        'opus_mt_kg_fr': 'MarianTransformer',
        'opus_mt_kg_sv': 'MarianTransformer',
        'opus_mt_kj_en': 'MarianTransformer',
        'opus_mt_kl_en': 'MarianTransformer',
        'opus_mt_ko_de': 'MarianTransformer',
        'opus_mt_ko_en': 'MarianTransformer',
        'opus_mt_ko_es': 'MarianTransformer',
        'opus_mt_ko_fi': 'MarianTransformer',
        'opus_mt_ko_fr': 'MarianTransformer',
        'opus_mt_ko_hu': 'MarianTransformer',
        'opus_mt_ko_ru': 'MarianTransformer',
        'opus_mt_ko_sv': 'MarianTransformer',
        'opus_mt_kqn_en': 'MarianTransformer',
        'opus_mt_kqn_es': 'MarianTransformer',
        'opus_mt_kqn_fr': 'MarianTransformer',
        'opus_mt_kqn_sv': 'MarianTransformer',
        'opus_mt_kwn_en': 'MarianTransformer',
        'opus_mt_kwy_en': 'MarianTransformer',
        'opus_mt_kwy_fr': 'MarianTransformer',
        'opus_mt_kwy_sv': 'MarianTransformer',
        'opus_mt_lg_en': 'MarianTransformer',
        'opus_mt_lg_es': 'MarianTransformer',
        'opus_mt_lg_fi': 'MarianTransformer',
        'opus_mt_lg_fr': 'MarianTransformer',
        'opus_mt_lg_sv': 'MarianTransformer',
        'opus_mt_ln_de': 'MarianTransformer',
        'opus_mt_ln_en': 'MarianTransformer',
        'opus_mt_ln_es': 'MarianTransformer',
        'opus_mt_ln_fr': 'MarianTransformer',
        'opus_mt_loz_de': 'MarianTransformer',
        'opus_mt_loz_en': 'MarianTransformer',
        'opus_mt_loz_es': 'MarianTransformer',
        'opus_mt_loz_fi': 'MarianTransformer',
        'opus_mt_loz_fr': 'MarianTransformer',
        'opus_mt_loz_sv': 'MarianTransformer',
        'opus_mt_lt_de': 'MarianTransformer',
        'opus_mt_lt_eo': 'MarianTransformer',
        'opus_mt_lt_es': 'MarianTransformer',
        'opus_mt_lt_fr': 'MarianTransformer',
        'opus_mt_lt_it': 'MarianTransformer',
        'opus_mt_lt_pl': 'MarianTransformer',
        'opus_mt_lt_ru': 'MarianTransformer',
        'opus_mt_lt_sv': 'MarianTransformer',
        'opus_mt_lt_tr': 'MarianTransformer',
        'opus_mt_lu_en': 'MarianTransformer',
        'opus_mt_lu_es': 'MarianTransformer',
        'opus_mt_lu_fi': 'MarianTransformer',
        'opus_mt_lu_fr': 'MarianTransformer',
        'opus_mt_lu_sv': 'MarianTransformer',
        'opus_mt_lua_en': 'MarianTransformer',
        'opus_mt_lua_es': 'MarianTransformer',
        'opus_mt_lua_fi': 'MarianTransformer',
        'opus_mt_lua_fr': 'MarianTransformer',
        'opus_mt_lua_sv': 'MarianTransformer',
        'opus_mt_lue_en': 'MarianTransformer',
        'opus_mt_lue_es': 'MarianTransformer',
        'opus_mt_lue_fi': 'MarianTransformer',
        'opus_mt_lue_fr': 'MarianTransformer',
        'opus_mt_lue_sv': 'MarianTransformer',
        'opus_mt_lun_en': 'MarianTransformer',
        'opus_mt_luo_en': 'MarianTransformer',
        'opus_mt_lus_en': 'MarianTransformer',
        'opus_mt_lus_es': 'MarianTransformer',
        'opus_mt_lus_fi': 'MarianTransformer',
        'opus_mt_lus_fr': 'MarianTransformer',
        'opus_mt_lus_sv': 'MarianTransformer',
        'opus_mt_lv_en': 'MarianTransformer',
        'opus_mt_lv_es': 'MarianTransformer',
        'opus_mt_lv_fi': 'MarianTransformer',
        'opus_mt_lv_fr': 'MarianTransformer',
        'opus_mt_lv_ru': 'MarianTransformer',
        'opus_mt_lv_sv': 'MarianTransformer',
        'opus_mt_mfe_en': 'MarianTransformer',
        'opus_mt_mfe_es': 'MarianTransformer',
        'opus_mt_mfs_es': 'MarianTransformer',
        'opus_mt_mg_en': 'MarianTransformer',
        'opus_mt_mg_es': 'MarianTransformer',
        'opus_mt_mh_en': 'MarianTransformer',
        'opus_mt_mh_es': 'MarianTransformer',
        'opus_mt_mh_fi': 'MarianTransformer',
        'opus_mt_mk_en': 'MarianTransformer',
        'opus_mt_mk_es': 'MarianTransformer',
        'opus_mt_mk_fi': 'MarianTransformer',
        'opus_mt_mk_fr': 'MarianTransformer',
        'opus_mt_mkh_en': 'MarianTransformer',
        'opus_mt_ml_en': 'MarianTransformer',
        'opus_mt_mos_en': 'MarianTransformer',
        'opus_mt_mr_en': 'MarianTransformer',
        'opus_mt_ms_de': 'MarianTransformer',
        'opus_mt_ms_fr': 'MarianTransformer',
        'opus_mt_ms_it': 'MarianTransformer',
        'opus_mt_ms_ms': 'MarianTransformer',
        'opus_mt_mt_en': 'MarianTransformer',
        'opus_mt_mt_es': 'MarianTransformer',
        'opus_mt_mt_fi': 'MarianTransformer',
        'opus_mt_mt_fr': 'MarianTransformer',
        'opus_mt_mt_sv': 'MarianTransformer',
        'opus_mt_mul_en': 'MarianTransformer',
        'opus_mt_ng_en': 'MarianTransformer',
        'opus_mt_nic_en': 'MarianTransformer',
        'opus_mt_niu_de': 'MarianTransformer',
        'opus_mt_niu_en': 'MarianTransformer',
        'opus_mt_niu_es': 'MarianTransformer',
        'opus_mt_niu_fi': 'MarianTransformer',
        'opus_mt_niu_fr': 'MarianTransformer',
        'opus_mt_niu_sv': 'MarianTransformer',
        'opus_mt_nl_af': 'MarianTransformer',
        'opus_mt_nl_ca': 'MarianTransformer',
        'opus_mt_nl_en': 'MarianTransformer',
        'opus_mt_nl_eo': 'MarianTransformer',
        'opus_mt_nl_es': 'MarianTransformer',
        'opus_mt_nl_fi': 'MarianTransformer',
        'opus_mt_nl_fr': 'MarianTransformer',
        'opus_mt_nl_no': 'MarianTransformer',
        'opus_mt_nl_sv': 'MarianTransformer',
        'opus_mt_nl_uk': 'MarianTransformer',
        'opus_mt_no_da': 'MarianTransformer',
        'opus_mt_no_de': 'MarianTransformer',
        'opus_mt_no_es': 'MarianTransformer',
        'opus_mt_no_fi': 'MarianTransformer',
        'opus_mt_no_fr': 'MarianTransformer',
        'opus_mt_no_nl': 'MarianTransformer',
        'opus_mt_no_no': 'MarianTransformer',
        'opus_mt_no_pl': 'MarianTransformer',
        'opus_mt_no_ru': 'MarianTransformer',
        'opus_mt_no_sv': 'MarianTransformer',
        'opus_mt_no_uk': 'MarianTransformer',
        'opus_mt_nso_de': 'MarianTransformer',
        'opus_mt_nso_en': 'MarianTransformer',
        'opus_mt_nso_es': 'MarianTransformer',
        'opus_mt_nso_fi': 'MarianTransformer',
        'opus_mt_nso_fr': 'MarianTransformer',
        'opus_mt_nso_sv': 'MarianTransformer',
        'opus_mt_ny_de': 'MarianTransformer',
        'opus_mt_ny_en': 'MarianTransformer',
        'opus_mt_ny_es': 'MarianTransformer',
        'opus_mt_nyk_en': 'MarianTransformer',
        'opus_mt_om_en': 'MarianTransformer',
        'opus_mt_pa_en': 'MarianTransformer',
        'opus_mt_pag_de': 'MarianTransformer',
        'opus_mt_pag_en': 'MarianTransformer',
        'opus_mt_pag_es': 'MarianTransformer',
        'opus_mt_pag_fi': 'MarianTransformer',
        'opus_mt_pag_sv': 'MarianTransformer',
        'opus_mt_pap_de': 'MarianTransformer',
        'opus_mt_pap_en': 'MarianTransformer',
        'opus_mt_pap_es': 'MarianTransformer',
        'opus_mt_pap_fi': 'MarianTransformer',
        'opus_mt_pap_fr': 'MarianTransformer',
        'opus_mt_phi_en': 'MarianTransformer',
        'opus_mt_pis_en': 'MarianTransformer',
        'opus_mt_pis_es': 'MarianTransformer',
        'opus_mt_pis_fi': 'MarianTransformer',
        'opus_mt_pis_fr': 'MarianTransformer',
        'opus_mt_pis_sv': 'MarianTransformer',
        'opus_mt_pl_ar': 'MarianTransformer',
        'opus_mt_pl_de': 'MarianTransformer',
        'opus_mt_pl_en': 'MarianTransformer',
        'opus_mt_pl_eo': 'MarianTransformer',
        'opus_mt_pl_es': 'MarianTransformer',
        'opus_mt_pl_fr': 'MarianTransformer',
        'opus_mt_pl_lt': 'MarianTransformer',
        'opus_mt_pl_no': 'MarianTransformer',
        'opus_mt_pl_sv': 'MarianTransformer',
        'opus_mt_pl_uk': 'MarianTransformer',
        'opus_mt_pon_en': 'MarianTransformer',
        'opus_mt_pon_es': 'MarianTransformer',
        'opus_mt_pon_fi': 'MarianTransformer',
        'opus_mt_pon_fr': 'MarianTransformer',
        'opus_mt_pon_sv': 'MarianTransformer',
        'opus_mt_pqe_en': 'MarianTransformer',
        'opus_mt_prl_es': 'MarianTransformer',
        'opus_mt_pt_ca': 'MarianTransformer',
        'opus_mt_pt_eo': 'MarianTransformer',
        'opus_mt_pt_gl': 'MarianTransformer',
        'opus_mt_pt_tl': 'MarianTransformer',
        'opus_mt_pt_uk': 'MarianTransformer',
        'opus_mt_rn_de': 'MarianTransformer',
        'opus_mt_rn_en': 'MarianTransformer',
        'opus_mt_rn_es': 'MarianTransformer',
        'opus_mt_rn_fr': 'MarianTransformer',
        'opus_mt_rn_ru': 'MarianTransformer',
        'opus_mt_rnd_en': 'MarianTransformer',
        'opus_mt_rnd_fr': 'MarianTransformer',
        'opus_mt_rnd_sv': 'MarianTransformer',
        'opus_mt_ro_eo': 'MarianTransformer',
        'opus_mt_ro_fi': 'MarianTransformer',
        'opus_mt_ro_fr': 'MarianTransformer',
        'opus_mt_ro_sv': 'MarianTransformer',
        'opus_mt_roa_en': 'MarianTransformer',
        'opus_mt_ru_af': 'MarianTransformer',
        'opus_mt_ru_ar': 'MarianTransformer',
        'opus_mt_ru_bg': 'MarianTransformer',
        'opus_mt_ru_da': 'MarianTransformer',
        'opus_mt_ru_en': 'MarianTransformer',
        'opus_mt_ru_eo': 'MarianTransformer',
        'opus_mt_ru_es': 'MarianTransformer',
        'opus_mt_ru_et': 'MarianTransformer',
        'opus_mt_ru_eu': 'MarianTransformer',
        'opus_mt_ru_fi': 'MarianTransformer',
        'opus_mt_ru_fr': 'MarianTransformer',
        'opus_mt_ru_he': 'MarianTransformer',
        'opus_mt_ru_hy': 'MarianTransformer',
        'opus_mt_ru_lt': 'MarianTransformer',
        'opus_mt_ru_lv': 'MarianTransformer',
        'opus_mt_ru_no': 'MarianTransformer',
        'opus_mt_ru_sl': 'MarianTransformer',
        'opus_mt_ru_sv': 'MarianTransformer',
        'opus_mt_ru_uk': 'MarianTransformer',
        'opus_mt_ru_vi': 'MarianTransformer',
        'opus_mt_run_en': 'MarianTransformer',
        'opus_mt_run_es': 'MarianTransformer',
        'opus_mt_run_sv': 'MarianTransformer',
        'opus_mt_rw_en': 'MarianTransformer',
        'opus_mt_rw_es': 'MarianTransformer',
        'opus_mt_rw_fr': 'MarianTransformer',
        'opus_mt_rw_sv': 'MarianTransformer',
        'opus_mt_sal_en': 'MarianTransformer',
        'opus_mt_sem_en': 'MarianTransformer',
        'opus_mt_sem_sem': 'MarianTransformer',
        'opus_mt_sg_en': 'MarianTransformer',
        'opus_mt_sg_es': 'MarianTransformer',
        'opus_mt_sg_fi': 'MarianTransformer',
        'opus_mt_sg_fr': 'MarianTransformer',
        'opus_mt_sg_sv': 'MarianTransformer',
        'opus_mt_sh_eo': 'MarianTransformer',
        'opus_mt_sh_uk': 'MarianTransformer',
        'opus_mt_sk_en': 'MarianTransformer',
        'opus_mt_sk_es': 'MarianTransformer',
        'opus_mt_sk_fi': 'MarianTransformer',
        'opus_mt_sk_fr': 'MarianTransformer',
        'opus_mt_sk_sv': 'MarianTransformer',
        'opus_mt_sl_es': 'MarianTransformer',
        'opus_mt_sl_fi': 'MarianTransformer',
        'opus_mt_sl_fr': 'MarianTransformer',
        'opus_mt_sl_ru': 'MarianTransformer',
        'opus_mt_sl_sv': 'MarianTransformer',
        'opus_mt_sl_uk': 'MarianTransformer',
        'opus_mt_sla_en': 'MarianTransformer',
        'opus_mt_sla_sla': 'MarianTransformer',
        'opus_mt_sm_en': 'MarianTransformer',
        'opus_mt_sm_es': 'MarianTransformer',
        'opus_mt_sm_fr': 'MarianTransformer',
        'opus_mt_sn_en': 'MarianTransformer',
        'opus_mt_sn_es': 'MarianTransformer',
        'opus_mt_sn_fr': 'MarianTransformer',
        'opus_mt_sn_sv': 'MarianTransformer',
        'opus_mt_sq_en': 'MarianTransformer',
        'opus_mt_sq_es': 'MarianTransformer',
        'opus_mt_sq_sv': 'MarianTransformer',
        'opus_mt_srn_en': 'MarianTransformer',
        'opus_mt_srn_es': 'MarianTransformer',
        'opus_mt_srn_fr': 'MarianTransformer',
        'opus_mt_srn_sv': 'MarianTransformer',
        'opus_mt_ss_en': 'MarianTransformer',
        'opus_mt_ssp_es': 'MarianTransformer',
        'opus_mt_st_en': 'MarianTransformer',
        'opus_mt_st_es': 'MarianTransformer',
        'opus_mt_st_fi': 'MarianTransformer',
        'opus_mt_st_fr': 'MarianTransformer',
        'opus_mt_st_sv': 'MarianTransformer',
        'opus_mt_sv_af': 'MarianTransformer',
        'opus_mt_sv_ase': 'MarianTransformer',
        'opus_mt_sv_bcl': 'MarianTransformer',
        'opus_mt_sv_bem': 'MarianTransformer',
        'opus_mt_sv_bg': 'MarianTransformer',
        'opus_mt_sv_bi': 'MarianTransformer',
        'opus_mt_sv_bzs': 'MarianTransformer',
        'opus_mt_sv_ceb': 'MarianTransformer',
        'opus_mt_sv_chk': 'MarianTransformer',
        'opus_mt_sv_crs': 'MarianTransformer',
        'opus_mt_sv_cs': 'MarianTransformer',
        'opus_mt_sv_ee': 'MarianTransformer',
        'opus_mt_sv_efi': 'MarianTransformer',
        'opus_mt_sv_el': 'MarianTransformer',
        'opus_mt_sv_en': 'MarianTransformer',
        'opus_mt_sv_eo': 'MarianTransformer',
        'opus_mt_sv_es': 'MarianTransformer',
        'opus_mt_sv_et': 'MarianTransformer',
        'opus_mt_sv_fi': 'MarianTransformer',
        'opus_mt_sv_fj': 'MarianTransformer',
        'opus_mt_sv_fr': 'MarianTransformer',
        'opus_mt_sv_gaa': 'MarianTransformer',
        'opus_mt_sv_gil': 'MarianTransformer',
        'opus_mt_sv_guw': 'MarianTransformer',
        'opus_mt_sv_ha': 'MarianTransformer',
        'opus_mt_sv_he': 'MarianTransformer',
        'opus_mt_sv_hil': 'MarianTransformer',
        'opus_mt_sv_ho': 'MarianTransformer',
        'opus_mt_sv_hr': 'MarianTransformer',
        'opus_mt_sv_ht': 'MarianTransformer',
        'opus_mt_sv_hu': 'MarianTransformer',
        'opus_mt_sv_id': 'MarianTransformer',
        'opus_mt_sv_ig': 'MarianTransformer',
        'opus_mt_sv_ilo': 'MarianTransformer',
        'opus_mt_sv_is': 'MarianTransformer',
        'opus_mt_sv_iso': 'MarianTransformer',
        'opus_mt_sv_kg': 'MarianTransformer',
        'opus_mt_sv_kqn': 'MarianTransformer',
        'opus_mt_sv_kwy': 'MarianTransformer',
        'opus_mt_sv_lg': 'MarianTransformer',
        'opus_mt_sv_ln': 'MarianTransformer',
        'opus_mt_sv_lu': 'MarianTransformer',
        'opus_mt_sv_lua': 'MarianTransformer',
        'opus_mt_sv_lue': 'MarianTransformer',
        'opus_mt_sv_lus': 'MarianTransformer',
        'opus_mt_sv_lv': 'MarianTransformer',
        'opus_mt_sv_mfe': 'MarianTransformer',
        'opus_mt_sv_mh': 'MarianTransformer',
        'opus_mt_sv_mos': 'MarianTransformer',
        'opus_mt_sv_mt': 'MarianTransformer',
        'opus_mt_sv_niu': 'MarianTransformer',
        'opus_mt_sv_nl': 'MarianTransformer',
        'opus_mt_sv_no': 'MarianTransformer',
        'opus_mt_sv_nso': 'MarianTransformer',
        'opus_mt_sv_ny': 'MarianTransformer',
        'opus_mt_sv_pag': 'MarianTransformer',
        'opus_mt_sv_pap': 'MarianTransformer',
        'opus_mt_sv_pis': 'MarianTransformer',
        'opus_mt_sv_pon': 'MarianTransformer',
        'opus_mt_sv_rnd': 'MarianTransformer',
        'opus_mt_sv_ro': 'MarianTransformer',
        'opus_mt_sv_ru': 'MarianTransformer',
        'opus_mt_sv_run': 'MarianTransformer',
        'opus_mt_sv_rw': 'MarianTransformer',
        'opus_mt_sv_sg': 'MarianTransformer',
        'opus_mt_sv_sk': 'MarianTransformer',
        'opus_mt_sv_sl': 'MarianTransformer',
        'opus_mt_sv_sm': 'MarianTransformer',
        'opus_mt_sv_sn': 'MarianTransformer',
        'opus_mt_sv_sq': 'MarianTransformer',
        'opus_mt_sv_srn': 'MarianTransformer',
        'opus_mt_sv_st': 'MarianTransformer',
        'opus_mt_sv_sv': 'MarianTransformer',
        'opus_mt_sv_swc': 'MarianTransformer',
        'opus_mt_sv_th': 'MarianTransformer',
        'opus_mt_sv_tiv': 'MarianTransformer',
        'opus_mt_sv_tll': 'MarianTransformer',
        'opus_mt_sv_tn': 'MarianTransformer',
        'opus_mt_sv_to': 'MarianTransformer',
        'opus_mt_sv_toi': 'MarianTransformer',
        'opus_mt_sv_tpi': 'MarianTransformer',
        'opus_mt_sv_ts': 'MarianTransformer',
        'opus_mt_sv_tum': 'MarianTransformer',
        'opus_mt_sv_tvl': 'MarianTransformer',
        'opus_mt_sv_tw': 'MarianTransformer',
        'opus_mt_sv_ty': 'MarianTransformer',
        'opus_mt_sv_uk': 'MarianTransformer',
        'opus_mt_sv_umb': 'MarianTransformer',
        'opus_mt_sv_ve': 'MarianTransformer',
        'opus_mt_sv_war': 'MarianTransformer',
        'opus_mt_sv_wls': 'MarianTransformer',
        'opus_mt_sv_xh': 'MarianTransformer',
        'opus_mt_sv_yap': 'MarianTransformer',
        'opus_mt_sv_yo': 'MarianTransformer',
        'opus_mt_sv_zne': 'MarianTransformer',
        'opus_mt_swc_en': 'MarianTransformer',
        'opus_mt_swc_es': 'MarianTransformer',
        'opus_mt_swc_fi': 'MarianTransformer',
        'opus_mt_swc_fr': 'MarianTransformer',
        'opus_mt_swc_sv': 'MarianTransformer',
        'opus_mt_taw_en': 'MarianTransformer',
        'opus_mt_th_en': 'MarianTransformer',
        'opus_mt_th_fr': 'MarianTransformer',
        'opus_mt_ti_en': 'MarianTransformer',
        'opus_mt_tiv_en': 'MarianTransformer',
        'opus_mt_tiv_fr': 'MarianTransformer',
        'opus_mt_tiv_sv': 'MarianTransformer',
        'opus_mt_tl_de': 'MarianTransformer',
        'opus_mt_tl_en': 'MarianTransformer',
        'opus_mt_tl_es': 'MarianTransformer',
        'opus_mt_tl_pt': 'MarianTransformer',
        'opus_mt_tll_en': 'MarianTransformer',
        'opus_mt_tll_es': 'MarianTransformer',
        'opus_mt_tll_fi': 'MarianTransformer',
        'opus_mt_tll_fr': 'MarianTransformer',
        'opus_mt_tll_sv': 'MarianTransformer',
        'opus_mt_tn_en': 'MarianTransformer',
        'opus_mt_tn_es': 'MarianTransformer',
        'opus_mt_tn_fr': 'MarianTransformer',
        'opus_mt_tn_sv': 'MarianTransformer',
        'opus_mt_to_en': 'MarianTransformer',
        'opus_mt_to_es': 'MarianTransformer',
        'opus_mt_to_fr': 'MarianTransformer',
        'opus_mt_to_sv': 'MarianTransformer',
        'opus_mt_toi_en': 'MarianTransformer',
        'opus_mt_toi_es': 'MarianTransformer',
        'opus_mt_toi_fi': 'MarianTransformer',
        'opus_mt_toi_fr': 'MarianTransformer',
        'opus_mt_toi_sv': 'MarianTransformer',
        'opus_mt_tpi_en': 'MarianTransformer',
        'opus_mt_tpi_sv': 'MarianTransformer',
        'opus_mt_tr_ar': 'MarianTransformer',
        'opus_mt_tr_az': 'MarianTransformer',
        'opus_mt_tr_en': 'MarianTransformer',
        'opus_mt_tr_eo': 'MarianTransformer',
        'opus_mt_tr_es': 'MarianTransformer',
        'opus_mt_tr_fr': 'MarianTransformer',
        'opus_mt_tr_lt': 'MarianTransformer',
        'opus_mt_tr_sv': 'MarianTransformer',
        'opus_mt_tr_uk': 'MarianTransformer',
        'opus_mt_trk_en': 'MarianTransformer',
        'opus_mt_ts_en': 'MarianTransformer',
        'opus_mt_ts_es': 'MarianTransformer',
        'opus_mt_ts_fi': 'MarianTransformer',
        'opus_mt_ts_fr': 'MarianTransformer',
        'opus_mt_ts_sv': 'MarianTransformer',
        'opus_mt_tum_en': 'MarianTransformer',
        'opus_mt_tum_es': 'MarianTransformer',
        'opus_mt_tum_fr': 'MarianTransformer',
        'opus_mt_tum_sv': 'MarianTransformer',
        'opus_mt_tvl_en': 'MarianTransformer',
        'opus_mt_tvl_es': 'MarianTransformer',
        'opus_mt_tvl_fi': 'MarianTransformer',
        'opus_mt_tvl_fr': 'MarianTransformer',
        'opus_mt_tvl_sv': 'MarianTransformer',
        'opus_mt_tw_es': 'MarianTransformer',
        'opus_mt_tw_fi': 'MarianTransformer',
        'opus_mt_tw_fr': 'MarianTransformer',
        'opus_mt_tw_sv': 'MarianTransformer',
        'opus_mt_ty_es': 'MarianTransformer',
        'opus_mt_ty_fi': 'MarianTransformer',
        'opus_mt_ty_fr': 'MarianTransformer',
        'opus_mt_ty_sv': 'MarianTransformer',
        'opus_mt_tzo_es': 'MarianTransformer',
        'opus_mt_uk_bg': 'MarianTransformer',
        'opus_mt_uk_ca': 'MarianTransformer',
        'opus_mt_uk_cs': 'MarianTransformer',
        'opus_mt_uk_de': 'MarianTransformer',
        'opus_mt_uk_en': 'MarianTransformer',
        'opus_mt_uk_es': 'MarianTransformer',
        'opus_mt_uk_fi': 'MarianTransformer',
        'opus_mt_uk_fr': 'MarianTransformer',
        'opus_mt_uk_he': 'MarianTransformer',
        'opus_mt_uk_hu': 'MarianTransformer',
        'opus_mt_uk_it': 'MarianTransformer',
        'opus_mt_uk_nl': 'MarianTransformer',
        'opus_mt_uk_no': 'MarianTransformer',
        'opus_mt_uk_pl': 'MarianTransformer',
        'opus_mt_uk_pt': 'MarianTransformer',
        'opus_mt_uk_ru': 'MarianTransformer',
        'opus_mt_uk_sh': 'MarianTransformer',
        'opus_mt_uk_sl': 'MarianTransformer',
        'opus_mt_uk_sv': 'MarianTransformer',
        'opus_mt_uk_tr': 'MarianTransformer',
        'opus_mt_umb_en': 'MarianTransformer',
        'opus_mt_ur_en': 'MarianTransformer',
        'opus_mt_urj_en': 'MarianTransformer',
        'opus_mt_urj_urj': 'MarianTransformer',
        'opus_mt_ve_en': 'MarianTransformer',
        'opus_mt_ve_es': 'MarianTransformer',
        'opus_mt_vi_de': 'MarianTransformer',
        'opus_mt_vi_en': 'MarianTransformer',
        'opus_mt_vi_eo': 'MarianTransformer',
        'opus_mt_vi_es': 'MarianTransformer',
        'opus_mt_vi_fr': 'MarianTransformer',
        'opus_mt_vi_it': 'MarianTransformer',
        'opus_mt_vi_ru': 'MarianTransformer',
        'opus_mt_vsl_es': 'MarianTransformer',
        'opus_mt_wa_en': 'MarianTransformer',
        'opus_mt_wal_en': 'MarianTransformer',
        'opus_mt_war_en': 'MarianTransformer',
        'opus_mt_war_es': 'MarianTransformer',
        'opus_mt_war_fi': 'MarianTransformer',
        'opus_mt_war_fr': 'MarianTransformer',
        'opus_mt_war_sv': 'MarianTransformer',
        'opus_mt_wls_en': 'MarianTransformer',
        'opus_mt_wls_fr': 'MarianTransformer',
        'opus_mt_wls_sv': 'MarianTransformer',
        'opus_mt_xh_en': 'MarianTransformer',
        'opus_mt_xh_es': 'MarianTransformer',
        'opus_mt_xh_fr': 'MarianTransformer',
        'opus_mt_xh_sv': 'MarianTransformer',
        'opus_mt_yap_en': 'MarianTransformer',
        'opus_mt_yap_fr': 'MarianTransformer',
        'opus_mt_yap_sv': 'MarianTransformer',
        'opus_mt_yo_en': 'MarianTransformer',
        'opus_mt_yo_es': 'MarianTransformer',
        'opus_mt_yo_fi': 'MarianTransformer',
        'opus_mt_yo_fr': 'MarianTransformer',
        'opus_mt_yo_sv': 'MarianTransformer',
        'opus_mt_zai_es': 'MarianTransformer',
        'opus_mt_zh_bg': 'MarianTransformer',
        'opus_mt_zh_de': 'MarianTransformer',
        'opus_mt_zh_en': 'MarianTransformer',
        'opus_mt_zh_fi': 'MarianTransformer',
        'opus_mt_zh_he': 'MarianTransformer',
        'opus_mt_zh_it': 'MarianTransformer',
        'opus_mt_zh_ms': 'MarianTransformer',
        'opus_mt_zh_nl': 'MarianTransformer',
        'opus_mt_zh_sv': 'MarianTransformer',
        'opus_mt_zh_uk': 'MarianTransformer',
        'opus_mt_zh_vi': 'MarianTransformer',
        'opus_mt_zle_en': 'MarianTransformer',
        'opus_mt_zle_zle': 'MarianTransformer',
        'opus_mt_zls_en': 'MarianTransformer',
        'opus_mt_zls_zls': 'MarianTransformer',
        'opus_mt_zlw_en': 'MarianTransformer',
        'opus_mt_zlw_zlw': 'MarianTransformer',
        'opus_mt_zne_es': 'MarianTransformer',
        'opus_mt_zne_fi': 'MarianTransformer',
        'opus_mt_zne_fr': 'MarianTransformer',
        'opus_mt_zne_sv': 'MarianTransformer',
        'opus_tatoeba_af_ru': 'MarianTransformer',
        'opus_tatoeba_es_zh': 'MarianTransformer',
        'opus_tatoeba_he_fr': 'MarianTransformer',
        'opus_tatoeba_he_it': 'MarianTransformer',
        'opus_tatoeba_it_he': 'MarianTransformer',
        'persian_w2v_cc_300d': 'WordEmbeddingsModel',
        'personer_cc_300d': 'NerDLModel',
        'pos_afribooms': 'PerceptronModel',
        'pos_alksnis': 'PerceptronModel',
        'pos_alpino': 'PerceptronModel',
        'pos_anc': 'PerceptronModel',
        'pos_ancora': 'PerceptronModel',
        'pos_arcosg': 'PerceptronModel',
        'pos_armtdp': 'PerceptronModel',
        'pos_atis': 'PerceptronModel',
        'pos_bdt': 'PerceptronModel',
        'pos_bosque': 'PerceptronModel',
        'pos_btb': 'PerceptronModel',
        'pos_cac': 'PerceptronModel',
        'pos_ccg': 'PerceptronModel',
        'pos_clinical': 'PerceptronModel',
        'pos_cltt': 'PerceptronModel',
        'pos_ctg': 'PerceptronModel',
        'pos_ddt': 'PerceptronModel',
        'pos_ewt': 'PerceptronModel',
        'pos_framenet': 'PerceptronModel',
        'pos_ftb': 'PerceptronModel',
        'pos_gdt': 'PerceptronModel',
        'pos_gsd': 'PerceptronModel',
        'pos_gsdluw': 'PerceptronModel',
        'pos_gum': 'PerceptronModel',
        'pos_hdt': 'PerceptronModel',
        'pos_hdtb': 'PerceptronModel',
        'pos_hiencs': 'PerceptronModel',
        'pos_hse': 'PerceptronModel',
        'pos_htb': 'PerceptronModel',
        'pos_isdt': 'PerceptronModel',
        'pos_ittb': 'PerceptronModel',
        'pos_iu': 'PerceptronModel',
        'pos_kaist': 'PerceptronModel',
        'pos_kenet': 'PerceptronModel',
        'pos_kyoto': 'PerceptronModel',
        'pos_lassysmall': 'PerceptronModel',
        'pos_lines': 'PerceptronModel',
        'pos_llct': 'PerceptronModel',
        'pos_lst20': 'PerceptronModel',
        'pos_modern': 'PerceptronModel',
        'pos_msri': 'PerceptronModel',
        'pos_mtg': 'PerceptronModel',
        'pos_nsc': 'PerceptronModel',
        'pos_parisstories': 'PerceptronModel',
        'pos_partut': 'PerceptronModel',
        'pos_pdb': 'PerceptronModel',
        'pos_pdt': 'PerceptronModel',
        'pos_penn': 'PerceptronModel',
        'pos_perseus': 'PerceptronModel',
        'pos_postwita': 'PerceptronModel',
        'pos_proiel': 'PerceptronModel',
        'pos_rnc': 'PerceptronModel',
        'pos_rrt': 'PerceptronModel',
        'pos_seraji': 'PerceptronModel',
        'pos_set': 'PerceptronModel',
        'pos_simonero': 'PerceptronModel',
        'pos_snk': 'PerceptronModel',
        'pos_srcmf': 'PerceptronModel',
        'pos_ssj': 'PerceptronModel',
        'pos_szeged': 'PerceptronModel',
        'pos_taiga': 'PerceptronModel',
        'pos_talbanken': 'PerceptronModel',
        'pos_torot': 'PerceptronModel',
        'pos_treegal': 'PerceptronModel',
        'pos_ttb': 'PerceptronModel',
        'pos_ud_alpino': 'PerceptronModel',
        'pos_ud_ancora': 'PerceptronModel',
        'pos_ud_armtdp': 'PerceptronModel',
        'pos_ud_att': 'PerceptronModel',
        'pos_ud_bdt': 'PerceptronModel',
        'pos_ud_bhtb': 'PerceptronModel',
        'pos_ud_bosque': 'PerceptronModel',
        'pos_ud_btb': 'PerceptronModel',
        'pos_ud_ddt': 'PerceptronModel',
        'pos_ud_ewt': 'PerceptronModel',
        'pos_ud_gdt': 'PerceptronModel',
        'pos_ud_gsd': 'PerceptronModel',
        'pos_ud_gsd_trad': 'PerceptronModel',
        'pos_ud_hdt': 'PerceptronModel',
        'pos_ud_hdtb': 'PerceptronModel',
        'pos_ud_htb': 'PerceptronModel',
        'pos_ud_idt': 'PerceptronModel',
        'pos_ud_imst': 'PerceptronModel',
        'pos_ud_isdt': 'PerceptronModel',
        'pos_ud_iu': 'PerceptronModel',
        'pos_ud_kaist': 'PerceptronModel',
        'pos_ud_keb': 'PerceptronModel',
        'pos_ud_lfg': 'PerceptronModel',
        'pos_ud_llct': 'PerceptronModel',
        'pos_ud_lvtb': 'PerceptronModel',
        'pos_ud_nynorsk': 'PerceptronModel',
        'pos_ud_padt': 'PerceptronModel',
        'pos_ud_pdt': 'PerceptronModel',
        'pos_ud_perdt': 'PerceptronModel',
        'pos_ud_rrt': 'PerceptronModel',
        'pos_ud_snk': 'PerceptronModel',
        'pos_ud_ssj': 'PerceptronModel',
        'pos_ud_szeged': 'PerceptronModel',
        'pos_ud_tal': 'PerceptronModel',
        'pos_ud_tdt': 'PerceptronModel',
        'pos_ud_treegal': 'PerceptronModel',
        'pos_ud_udtb': 'PerceptronModel',
        'pos_ud_ufal': 'PerceptronModel',
        'pos_ud_ytb': 'PerceptronModel',
        'pos_udt': 'PerceptronModel',
        'pos_vit': 'PerceptronModel',
        'pos_vtb': 'PerceptronModel',
        'pragmatic_sentence_detector': 'SentenceDetector',
        're_ade_biobert': 'RelationExtractionModel',
        're_ade_clinical': 'RelationExtractionModel',
        're_drugprot_clinical': 'RelationExtractionModel',
        're_temporal_events_clinical': 'RelationExtractionModel',
        're_test_result_date': 'RelationExtractionModel',
        're_zeroshot_biobert': 'ZeroShotRelationExtractionModel',
        'redl_ade_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_direction_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_problem_biobert': 'RelationExtractionDLModel',
        'redl_bodypart_procedure_test_biobert': 'RelationExtractionDLModel',
        'redl_chemprot_biobert': 'RelationExtractionDLModel',
        'redl_clinical_biobert': 'RelationExtractionDLModel',
        'redl_date_clinical_biobert': 'RelationExtractionDLModel',
        'redl_drug_drug_interaction_biobert': 'RelationExtractionDLModel',
        'redl_drugprot_biobert': 'RelationExtractionDLModel',
        'redl_human_phenotype_gene_biobert': 'RelationExtractionDLModel',
        'redl_nihss_biobert': 'RelationExtractionDLModel',
        'redl_temporal_events_biobert': 'RelationExtractionDLModel',
        'regex_matcher': 'RegexMatcher',
        'roberta_base': 'RoBertaEmbeddings',
        'roberta_base_biomedical': 'RoBertaEmbeddings',
        'roberta_base_sequence_classifier_ag_news': 'RoBertaForSequenceClassification',
        'roberta_base_sequence_classifier_imdb': 'RoBertaForSequenceClassification',
        'roberta_base_token_classifier_conll03': 'RoBertaForTokenClassification',
        'roberta_base_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'roberta_large': 'RoBertaEmbeddings',
        'roberta_large_token_classifier_conll03': 'RoBertaForTokenClassification',
        'roberta_large_token_classifier_ontonotes': 'RoBertaForTokenClassification',
        'roberta_ner_diag_proc': 'MedicalNerModel',
        'roberta_token_classifier_bne_capitel_ner': 'RoBertaForTokenClassification',
        'roberta_token_classifier_icelandic_ner': 'RoBertaForTokenClassification',
        'roberta_token_classifier_pos_tagger': 'RoBertaForTokenClassification',
        'roberta_token_classifier_ticker': 'RoBertaForTokenClassification',
        'roberta_token_classifier_timex_semeval': 'RoBertaForTokenClassification',
        'roberta_token_classifier_zwnj_base_ner': 'RoBertaForTokenClassification',
        'robertaresolve_snomed': 'SentenceEntityResolverModel',
        'sbert_jsl_medium_rxnorm_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_medium_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_medium_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_mini_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_mini_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_tiny_umls_uncased': 'BertSentenceEmbeddings',
        'sbert_jsl_tiny_uncased': 'BertSentenceEmbeddings',
        'sbertresolve_icd10cm_slim_billable_hcc_med': 'SentenceEntityResolverModel',
        'sbertresolve_icd10gm': 'SentenceEntityResolverModel',
        'sbertresolve_rxnorm_disposition': 'SentenceEntityResolverModel',
        'sbertresolve_snomed': 'SentenceEntityResolverModel',
        'sbertresolve_snomed_bodyStructure_med': 'SentenceEntityResolverModel',
        'sbertresolve_snomed_conditions': 'SentenceEntityResolverModel',
        'sbiobert_base_cased_mli': 'BertSentenceEmbeddings',
        'sbiobert_jsl_cased': 'BertSentenceEmbeddings',
        'sbiobert_jsl_rxnorm_cased': 'BertSentenceEmbeddings',
        'sbiobert_jsl_umls_cased': 'BertSentenceEmbeddings',
        'sbiobertresolve_HPO': 'SentenceEntityResolverModel',
        'sbiobertresolve_clinical_abbreviation_acronym': 'SentenceEntityResolverModel',
        'sbiobertresolve_clinical_snomed_procedures_measurements': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_procedures_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_cpt_procedures_measurements_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_hcc_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_hcpcs': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_augmented_billable_hcc': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_generalised': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10cm_slim_billable_hcc': 'SentenceEntityResolverModel',
        'sbiobertresolve_icd10pcs': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_icdo_base': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_loinc_cased': 'SentenceEntityResolverModel',
        'sbiobertresolve_mesh': 'SentenceEntityResolverModel',
        'sbiobertresolve_ndc': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxcui': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_augmented': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_augmented_re': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_disposition': 'SentenceEntityResolverModel',
        'sbiobertresolve_rxnorm_ndc': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_auxConcepts': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_auxConcepts_int': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_bodyStructure': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_drug': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings_aux_concepts': 'SentenceEntityResolverModel',
        'sbiobertresolve_snomed_findings_int': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_clinical_drugs': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_disease_syndrome': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_drug_substance': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_findings': 'SentenceEntityResolverModel',
        'sbiobertresolve_umls_major_concepts': 'SentenceEntityResolverModel',
        'sbluebert_base_uncased_mli': 'BertSentenceEmbeddings',
        'sbluebertresolve_loinc': 'SentenceEntityResolverModel',
        'sbluebertresolve_loinc_uncased': 'SentenceEntityResolverModel',
        'sent_bert_base_cased': 'BertSentenceEmbeddings',
        'sent_bert_base_uncased': 'BertSentenceEmbeddings',
        'sent_bert_base_uncased_legal': 'BertSentenceEmbeddings',
        'sent_bert_large_cased': 'BertSentenceEmbeddings',
        'sent_bert_large_uncased': 'BertSentenceEmbeddings',
        'sent_bert_multi_cased': 'BertSentenceEmbeddings',
        'sent_bert_muril': 'BertSentenceEmbeddings',
        'sent_bert_pubmed': 'BertSentenceEmbeddings',
        'sent_bert_pubmed_squad2': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_en_base': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_en_large': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_multi_base': 'BertSentenceEmbeddings',
        'sent_bert_use_cmlm_multi_base_br': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_mnli': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_qnli': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_qqp': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_squad2': 'BertSentenceEmbeddings',
        'sent_bert_wiki_books_sst2': 'BertSentenceEmbeddings',
        'sent_biobert_clinical_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_discharge_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pmc_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_base_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_large_cased': 'BertSentenceEmbeddings',
        'sent_biobert_pubmed_pmc_base_cased': 'BertSentenceEmbeddings',
        'sent_covidbert_large_uncased': 'BertSentenceEmbeddings',
        'sent_electra_base_uncased': 'BertSentenceEmbeddings',
        'sent_electra_large_uncased': 'BertSentenceEmbeddings',
        'sent_electra_small_uncased': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L10_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L12_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L2_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L4_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L6_768': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_128': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_256': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_512': 'BertSentenceEmbeddings',
        'sent_small_bert_L8_768': 'BertSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_amharic': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_hausa': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_igbo': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_kinyarwanda': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_luganda': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_naija': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_swahili': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_wolof': 'XlmRoBertaSentenceEmbeddings',
        'sent_xlm_roberta_base_finetuned_yoruba': 'XlmRoBertaSentenceEmbeddings',
        'sentence_detector_dl': 'SentenceDetectorDLModel',
        'sentence_detector_dl_healthcare': 'SentenceDetectorDLModel',
        'sentiment_jager_use': 'SentimentDLModel',
        'sentiment_vivekn': 'ViveknSentimentModel',
        'sentimentdl_glove_imdb': 'SentimentDLModel',
        'sentimentdl_urduvec_imdb': 'SentimentDLModel',
        'sentimentdl_use_imdb': 'SentimentDLModel',
        'sentimentdl_use_twitter': 'SentimentDLModel',
        'small_bert_L10_128': 'BertEmbeddings',
        'small_bert_L10_256': 'BertEmbeddings',
        'small_bert_L10_512': 'BertEmbeddings',
        'small_bert_L10_768': 'BertEmbeddings',
        'small_bert_L12_128': 'BertEmbeddings',
        'small_bert_L12_256': 'BertEmbeddings',
        'small_bert_L12_512': 'BertEmbeddings',
        'small_bert_L12_768': 'BertEmbeddings',
        'small_bert_L2_128': 'BertEmbeddings',
        'small_bert_L2_256': 'BertEmbeddings',
        'small_bert_L2_512': 'BertEmbeddings',
        'small_bert_L2_768': 'BertEmbeddings',
        'small_bert_L4_128': 'BertEmbeddings',
        'small_bert_L4_256': 'BertEmbeddings',
        'small_bert_L4_512': 'BertEmbeddings',
        'small_bert_L4_768': 'BertEmbeddings',
        'small_bert_L6_128': 'BertEmbeddings',
        'small_bert_L6_256': 'BertEmbeddings',
        'small_bert_L6_512': 'BertEmbeddings',
        'small_bert_L6_768': 'BertEmbeddings',
        'small_bert_L8_128': 'BertEmbeddings',
        'small_bert_L8_256': 'BertEmbeddings',
        'small_bert_L8_512': 'BertEmbeddings',
        'small_bert_L8_768': 'BertEmbeddings',
        'spark_nlp_tokenizer': 'TokenizerModel',
        'spellcheck_dl': 'ContextSpellCheckerModel',
        'spellcheck_drug_norvig': 'NorvigSweetingModel',
        'spellcheck_norvig': 'NorvigSweetingModel',
        'spellcheck_sd': 'SymmetricDeleteModel',
        'stemmer': 'Stemmer',
        'stopwords_af': 'StopWordsCleaner',
        'stopwords_ar': 'StopWordsCleaner',
        'stopwords_bg': 'StopWordsCleaner',
        'stopwords_bn': 'StopWordsCleaner',
        'stopwords_br': 'StopWordsCleaner',
        'stopwords_ca': 'StopWordsCleaner',
        'stopwords_cs': 'StopWordsCleaner',
        'stopwords_de': 'StopWordsCleaner',
        'stopwords_el': 'StopWordsCleaner',
        'stopwords_en': 'StopWordsCleaner',
        'stopwords_eo': 'StopWordsCleaner',
        'stopwords_es': 'StopWordsCleaner',
        'stopwords_eu': 'StopWordsCleaner',
        'stopwords_fa': 'StopWordsCleaner',
        'stopwords_fi': 'StopWordsCleaner',
        'stopwords_fr': 'StopWordsCleaner',
        'stopwords_ga': 'StopWordsCleaner',
        'stopwords_gl': 'StopWordsCleaner',
        'stopwords_ha': 'StopWordsCleaner',
        'stopwords_he': 'StopWordsCleaner',
        'stopwords_hi': 'StopWordsCleaner',
        'stopwords_hu': 'StopWordsCleaner',
        'stopwords_hy': 'StopWordsCleaner',
        'stopwords_id': 'StopWordsCleaner',
        'stopwords_it': 'StopWordsCleaner',
        'stopwords_ja': 'StopWordsCleaner',
        'stopwords_la': 'StopWordsCleaner',
        'stopwords_lv': 'StopWordsCleaner',
        'stopwords_mr': 'StopWordsCleaner',
        'stopwords_pl': 'StopWordsCleaner',
        'stopwords_pt': 'StopWordsCleaner',
        'stopwords_ro': 'StopWordsCleaner',
        'stopwords_ru': 'StopWordsCleaner',
        'stopwords_sk': 'StopWordsCleaner',
        'stopwords_sl': 'StopWordsCleaner',
        'stopwords_so': 'StopWordsCleaner',
        'stopwords_st': 'StopWordsCleaner',
        'stopwords_sv': 'StopWordsCleaner',
        'stopwords_sw': 'StopWordsCleaner',
        'stopwords_th': 'StopWordsCleaner',
        'stopwords_tr': 'StopWordsCleaner',
        'stopwords_yo': 'StopWordsCleaner',
        'stopwords_zu': 'StopWordsCleaner',
        'swedish_ner_6B_100': 'NerDLModel',
        'swedish_ner_6B_300': 'NerDLModel',
        'swedish_ner_840B_300': 'NerDLModel',
        't5_active_to_passive_styletransfer': 'T5Transformer',
        't5_base': 'T5Transformer',
        't5_base_mediqa_mnli': 'T5Transformer',
        't5_formal_to_informal_styletransfer': 'T5Transformer',
        't5_grammar_error_corrector': 'T5Transformer',
        't5_informal_to_formal_styletransfer': 'T5Transformer',
        't5_passive_to_active_styletransfer': 'T5Transformer',
        't5_small': 'T5Transformer',
        't5_small_wikiSQL': 'T5Transformer',
        'text_matcher': 'TextMatcher',
        'tfhub_use': 'UniversalSentenceEncoder',
        'tfhub_use_lg': 'UniversalSentenceEncoder',
        'tfhub_use_multi': 'UniversalSentenceEncoder',
        'tfhub_use_multi_lg': 'UniversalSentenceEncoder',
        'turkish_ner_840B_300': 'NerDLModel',
        'turkish_ner_bert': 'NerDLModel',
        'twitter_xlm_roberta_base': 'XlmRoBertaEmbeddings',
        'uner_mk_140M_300d': 'NerDLModel',
        'urduvec_140M_300d': 'WordEmbeddingsModel',
        'w2v_cc_300d': 'WordEmbeddingsModel',
        'wikiner_6B_100': 'NerDLModel',
        'wikiner_6B_300': 'NerDLModel',
        'wikiner_840B_300': 'NerDLModel',
        'word2vec_gigaword_300': 'Word2VecModel',
        'word2vec_gigaword_wiki_300': 'Word2VecModel',
        'word2vec_wac_200': 'WordEmbeddingsModel',
        'word2vec_wiki_1000': 'WordEmbeddingsModel',
        'wordseg_best': 'WordSegmenterModel',
        'wordseg_ctb9': 'WordSegmenterModel',
        'wordseg_gsd_ud': 'WordSegmenterModel',
        'wordseg_gsd_ud_trad': 'WordSegmenterModel',
        'wordseg_kaist_ud': 'WordSegmenterModel',
        'wordseg_large': 'WordSegmenterModel',
        'wordseg_msra': 'WordSegmenterModel',
        'wordseg_pku': 'WordSegmenterModel',
        'wordseg_weibo': 'WordSegmenterModel',
        'xlm_roberta_base': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_amharic': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_hausa': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_igbo': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_kinyarwanda': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_luganda': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_luo': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_naija': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_swahili': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_wolof': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_finetuned_yoruba': 'XlmRoBertaEmbeddings',
        'xlm_roberta_base_sequence_classifier_ag_news': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_sequence_classifier_allocine': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_sequence_classifier_imdb': 'XlmRoBertaForSequenceClassification',
        'xlm_roberta_base_token_classifier_ner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large': 'XlmRoBertaEmbeddings',
        'xlm_roberta_large_token_classification_ner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_conll03': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_hrl': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_large_token_classifier_masakhaner': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_token_classifier_ner_40_lang': 'XlmRoBertaForTokenClassification',
        'xlm_roberta_xtreme_base': 'XlmRoBertaEmbeddings',
        'xlnet_base_cased': 'XlnetEmbeddings',
        'xlnet_base_sequence_classifier_ag_news': 'XlnetForSequenceClassification',
        'xlnet_base_sequence_classifier_imdb': 'XlnetForSequenceClassification',
        'xlnet_base_token_classifier_conll03': 'XlnetForTokenClassification',
        'xlnet_large_cased': 'XlnetEmbeddings',
        'xlnet_large_token_classifier_conll03': 'XlnetForTokenClassification',
        'yake': 'YakeKeywordExtraction'}
