"""
This module contains constants and default values for the simulation.
"""

# keys and names used in the simulation

#: name of the population containing the simulation stop points
STOP_POINT_POPULATION = "stop_point"

#: agent_type of the agents generated by PublicTransportOperator
PUBLIC_TRANSPORT_TYPE = "public_transport"

#: required DataFrame columns of the table describing the stop points when calling add_stops()
ADD_STOPS_COLUMNS = ["stop_id", "stop_name", "stop_lat", "stop_lon"]

# base leaving codes

#: default leaving code, when the loop terminates without LeavingSimulation exception
DEFAULT_LEAVE = "DEFAULT"

#: leaving code signaling a completed loop
SUCCESS_LEAVE = "SUCCESS"

#: leaving code signaling the end of the simulation
END_OF_SIM_LEAVE = "END_OF_SIM"

#: leaving code signaling a simulation error
SIM_ERROR_LEAVE = "SIM_ERROR"

#: dict of base leaving codes and their descriptions
BASE_LEAVING_CODES = {
        DEFAULT_LEAVE: "No explicit leave call",
        SUCCESS_LEAVE: "Successful loop",
        END_OF_SIM_LEAVE: "End of simulation",
        SIM_ERROR_LEAVE: "Simulation error"
}

# filename formats

#: format of the ALIENS operators usage diagram
OPERATORS_USAGE_FORMAT = "{prefix}_operators.png"

#: format of the ALIENS objective function graph
OBJECTIVE_GRAPH_FORMAT = "{prefix}_objective.png"
