# pyMacroMS
##### _High performance quantification of complex high resolution polymer mass spectra_

The purpose of this program is to identify and quantify macromolecular species 
in high resolution mass spectra based on the used monomer(s), possible end-groups 
and the adduct ion. Experimental spectra are imported as a centroided peaklist
from a comma-separated values (csv) file or directly from a Thermo RAW file (from v1.0.0). Please find code for example usage
 on our [webpage](http://macroarc.org/research/macroarc-pyMacroMS.html).
 
From version 1.0.0, pyMacroMS requires a 64-bit version of Python. 

##### Dependencies

pyMacroMS requires the following modules to be installed:
* [IsoSpecPy](http://matteolacki.github.io/IsoSpec/) for the generation of isotopic patterns
* numpy and pandas for data processing
* sklearn for quantification via linear regression
* matplotlib for quick representation of results
* progressbar2 for feedback during the more time consuming steps 
* reportlab and svglib for the generation of a PDF report
* pythonnet for the interface with Thermo's RawFileReader

##### Citation

Please refer to our publication for more details about the algorithm and 
cite us when using pyMacroMS in your work:

[K. De Bruycker, T. Krappitz, C. Barner-Kowollik, _ACS Macro Lett._ **2018**, 1443-1447.](http://dx.doi.org/10.1021/acsmacrolett.8b00804)

##### License

* pyMacroMS is available free of charge under an MIT License. 
See the LICENCE file for more details.
* pyMacroMS uses the RawFileReader reading tool. Copyright © 2016 by Thermo Fisher Scientific, Inc. All rights reserved.
If you use pyMacroMS, you agree to the license agreement of RawFileReader, of which a copy is provided when installing pyMacroMS. 


##### Changelog

###### 1.1.1
* Now works with IsoSpecPy 2.x, tested with 2.1.4, but does not work with IsoSpecPy 1.x any more.

###### 1.1.0
* Speed improvements for assembling the possible monomer combinations in the polymer simulation. 
  Special thanks to Matthieu Soete for sharing his insights.
* Preparations for a GUI

###### 1.0.9
* Introduced basic support for Scan Filters (limit the imported data to 1 type of scan). Different scan types are detrimental for the averaging algorithm and probably don't make much sense anyway (?) 
* Increase compatibility with Unix systems, installation of pythonnet package seems to be the major struggle though
* MSData class now takes the argument mzOffset, an offset that is added to every m/z value when reading the spectrum. 
* Speed improvements for a large amount of possible compositions
* Minor bugfixes

###### 1.0.0
* Thermo RAW files can now be used as input without any pre-processing
    * By default, all scans are imported separately
    * Scans can be averaged by providing a range of scans or retention times
* New MSData class introduced
    * Handles reading of csv files (previously Spectrum class) and Thermo RAW files
    * Stores all imported spectra and corresponding processed results to allow for batch processing of multiple scans 
    * Post-processing of results still in Spectrum class, so on a per-scan base... Future problem
* Version 1.0.0 and onwards are licensed under an MIT License (rather than a GNU GPL v3.0 for older versions) to comply with the license requirements of Thermo's RawFileReader

###### 0.2.0
* Isobaric species are now pre-filtered, which leads to a significantly improved calculation time
* Introduced the option to define a custom database of monomers/endgroups (with a higher priority than the built-in database)
* Introduced the option to save the output as a PDF report

###### 0.1.2
* Update code to use the new IsoSpecPy 1.9.X API

###### 0.1.1
* Minor fixes to the interfacing with IsoSpecPy
* Fixed compatibility with IsoSpecPy 1.9.X

###### 0.1.0
* Initial release



