![CrowdStrike](https://raw.githubusercontent.com/CrowdStrike/falcon-integration-gateway/main/docs/assets/cs-logo.png)

# falcon-integration-gateway [![Python Lint](https://github.com/CrowdStrike/falcon-integration-gateway/actions/workflows/linting.yml/badge.svg)](https://github.com/CrowdStrike/falcon-integration-gateway/actions/workflows/linting.yml) [![Container Build on Quay](https://quay.io/repository/crowdstrike/falcon-integration-gateway/status "Docker Repository on Quay")](https://quay.io/repository/crowdstrike/falcon-integration-gateway)

Falcon Integration Gateway (FIG) forwards threat detection findings from CrowdStrike Falcon platform to the [backend](fig/backends) of your choice.

Detection findings generated by CrowdStrike Falcon platform inform you about suspicious files and behaviors in your environment. You will see detections on a range of activities from the presence of a bad file (indicator of compromise (IOC)) to a nuanced collection of suspicious behaviors (indicator of attack (IOA)) occurring on one of your hosts or containers. You can learn more about the individual detections in [Falcon documentation](https://falcon.crowdstrike.com/support/documentation/40/mitre-based-falcon-detections-framework).

This project facilitates the export of the individual detections from CrowdStrike Falcon to third-party security dashboards (so called backends). The export is useful in cases where security operation team workflows are tied to given third-party solution to get early real-time heads-up about malicious activities detected by CrowdStrike Falcon platform.

Currently available backends are:

| Backend | Description | Deployment Guide(s) | Developer Guide(s) |
|:--------|:------------|:--------------------|:-------------------|
| AWS | Pushes events to AWS Security Hub | *Coming Soon* | [AWS backend](fig/backends/aws) |
| Azure | Pushes events to Azure Log Analytics | <ul><li>[Deployment to AKS](docs/aks)</li></ul> | [Azure backend](fig/backends/azure) |
| Chronicle | Pushes events to Google Chronicle | <ul><li>[Deployment to GKE](docs/listings/gke-chronicle/UserGuide.md) (using [marketplace](https://console.cloud.google.com/marketplace/product/crowdstrike-saas/falcon-integration-gateway-chronicle))</li><li>[Deployment to GKE](docs/chronicle) (manual)</li></ul> | [Chronicle backend](fig/backends/chronicle) |
| GCP | Pushes events to GCP Security Command Center | <ul><li>[Deployment to GKE](docs/listings/gke/UserGuide.md) (using [marketplace](https://console.cloud.google.com/marketplace/product/crowdstrike-saas/falcon-integration-gateway-scc))</li><li>[Deployment to GKE](docs/gke) (manual)</li></ul> | [GCP backend](fig/backends/gcp) |
| Workspace ONE | Pushes events to VMware Workspace ONE Intelligence | *Coming Soon* | [Workspace ONE backend](fig/backends/workspaceone) |

## Deployment

There are 3 options available for the deployment.

### Installation to kubernetes using the existing deployment guides

Please refer to various deployment guides to the above table.

### Installation to kubernetes using the helm chart

Please refer to [helm chart documentation](https://github.com/CrowdStrike/falcon-helm/tree/main/helm-charts/falcon-integration-gateway)

### Manual Installation and Removal
![PyPI - Status](https://img.shields.io/pypi/status/falcon-integration-gateway)
![PyPI](https://img.shields.io/pypi/v/falcon-integration-gateway)
![PyPI - Wheel](https://img.shields.io/pypi/wheel/falcon-integration-gateway) 
<!--![PyPI - Downloads](https://img.shields.io/pypi/dm/falcon-integration-gateway)-->

Falcon Integration Gateway (FIG) is available on the [Python Package Index](https://pypi.org/project/falcon-integration-gateway/).

### Installation
FIG can be installed with a single command.

```shell
python3 -m pip install falcon-integration-gateway
```
or
```shell
pip3 install falcon-integration-gateway
```

### Upgrades
Upgrading to the latest release is also straightforward.

```shell
python3 -m pip install falcon-integration-gateway --upgrade
```
or
```shell
pip3 install falcon-integration-gateway --upgrade
```

### Removal
To remove Falcon Integration Gateway, execute the following command.

```shell
python3 -m pip uninstall falcon-integration-gateway
```
or
```shell
pip3 uninstall falcon-integration-gateway
```

## Statement of Support
Falcon Integration Gateway (FIG) is an open source project, not CrowdStrike product. As such it carries no formal support, expressed or implied.
