# whylabs-client
WhyLabs API that enables end-to-end AI observability

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1
- Package version: 0.2.0-dev0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://whylabs.ai](https://whylabs.ai)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import whylabs_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import whylabs_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import whylabs_client
from pprint import pprint
from whylabs_client.api import alerts_api
from whylabs_client.model.get_alerts_paths_response import GetAlertsPathsResponse
from whylabs_client.model.segment_tag import SegmentTag
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = whylabs_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with whylabs_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = alerts_api.AlertsApi(api_client)
    org_id = "org-123" # str | Your company's unique organization ID
model_id = "model-123" # str | The unique model ID in your company. The model is created if it doesn't exist already.
start_timestamp = 1577836800000 # int | Start time exclusive
end_timestamp = 1893456000000 # int | 
segment_tags = [
        SegmentTag(
            key="key_example",
            value="value_example",
        ),
    ] # [SegmentTag], none_type | List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
version = "" # str, none_type | the version of the alert in case we have multiple schemas (optional)

    try:
        # Get the alerts for a given time period.
        api_response = api_instance.get_alerts_paths(org_id, model_id, start_timestamp, end_timestamp, segment_tags=segment_tags, version=version)
        pprint(api_response)
    except whylabs_client.ApiException as e:
        print("Exception when calling AlertsApi->get_alerts_paths: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertsApi* | [**get_alerts_paths**](docs/AlertsApi.md#get_alerts_paths) | **GET** /v0/organizations/{org_id}/alerts/models/{model_id}/paths | Get the alerts for a given time period.
*ApiKeyApi* | [**create_api_key**](docs/ApiKeyApi.md#create_api_key) | **POST** /v0/organizations/{org_id}/api-key | Generate an API key for a user.
*ApiKeyApi* | [**get_api_key**](docs/ApiKeyApi.md#get_api_key) | **GET** /v0/organizations/{org_id}/api-key/{key_id} | Get an api key by its id
*ApiKeyApi* | [**list_api_keys**](docs/ApiKeyApi.md#list_api_keys) | **GET** /v0/organizations/{org_id}/api-key | List API key metadata for a given organization and user
*ApiKeyApi* | [**revoke_api_key**](docs/ApiKeyApi.md#revoke_api_key) | **DELETE** /v0/organizations/{org_id}/api-key | Revoke the given API Key, removing its ability to access WhyLabs systems
*EventsApi* | [**get_events_data**](docs/EventsApi.md#get_events_data) | **GET** /v0/organizations/{org_id}/events/models/{model_id}/data | Get the event data as multi-line JSON for a given time period.
*LogApi* | [**log**](docs/LogApi.md#log) | **POST** /v0/organizations/{org_id}/log | Log a dataset profile entry to the backend
*LogApi* | [**log_async**](docs/LogApi.md#log_async) | **POST** /v0/organizations/{org_id}/log/async/{dataset_id} | Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
*LogApi* | [**log_reference**](docs/LogApi.md#log_reference) | **POST** /v0/organizations/{org_id}/log/reference/{model_id} | Returns a presigned URL for uploading the reference profile to.
*ModelsApi* | [**create_model**](docs/ModelsApi.md#create_model) | **POST** /v0/organizations/{org_id}/models | Create a model with a given name and a time period
*ModelsApi* | [**deactivate_model**](docs/ModelsApi.md#deactivate_model) | **DELETE** /v0/organizations/{org_id}/models/{model_id} | Mark a model as inactive
*ModelsApi* | [**get_model**](docs/ModelsApi.md#get_model) | **GET** /v0/organizations/{org_id}/models/{model_id} | Get a model metadata
*ModelsApi* | [**list_models**](docs/ModelsApi.md#list_models) | **GET** /v0/organizations/{org_id}/models | Get a list of all of the model ids for an organization.
*ModelsApi* | [**list_segments**](docs/ModelsApi.md#list_segments) | **GET** /v0/organizations/{org_id}/models/{model_id}/segments | Get a model metadata
*ModelsApi* | [**put_segments**](docs/ModelsApi.md#put_segments) | **PUT** /v0/organizations/{org_id}/models/{model_id}/segments | Add a segment to the dataset
*ModelsApi* | [**update_model**](docs/ModelsApi.md#update_model) | **PUT** /v0/organizations/{org_id}/models/{model_id} | Update a model&#39;s metadata
*SessionsApi* | [**close_session**](docs/SessionsApi.md#close_session) | **POST** /v0/sessions/{session_token}/close | naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
*SessionsApi* | [**create_dataset_profile_upload**](docs/SessionsApi.md#create_dataset_profile_upload) | **POST** /v0/sessions/{session_token}/upload | Create an upload for a given session.
*SessionsApi* | [**create_session**](docs/SessionsApi.md#create_session) | **POST** /v0/sessions | Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
*SessionsApi* | [**get_session**](docs/SessionsApi.md#get_session) | **GET** /v0/sessions/{session_token} | Get information about a session.


## Documentation For Models

 - [AddMembershipRequest](docs/AddMembershipRequest.md)
 - [AlertsPath](docs/AlertsPath.md)
 - [AlertsSummary](docs/AlertsSummary.md)
 - [AsyncLogResponse](docs/AsyncLogResponse.md)
 - [CloseSessionResponse](docs/CloseSessionResponse.md)
 - [CreateSessionResponse](docs/CreateSessionResponse.md)
 - [CreateSessionUploadResponse](docs/CreateSessionUploadResponse.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [EventsPath](docs/EventsPath.md)
 - [EventsSummary](docs/EventsSummary.md)
 - [GetAlertsPathsResponse](docs/GetAlertsPathsResponse.md)
 - [GetDefaultMembershipResponse](docs/GetDefaultMembershipResponse.md)
 - [GetEventsPathResponse](docs/GetEventsPathResponse.md)
 - [GetMembershipsResponse](docs/GetMembershipsResponse.md)
 - [GetNotificationSettingsResponse](docs/GetNotificationSettingsResponse.md)
 - [GetSessionResponse](docs/GetSessionResponse.md)
 - [ListModelsResponse](docs/ListModelsResponse.md)
 - [ListSegmentsResponse](docs/ListSegmentsResponse.md)
 - [ListUserApiKeys](docs/ListUserApiKeys.md)
 - [LogAsyncRequest](docs/LogAsyncRequest.md)
 - [LogReferenceRequest](docs/LogReferenceRequest.md)
 - [LogReferenceResponse](docs/LogReferenceResponse.md)
 - [LogResponse](docs/LogResponse.md)
 - [Membership](docs/Membership.md)
 - [MembershipMetadata](docs/MembershipMetadata.md)
 - [ModelMetadata](docs/ModelMetadata.md)
 - [ModelType](docs/ModelType.md)
 - [MonitorConfig](docs/MonitorConfig.md)
 - [NotificationSettings](docs/NotificationSettings.md)
 - [NotificationSettingsDay](docs/NotificationSettingsDay.md)
 - [NotificationSqsMessageCadence](docs/NotificationSqsMessageCadence.md)
 - [OrganizationMetadata](docs/OrganizationMetadata.md)
 - [OrganizationSummary](docs/OrganizationSummary.md)
 - [ProvidedConfig](docs/ProvidedConfig.md)
 - [ProvisionNewUserRequest](docs/ProvisionNewUserRequest.md)
 - [ProvisionNewUserResponse](docs/ProvisionNewUserResponse.md)
 - [ReferenceProfileItemResponse](docs/ReferenceProfileItemResponse.md)
 - [RemoveMembershipRequest](docs/RemoveMembershipRequest.md)
 - [Role](docs/Role.md)
 - [Segment](docs/Segment.md)
 - [SegmentMetadata](docs/SegmentMetadata.md)
 - [SegmentSummary](docs/SegmentSummary.md)
 - [SegmentTag](docs/SegmentTag.md)
 - [SessionMetadata](docs/SessionMetadata.md)
 - [SetDefaultMembershipRequest](docs/SetDefaultMembershipRequest.md)
 - [SubscriptionTier](docs/SubscriptionTier.md)
 - [TimePeriod](docs/TimePeriod.md)
 - [UberNotificationSchedule](docs/UberNotificationSchedule.md)
 - [User](docs/User.md)
 - [UserApiKey](docs/UserApiKey.md)
 - [UserApiKeyResponse](docs/UserApiKeyResponse.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Author

support@whylabs.ai


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in whylabs_client.apis and whylabs_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from whylabs_client.api.default_api import DefaultApi`
- `from whylabs_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import whylabs_client
from whylabs_client.apis import *
from whylabs_client.models import *
```

