"""
    WhyLabs API client

    WhyLabs API that enables end-to-end AI observability  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: support@whylabs.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whylabs_client.api_client import ApiClient, Endpoint as _Endpoint
from whylabs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whylabs_client.model.get_alerts_paths_response import GetAlertsPathsResponse
from whylabs_client.model.segment_tag import SegmentTag


class AlertsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_alerts_paths(
            self,
            org_id,
            model_id,
            start_timestamp,
            end_timestamp,
            **kwargs
        ):
            """Get the alerts for a given time period.  # noqa: E501

            Get the alerts from a given time period.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_alerts_paths(org_id, model_id, start_timestamp, end_timestamp, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Your company's unique organization ID
                model_id (str): The unique model ID in your company. The model is created if it doesn't exist already.
                start_timestamp (int): Start time exclusive
                end_timestamp (int):

            Keyword Args:
                segment_tags ([SegmentTag], none_type): List of (key, value) pair tags for a segment. Must not contain duplicate values. [optional]
                version (str, none_type): the version of the alert in case we have multiple schemas. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetAlertsPathsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            kwargs['start_timestamp'] = \
                start_timestamp
            kwargs['end_timestamp'] = \
                end_timestamp
            return self.call_with_http_info(**kwargs)

        self.get_alerts_paths = _Endpoint(
            settings={
                'response_type': (GetAlertsPathsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/alerts/models/{model_id}/paths',
                'operation_id': 'get_alerts_paths',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                    'start_timestamp',
                    'end_timestamp',
                    'segment_tags',
                    'version',
                ],
                'required': [
                    'org_id',
                    'model_id',
                    'start_timestamp',
                    'end_timestamp',
                ],
                'nullable': [
                    'segment_tags',
                    'version',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                    'start_timestamp':
                        (int,),
                    'end_timestamp':
                        (int,),
                    'segment_tags':
                        ([SegmentTag], none_type,),
                    'version':
                        (str, none_type,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                    'start_timestamp': 'start_timestamp',
                    'end_timestamp': 'end_timestamp',
                    'segment_tags': 'segment_tags',
                    'version': 'version',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                    'start_timestamp': 'query',
                    'end_timestamp': 'query',
                    'segment_tags': 'query',
                    'version': 'query',
                },
                'collection_format_map': {
                    'segment_tags': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_alerts_paths
        )
