"""
    WhyLabs API client

    WhyLabs API that enables end-to-end AI observability  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: support@whylabs.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whylabs_client.api_client import ApiClient, Endpoint as _Endpoint
from whylabs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whylabs_client.model.list_models_response import ListModelsResponse
from whylabs_client.model.list_segments_response import ListSegmentsResponse
from whylabs_client.model.model_metadata import ModelMetadata
from whylabs_client.model.model_type import ModelType
from whylabs_client.model.segment_metadata import SegmentMetadata
from whylabs_client.model.segment_tag import SegmentTag
from whylabs_client.model.time_period import TimePeriod


class ModelsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_model(
            self,
            org_id,
            model_name,
            time_period,
            **kwargs
        ):
            """Create a model with a given name and a time period  # noqa: E501

            Create a model  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_model(org_id, model_name, time_period, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The organization ID
                model_name (str): The name of a model
                time_period (TimePeriod): The [TimePeriod] for data aggregation/alerting for a model

            Keyword Args:
                model_type (ModelType): The [ModelType] of the dataset. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_name'] = \
                model_name
            kwargs['time_period'] = \
                time_period
            return self.call_with_http_info(**kwargs)

        self.create_model = _Endpoint(
            settings={
                'response_type': (ModelMetadata,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models',
                'operation_id': 'create_model',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_name',
                    'time_period',
                    'model_type',
                ],
                'required': [
                    'org_id',
                    'model_name',
                    'time_period',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_name':
                        (str,),
                    'time_period':
                        (TimePeriod,),
                    'model_type':
                        (ModelType,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_name': 'model_name',
                    'time_period': 'time_period',
                    'model_type': 'model_type',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_name': 'query',
                    'time_period': 'query',
                    'model_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__create_model
        )

        def __deactivate_model(
            self,
            org_id,
            model_id,
            **kwargs
        ):
            """Mark a model as inactive  # noqa: E501

            Mark a model as inactive  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.deactivate_model(org_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The organization ID
                model_id (str): The model ID

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            return self.call_with_http_info(**kwargs)

        self.deactivate_model = _Endpoint(
            settings={
                'response_type': (ModelMetadata,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'deactivate_model',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__deactivate_model
        )

        def __get_model(
            self,
            org_id,
            model_id,
            **kwargs
        ):
            """Get a model metadata  # noqa: E501

            Returns various metadata about a model  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_model(org_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The name of an organization
                model_id (str): The ID of a model

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            return self.call_with_http_info(**kwargs)

        self.get_model = _Endpoint(
            settings={
                'response_type': (ModelMetadata,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'get_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_model
        )

        def __list_models(
            self,
            org_id,
            **kwargs
        ):
            """Get a list of all of the model ids for an organization.  # noqa: E501

            Get a list of all of the model ids for an organization.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_models(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Your company's unique organization ID

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListModelsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        self.list_models = _Endpoint(
            settings={
                'response_type': (ListModelsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models',
                'operation_id': 'list_models',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                ],
                'required': [
                    'org_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                },
                'location_map': {
                    'org_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_models
        )

        def __list_segments(
            self,
            org_id,
            model_id,
            **kwargs
        ):
            """Get a model metadata  # noqa: E501

            Returns the list of Segments for a given model  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_segments(org_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The name of an organization
                model_id (str): The ID of a model

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSegmentsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            return self.call_with_http_info(**kwargs)

        self.list_segments = _Endpoint(
            settings={
                'response_type': (ListSegmentsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}/segments',
                'operation_id': 'list_segments',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_segments
        )

        def __put_segments(
            self,
            org_id,
            model_id,
            segment_tag,
            **kwargs
        ):
            """Add a segment to the dataset  # noqa: E501

            Return 200 if succeeds  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_segments(org_id, model_id, segment_tag, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The name of an organization
                model_id (str): The ID of a model
                segment_tag ([SegmentTag]): List of segment tags to create the segment for

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SegmentMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            kwargs['segment_tag'] = \
                segment_tag
            return self.call_with_http_info(**kwargs)

        self.put_segments = _Endpoint(
            settings={
                'response_type': (SegmentMetadata,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}/segments',
                'operation_id': 'put_segments',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                    'segment_tag',
                ],
                'required': [
                    'org_id',
                    'model_id',
                    'segment_tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                    'segment_tag':
                        ([SegmentTag],),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                    'segment_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_segments
        )

        def __update_model(
            self,
            org_id,
            model_id,
            model_name,
            time_period,
            **kwargs
        ):
            """Update a model's metadata  # noqa: E501

            Update a model's metadata  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_model(org_id, model_id, model_name, time_period, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): The organization ID
                model_id (str): The model ID
                model_name (str): The name of a model
                time_period (TimePeriod): The [TimePeriod] for data aggregation/alerting for a model

            Keyword Args:
                model_type (ModelType): The [ModelType] of the dataset. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            kwargs['model_id'] = \
                model_id
            kwargs['model_name'] = \
                model_name
            kwargs['time_period'] = \
                time_period
            return self.call_with_http_info(**kwargs)

        self.update_model = _Endpoint(
            settings={
                'response_type': (ModelMetadata,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'update_model',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                    'model_name',
                    'time_period',
                    'model_type',
                ],
                'required': [
                    'org_id',
                    'model_id',
                    'model_name',
                    'time_period',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                    'model_name':
                        (str,),
                    'time_period':
                        (TimePeriod,),
                    'model_type':
                        (ModelType,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                    'model_name': 'model_name',
                    'time_period': 'time_period',
                    'model_type': 'model_type',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                    'model_name': 'query',
                    'time_period': 'query',
                    'model_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__update_model
        )
