import abc
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

from jsii.python import classproperty

import aws_cdk.aws_events
import aws_cdk.aws_iam
import aws_cdk.cdk
__jsii_assembly__ = jsii.JSIIAssembly.load("@aws-cdk/aws-ecr", "0.30.0", __name__, "aws-ecr@0.30.0.jsii.tgz")
class CfnRepository(aws_cdk.cdk.CfnResource, metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/aws-ecr.CfnRepository"):
    """A CloudFormation ``AWS::ECR::Repository``.

    See:
        http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html
    cloudformationResource:
        AWS::ECR::Repository
    """
    def __init__(self, scope: aws_cdk.cdk.Construct, id: str, *, lifecycle_policy: typing.Optional[typing.Union[typing.Optional["LifecyclePolicyProperty"], typing.Optional[aws_cdk.cdk.Token]]]=None, repository_name: typing.Optional[str]=None, repository_policy_text: typing.Optional[typing.Union[typing.Optional[typing.Mapping[typing.Any, typing.Any]], typing.Optional[aws_cdk.cdk.Token]]]=None) -> None:
        """Create a new ``AWS::ECR::Repository``.

        Arguments:
            scope: - scope in which this resource is defined.
            id: - scoped id of the resource.
            props: - resource properties.
            lifecyclePolicy: ``AWS::ECR::Repository.LifecyclePolicy``.
            repositoryName: ``AWS::ECR::Repository.RepositoryName``.
            repositoryPolicyText: ``AWS::ECR::Repository.RepositoryPolicyText``.
        """
        props: CfnRepositoryProps = {}

        if lifecycle_policy is not None:
            props["lifecyclePolicy"] = lifecycle_policy

        if repository_name is not None:
            props["repositoryName"] = repository_name

        if repository_policy_text is not None:
            props["repositoryPolicyText"] = repository_policy_text

        jsii.create(CfnRepository, self, [scope, id, props])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(self, properties: typing.Any) -> typing.Mapping[str,typing.Any]:
        """
        Arguments:
            properties: -
        """
        return jsii.invoke(self, "renderProperties", [properties])

    @classproperty
    @jsii.member(jsii_name="resourceTypeName")
    def RESOURCE_TYPE_NAME(cls) -> str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "resourceTypeName")

    @property
    @jsii.member(jsii_name="propertyOverrides")
    def property_overrides(self) -> "CfnRepositoryProps":
        return jsii.get(self, "propertyOverrides")

    @property
    @jsii.member(jsii_name="repositoryArn")
    def repository_arn(self) -> str:
        """
        cloudformationAttribute:
            Arn
        """
        return jsii.get(self, "repositoryArn")

    @property
    @jsii.member(jsii_name="repositoryName")
    def repository_name(self) -> str:
        return jsii.get(self, "repositoryName")

    @jsii.data_type(jsii_type="@aws-cdk/aws-ecr.CfnRepository.LifecyclePolicyProperty", jsii_struct_bases=[])
    class LifecyclePolicyProperty(jsii.compat.TypedDict, total=False):
        """
        See:
            http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html
        """
        lifecyclePolicyText: str
        """``CfnRepository.LifecyclePolicyProperty.LifecyclePolicyText``.

        See:
            http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html#cfn-ecr-repository-lifecyclepolicy-lifecyclepolicytext
        """

        registryId: str
        """``CfnRepository.LifecyclePolicyProperty.RegistryId``.

        See:
            http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html#cfn-ecr-repository-lifecyclepolicy-registryid
        """


@jsii.data_type(jsii_type="@aws-cdk/aws-ecr.CfnRepositoryProps", jsii_struct_bases=[])
class CfnRepositoryProps(jsii.compat.TypedDict, total=False):
    """Properties for defining a ``AWS::ECR::Repository``.

    See:
        http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html
    """
    lifecyclePolicy: typing.Union["CfnRepository.LifecyclePolicyProperty", aws_cdk.cdk.Token]
    """``AWS::ECR::Repository.LifecyclePolicy``.

    See:
        http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-lifecyclepolicy
    """

    repositoryName: str
    """``AWS::ECR::Repository.RepositoryName``.

    See:
        http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositoryname
    """

    repositoryPolicyText: typing.Union[typing.Mapping[typing.Any, typing.Any], aws_cdk.cdk.Token]
    """``AWS::ECR::Repository.RepositoryPolicyText``.

    See:
        http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositorypolicytext
    """

@jsii.enum(jsii_type="@aws-cdk/aws-ecr.CountType")
class CountType(enum.Enum):
    """Select images based on counts."""
    ImageCountMoreThan = "ImageCountMoreThan"
    """Set a limit on the number of images in your repository."""
    SinceImagePushed = "SinceImagePushed"
    """Set an age limit on the images in your repository."""

@jsii.interface(jsii_type="@aws-cdk/aws-ecr.IRepository")
class IRepository(aws_cdk.cdk.IResource, jsii.compat.Protocol):
    """Represents an ECR repository."""
    @staticmethod
    def __jsii_proxy_class__():
        return _IRepositoryProxy

    @property
    @jsii.member(jsii_name="repositoryArn")
    def repository_arn(self) -> str:
        """The ARN of the repository."""
        ...

    @property
    @jsii.member(jsii_name="repositoryName")
    def repository_name(self) -> str:
        """The name of the repository."""
        ...

    @property
    @jsii.member(jsii_name="repositoryUri")
    def repository_uri(self) -> str:
        """The URI of this repository (represents the latest image):.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
        """
        ...

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: aws_cdk.aws_iam.PolicyStatement) -> None:
        """Add a policy statement to the repository's resource policy.

        Arguments:
            statement: -
        """
        ...

    @jsii.member(jsii_name="export")
    def export(self) -> "RepositoryImportProps":
        """Export this repository from the stack."""
        ...

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: aws_cdk.aws_iam.IGrantable, *actions: str) -> aws_cdk.aws_iam.Grant:
        """Grant the given principal identity permissions to perform the actions on this repository.

        Arguments:
            grantee: -
            actions: -
        """
        ...

    @jsii.member(jsii_name="grantPull")
    def grant_pull(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to pull images in this repository.

        Arguments:
            grantee: -
        """
        ...

    @jsii.member(jsii_name="grantPullPush")
    def grant_pull_push(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to pull and push images to this repository.

        Arguments:
            grantee: -
        """
        ...

    @jsii.member(jsii_name="onImagePushed")
    def on_image_pushed(self, name: str, target: typing.Optional[aws_cdk.aws_events.IEventRuleTarget]=None, image_tag: typing.Optional[str]=None) -> aws_cdk.aws_events.EventRule:
        """Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.

        Arguments:
            name: The name of the rule.
            target: An IEventRuleTarget to invoke when this event happens (you can add more targets using ``addTarget``).
            imageTag: Only trigger on the specific image tag.
        """
        ...

    @jsii.member(jsii_name="repositoryUriForTag")
    def repository_uri_for_tag(self, tag: typing.Optional[str]=None) -> str:
        """Returns the URI of the repository for a certain tag. Can be used in ``docker push/pull``.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]

        Arguments:
            tag: Image tag to use (tools usually default to "latest" if omitted).
        """
        ...


class _IRepositoryProxy(jsii.proxy_for(aws_cdk.cdk.IResource)):
    """Represents an ECR repository."""
    __jsii_type__ = "@aws-cdk/aws-ecr.IRepository"
    @property
    @jsii.member(jsii_name="repositoryArn")
    def repository_arn(self) -> str:
        """The ARN of the repository."""
        return jsii.get(self, "repositoryArn")

    @property
    @jsii.member(jsii_name="repositoryName")
    def repository_name(self) -> str:
        """The name of the repository."""
        return jsii.get(self, "repositoryName")

    @property
    @jsii.member(jsii_name="repositoryUri")
    def repository_uri(self) -> str:
        """The URI of this repository (represents the latest image):.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
        """
        return jsii.get(self, "repositoryUri")

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: aws_cdk.aws_iam.PolicyStatement) -> None:
        """Add a policy statement to the repository's resource policy.

        Arguments:
            statement: -
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement])

    @jsii.member(jsii_name="export")
    def export(self) -> "RepositoryImportProps":
        """Export this repository from the stack."""
        return jsii.invoke(self, "export", [])

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: aws_cdk.aws_iam.IGrantable, *actions: str) -> aws_cdk.aws_iam.Grant:
        """Grant the given principal identity permissions to perform the actions on this repository.

        Arguments:
            grantee: -
            actions: -
        """
        return jsii.invoke(self, "grant", [grantee, actions])

    @jsii.member(jsii_name="grantPull")
    def grant_pull(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to pull images in this repository.

        Arguments:
            grantee: -
        """
        return jsii.invoke(self, "grantPull", [grantee])

    @jsii.member(jsii_name="grantPullPush")
    def grant_pull_push(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to pull and push images to this repository.

        Arguments:
            grantee: -
        """
        return jsii.invoke(self, "grantPullPush", [grantee])

    @jsii.member(jsii_name="onImagePushed")
    def on_image_pushed(self, name: str, target: typing.Optional[aws_cdk.aws_events.IEventRuleTarget]=None, image_tag: typing.Optional[str]=None) -> aws_cdk.aws_events.EventRule:
        """Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.

        Arguments:
            name: The name of the rule.
            target: An IEventRuleTarget to invoke when this event happens (you can add more targets using ``addTarget``).
            imageTag: Only trigger on the specific image tag.
        """
        return jsii.invoke(self, "onImagePushed", [name, target, image_tag])

    @jsii.member(jsii_name="repositoryUriForTag")
    def repository_uri_for_tag(self, tag: typing.Optional[str]=None) -> str:
        """Returns the URI of the repository for a certain tag. Can be used in ``docker push/pull``.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]

        Arguments:
            tag: Image tag to use (tools usually default to "latest" if omitted).
        """
        return jsii.invoke(self, "repositoryUriForTag", [tag])


@jsii.data_type(jsii_type="@aws-cdk/aws-ecr.LifecycleRule", jsii_struct_bases=[])
class LifecycleRule(jsii.compat.TypedDict, total=False):
    """An ECR life cycle rule."""
    description: str
    """Describes the purpose of the rule.

    Default:
        No description
    """

    maxImageAgeDays: jsii.Number
    """The maximum age of images to retain.

    Specify exactly one of maxImageCount and maxImageAgeDays.
    """

    maxImageCount: jsii.Number
    """The maximum number of images to retain.

    Specify exactly one of maxImageCount and maxImageAgeDays.
    """

    rulePriority: jsii.Number
    """Controls the order in which rules are evaluated (low to high).

    All rules must have a unique priority, where lower numbers have
    higher precedence. The first rule that matches is applied to an image.

    There can only be one rule with a tagStatus of Any, and it must have
    the highest rulePriority.

    All rules without a specified priority will have incrementing priorities
    automatically assigned to them, higher than any rules that DO have priorities.

    Default:
        Automatically assigned
    """

    tagPrefixList: typing.List[str]
    """Select images that have ALL the given prefixes in their tag.

    Only if tagStatus == TagStatus.Tagged
    """

    tagStatus: "TagStatus"
    """Select images based on tags.

    Only one rule is allowed to select untagged images, and it must
    have the highest rulePriority.

    Default:
        TagStatus.Tagged if tagPrefixList is given, TagStatus.Any otherwise
    """

@jsii.implements(IRepository)
class RepositoryBase(aws_cdk.cdk.Resource, metaclass=jsii.JSIIAbstractClass, jsii_type="@aws-cdk/aws-ecr.RepositoryBase"):
    """Base class for ECR repository.

    Reused between imported repositories and owned repositories.
    """
    @staticmethod
    def __jsii_proxy_class__():
        return _RepositoryBaseProxy

    def __init__(self, scope: aws_cdk.cdk.Construct, id: str) -> None:
        """Creates a new construct node.

        Arguments:
            scope: The scope in which to define this construct.
            id: The scoped construct ID. Must be unique amongst siblings. If the ID includes a path separator (``/``), then it will be replaced by double dash ``--``.
        """
        jsii.create(RepositoryBase, self, [scope, id])

    @jsii.member(jsii_name="arnForLocalRepository")
    @classmethod
    def arn_for_local_repository(cls, repository_name: str, scope: aws_cdk.cdk.IConstruct) -> str:
        """Returns an ECR ARN for a repository that resides in the same account/region as the current stack.

        Arguments:
            repositoryName: -
            scope: -
        """
        return jsii.sinvoke(cls, "arnForLocalRepository", [repository_name, scope])

    @jsii.member(jsii_name="import")
    @classmethod
    def import_(cls, scope: aws_cdk.cdk.Construct, id: str, *, repository_arn: typing.Optional[str]=None, repository_name: typing.Optional[str]=None) -> "IRepository":
        """Import a repository.

        Arguments:
            scope: -
            id: -
            props: -
            repositoryArn: The ARN of the repository to import. At least one of ``repositoryArn`` or ``repositoryName`` is required. Default: If you only have a repository name and the repository is in the same account/region as the current stack, you can set ``repositoryName`` instead and the ARN will be formatted with the current region and account.
            repositoryName: The full name of the repository to import. This is only needed if the repository ARN is not a concrete string, in which case it is impossible to safely parse the ARN and extract full repository names from it if it includes multiple components (e.g. ``foo/bar/myrepo``). If the repository is in the same region/account as the stack, it is sufficient to only specify the repository name.
        """
        props: RepositoryImportProps = {}

        if repository_arn is not None:
            props["repositoryArn"] = repository_arn

        if repository_name is not None:
            props["repositoryName"] = repository_name

        return jsii.sinvoke(cls, "import", [scope, id, props])

    @jsii.member(jsii_name="addToResourcePolicy")
    @abc.abstractmethod
    def add_to_resource_policy(self, statement: aws_cdk.aws_iam.PolicyStatement) -> None:
        """Add a policy statement to the repository's resource policy.

        Arguments:
            statement: -
        """
        ...

    @jsii.member(jsii_name="export")
    @abc.abstractmethod
    def export(self) -> "RepositoryImportProps":
        """Export this repository from the stack."""
        ...

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: aws_cdk.aws_iam.IGrantable, *actions: str) -> aws_cdk.aws_iam.Grant:
        """Grant the given principal identity permissions to perform the actions on this repository.

        Arguments:
            grantee: -
            actions: -
        """
        return jsii.invoke(self, "grant", [grantee, actions])

    @jsii.member(jsii_name="grantPull")
    def grant_pull(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to use the images in this repository.

        Arguments:
            grantee: -
        """
        return jsii.invoke(self, "grantPull", [grantee])

    @jsii.member(jsii_name="grantPullPush")
    def grant_pull_push(self, grantee: aws_cdk.aws_iam.IGrantable) -> aws_cdk.aws_iam.Grant:
        """Grant the given identity permissions to pull and push images to this repository.

        Arguments:
            grantee: -
        """
        return jsii.invoke(self, "grantPullPush", [grantee])

    @jsii.member(jsii_name="onImagePushed")
    def on_image_pushed(self, name: str, target: typing.Optional[aws_cdk.aws_events.IEventRuleTarget]=None, image_tag: typing.Optional[str]=None) -> aws_cdk.aws_events.EventRule:
        """Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.

        Arguments:
            name: The name of the rule.
            target: An IEventRuleTarget to invoke when this event happens (you can add more targets using ``addTarget``).
            imageTag: Only trigger on the specific image tag.
        """
        return jsii.invoke(self, "onImagePushed", [name, target, image_tag])

    @jsii.member(jsii_name="repositoryUriForTag")
    def repository_uri_for_tag(self, tag: typing.Optional[str]=None) -> str:
        """Returns the URL of the repository. Can be used in ``docker push/pull``.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]

        Arguments:
            tag: Optional image tag.
        """
        return jsii.invoke(self, "repositoryUriForTag", [tag])

    @property
    @jsii.member(jsii_name="repositoryArn")
    @abc.abstractmethod
    def repository_arn(self) -> str:
        """The ARN of the repository."""
        ...

    @property
    @jsii.member(jsii_name="repositoryName")
    @abc.abstractmethod
    def repository_name(self) -> str:
        """The name of the repository."""
        ...

    @property
    @jsii.member(jsii_name="repositoryUri")
    def repository_uri(self) -> str:
        """The URI of this repository (represents the latest image):.

        ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
        """
        return jsii.get(self, "repositoryUri")


class _RepositoryBaseProxy(RepositoryBase, jsii.proxy_for(aws_cdk.cdk.Resource)):
    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: aws_cdk.aws_iam.PolicyStatement) -> None:
        """Add a policy statement to the repository's resource policy.

        Arguments:
            statement: -
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement])

    @jsii.member(jsii_name="export")
    def export(self) -> "RepositoryImportProps":
        """Export this repository from the stack."""
        return jsii.invoke(self, "export", [])

    @property
    @jsii.member(jsii_name="repositoryArn")
    def repository_arn(self) -> str:
        """The ARN of the repository."""
        return jsii.get(self, "repositoryArn")

    @property
    @jsii.member(jsii_name="repositoryName")
    def repository_name(self) -> str:
        """The name of the repository."""
        return jsii.get(self, "repositoryName")


class Repository(RepositoryBase, metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/aws-ecr.Repository"):
    """Define an ECR repository."""
    def __init__(self, scope: aws_cdk.cdk.Construct, id: str, *, lifecycle_registry_id: typing.Optional[str]=None, lifecycle_rules: typing.Optional[typing.List["LifecycleRule"]]=None, repository_name: typing.Optional[str]=None, retain: typing.Optional[bool]=None) -> None:
        """
        Arguments:
            scope: -
            id: -
            props: -
            lifecycleRegistryId: The AWS account ID associated with the registry that contains the repository. Default: The default registry is assumed.
            lifecycleRules: Life cycle rules to apply to this registry. Default: No life cycle rules
            repositoryName: Name for this repository. Default: Automatically generated name.
            retain: Retain the repository on stack deletion. If you don't set this to true, the registry must be empty, otherwise your stack deletion will fail. Default: false
        """
        props: RepositoryProps = {}

        if lifecycle_registry_id is not None:
            props["lifecycleRegistryId"] = lifecycle_registry_id

        if lifecycle_rules is not None:
            props["lifecycleRules"] = lifecycle_rules

        if repository_name is not None:
            props["repositoryName"] = repository_name

        if retain is not None:
            props["retain"] = retain

        jsii.create(Repository, self, [scope, id, props])

    @jsii.member(jsii_name="addLifecycleRule")
    def add_lifecycle_rule(self, *, description: typing.Optional[str]=None, max_image_age_days: typing.Optional[jsii.Number]=None, max_image_count: typing.Optional[jsii.Number]=None, rule_priority: typing.Optional[jsii.Number]=None, tag_prefix_list: typing.Optional[typing.List[str]]=None, tag_status: typing.Optional["TagStatus"]=None) -> None:
        """Add a life cycle rule to the repository.

        Life cycle rules automatically expire images from the repository that match
        certain conditions.

        Arguments:
            rule: -
            description: Describes the purpose of the rule. Default: No description
            maxImageAgeDays: The maximum age of images to retain. Specify exactly one of maxImageCount and maxImageAgeDays.
            maxImageCount: The maximum number of images to retain. Specify exactly one of maxImageCount and maxImageAgeDays.
            rulePriority: Controls the order in which rules are evaluated (low to high). All rules must have a unique priority, where lower numbers have higher precedence. The first rule that matches is applied to an image. There can only be one rule with a tagStatus of Any, and it must have the highest rulePriority. All rules without a specified priority will have incrementing priorities automatically assigned to them, higher than any rules that DO have priorities. Default: Automatically assigned
            tagPrefixList: Select images that have ALL the given prefixes in their tag. Only if tagStatus == TagStatus.Tagged
            tagStatus: Select images based on tags. Only one rule is allowed to select untagged images, and it must have the highest rulePriority. Default: TagStatus.Tagged if tagPrefixList is given, TagStatus.Any otherwise
        """
        rule: LifecycleRule = {}

        if description is not None:
            rule["description"] = description

        if max_image_age_days is not None:
            rule["maxImageAgeDays"] = max_image_age_days

        if max_image_count is not None:
            rule["maxImageCount"] = max_image_count

        if rule_priority is not None:
            rule["rulePriority"] = rule_priority

        if tag_prefix_list is not None:
            rule["tagPrefixList"] = tag_prefix_list

        if tag_status is not None:
            rule["tagStatus"] = tag_status

        return jsii.invoke(self, "addLifecycleRule", [rule])

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: aws_cdk.aws_iam.PolicyStatement) -> None:
        """Add a policy statement to the repository's resource policy.

        Arguments:
            statement: -
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement])

    @jsii.member(jsii_name="export")
    def export(self) -> "RepositoryImportProps":
        """Export this repository from the stack."""
        return jsii.invoke(self, "export", [])

    @property
    @jsii.member(jsii_name="repositoryArn")
    def repository_arn(self) -> str:
        """The ARN of the repository."""
        return jsii.get(self, "repositoryArn")

    @property
    @jsii.member(jsii_name="repositoryName")
    def repository_name(self) -> str:
        """The name of the repository."""
        return jsii.get(self, "repositoryName")


@jsii.data_type(jsii_type="@aws-cdk/aws-ecr.RepositoryImportProps", jsii_struct_bases=[])
class RepositoryImportProps(jsii.compat.TypedDict, total=False):
    repositoryArn: str
    """The ARN of the repository to import.

    At least one of ``repositoryArn`` or ``repositoryName`` is required.

    Default:
        If you only have a repository name and the repository is in the same
        account/region as the current stack, you can set ``repositoryName`` instead
        and the ARN will be formatted with the current region and account.
    """

    repositoryName: str
    """The full name of the repository to import.

    This is only needed if the repository ARN is not a concrete string, in which
    case it is impossible to safely parse the ARN and extract full repository
    names from it if it includes multiple components (e.g. ``foo/bar/myrepo``).

    If the repository is in the same region/account as the stack, it is sufficient
    to only specify the repository name.
    """

@jsii.data_type(jsii_type="@aws-cdk/aws-ecr.RepositoryProps", jsii_struct_bases=[])
class RepositoryProps(jsii.compat.TypedDict, total=False):
    lifecycleRegistryId: str
    """The AWS account ID associated with the registry that contains the repository.

    Default:
        The default registry is assumed.

    See:
        https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_PutLifecyclePolicy.html
    """

    lifecycleRules: typing.List["LifecycleRule"]
    """Life cycle rules to apply to this registry.

    Default:
        No life cycle rules
    """

    repositoryName: str
    """Name for this repository.

    Default:
        Automatically generated name.
    """

    retain: bool
    """Retain the repository on stack deletion.

    If you don't set this to true, the registry must be empty, otherwise
    your stack deletion will fail.

    Default:
        false
    """

@jsii.enum(jsii_type="@aws-cdk/aws-ecr.TagStatus")
class TagStatus(enum.Enum):
    """Select images based on tags."""
    Any = "Any"
    """Rule applies to all images."""
    Tagged = "Tagged"
    """Rule applies to tagged images."""
    Untagged = "Untagged"
    """Rule applies to untagged images."""

__all__ = ["CfnRepository", "CfnRepositoryProps", "CountType", "IRepository", "LifecycleRule", "Repository", "RepositoryBase", "RepositoryImportProps", "RepositoryProps", "TagStatus", "__jsii_assembly__"]

publication.publish()
