import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::ECR::Repository`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html
 */
export interface CfnRepositoryProps {
    /**
     * `AWS::ECR::Repository.LifecyclePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-lifecyclepolicy
     */
    readonly lifecyclePolicy?: CfnRepository.LifecyclePolicyProperty | cdk.Token;
    /**
     * `AWS::ECR::Repository.RepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositoryname
     */
    readonly repositoryName?: string;
    /**
     * `AWS::ECR::Repository.RepositoryPolicyText`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html#cfn-ecr-repository-repositorypolicytext
     */
    readonly repositoryPolicyText?: object | cdk.Token;
}
/**
 * A CloudFormation `AWS::ECR::Repository`
 *
 * @cloudformationResource AWS::ECR::Repository
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repository.html
 */
export declare class CfnRepository extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::ECR::Repository";
    /**
     * @cloudformationAttribute Arn
     */
    readonly repositoryArn: string;
    readonly repositoryName: string;
    /**
     * Create a new `AWS::ECR::Repository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRepositoryProps);
    readonly propertyOverrides: CfnRepositoryProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html
     */
    interface LifecyclePolicyProperty {
        /**
         * `CfnRepository.LifecyclePolicyProperty.LifecyclePolicyText`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html#cfn-ecr-repository-lifecyclepolicy-lifecyclepolicytext
         */
        readonly lifecyclePolicyText?: string;
        /**
         * `CfnRepository.LifecyclePolicyProperty.RegistryId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecr-repository-lifecyclepolicy.html#cfn-ecr-repository-lifecyclepolicy-registryid
         */
        readonly registryId?: string;
    }
}
