"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Select images based on tags
 */
var TagStatus;
(function (TagStatus) {
    /**
     * Rule applies to all images
     */
    TagStatus["Any"] = "any";
    /**
     * Rule applies to tagged images
     */
    TagStatus["Tagged"] = "tagged";
    /**
     * Rule applies to untagged images
     */
    TagStatus["Untagged"] = "untagged";
})(TagStatus = exports.TagStatus || (exports.TagStatus = {}));
/**
 * Select images based on counts
 */
var CountType;
(function (CountType) {
    /**
     * Set a limit on the number of images in your repository
     */
    CountType["ImageCountMoreThan"] = "imageCountMoreThan";
    /**
     * Set an age limit on the images in your repository
     */
    CountType["SinceImagePushed"] = "sinceImagePushed";
})(CountType = exports.CountType || (exports.CountType = {}));
//# sourceMappingURL=data:application/json;base64,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