"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gws_generated_1 = require("./gws.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return gws_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GWS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GWS::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new gws_generated_1.RosInstance(this, id, {
            clusterId: props.clusterId,
            systemDiskSize: props.systemDiskSize,
            instanceChargeType: props.instanceChargeType,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            allocatePublicAddress: props.allocatePublicAddress,
            systemDiskCategory: props.systemDiskCategory,
            name: props.name,
            internetChargeType: props.internetChargeType,
            internetMaxBandwidthOut: props.internetMaxBandwidthOut,
            internetMaxBandwidthIn: props.internetMaxBandwidthIn,
            imageId: props.imageId,
            instanceType: props.instanceType,
            appList: props.appList,
            workMode: props.workMode,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrClusterId = rosInstance.attrClusterId;
        this.attrInstanceChargeType = rosInstance.attrInstanceChargeType;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrMaxBandwidthIn = rosInstance.attrMaxBandwidthIn;
        this.attrMaxBandwidthOut = rosInstance.attrMaxBandwidthOut;
        this.attrName = rosInstance.attrName;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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