# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DatasetSchemaUpdateModelChanges(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'add_tables': 'list[TableModel]',
        'add_columns': 'list[DatasetSchemaColumnUpdateModel]'
    }

    attribute_map = {
        'add_tables': 'addTables',
        'add_columns': 'addColumns'
    }

    def __init__(self, add_tables=None, add_columns=None, local_vars_configuration=None):  # noqa: E501
        """DatasetSchemaUpdateModelChanges - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._add_tables = None
        self._add_columns = None
        self.discriminator = None

        if add_tables is not None:
            self.add_tables = add_tables
        if add_columns is not None:
            self.add_columns = add_columns

    @property
    def add_tables(self):
        """Gets the add_tables of this DatasetSchemaUpdateModelChanges.  # noqa: E501


        :return: The add_tables of this DatasetSchemaUpdateModelChanges.  # noqa: E501
        :rtype: list[TableModel]
        """
        return self._add_tables

    @add_tables.setter
    def add_tables(self, add_tables):
        """Sets the add_tables of this DatasetSchemaUpdateModelChanges.


        :param add_tables: The add_tables of this DatasetSchemaUpdateModelChanges.  # noqa: E501
        :type: list[TableModel]
        """

        self._add_tables = add_tables

    @property
    def add_columns(self):
        """Gets the add_columns of this DatasetSchemaUpdateModelChanges.  # noqa: E501


        :return: The add_columns of this DatasetSchemaUpdateModelChanges.  # noqa: E501
        :rtype: list[DatasetSchemaColumnUpdateModel]
        """
        return self._add_columns

    @add_columns.setter
    def add_columns(self, add_columns):
        """Sets the add_columns of this DatasetSchemaUpdateModelChanges.


        :param add_columns: The add_columns of this DatasetSchemaUpdateModelChanges.  # noqa: E501
        :type: list[DatasetSchemaColumnUpdateModel]
        """

        self._add_columns = add_columns

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetSchemaUpdateModelChanges):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatasetSchemaUpdateModelChanges):
            return True

        return self.to_dict() != other.to_dict()
