# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotExportResponseModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'snapshot': 'SnapshotModel',
        'validated_primary_keys': 'bool',
        'format': 'SnapshotExportResponseModelFormat'
    }

    attribute_map = {
        'snapshot': 'snapshot',
        'validated_primary_keys': 'validatedPrimaryKeys',
        'format': 'format'
    }

    def __init__(self, snapshot=None, validated_primary_keys=None, format=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotExportResponseModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._snapshot = None
        self._validated_primary_keys = None
        self._format = None
        self.discriminator = None

        if snapshot is not None:
            self.snapshot = snapshot
        if validated_primary_keys is not None:
            self.validated_primary_keys = validated_primary_keys
        if format is not None:
            self.format = format

    @property
    def snapshot(self):
        """Gets the snapshot of this SnapshotExportResponseModel.  # noqa: E501


        :return: The snapshot of this SnapshotExportResponseModel.  # noqa: E501
        :rtype: SnapshotModel
        """
        return self._snapshot

    @snapshot.setter
    def snapshot(self, snapshot):
        """Sets the snapshot of this SnapshotExportResponseModel.


        :param snapshot: The snapshot of this SnapshotExportResponseModel.  # noqa: E501
        :type: SnapshotModel
        """

        self._snapshot = snapshot

    @property
    def validated_primary_keys(self):
        """Gets the validated_primary_keys of this SnapshotExportResponseModel.  # noqa: E501


        :return: The validated_primary_keys of this SnapshotExportResponseModel.  # noqa: E501
        :rtype: bool
        """
        return self._validated_primary_keys

    @validated_primary_keys.setter
    def validated_primary_keys(self, validated_primary_keys):
        """Sets the validated_primary_keys of this SnapshotExportResponseModel.


        :param validated_primary_keys: The validated_primary_keys of this SnapshotExportResponseModel.  # noqa: E501
        :type: bool
        """

        self._validated_primary_keys = validated_primary_keys

    @property
    def format(self):
        """Gets the format of this SnapshotExportResponseModel.  # noqa: E501


        :return: The format of this SnapshotExportResponseModel.  # noqa: E501
        :rtype: SnapshotExportResponseModelFormat
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this SnapshotExportResponseModel.


        :param format: The format of this SnapshotExportResponseModel.  # noqa: E501
        :type: SnapshotExportResponseModelFormat
        """

        self._format = format

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotExportResponseModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotExportResponseModel):
            return True

        return self.to_dict() != other.to_dict()
