# wstompy
Using a transport agnostic protocol and websocket-client to speak STOMP over websocket.

## Features

### Yes
* [STOMP 1.2](https://stomp.github.io/stomp-specification-1.2.html)
* Websocket with SSL/TLS(wss://) from websocket-client
* Verbose socket logging thanks to websocket-client `websocket.enableTrace(True)` 
* Custom headers for transport and protocol

### No
* A non-websocket client

### No, until added
* STOMP versions before 1.2 
* Data Classes/Models
* Ready for production

## Instructions

### Install
`pip install wstompy`

### Usage
```python
import websocket
from wstompy.connection import WebSocketStompClient

websocket.enableTrace(True)

access_token = 'tokentokentoken'
host = 'localhost'
url = f'ws://{host}:8080/ws/websocket'
client = WebSocketStompClient(
    header_host=host,
    socket_url=url,
    custom_headers={'Authorization': f'Bearer {access_token}'},
    subprotocols=['v12.stomp']
)
client.run_forever(suppress_origin=True)
```

### Collaboration
* Submit polite and/or well-written tickets for issues.
* Fork and submit PRs referencing issues.
* Uses poetry because they were early with pyproject.toml implementation which is neater when publishing.
* Testing, feedback and reporting on usage with different server implementations.
* Code is expected to have been run through black before commits, see Makefile.

## Family, extended relatives and inspirations
* [stomp.py](https://github.com/jasonrbriggs/stomp.py) - tried but its run loop was too sticky using dunders, preventing an easy merge with websocket-client's run loop.
* [stomper](https://github.com/oisinmulvihill/stomper) - didn't have STOMP 1.2 implemented and I figured it was just as easy to reimplement to have the possibility of adding custom headers.
* [stompest](https://github.com/nikipore/stompest) - didn't try it, but has async support in its packaged client. 

## Developing
* `flake8 wstompy/` config in .flake8 until they support pyproject.toml
* `mypy wstompy/` config in pyproject.toml
* `black wstompy/` config in pyproject.toml

## Notes
* This has initially been implemented using [Spring Framework's STOMP server](https://spring.io/guides/gs/messaging-stomp-websocket/) with and without SockJS.
