<a id="mypy-boto3-devops-guru"></a>

# mypy-boto3-devops-guru

[![PyPI - mypy-boto3-devops-guru](https://img.shields.io/pypi/v/mypy-boto3-devops-guru.svg?color=blue)](https://pypi.org/project/mypy-boto3-devops-guru)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-devops-guru.svg?color=blue)](https://pypi.org/project/mypy-boto3-devops-guru)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-devops-guru?color=blue)](https://pypistats.org/packages/mypy-boto3-devops-guru)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DevOpsGuru 1.17.106](https://boto3.amazonaws.com/v1/documentation/api/1.17.106/reference/services/devops-guru.html#DevOpsGuru)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-devops-guru docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_devops_guru/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-devops-guru](#mypy-boto3-devops-guru)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `DevOpsGuru` service.

```bash
python -m pip install boto3-stubs[devops-guru]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[devops-guru]` in your environment:
  `python -m pip install 'boto3-stubs[devops-guru]'`

Both type checking and auto-complete should work for `DevOpsGuru` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[devops-guru]` in your environment:
  `python -m pip install 'boto3-stubs[devops-guru]'`

Both type checking and auto-complete should work for `DevOpsGuru` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[devops-guru]` in your environment:
  `python -m pip install 'boto3-stubs[devops-guru]'`
- Run `mypy` as usual

Type checking should work for `DevOpsGuru` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[devops-guru]` in your environment:
  `python -m pip install 'boto3-stubs[devops-guru]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DevOpsGuru` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`DevOpsGuruClient` provides annotations for `boto3.client("devops-guru")`.

```python
import boto3

from mypy_boto3_devops_guru import DevOpsGuruClient

client: DevOpsGuruClient = boto3.client("devops-guru")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DevOpsGuruClient = session.client("devops-guru")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_devops_guru.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_devops_guru import DevOpsGuruClient
from mypy_boto3_devops_guru.paginator import (
    DescribeResourceCollectionHealthPaginator,
    GetCostEstimationPaginator,
    GetResourceCollectionPaginator,
    ListAnomaliesForInsightPaginator,
    ListEventsPaginator,
    ListInsightsPaginator,
    ListNotificationChannelsPaginator,
    ListRecommendationsPaginator,
    SearchInsightsPaginator,
)

client: DevOpsGuruClient = boto3.client("devops-guru")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_resource_collection_health_paginator: DescribeResourceCollectionHealthPaginator = client.get_paginator("describe_resource_collection_health")
get_cost_estimation_paginator: GetCostEstimationPaginator = client.get_paginator("get_cost_estimation")
get_resource_collection_paginator: GetResourceCollectionPaginator = client.get_paginator("get_resource_collection")
list_anomalies_for_insight_paginator: ListAnomaliesForInsightPaginator = client.get_paginator("list_anomalies_for_insight")
list_events_paginator: ListEventsPaginator = client.get_paginator("list_events")
list_insights_paginator: ListInsightsPaginator = client.get_paginator("list_insights")
list_notification_channels_paginator: ListNotificationChannelsPaginator = client.get_paginator("list_notification_channels")
list_recommendations_paginator: ListRecommendationsPaginator = client.get_paginator("list_recommendations")
search_insights_paginator: SearchInsightsPaginator = client.get_paginator("search_insights")
```

<a id="literals"></a>

### Literals

`mypy_boto3_devops_guru.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_devops_guru.literals import (
    AnomalySeverityType,
    AnomalyStatusType,
    CloudWatchMetricsStatType,
    CostEstimationServiceResourceStateType,
    CostEstimationStatusType,
    DescribeResourceCollectionHealthPaginatorName,
    EventClassType,
    EventDataSourceType,
    GetCostEstimationPaginatorName,
    GetResourceCollectionPaginatorName,
    InsightFeedbackOptionType,
    InsightSeverityType,
    InsightStatusType,
    InsightTypeType,
    ListAnomaliesForInsightPaginatorName,
    ListEventsPaginatorName,
    ListInsightsPaginatorName,
    ListNotificationChannelsPaginatorName,
    ListRecommendationsPaginatorName,
    LocaleType,
    OptInStatusType,
    ResourceCollectionTypeType,
    SearchInsightsPaginatorName,
    ServiceNameType,
    UpdateResourceCollectionActionType,
)

def check_value(value: AnomalySeverityType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_devops_guru.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_devops_guru.type_defs import (
    AddNotificationChannelRequestRequestTypeDef,
    AddNotificationChannelResponseTypeDef,
    AnomalySourceDetailsTypeDef,
    AnomalyTimeRangeTypeDef,
    CloudFormationCollectionFilterTypeDef,
    CloudFormationCollectionTypeDef,
    CloudFormationCostEstimationResourceCollectionFilterTypeDef,
    CloudFormationHealthTypeDef,
    CloudWatchMetricsDetailTypeDef,
    CloudWatchMetricsDimensionTypeDef,
    CostEstimationResourceCollectionFilterTypeDef,
    CostEstimationTimeRangeTypeDef,
    DescribeAccountHealthResponseTypeDef,
    DescribeAccountOverviewRequestRequestTypeDef,
    DescribeAccountOverviewResponseTypeDef,
    DescribeAnomalyRequestRequestTypeDef,
    DescribeAnomalyResponseTypeDef,
    DescribeFeedbackRequestRequestTypeDef,
    DescribeFeedbackResponseTypeDef,
    DescribeInsightRequestRequestTypeDef,
    DescribeInsightResponseTypeDef,
    DescribeResourceCollectionHealthRequestRequestTypeDef,
    DescribeResourceCollectionHealthResponseTypeDef,
    DescribeServiceIntegrationResponseTypeDef,
    EndTimeRangeTypeDef,
    EventResourceTypeDef,
    EventTimeRangeTypeDef,
    EventTypeDef,
    GetCostEstimationRequestRequestTypeDef,
    GetCostEstimationResponseTypeDef,
    GetResourceCollectionRequestRequestTypeDef,
    GetResourceCollectionResponseTypeDef,
    InsightFeedbackTypeDef,
    InsightHealthTypeDef,
    InsightTimeRangeTypeDef,
    ListAnomaliesForInsightRequestRequestTypeDef,
    ListAnomaliesForInsightResponseTypeDef,
    ListEventsFiltersTypeDef,
    ListEventsRequestRequestTypeDef,
    ListEventsResponseTypeDef,
    ListInsightsAnyStatusFilterTypeDef,
    ListInsightsClosedStatusFilterTypeDef,
    ListInsightsOngoingStatusFilterTypeDef,
    ListInsightsRequestRequestTypeDef,
    ListInsightsResponseTypeDef,
    ListInsightsStatusFilterTypeDef,
    ListNotificationChannelsRequestRequestTypeDef,
    ListNotificationChannelsResponseTypeDef,
    ListRecommendationsRequestRequestTypeDef,
    ListRecommendationsResponseTypeDef,
    NotificationChannelConfigTypeDef,
    NotificationChannelTypeDef,
    OpsCenterIntegrationConfigTypeDef,
    OpsCenterIntegrationTypeDef,
    PaginatorConfigTypeDef,
    PredictionTimeRangeTypeDef,
    ProactiveAnomalySummaryTypeDef,
    ProactiveAnomalyTypeDef,
    ProactiveInsightSummaryTypeDef,
    ProactiveInsightTypeDef,
    PutFeedbackRequestRequestTypeDef,
    ReactiveAnomalySummaryTypeDef,
    ReactiveAnomalyTypeDef,
    ReactiveInsightSummaryTypeDef,
    ReactiveInsightTypeDef,
    RecommendationRelatedAnomalyResourceTypeDef,
    RecommendationRelatedAnomalySourceDetailTypeDef,
    RecommendationRelatedAnomalyTypeDef,
    RecommendationRelatedCloudWatchMetricsSourceDetailTypeDef,
    RecommendationRelatedEventResourceTypeDef,
    RecommendationRelatedEventTypeDef,
    RecommendationTypeDef,
    RemoveNotificationChannelRequestRequestTypeDef,
    ResourceCollectionFilterTypeDef,
    ResourceCollectionTypeDef,
    ResponseMetadataTypeDef,
    SearchInsightsFiltersTypeDef,
    SearchInsightsRequestRequestTypeDef,
    SearchInsightsResponseTypeDef,
    ServiceCollectionTypeDef,
    ServiceHealthTypeDef,
    ServiceInsightHealthTypeDef,
    ServiceIntegrationConfigTypeDef,
    ServiceResourceCostTypeDef,
    SnsChannelConfigTypeDef,
    StartCostEstimationRequestRequestTypeDef,
    StartTimeRangeTypeDef,
    UpdateCloudFormationCollectionFilterTypeDef,
    UpdateResourceCollectionFilterTypeDef,
    UpdateResourceCollectionRequestRequestTypeDef,
    UpdateServiceIntegrationConfigTypeDef,
    UpdateServiceIntegrationRequestRequestTypeDef,
)

def get_structure() -> AddNotificationChannelRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-devops-guru` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-devops-guru docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_devops_guru/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
