# mypy-boto3-dataexchange

[![PyPI - mypy-boto3-dataexchange](https://img.shields.io/pypi/v/mypy-boto3-dataexchange.svg?color=blue)](https://pypi.org/project/mypy-boto3-dataexchange)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dataexchange.svg?color=blue)](https://pypi.org/project/mypy-boto3-dataexchange)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-dataexchange](#mypy-boto3-dataexchange)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.DataExchange 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/dataexchange.html#DataExchange) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-dataexchange](#mypy-boto3-dataexchange)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DataExchange` service.

```bash
python -m pip install boto3-stubs[dataexchange]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_dataexchange` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_dataexchange import DataExchangeClient

# Now mypy can check if your code is valid.
client: DataExchangeClient = boto3.client("dataexchange")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataExchangeClient = session.client("dataexchange")



# Annotated paginators are included as well

import mypy_boto3_dataexchange.paginator as dataexchange_paginators

list_data_set_revisions_paginator: dataexchange_paginators.ListDataSetRevisionsPaginator = client.get_paginator("list_data_set_revisions")
list_data_sets_paginator: dataexchange_paginators.ListDataSetsPaginator = client.get_paginator("list_data_sets")
list_jobs_paginator: dataexchange_paginators.ListJobsPaginator = client.get_paginator("list_jobs")
list_revision_assets_paginator: dataexchange_paginators.ListRevisionAssetsPaginator = client.get_paginator("list_revision_assets")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_dataexchange` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_dataexchange as dataexchange
from mypy_boto3_dataexchange import DataExchangeClient

# with these
from mypy_boto3 import dataexchange
from mypy_boto3.dataexchange import DataExchangeClient
```