# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = [
    'SecurityFirewallRule',
    'GetNodesNodeResult',
    'GetPluginsCommunityPluginResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class SecurityFirewallRule(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None,
                 ports: Optional[List[float]] = None,
                 services: Optional[List[str]] = None):
        """
        :param str ip: Source ip and netmask for the rule. (e.g. 10.56.72.0/24)
        :param str description: Description name of the rule. e.g. Default.
        :param List[float] ports: Custom ports to be opened
        :param List[str] services: Pre-defined service ports
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        Source ip and netmask for the rule. (e.g. 10.56.72.0/24)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description name of the rule. e.g. Default.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ports(self) -> Optional[List[float]]:
        """
        Custom ports to be opened
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def services(self) -> Optional[List[str]]:
        """
        Pre-defined service ports
        """
        return pulumi.get(self, "services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetNodesNodeResult(dict):
    def __init__(__self__, *,
                 erlang_version: str,
                 hipe: bool,
                 hostname: str,
                 name: str,
                 rabbitmq_version: str,
                 running: bool):
        pulumi.set(__self__, "erlang_version", erlang_version)
        pulumi.set(__self__, "hipe", hipe)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rabbitmq_version", rabbitmq_version)
        pulumi.set(__self__, "running", running)

    @property
    @pulumi.getter(name="erlangVersion")
    def erlang_version(self) -> str:
        return pulumi.get(self, "erlang_version")

    @property
    @pulumi.getter
    def hipe(self) -> bool:
        return pulumi.get(self, "hipe")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rabbitmqVersion")
    def rabbitmq_version(self) -> str:
        return pulumi.get(self, "rabbitmq_version")

    @property
    @pulumi.getter
    def running(self) -> bool:
        return pulumi.get(self, "running")


@pulumi.output_type
class GetPluginsCommunityPluginResult(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 require: Optional[str] = None):
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require is not None:
            pulumi.set(__self__, "require", require)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def require(self) -> Optional[str]:
        return pulumi.get(self, "require")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


