/**
 * Copyright (c) 2021, Ouster, Inc.
 * All rights reserved.
 *
 * "Expected" sensor_info structs generated using dump_sensor_info
 *
 * This will need to be updated when sensor_info changes, or when new testcases
 * are added to the test data in gcs.
 */

#pragma once

#include <Eigen/Core>
#include <array>
#include <map>
#include <string>

#include "ouster/types.h"

namespace ouster {
namespace testing {

inline mat4d mkmat4d(const std::array<double, 16>& v) {
    return Eigen::Map<const mat4d>(v.data()).transpose();
}

using namespace ouster::sensor;

// clang-format off
static sensor_info si_1_12_os1_991913000010_64 = {
    "",
    "991913000010",
    "v1.12.0",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.073, 0.904, -1.261, -3.384, 3.048, 0.9, -1.235, -3.335, 3.029, 0.915, -1.2, -3.301, 3.026, 0.921, -1.179, -3.268, 3.032, 0.933, -1.156, -3.23, 3.028, 0.953, -1.131, -3.209, 3.059, 0.976, -1.112, -3.182, 3.071, 0.99, -1.087, -3.155, 3.097, 1.014, -1.103, -3.133, 3.118, 1.035, -1.039, -3.116, 3.144, 1.061, -1.013, -3.101, 3.178, 1.092, -0.993, -3.089, 3.217, 1.125, -0.972, -3.072, 3.265, 1.159, -0.949, -3.066, 3.321, 1.204, -0.921, -3.055, 3.381, 1.252, -0.898, -3.071},
    {16.729, 16.118, 15.543, 14.995, 14.526, 13.937, 13.381, 12.837, 12.378, 11.801, 11.251, 10.704, 10.251, 9.693, 9.138, 8.603, 8.149, 7.594, 7.049, 6.513, 6.056, 5.504, 4.961, 4.419, 3.967, 3.424, 2.881, 2.328, 1.88, 1.337, 0.787, 0.239, -0.205, -0.756, -1.39, -1.854, -2.3, -2.839, -3.386, -3.935, -4.391, -4.929, -5.472, -6.028, -6.471, -7.02, -7.563, -8.116, -8.572, -9.112, -9.66, -10.227, -10.687, -11.226, -11.777, -12.35, -12.807, -13.347, -13.902, -14.49, -14.968, -15.504, -16.078, -16.679},
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_12_os1_991937000062_16A0_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.12.0",
    MODE_1024x10,
    "OS-1-16-A0",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.041, 0.895, -1.255, -3.387, 3.024, 0.897, -1.223, -3.326, 3.032, 0.916, -1.189, -3.288, 3.014, 0.926, -1.175, -3.243, 3.024, 0.956, -1.138, -3.206, 3.04, 0.958, -1.13, -3.183, 3.06, 0.991, -1.095, -3.159, 3.079, 1.003, -1.064, -3.129, 3.105, 1.037, -1.09, -3.1, 3.155, 1.06, -1.007, -3.083, 3.166, 1.087, -1.014, -3.067, 3.215, 1.11, -0.96, -3.048, 3.228, 1.145, -0.936, -3.04, 3.29, 1.188, -0.917, -3.037, 3.331, 1.222, -0.895, -3.043, 3.4, 1.265, -0.884, -3.041, },
    {16.509, 15.91, 15.345, 14.799, 14.329, 13.747, 13.185, 12.648, 12.192, 11.624, 11.081, 10.537, 10.083, 9.525, 8.97, 8.442, 7.984, 7.429, 6.892, 6.357, 5.899, 5.349, 4.811, 4.262, 3.828, 3.257, 2.726, 2.183, 1.733, 1.186, 0.64, 0.1, -0.349, -0.893, -1.499, -1.991, -2.444, -2.983, -3.532, -4.079, -4.53, -5.065, -5.642, -6.168, -6.616, -7.179, -7.708, -8.275, -8.707, -9.248, -9.8, -10.373, -10.836, -11.368, -11.92, -12.489, -12.966, -13.516, -14.077, -14.658, -15.121, -15.684, -16.238, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_12_os1_991937000062_64_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.12.0",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.041, 0.895, -1.255, -3.387, 3.024, 0.897, -1.223, -3.326, 3.032, 0.916, -1.189, -3.288, 3.014, 0.926, -1.175, -3.243, 3.024, 0.956, -1.138, -3.206, 3.04, 0.958, -1.13, -3.183, 3.06, 0.991, -1.095, -3.159, 3.079, 1.003, -1.064, -3.129, 3.105, 1.037, -1.09, -3.1, 3.155, 1.06, -1.007, -3.083, 3.166, 1.087, -1.014, -3.067, 3.215, 1.11, -0.96, -3.048, 3.228, 1.145, -0.936, -3.04, 3.29, 1.188, -0.917, -3.037, 3.331, 1.222, -0.895, -3.043, 3.4, 1.265, -0.884, -3.041, },
    {16.509, 15.91, 15.345, 14.799, 14.329, 13.747, 13.185, 12.648, 12.192, 11.624, 11.081, 10.537, 10.083, 9.525, 8.97, 8.442, 7.984, 7.429, 6.892, 6.357, 5.899, 5.349, 4.811, 4.262, 3.828, 3.257, 2.726, 2.183, 1.733, 1.186, 0.64, 0.1, -0.349, -0.893, -1.499, -1.991, -2.444, -2.983, -3.532, -4.079, -4.53, -5.065, -5.642, -6.168, -6.616, -7.179, -7.708, -8.275, -8.707, -9.248, -9.8, -10.373, -10.836, -11.368, -11.92, -12.489, -12.966, -13.516, -14.077, -14.658, -15.121, -15.684, -16.238, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_13_os1_991913000010_64 = {
    "",
    "991913000010",
    "v1.13.0",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.073, 0.904, -1.261, -3.384, 3.048, 0.9, -1.235, -3.335, 3.029, 0.915, -1.2, -3.301, 3.026, 0.921, -1.179, -3.268, 3.032, 0.933, -1.156, -3.23, 3.028, 0.953, -1.131, -3.209, 3.059, 0.976, -1.112, -3.182, 3.071, 0.99, -1.087, -3.155, 3.097, 1.014, -1.103, -3.133, 3.118, 1.035, -1.039, -3.116, 3.144, 1.061, -1.013, -3.101, 3.178, 1.092, -0.993, -3.089, 3.217, 1.125, -0.972, -3.072, 3.265, 1.159, -0.949, -3.066, 3.321, 1.204, -0.921, -3.055, 3.381, 1.252, -0.898, -3.071},
    {16.729, 16.118, 15.543, 14.995, 14.526, 13.937, 13.381, 12.837, 12.378, 11.801, 11.251, 10.704, 10.251, 9.693, 9.138, 8.603, 8.149, 7.594, 7.049, 6.513, 6.056, 5.504, 4.961, 4.419, 3.967, 3.424, 2.881, 2.328, 1.88, 1.337, 0.787, 0.239, -0.205, -0.756, -1.39, -1.854, -2.3, -2.839, -3.386, -3.935, -4.391, -4.929, -5.472, -6.028, -6.471, -7.02, -7.563, -8.116, -8.572, -9.112, -9.66, -10.227, -10.687, -11.226, -11.777, -12.35, -12.807, -13.347, -13.902, -14.49, -14.968, -15.504, -16.078, -16.679},
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_13_os1_991937000062_16A0_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.13.0",
    MODE_1024x10,
    "OS-1-16-A0",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {0, 0, 0, -3.387, 0, 0, 0, -3.326, 0, 0, 0, -3.288, 0, 0, 0, -3.243, 0, 0, 0, -3.206, 0, 0, 0, -3.183, 0, 0, 0, -3.159, 0, 0, 0, -3.129, 0, 0, 0, -3.1, 0, 0, 0, -3.083, 0, 0, 0, -3.067, 0, 0, 0, -3.048, 0, 0, 0, -3.04, 0, 0, 0, -3.037, 0, 0, 0, -3.043, 0, 0, 0, -3.041, },
    {0, 0, 0, 14.799, 0, 0, 0, 12.648, 0, 0, 0, 10.537, 0, 0, 0, 8.442, 0, 0, 0, 6.357, 0, 0, 0, 4.262, 0, 0, 0, 2.183, 0, 0, 0, 0.1, 0, 0, 0, -1.991, 0, 0, 0, -4.079, 0, 0, 0, -6.168, 0, 0, 0, -8.275, 0, 0, 0, -10.373, 0, 0, 0, -12.489, 0, 0, 0, -14.658, 0, 0, 0, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_13_os1_991937000062_32A02_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.13.0",
    MODE_1024x10,
    "OS-1-32-A02",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {0, 0.895, 0, -3.387, 0, 0.897, 0, -3.326, 0, 0.916, 0, -3.288, 0, 0.926, 0, -3.243, 0, 0.956, 0, -3.206, 0, 0.958, 0, -3.183, 0, 0.991, 0, -3.159, 0, 1.003, 0, -3.129, 0, 1.037, 0, -3.1, 0, 1.06, 0, -3.083, 0, 1.087, 0, -3.067, 0, 1.11, 0, -3.048, 0, 1.145, 0, -3.04, 0, 1.188, 0, -3.037, 0, 1.222, 0, -3.043, 0, 1.265, 0, -3.041, },
    {0, 15.91, 0, 14.799, 0, 13.747, 0, 12.648, 0, 11.624, 0, 10.537, 0, 9.525, 0, 8.442, 0, 7.429, 0, 6.357, 0, 5.349, 0, 4.262, 0, 3.257, 0, 2.183, 0, 1.186, 0, 0.1, 0, -0.893, 0, -1.991, 0, -2.983, 0, -4.079, 0, -5.065, 0, -6.168, 0, -7.179, 0, -8.275, 0, -9.248, 0, -10.373, 0, -11.368, 0, -12.489, 0, -13.516, 0, -14.658, 0, -15.684, 0, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_13_os1_991937000062_64_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.13.0",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.041, 0.895, -1.255, -3.387, 3.024, 0.897, -1.223, -3.326, 3.032, 0.916, -1.189, -3.288, 3.014, 0.926, -1.175, -3.243, 3.024, 0.956, -1.138, -3.206, 3.04, 0.958, -1.13, -3.183, 3.06, 0.991, -1.095, -3.159, 3.079, 1.003, -1.064, -3.129, 3.105, 1.037, -1.09, -3.1, 3.155, 1.06, -1.007, -3.083, 3.166, 1.087, -1.014, -3.067, 3.215, 1.11, -0.96, -3.048, 3.228, 1.145, -0.936, -3.04, 3.29, 1.188, -0.917, -3.037, 3.331, 1.222, -0.895, -3.043, 3.4, 1.265, -0.884, -3.041, },
    {16.509, 15.91, 15.345, 14.799, 14.329, 13.747, 13.185, 12.648, 12.192, 11.624, 11.081, 10.537, 10.083, 9.525, 8.97, 8.442, 7.984, 7.429, 6.892, 6.357, 5.899, 5.349, 4.811, 4.262, 3.828, 3.257, 2.726, 2.183, 1.733, 1.186, 0.64, 0.1, -0.349, -0.893, -1.499, -1.991, -2.444, -2.983, -3.532, -4.079, -4.53, -5.065, -5.642, -6.168, -6.616, -7.179, -7.708, -8.275, -8.707, -9.248, -9.8, -10.373, -10.836, -11.368, -11.92, -12.489, -12.966, -13.516, -14.077, -14.658, -15.121, -15.684, -16.238, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_6cccd_os_882002000138_128_legacy = {
    "os-882002000138.local",
    "882002000138",
    "v1.14.0-beta.1-928-g6cccd78",
    MODE_1024x10,
    "OS-0-128",
    {128, 16, 1024, {48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {11.15, 3.677, -3.639, -10.81, 10.7, 3.534, -3.502, -10.41, 10.32, 3.412, -3.384, -10.08, 9.999, 3.307, -3.283, -9.786, 9.72, 3.217, -3.197, -9.537, 9.48, 3.14, -3.122, -9.322, 9.273, 3.074, -3.059, -9.138, 9.096, 3.017, -3.004, -8.981, 8.945, 2.968, -2.957, -8.847, 8.818, 2.927, -2.918, -8.736, 8.711, 2.894, -2.886, -8.643, 8.623, 2.866, -2.86, -8.57, 8.554, 2.844, -2.84, -8.513, 8.501, 2.828, -2.825, -8.472, 8.465, 2.817, -2.815, -8.447, 8.444, 2.811, -2.811, -8.438, 8.438, 2.811, -2.811, -8.444, 8.447, 2.815, -2.817, -8.465, 8.472, 2.825, -2.828, -8.501, 8.513, 2.84, -2.844, -8.554, 8.57, 2.86, -2.866, -8.623, 8.643, 2.886, -2.894, -8.711, 8.736, 2.918, -2.927, -8.818, 8.847, 2.957, -2.968, -8.945, 8.981, 3.004, -3.017, -9.096, 9.138, 3.059, -3.074, -9.273, 9.322, 3.122, -3.14, -9.48, 9.537, 3.197, -3.217, -9.72, 9.786, 3.283, -3.307, -9.999, 10.08, 3.384, -3.412, -10.32, 10.41, 3.502, -3.534, -10.7, 10.81, 3.639, -3.677, -11.15, },
    {46.2, 45.12, 44.36, 43.9, 43.14, 42.09, 41.33, 40.87, 40.11, 39.09, 38.34, 37.86, 37.11, 36.11, 35.37, 34.88, 34.14, 33.16, 32.43, 31.92, 31.19, 30.24, 29.51, 28.99, 28.26, 27.33, 26.61, 26.07, 25.34, 24.44, 23.72, 23.17, 22.45, 21.57, 20.86, 20.29, 19.57, 18.72, 18, 17.42, 16.7, 15.87, 15.16, 14.56, 13.84, 13.04, 12.33, 11.71, 10.99, 10.21, 9.503, 8.862, 8.152, 7.388, 6.684, 6.023, 5.314, 4.572, 3.868, 3.188, 2.479, 1.758, 1.055, 0.3541, -0.3541, -1.055, -1.758, -2.479, -3.188, -3.868, -4.572, -5.314, -6.023, -6.684, -7.388, -8.152, -8.862, -9.503, -10.21, -10.99, -11.71, -12.33, -13.04, -13.84, -14.56, -15.16, -15.87, -16.7, -17.42, -18, -18.72, -19.57, -20.29, -20.86, -21.57, -22.45, -23.17, -23.72, -24.44, -25.34, -26.07, -26.61, -27.33, -28.26, -28.99, -29.51, -30.24, -31.19, -31.92, -32.43, -33.16, -34.14, -34.88, -35.37, -36.11, -37.11, -37.86, -38.34, -39.09, -40.11, -40.87, -41.33, -42.09, -43.14, -43.9, -44.36, -45.12, -46.2, },
    27.67,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_6cccd_os_882002000138_32U0_legacy = {
    "os-882002000138.local",
    "882002000138",
    "v1.14.0-beta.1-928-g6cccd78",
    MODE_1024x10,
    "OS-0-32-U0",
    {32, 16, 1024, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {-10.81, -10.41, -10.08, -9.786, -9.537, -9.322, -9.138, -8.981, -8.847, -8.736, -8.643, -8.57, -8.513, -8.472, -8.447, -8.438, -8.444, -8.465, -8.501, -8.554, -8.623, -8.711, -8.818, -8.945, -9.096, -9.273, -9.48, -9.72, -9.999, -10.32, -10.7, -11.15, },
    {43.9, 40.87, 37.86, 34.88, 31.92, 28.99, 26.07, 23.17, 20.29, 17.42, 14.56, 11.71, 8.862, 6.023, 3.188, 0.3541, -2.479, -5.314, -8.152, -10.99, -13.84, -16.7, -19.57, -22.45, -25.34, -28.26, -31.19, -34.14, -37.11, -40.11, -43.14, -46.2, },
    27.67,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_6cccd_os_882002000138_64U02_legacy = {
    "os-882002000138.local",
    "882002000138",
    "v1.14.0-beta.1-928-g6cccd78",
    MODE_1024x10,
    "OS-0-64-U02",
    {64, 16, 1024, {32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, 32, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.677, -10.81, 3.534, -10.41, 3.412, -10.08, 3.307, -9.786, 3.217, -9.537, 3.14, -9.322, 3.074, -9.138, 3.017, -8.981, 2.968, -8.847, 2.927, -8.736, 2.894, -8.643, 2.866, -8.57, 2.844, -8.513, 2.828, -8.472, 2.817, -8.447, 2.811, -8.438, 2.811, -8.444, 2.815, -8.465, 2.825, -8.501, 2.84, -8.554, 2.86, -8.623, 2.886, -8.711, 2.918, -8.818, 2.957, -8.945, 3.004, -9.096, 3.059, -9.273, 3.122, -9.48, 3.197, -9.72, 3.283, -9.999, 3.384, -10.32, 3.502, -10.7, 3.639, -11.15, },
    {45.12, 43.9, 42.09, 40.87, 39.09, 37.86, 36.11, 34.88, 33.16, 31.92, 30.24, 28.99, 27.33, 26.07, 24.44, 23.17, 21.57, 20.29, 18.72, 17.42, 15.87, 14.56, 13.04, 11.71, 10.21, 8.862, 7.388, 6.023, 4.572, 3.188, 1.758, 0.3541, -1.055, -2.479, -3.868, -5.314, -6.684, -8.152, -9.503, -10.99, -12.33, -13.84, -15.16, -16.7, -18, -19.57, -20.86, -22.45, -23.72, -25.34, -26.61, -28.26, -29.51, -31.19, -32.43, -34.14, -35.37, -37.11, -38.34, -40.11, -41.33, -43.14, -44.36, -46.2, },
    27.67,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_beta_os1_991937000062_16A0_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.14.0-beta.1-87-gde6f92c",
    MODE_1024x10,
    "OS-1-16-A0",
    {16, 16, 1024, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {-3.387, -3.326, -3.288, -3.243, -3.206, -3.183, -3.159, -3.129, -3.1, -3.083, -3.067, -3.048, -3.04, -3.037, -3.043, -3.041, },
    {14.799, 12.648, 10.537, 8.442, 6.357, 4.262, 2.183, 0.1, -1.991, -4.079, -6.168, -8.275, -10.373, -12.489, -14.658, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_beta_os1_991937000062_32A02_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.14.0-beta.1-87-gde6f92c",
    MODE_1024x10,
    "OS-1-32-A02",
    {32, 16, 1024, {12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {0.895, -3.387, 0.897, -3.326, 0.916, -3.288, 0.926, -3.243, 0.956, -3.206, 0.958, -3.183, 0.991, -3.159, 1.003, -3.129, 1.037, -3.1, 1.06, -3.083, 1.087, -3.067, 1.11, -3.048, 1.145, -3.04, 1.188, -3.037, 1.222, -3.043, 1.265, -3.041, },
    {15.91, 14.799, 13.747, 12.648, 11.624, 10.537, 9.525, 8.442, 7.429, 6.357, 5.349, 4.262, 3.257, 2.183, 1.186, 0.1, -0.893, -1.991, -2.983, -4.079, -5.065, -6.168, -7.179, -8.275, -9.248, -10.373, -11.368, -12.489, -13.516, -14.658, -15.684, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_beta_os1_991937000062_64_legacy = {
    "os1-991937000062.local",
    "991937000062",
    "v1.14.0-beta.1-87-gde6f92c",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, {18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, 18, 12, 6, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {3.041, 0.895, -1.255, -3.387, 3.024, 0.897, -1.223, -3.326, 3.032, 0.916, -1.189, -3.288, 3.014, 0.926, -1.175, -3.243, 3.024, 0.956, -1.138, -3.206, 3.04, 0.958, -1.13, -3.183, 3.06, 0.991, -1.095, -3.159, 3.079, 1.003, -1.064, -3.129, 3.105, 1.037, -1.09, -3.1, 3.155, 1.06, -1.007, -3.083, 3.166, 1.087, -1.014, -3.067, 3.215, 1.11, -0.96, -3.048, 3.228, 1.145, -0.936, -3.04, 3.29, 1.188, -0.917, -3.037, 3.331, 1.222, -0.895, -3.043, 3.4, 1.265, -0.884, -3.041, },
    {16.509, 15.91, 15.345, 14.799, 14.329, 13.747, 13.185, 12.648, 12.192, 11.624, 11.081, 10.537, 10.083, 9.525, 8.97, 8.442, 7.984, 7.429, 6.892, 6.357, 5.899, 5.349, 4.811, 4.262, 3.828, 3.257, 2.726, 2.183, 1.733, 1.186, 0.64, 0.1, -0.349, -0.893, -1.499, -1.991, -2.444, -2.983, -3.532, -4.079, -4.53, -5.065, -5.642, -6.168, -6.616, -7.179, -7.708, -8.275, -8.707, -9.248, -9.8, -10.373, -10.836, -11.368, -11.92, -12.489, -12.966, -13.516, -14.077, -14.658, -15.121, -15.684, -16.238, -16.858, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_1_14_beta_os_882004000055_128_legacy = {
    "os-882004000055.local",
    "882004000055",
    "v1.14.0-beta.1-87-gde6f92c",
    MODE_1024x10,
    "OS-0-128",
    {128, 16, 1024, {48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, }, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {11.148, 3.6772, -3.6392, -10.8077, 10.7031, 3.5339, -3.5016, -10.4132, 10.3239, 3.4117, -3.3841, -10.0757, 9.999, 3.3071, -3.2833, -9.7858, 9.72, 3.2172, -3.1968, -9.5365, 9.4799, 3.1399, -3.1224, -9.3221, 9.2734, 3.0736, -3.0585, -9.1381, 9.0964, 3.0167, -3.0039, -8.9808, 8.9453, 2.9683, -2.9574, -8.8474, 8.8175, 2.9275, -2.9184, -8.7356, 8.7108, 2.8935, -2.886, -8.6434, 8.6233, 2.8659, -2.8599, -8.5695, 8.5538, 2.8441, -2.8396, -8.5127, 8.5011, 2.8279, -2.8247, -8.4722, 8.4645, 2.817, -2.8151, -8.4474, 8.4436, 2.8113, -2.8107, -8.4379, 8.4379, 2.8107, -2.8113, -8.4436, 8.4474, 2.8151, -2.817, -8.4645, 8.4722, 2.8247, -2.8279, -8.5011, 8.5127, 2.8396, -2.8441, -8.5538, 8.5695, 2.8599, -2.8659, -8.6233, 8.6434, 2.886, -2.8935, -8.7108, 8.7356, 2.9184, -2.9275, -8.8175, 8.8474, 2.9574, -2.9683, -8.9453, 8.9808, 3.0039, -3.0167, -9.0964, 9.1381, 3.0585, -3.0736, -9.2734, 9.3221, 3.1224, -3.1399, -9.4799, 9.5365, 3.1968, -3.2172, -9.72, 9.7858, 3.2833, -3.3071, -9.999, 10.0757, 3.3841, -3.4117, -10.3239, 10.4132, 3.5016, -3.5339, -10.7031, 10.8077, 3.6392, -3.6772, -11.148, },
    {46.1999, 45.1197, 44.3589, 43.9039, 43.1423, 42.0882, 41.335, 40.8685, 40.1141, 39.0861, 38.34, 37.8611, 37.1134, 36.1115, 35.3719, 34.8799, 34.1384, 33.1623, 32.4287, 31.9227, 31.1868, 30.2361, 29.5079, 28.9872, 28.2564, 27.3307, 26.6073, 26.0712, 25.3449, 24.4438, 23.7246, 23.1723, 22.45, 21.5729, 20.8575, 20.2885, 19.5696, 18.7161, 18.0038, 17.4175, 16.7015, 15.8712, 15.1615, 14.5574, 13.8438, 13.0361, 12.3286, 11.7061, 10.9945, 10.209, 9.5033, 8.8619, 8.1518, 7.3881, 6.6837, 6.023, 5.3139, 4.5717, 3.868, 3.1876, 2.4791, 1.7579, 1.0547, 0.3541, -0.3541, -1.0547, -1.7579, -2.4791, -3.1876, -3.868, -4.5717, -5.3139, -6.023, -6.6837, -7.3881, -8.1518, -8.8619, -9.5033, -10.209, -10.9945, -11.7061, -12.3286, -13.0361, -13.8438, -14.5574, -15.1615, -15.8712, -16.7015, -17.4175, -18.0038, -18.7161, -19.5696, -20.2885, -20.8575, -21.5729, -22.45, -23.1723, -23.7246, -24.4438, -25.3449, -26.0712, -26.6073, -27.3307, -28.2564, -28.9872, -29.5079, -30.2361, -31.1868, -31.9227, -32.4287, -33.1623, -34.1384, -34.8799, -35.3719, -36.1115, -37.1134, -37.8611, -38.34, -39.0861, -40.1141, -40.8685, -41.335, -42.0882, -43.1423, -43.9039, -44.3589, -45.1197, -46.1999, },
    27.67,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_ouster_studio_reduced_config_v1 = {
    "",
    "",
    "",
    MODE_2048x10,
    "",
    {64, 16, 2048, {36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, 36, 24, 12, 0, },  {0, 2047}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {1.5, -4.16, 1.49, -4.15, 1.48, -4.15, 1.47, -4.15, 1.46, -4.16, 1.47, -4.18, 1.45, -4.16, 1.45, -4.18, 1.45, -4.19, 1.43, -4.18, 1.43, -4.2, 1.42, -4.2, 1.41, -4.21, 1.41, -4.22, 1.39, -4.21, 1.4, -4.22, 1.39, -4.25, 1.39, -4.24, 1.39, -4.25, 1.38, -4.26, 1.38, -4.27, 1.37, -4.25, 1.37, -4.27, 1.37, -4.28, 1.36, -4.27, 1.37, -4.27, 1.35, -4.29, 1.35, -4.28, 1.34, -4.3, 1.33, -4.3, 1.32, -4.31, 1.34, -4.31, },
    {21.45, 20.84, 20.21, 19.6, 18.95, 18.34, 17.69, 17.06, 16.38, 15.76, 15.09, 14.43, 13.74, 13.11, 12.41, 11.77, 11.06, 10.4, 9.68, 9.03, 8.31, 7.64, 6.92, 6.26, 5.53, 4.86, 4.14, 3.46, 2.72, 2.06, 1.33, 0.67, -0.08, -0.77, -1.49, -2.16, -2.88, -3.58, -4.29, -4.96, -5.68, -6.36, -7.07, -7.74, -8.45, -9.13, -9.81, -10.5, -11.19, -11.84, -12.53, -13.19, -13.88, -14.53, -15.21, -15.83, -16.52, -17.14, -17.82, -18.43, -19.1, -19.68, -20.33, -20.92, },
    12.163,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_0_rc2_os_992011000121_32U0_legacy = {
    "os-992011000121.local",
    "992011000121",
    "v2.0.0-rc.2",
    MODE_512x10,
    "OS-1-32-U0",
    {32, 16, 512, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, }, {0, 511}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {-4.252, -4.2518, -4.2517, -4.2518, -4.2521, -4.2526, -4.2534, -4.2543, -4.2555, -4.2568, -4.2582, -4.2596, -4.2608, -4.2618, -4.2625, -4.2628, -4.2626, -4.262, -4.2611, -4.2599, -4.2586, -4.2572, -4.2558, -4.2546, -4.2536, -4.2528, -4.2522, -4.2518, -4.2517, -4.2517, -4.2519, -4.2521, },
    {20.5477, 19.2919, 18.0171, 16.7242, 15.4141, 14.088, 12.7466, 11.3909, 10.022, 8.641, 7.249, 5.8474, 4.4377, 3.0216, 1.601, 0.1779, -1.2454, -2.6668, -4.0842, -5.4956, -6.8994, -8.2939, -9.6778, -11.0499, -12.409, -13.754, -15.0841, -16.3982, -17.6955, -18.975, -20.2356, -21.4764, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_0_0_os1_992008000494_128_col_win_legacy = {
    "192.168.87.249",
    "992008000494",
    "v2.0.0",
    MODE_2048x10,
    "OS-1-128",
    {128, 16, 2048, {48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, 48, 32, 16, 0, }, {2014, 2036}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {4.2521, 1.4197, -1.4196, -4.252, 4.2519, 1.4196, -1.4196, -4.2518, 4.2517, 1.4196, -1.4195, -4.2517, 4.2517, 1.4196, -1.4196, -4.2518, 4.2518, 1.4197, -1.4197, -4.2521, 4.2522, 1.4198, -1.4199, -4.2526, 4.2528, 1.4201, -1.4202, -4.2534, 4.2536, 1.4204, -1.4205, -4.2543, 4.2546, 1.4208, -1.421, -4.2555, 4.2558, 1.4213, -1.4215, -4.2568, 4.2572, 1.4219, -1.422, -4.2582, 4.2586, 1.4224, -1.4225, -4.2596, 4.2599, 1.4229, -1.423, -4.2608, 4.2611, 1.4234, -1.4234, -4.2618, 4.262, 1.4237, -1.4237, -4.2625, 4.2626, 1.4239, -1.4239, -4.2628, 4.2628, 1.4239, -1.4239, -4.2626, 4.2625, 1.4237, -1.4237, -4.262, 4.2618, 1.4234, -1.4234, -4.2611, 4.2608, 1.423, -1.4229, -4.2599, 4.2596, 1.4225, -1.4224, -4.2586, 4.2582, 1.422, -1.4219, -4.2572, 4.2568, 1.4215, -1.4213, -4.2558, 4.2555, 1.421, -1.4208, -4.2546, 4.2543, 1.4205, -1.4204, -4.2536, 4.2534, 1.4202, -1.4201, -4.2528, 4.2526, 1.4199, -1.4198, -4.2522, 4.2521, 1.4197, -1.4197, -4.2518, 4.2518, 1.4196, -1.4196, -4.2517, 4.2517, 1.4195, -1.4196, -4.2517, 4.2518, 1.4196, -1.4196, -4.2519, 4.252, 1.4196, -1.4197, -4.2521, },
    {21.4764, 21.1679, 20.8583, 20.5477, 20.2356, 19.9221, 19.6075, 19.2919, 18.975, 18.6567, 18.3375, 18.0171, 17.6955, 17.3729, 17.0492, 16.7242, 16.3982, 16.0716, 15.7437, 15.4141, 15.0841, 14.7537, 14.4218, 14.088, 13.754, 13.4202, 13.0844, 12.7466, 12.409, 12.0718, 11.7326, 11.3909, 11.0499, 10.7097, 10.3671, 10.022, 9.6778, 9.3348, 8.9892, 8.641, 8.2939, 7.9482, 7.5999, 7.249, 6.8994, 6.5512, 6.2005, 5.8474, 5.4956, 5.1452, 4.7925, 4.4377, 4.0842, 3.7318, 3.3775, 3.0216, 2.6668, 2.3127, 1.9573, 1.601, 1.2454, 0.89, 0.5341, 0.1779, -0.1779, -0.5341, -0.89, -1.2454, -1.601, -1.9573, -2.3127, -2.6668, -3.0216, -3.3775, -3.7318, -4.0842, -4.4377, -4.7925, -5.1452, -5.4956, -5.8474, -6.2005, -6.5512, -6.8994, -7.249, -7.5999, -7.9482, -8.2939, -8.641, -8.9892, -9.3348, -9.6778, -10.022, -10.3671, -10.7097, -11.0499, -11.3909, -11.7326, -12.0718, -12.409, -12.7466, -13.0844, -13.4202, -13.754, -14.088, -14.4218, -14.7537, -15.0841, -15.4141, -15.7437, -16.0716, -16.3982, -16.7242, -17.0492, -17.3729, -17.6955, -18.0171, -18.3375, -18.6567, -18.975, -19.2919, -19.6075, -19.9221, -20.2356, -20.5477, -20.8583, -21.1679, -21.4764, },
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1, }),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1, }),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_0_0_os1_991913000010_64 = {
    "",
    "991913000010",
    "v2.0.0",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, { 19, 13, 6, 0, 19, 13, 6, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 20, 14, 7, 1}, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 3.073, 0.904, -1.261, -3.384, 3.048, 0.9, -1.235, -3.335, 3.029, 0.915, -1.2, -3.301, 3.026, 0.921, -1.179, -3.268, 3.032, 0.933, -1.156, -3.23, 3.028, 0.953, -1.131, -3.209, 3.059, 0.976, -1.112, -3.182, 3.071, 0.99, -1.087, -3.155, 3.097, 1.014, -1.103, -3.133, 3.118, 1.035, -1.039, -3.116, 3.144, 1.061, -1.013, -3.101, 3.178, 1.092, -0.993, -3.089, 3.217, 1.125, -0.972, -3.072, 3.265, 1.159, -0.949, -3.066, 3.321, 1.204, -0.921, -3.055, 3.381, 1.252, -0.898, -3.071},
    { 16.729, 16.118, 15.543, 14.995, 14.526, 13.937, 13.381, 12.837, 12.378, 11.801, 11.251, 10.704, 10.251, 9.693, 9.138, 8.603, 8.149, 7.594, 7.049, 6.513, 6.056, 5.504, 4.961, 4.419, 3.967, 3.424, 2.881, 2.328, 1.88, 1.337, 0.787, 0.239, -0.205, -0.756, -1.39, -1.854, -2.3, -2.839, -3.386, -3.935, -4.391, -4.929, -5.472, -6.028, -6.471, -7.02, -7.563, -8.116, -8.572, -9.112, -9.66, -10.227, -10.687, -11.226, -11.777, -12.35, -12.807, -13.347, -13.902, -14.49, -14.968, -15.504, -16.078, -16.679},
    12.163,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1,}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1,}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_1_2_os1_991913000010_64_legacy = {
    "",
    "991913000010",
    "v2.1.2",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, { 19, 13, 6, 0, 19, 13, 6, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 20, 14, 7, 1}, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 3.073, 0.904, -1.261, -3.384, 3.048, 0.9, -1.235, -3.335, 3.029, 0.915, -1.2, -3.301, 3.026, 0.921, -1.179, -3.268, 3.032, 0.933, -1.156, -3.23, 3.028, 0.953, -1.131, -3.209, 3.059, 0.976, -1.112, -3.182, 3.071, 0.99, -1.087, -3.155, 3.097, 1.014, -1.103, -3.133, 3.118, 1.035, -1.039, -3.116, 3.144, 1.061, -1.013, -3.101, 3.178, 1.092, -0.993, -3.089, 3.217, 1.125, -0.972, -3.072, 3.265, 1.159, -0.949, -3.066, 3.321, 1.204, -0.921, -3.055, 3.381, 1.252, -0.898, -3.071},
    { 16.729, 16.118, 15.543, 14.995, 14.526, 13.937, 13.381, 12.837, 12.378, 11.801, 11.251, 10.704, 10.251, 9.693, 9.138, 8.603, 8.149, 7.594, 7.049, 6.513, 6.056, 5.504, 4.961, 4.419, 3.967, 3.424, 2.881, 2.328, 1.88, 1.337, 0.787, 0.239, -0.205, -0.756, -1.39, -1.854, -2.3, -2.839, -3.386, -3.935, -4.391, -4.929, -5.472, -6.028, -6.471, -7.02, -7.563, -8.116, -8.572, -9.112, -9.66, -10.227, -10.687, -11.226, -11.777, -12.35, -12.807, -13.347, -13.902, -14.49, -14.968, -15.504, -16.078, -16.679},
    12.163,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1,}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1,}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_1_2_os1_991913000010_64 = {
    "",
    "991913000010",
    "v2.1.2",
    MODE_1024x10,
    "OS-1-64",
    {64, 16, 1024, { 19, 13, 6, 0, 19, 13, 6, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 19, 13, 7, 1, 20, 14, 7, 1}, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 3.073, 0.904, -1.261, -3.384, 3.048, 0.9, -1.235, -3.335, 3.029, 0.915, -1.2, -3.301, 3.026, 0.921, -1.179, -3.268, 3.032, 0.933, -1.156, -3.23, 3.028, 0.953, -1.131, -3.209, 3.059, 0.976, -1.112, -3.182, 3.071, 0.99, -1.087, -3.155, 3.097, 1.014, -1.103, -3.133, 3.118, 1.035, -1.039, -3.116, 3.144, 1.061, -1.013, -3.101, 3.178, 1.092, -0.993, -3.089, 3.217, 1.125, -0.972, -3.072, 3.265, 1.159, -0.949, -3.066, 3.321, 1.204, -0.921, -3.055, 3.381, 1.252, -0.898, -3.071},
    { 16.729, 16.118, 15.543, 14.995, 14.526, 13.937, 13.381, 12.837, 12.378, 11.801, 11.251, 10.704, 10.251, 9.693, 9.138, 8.603, 8.149, 7.594, 7.049, 6.513, 6.056, 5.504, 4.961, 4.419, 3.967, 3.424, 2.881, 2.328, 1.88, 1.337, 0.787, 0.239, -0.205, -0.756, -1.39, -1.854, -2.3, -2.839, -3.386, -3.935, -4.391, -4.929, -5.472, -6.028, -6.471, -7.02, -7.563, -8.116, -8.572, -9.112, -9.66, -10.227, -10.687, -11.226, -11.777, -12.35, -12.807, -13.347, -13.902, -14.49, -14.968, -15.504, -16.078, -16.679},
    12.163,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1,}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1,}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    0,
    0,
    0,
};

static sensor_info si_2_2_os_992119000444_128_legacy = {
    "",
    "992119000444",
    "v2.2.0-rc.1",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, {24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0}, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {4.26, 1.44, -1.39, -4.22, 4.27, 1.45, -1.38, -4.22, 4.26, 1.45, -1.38, -4.2, 4.25, 1.43, -1.4, -4.22, 4.28, 1.44, -1.4, -4.22, 4.27, 1.45, -1.4, -4.22, 4.27, 1.44, -1.39, -4.24, 4.26, 1.43, -1.39, -4.24, 4.26, 1.44, -1.4, -4.24, 4.25, 1.4, -1.4, -4.25, 4.25, 1.44, -1.41, -4.25, 4.28, 1.42, -1.4, -4.24, 4.26, 1.41, -1.43, -4.25, 4.26, 1.41, -1.42, -4.24, 4.24, 1.43, -1.42, -4.26, 4.27, 1.42, -1.42, -4.27, 4.26, 1.41, -1.45, -4.24, 4.24, 1.42, -1.41, -4.24, 4.25, 1.42, -1.43, -4.25, 4.27, 1.39, -1.43, -4.26, 4.23, 1.39, -1.44, -4.27, 4.26, 1.41, -1.43, -4.26, 4.24, 1.4, -1.42, -4.28, 4.24, 1.42, -1.43, -4.26, 4.24, 1.4, -1.43, -4.26, 4.22, 1.4, -1.43, -4.27, 4.24, 1.41, -1.44, -4.28, 4.24, 1.4, -1.45, -4.29, 4.23, 1.39, -1.45, -4.27, 4.22, 1.38, -1.45, -4.27, 4.2, 1.39, -1.45, -4.29, 4.22, 1.39, -1.45, -4.29},
    {21.51, 21.18, 20.87, 20.57, 20.26, 19.94, 19.63, 19.32, 19.01, 18.68, 18.35, 18.05, 17.72, 17.38, 17.06, 16.74, 16.42, 16.09, 15.76, 15.44, 15.09, 14.77, 14.43, 14.1, 13.75, 13.42, 13.1, 12.77, 12.41, 12.06, 11.73, 11.4, 11.04, 10.71, 10.36, 10.03, 9.67, 9.32, 9.01, 8.65, 8.28, 7.94, 7.59, 7.26, 6.91, 6.53, 6.21, 5.87, 5.5, 5.15, 4.8, 4.46, 4.11, 3.74, 3.39, 3.06, 2.68, 2.34, 1.99, 1.62, 1.27, 0.92, 0.58, 0.21, -0.14, -0.5, -0.86, -1.18, -1.55, -1.91, -2.25, -2.59, -2.98, -3.33, -3.68, -4.01, -4.38, -4.74, -5.08, -5.44, -5.8, -6.14, -6.48, -6.83, -7.19, -7.54, -7.88, -8.22, -8.59, -8.94, -9.26, -9.63, -9.97, -10.3, -10.65, -10.97, -11.33, -11.68, -12.02, -12.36, -12.72, -13.06, -13.37, -13.7, -14.05, -14.39, -14.71, -15.06, -15.39, -15.72, -16.04, -16.38, -16.7, -17.03, -17.34, -17.67, -18.01, -18.33, -18.64, -18.93, -19.29, -19.59, -19.89, -20.2, -20.51, -20.82, -21.14, -21.44},
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    7109745,
    7502,
    7503,
};

static sensor_info si_2_2_os_992119000444_128 = {
    "",
    "992119000444",
    "v2.2.0-rc.1",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, {24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0}, {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    {4.26, 1.44, -1.39, -4.22, 4.27, 1.45, -1.38, -4.22, 4.26, 1.45, -1.38, -4.2, 4.25, 1.43, -1.4, -4.22, 4.28, 1.44, -1.4, -4.22, 4.27, 1.45, -1.4, -4.22, 4.27, 1.44, -1.39, -4.24, 4.26, 1.43, -1.39, -4.24, 4.26, 1.44, -1.4, -4.24, 4.25, 1.4, -1.4, -4.25, 4.25, 1.44, -1.41, -4.25, 4.28, 1.42, -1.4, -4.24, 4.26, 1.41, -1.43, -4.25, 4.26, 1.41, -1.42, -4.24, 4.24, 1.43, -1.42, -4.26, 4.27, 1.42, -1.42, -4.27, 4.26, 1.41, -1.45, -4.24, 4.24, 1.42, -1.41, -4.24, 4.25, 1.42, -1.43, -4.25, 4.27, 1.39, -1.43, -4.26, 4.23, 1.39, -1.44, -4.27, 4.26, 1.41, -1.43, -4.26, 4.24, 1.4, -1.42, -4.28, 4.24, 1.42, -1.43, -4.26, 4.24, 1.4, -1.43, -4.26, 4.22, 1.4, -1.43, -4.27, 4.24, 1.41, -1.44, -4.28, 4.24, 1.4, -1.45, -4.29, 4.23, 1.39, -1.45, -4.27, 4.22, 1.38, -1.45, -4.27, 4.2, 1.39, -1.45, -4.29, 4.22, 1.39, -1.45, -4.29},
    {21.51, 21.18, 20.87, 20.57, 20.26, 19.94, 19.63, 19.32, 19.01, 18.68, 18.35, 18.05, 17.72, 17.38, 17.06, 16.74, 16.42, 16.09, 15.76, 15.44, 15.09, 14.77, 14.43, 14.1, 13.75, 13.42, 13.1, 12.77, 12.41, 12.06, 11.73, 11.4, 11.04, 10.71, 10.36, 10.03, 9.67, 9.32, 9.01, 8.65, 8.28, 7.94, 7.59, 7.26, 6.91, 6.53, 6.21, 5.87, 5.5, 5.15, 4.8, 4.46, 4.11, 3.74, 3.39, 3.06, 2.68, 2.34, 1.99, 1.62, 1.27, 0.92, 0.58, 0.21, -0.14, -0.5, -0.86, -1.18, -1.55, -1.91, -2.25, -2.59, -2.98, -3.33, -3.68, -4.01, -4.38, -4.74, -5.08, -5.44, -5.8, -6.14, -6.48, -6.83, -7.19, -7.54, -7.88, -8.22, -8.59, -8.94, -9.26, -9.63, -9.97, -10.3, -10.65, -10.97, -11.33, -11.68, -12.02, -12.36, -12.72, -13.06, -13.37, -13.7, -14.05, -14.39, -14.71, -15.06, -15.39, -15.72, -16.04, -16.38, -16.7, -17.03, -17.34, -17.67, -18.01, -18.33, -18.64, -18.93, -19.29, -19.59, -19.89, -20.2, -20.51, -20.82, -21.14, -21.44},
    15.806,
    mkmat4d({1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({-1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    7109745,
    7502,
    7503,
};

static sensor_info si_2_3_os_992146000760_128_legacy = { 
    "",
    "992146000760",
    "v2.3.0-rc.2",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, { 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0} , {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 4.27, 1.43, -1.39, -4.23, 4.26, 1.45, -1.38, -4.22, 4.28, 1.43, -1.39, -4.24, 4.27, 1.44, -1.4, -4.22, 4.28, 1.45, -1.39, -4.23, 4.26, 1.44, -1.4, -4.23, 4.27, 1.43, -1.39, -4.23, 4.26, 1.43, -1.4, -4.24, 4.26, 1.44, -1.4, -4.23, 4.28, 1.43, -1.4, -4.24, 4.26, 1.42, -1.39, -4.24, 4.27, 1.43, -1.42, -4.25, 4.26, 1.43, -1.42, -4.25, 4.28, 1.43, -1.42, -4.25, 4.26, 1.43, -1.44, -4.25, 4.27, 1.43, -1.43, -4.26, 4.27, 1.42, -1.43, -4.26, 4.25, 1.42, -1.43, -4.28, 4.25, 1.42, -1.45, -4.28, 4.26, 1.42, -1.44, -4.26, 4.26, 1.4, -1.46, -4.27, 4.24, 1.41, -1.43, -4.28, 4.26, 1.4, -1.44, -4.28, 4.22, 1.4, -1.43, -4.29, 4.25, 1.41, -1.45, -4.29, 4.24, 1.4, -1.46, -4.28, 4.24, 1.4, -1.44, -4.28, 4.22, 1.41, -1.45, -4.28, 4.25, 1.39, -1.45, -4.29, 4.23, 1.4, -1.45, -4.3, 4.22, 1.39, -1.47, -4.29, 4.22, 1.38, -1.47, -4.3 },
    { 21.34, 21.03, 20.72, 20.41, 20.08, 19.78, 19.48, 19.17, 18.83, 18.51, 18.21, 17.88, 17.56, 17.23, 16.92, 16.59, 16.26, 15.94, 15.61, 15.28, 14.93, 14.6, 14.27, 13.95, 13.61, 13.26, 12.94, 12.6, 12.26, 11.91, 11.58, 11.24, 10.89, 10.55, 10.21, 9.88, 9.52, 9.18, 8.83, 8.5, 8.14, 7.78, 7.46, 7.11, 6.75, 6.39, 6.05, 5.7, 5.33, 4.99, 4.64, 4.29, 3.94, 3.59, 3.24, 2.88, 2.52, 2.18, 1.81, 1.48, 1.11, 0.76, 0.4, 0.05, -0.3, -0.67, -1.01, -1.37, -1.75, -2.08, -2.43, -2.79, -3.15, -3.5, -3.86, -4.2, -4.56, -4.9, -5.27, -5.6, -5.96, -6.32, -6.68, -7, -7.38, -7.71, -8.05, -8.41, -8.77, -9.11, -9.45, -9.79, -10.16, -10.49, -10.83, -11.18, -11.54, -11.86, -12.2, -12.55, -12.91, -13.24, -13.58, -13.89, -14.26, -14.58, -14.89, -15.21, -15.6, -15.89, -16.22, -16.54, -16.88, -17.21, -17.52, -17.85, -18.2, -18.5, -18.82, -19.14, -19.47, -19.78, -20.09, -20.38, -20.72, -21.03, -21.33, -21.62 },
    15.806,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    5431288,
    7502,
    7503,
};

static sensor_info si_2_3_os_992146000760_128 = { 
    "",
    "992146000760",
    "v2.3.0-rc.2",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, { 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0} , {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 4.27, 1.43, -1.39, -4.23, 4.26, 1.45, -1.38, -4.22, 4.28, 1.43, -1.39, -4.24, 4.27, 1.44, -1.4, -4.22, 4.28, 1.45, -1.39, -4.23, 4.26, 1.44, -1.4, -4.23, 4.27, 1.43, -1.39, -4.23, 4.26, 1.43, -1.4, -4.24, 4.26, 1.44, -1.4, -4.23, 4.28, 1.43, -1.4, -4.24, 4.26, 1.42, -1.39, -4.24, 4.27, 1.43, -1.42, -4.25, 4.26, 1.43, -1.42, -4.25, 4.28, 1.43, -1.42, -4.25, 4.26, 1.43, -1.44, -4.25, 4.27, 1.43, -1.43, -4.26, 4.27, 1.42, -1.43, -4.26, 4.25, 1.42, -1.43, -4.28, 4.25, 1.42, -1.45, -4.28, 4.26, 1.42, -1.44, -4.26, 4.26, 1.4, -1.46, -4.27, 4.24, 1.41, -1.43, -4.28, 4.26, 1.4, -1.44, -4.28, 4.22, 1.4, -1.43, -4.29, 4.25, 1.41, -1.45, -4.29, 4.24, 1.4, -1.46, -4.28, 4.24, 1.4, -1.44, -4.28, 4.22, 1.41, -1.45, -4.28, 4.25, 1.39, -1.45, -4.29, 4.23, 1.4, -1.45, -4.3, 4.22, 1.39, -1.47, -4.29, 4.22, 1.38, -1.47, -4.3 },
    { 21.34, 21.03, 20.72, 20.41, 20.08, 19.78, 19.48, 19.17, 18.83, 18.51, 18.21, 17.88, 17.56, 17.23, 16.92, 16.59, 16.26, 15.94, 15.61, 15.28, 14.93, 14.6, 14.27, 13.95, 13.61, 13.26, 12.94, 12.6, 12.26, 11.91, 11.58, 11.24, 10.89, 10.55, 10.21, 9.88, 9.52, 9.18, 8.83, 8.5, 8.14, 7.78, 7.46, 7.11, 6.75, 6.39, 6.05, 5.7, 5.33, 4.99, 4.64, 4.29, 3.94, 3.59, 3.24, 2.88, 2.52, 2.18, 1.81, 1.48, 1.11, 0.76, 0.4, 0.05, -0.3, -0.67, -1.01, -1.37, -1.75, -2.08, -2.43, -2.79, -3.15, -3.5, -3.86, -4.2, -4.56, -4.9, -5.27, -5.6, -5.96, -6.32, -6.68, -7, -7.38, -7.71, -8.05, -8.41, -8.77, -9.11, -9.45, -9.79, -10.16, -10.49, -10.83, -11.18, -11.54, -11.86, -12.2, -12.55, -12.91, -13.24, -13.58, -13.89, -14.26, -14.58, -14.89, -15.21, -15.6, -15.89, -16.22, -16.54, -16.88, -17.21, -17.52, -17.85, -18.2, -18.5, -18.82, -19.14, -19.47, -19.78, -20.09, -20.38, -20.72, -21.03, -21.33, -21.62 },
    15.806,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    5431288,
    7502,
    7503,
};

static sensor_info si_2_3_1_os_992146000760_128_legacy = { 
    "",
    "992146000760",
    "v2.3.1-rc.1",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, { 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0} , {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 4.27, 1.43, -1.39, -4.23, 4.26, 1.45, -1.38, -4.22, 4.28, 1.43, -1.39, -4.24, 4.27, 1.44, -1.4, -4.22, 4.28, 1.45, -1.39, -4.23, 4.26, 1.44, -1.4, -4.23, 4.27, 1.43, -1.39, -4.23, 4.26, 1.43, -1.4, -4.24, 4.26, 1.44, -1.4, -4.23, 4.28, 1.43, -1.4, -4.24, 4.26, 1.42, -1.39, -4.24, 4.27, 1.43, -1.42, -4.25, 4.26, 1.43, -1.42, -4.25, 4.28, 1.43, -1.42, -4.25, 4.26, 1.43, -1.44, -4.25, 4.27, 1.43, -1.43, -4.26, 4.27, 1.42, -1.43, -4.26, 4.25, 1.42, -1.43, -4.28, 4.25, 1.42, -1.45, -4.28, 4.26, 1.42, -1.44, -4.26, 4.26, 1.4, -1.46, -4.27, 4.24, 1.41, -1.43, -4.28, 4.26, 1.4, -1.44, -4.28, 4.22, 1.4, -1.43, -4.29, 4.25, 1.41, -1.45, -4.29, 4.24, 1.4, -1.46, -4.28, 4.24, 1.4, -1.44, -4.28, 4.22, 1.41, -1.45, -4.28, 4.25, 1.39, -1.45, -4.29, 4.23, 1.4, -1.45, -4.3, 4.22, 1.39, -1.47, -4.29, 4.22, 1.38, -1.47, -4.3 },
    { 21.34, 21.03, 20.72, 20.41, 20.08, 19.78, 19.48, 19.17, 18.83, 18.51, 18.21, 17.88, 17.56, 17.23, 16.92, 16.59, 16.26, 15.94, 15.61, 15.28, 14.93, 14.6, 14.27, 13.95, 13.61, 13.26, 12.94, 12.6, 12.26, 11.91, 11.58, 11.24, 10.89, 10.55, 10.21, 9.88, 9.52, 9.18, 8.83, 8.5, 8.14, 7.78, 7.46, 7.11, 6.75, 6.39, 6.05, 5.7, 5.33, 4.99, 4.64, 4.29, 3.94, 3.59, 3.24, 2.88, 2.52, 2.18, 1.81, 1.48, 1.11, 0.76, 0.4, 0.05, -0.3, -0.67, -1.01, -1.37, -1.75, -2.08, -2.43, -2.79, -3.15, -3.5, -3.86, -4.2, -4.56, -4.9, -5.27, -5.6, -5.96, -6.32, -6.68, -7, -7.38, -7.71, -8.05, -8.41, -8.77, -9.11, -9.45, -9.79, -10.16, -10.49, -10.83, -11.18, -11.54, -11.86, -12.2, -12.55, -12.91, -13.24, -13.58, -13.89, -14.26, -14.58, -14.89, -15.21, -15.6, -15.89, -16.22, -16.54, -16.88, -17.21, -17.52, -17.85, -18.2, -18.5, -18.82, -19.14, -19.47, -19.78, -20.09, -20.38, -20.72, -21.03, -21.33, -21.62 },
    15.806,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    5431287,
    7502,
    7503,
};

static sensor_info si_2_3_1_os_992146000760_128 = { 
    "",
    "992146000760",
    "v2.3.1-rc.1",
    MODE_1024x10,
    "OS-1-128",
    {128, 16, 1024, { 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0, 24, 16, 8, 0} , {0, 1023}, PROFILE_LIDAR_LEGACY, PROFILE_IMU_LEGACY},
    { 4.27, 1.43, -1.39, -4.23, 4.26, 1.45, -1.38, -4.22, 4.28, 1.43, -1.39, -4.24, 4.27, 1.44, -1.4, -4.22, 4.28, 1.45, -1.39, -4.23, 4.26, 1.44, -1.4, -4.23, 4.27, 1.43, -1.39, -4.23, 4.26, 1.43, -1.4, -4.24, 4.26, 1.44, -1.4, -4.23, 4.28, 1.43, -1.4, -4.24, 4.26, 1.42, -1.39, -4.24, 4.27, 1.43, -1.42, -4.25, 4.26, 1.43, -1.42, -4.25, 4.28, 1.43, -1.42, -4.25, 4.26, 1.43, -1.44, -4.25, 4.27, 1.43, -1.43, -4.26, 4.27, 1.42, -1.43, -4.26, 4.25, 1.42, -1.43, -4.28, 4.25, 1.42, -1.45, -4.28, 4.26, 1.42, -1.44, -4.26, 4.26, 1.4, -1.46, -4.27, 4.24, 1.41, -1.43, -4.28, 4.26, 1.4, -1.44, -4.28, 4.22, 1.4, -1.43, -4.29, 4.25, 1.41, -1.45, -4.29, 4.24, 1.4, -1.46, -4.28, 4.24, 1.4, -1.44, -4.28, 4.22, 1.41, -1.45, -4.28, 4.25, 1.39, -1.45, -4.29, 4.23, 1.4, -1.45, -4.3, 4.22, 1.39, -1.47, -4.29, 4.22, 1.38, -1.47, -4.3 },
    { 21.34, 21.03, 20.72, 20.41, 20.08, 19.78, 19.48, 19.17, 18.83, 18.51, 18.21, 17.88, 17.56, 17.23, 16.92, 16.59, 16.26, 15.94, 15.61, 15.28, 14.93, 14.6, 14.27, 13.95, 13.61, 13.26, 12.94, 12.6, 12.26, 11.91, 11.58, 11.24, 10.89, 10.55, 10.21, 9.88, 9.52, 9.18, 8.83, 8.5, 8.14, 7.78, 7.46, 7.11, 6.75, 6.39, 6.05, 5.7, 5.33, 4.99, 4.64, 4.29, 3.94, 3.59, 3.24, 2.88, 2.52, 2.18, 1.81, 1.48, 1.11, 0.76, 0.4, 0.05, -0.3, -0.67, -1.01, -1.37, -1.75, -2.08, -2.43, -2.79, -3.15, -3.5, -3.86, -4.2, -4.56, -4.9, -5.27, -5.6, -5.96, -6.32, -6.68, -7, -7.38, -7.71, -8.05, -8.41, -8.77, -9.11, -9.45, -9.79, -10.16, -10.49, -10.83, -11.18, -11.54, -11.86, -12.2, -12.55, -12.91, -13.24, -13.58, -13.89, -14.26, -14.58, -14.89, -15.21, -15.6, -15.89, -16.22, -16.54, -16.88, -17.21, -17.52, -17.85, -18.2, -18.5, -18.82, -19.14, -19.47, -19.78, -20.09, -20.38, -20.72, -21.03, -21.33, -21.62 },
    15.806,
    mkmat4d({ 1, 0, 0, 6.253, 0, 1, 0, -11.775, 0, 0, 1, 7.645, 0, 0, 0, 1}),
    mkmat4d({ -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 36.18, 0, 0, 0, 1}),
    mkmat4d({1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, }),
    5431287,
    7502,
    7503,
};
// for lookup by name
const std::map<std::string, sensor_info> expected_sensor_infos{
    {"1_12_os1-991913000010-64", si_1_12_os1_991913000010_64},
    {"1_12_os1-991937000062-16A0_legacy", si_1_12_os1_991937000062_16A0_legacy},
    {"1_12_os1-991937000062-64_legacy", si_1_12_os1_991937000062_64_legacy},
    {"1_13_os1-991913000010-64", si_1_13_os1_991913000010_64},
    {"1_13_os1-991937000062-16A0_legacy", si_1_13_os1_991937000062_16A0_legacy},
    {"1_13_os1-991937000062-32A02_legacy", si_1_13_os1_991937000062_32A02_legacy},
    {"1_13_os1-991937000062-64_legacy", si_1_13_os1_991937000062_64_legacy},
    {"1_14_6cccd_os-882002000138-128_legacy", si_1_14_6cccd_os_882002000138_128_legacy},
    {"1_14_6cccd_os-882002000138-32U0_legacy", si_1_14_6cccd_os_882002000138_32U0_legacy},
    {"1_14_6cccd_os-882002000138-64U02_legacy", si_1_14_6cccd_os_882002000138_64U02_legacy},
    {"1_14_beta_os1-991937000062-16A0_legacy", si_1_14_beta_os1_991937000062_16A0_legacy},
    {"1_14_beta_os1-991937000062-32A02_legacy", si_1_14_beta_os1_991937000062_32A02_legacy},
    {"1_14_beta_os1-991937000062-64_legacy", si_1_14_beta_os1_991937000062_64_legacy},
    {"1_14_beta_os-882004000055-128_legacy", si_1_14_beta_os_882004000055_128_legacy},
    {"2_0_rc2_os-992011000121-32U0_legacy", si_2_0_rc2_os_992011000121_32U0_legacy},
    {"2_0_0_os1-992008000494-128_col_win_legacy", si_2_0_0_os1_992008000494_128_col_win_legacy},
    {"2_0_0_os1-991913000010-64", si_2_0_0_os1_991913000010_64},
    {"2_1_2_os1-991913000010-64_legacy", si_2_1_2_os1_991913000010_64_legacy},
    {"2_1_2_os1-991913000010-64", si_2_1_2_os1_991913000010_64},
    {"ouster-studio-reduced-config-v1", si_ouster_studio_reduced_config_v1},
    {"2_2_os-992119000444-128_legacy", si_2_2_os_992119000444_128_legacy},
    {"2_2_os-992119000444-128", si_2_2_os_992119000444_128},
    {"2_3_os-992146000760-128_legacy", si_2_3_os_992146000760_128_legacy},
    {"2_3_os-992146000760-128", si_2_3_os_992146000760_128},
    {"2_3_1_os-992146000760-128_legacy", si_2_3_1_os_992146000760_128_legacy},
    {"2_3_1_os-992146000760-128", si_2_3_1_os_992146000760_128}
};

// clang-format on

}  // namespace testing
}  // namespace ouster
