# Bruck

Write brainfuck with ONLY square brackets.

```bruck
[]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][][[]][]][][
```

![PyPI - Python Version](https://img.shields.io/pypi/pyversions/bruck) [![PyPI](https://img.shields.io/pypi/v/bruck?color=blueviolet)](https://pypi.org/project/bruck/) ![GitHub](https://img.shields.io/github/license/GLanguage/bruck)

## Installation

```shell
$ pip install bruck
```

## Usage

```shell
$ bruck [-veh] PROGRAM
```

You can interpret a bruck program by

```shell
$ bruck <filename>.bruck
```

Or run a program in command line by `-e` option. For example:

```shell
$ bruck -e '][][]['
```

`-v` option shows version, and `-h` option shows help.

## Bruck Syntax

The syntax of bruck is basically the same as brainfuck, but was inspired by codons in DNA or RNA molecules. We use 3-character strings consisting of `[` and `]` to represent 8 different commands in brainfuck.

| Bruck | Equivalent Brainfuck | Description |
| --- | --- | --- |
| `[]]` | `+` | Increment the memory cell at the pointer |
| `[[]` | `-` | Decrement the memory cell at the pointer |
| `]][` | `>` | Move the pointer to the right |
| `][[` | `<` | Move the pointer to the left |
| `[][` | `.` | Output the character signified by the cell at the pointer | 
| `][]` | `,` | Input a character and store it in the cell at the pointer |
| `[[[` | `[` | Jump past the matching `]]]` if the cell at the pointer is 0 |
| `]]]` | `]` | Jump back to the matching `[[[` if the cell at the pointer is nonzero

All characters other than `[` and `]` are ignored, including spaces and newlines. Having just started to use bruck, you may find it helpful to divide the program into commands:

```bruck
][] []] [][
```

And when you get familiar with the language, you can write something cool like this:

```bruck
[]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][]][][[][[]][]][]][][[]][][[[][[][[][[][][[]][]][]][][
```

Since the length of a bruck command is 3, the length of a bruck program (with only `[` and `]` counted) must be divisible by 3, otherwise the interpreter will raise an error.

## Error Messages

If an error occurs when executing a bruck program, the bruck interpreter will raise a `BruckError` with error messages showing where and why the error has occured.

If you find the error messages generated by the interpreter a little difficult to understand, don't worry. It is a *feature*. Bruck is a so-called *esoteric programming language*, and therefore the bruck interpreter is also designed to be esoteric. You will be used to that soon.

## API

A Python API is provided to interpret bruck programs. After installation, import the `interpreter` module by

```python
from bruck.interpreter import *
```

The `interpreter` module includes a class `BruckInterpreter` to interpret and execute bruck programs. Here is an example:

```python
from bruck.interpreter import *

bruckInterpreter = BruckInterpreter('<bruck_program_string>') # Initialize

bruckInterpreter.exec() # Execute the program
```

For more help on the API, try `help(BruckInterpreter)` after importing the module.

## Contribution

If you find any bugs or have suggestions for new features, please raise an issue for further discussion. All contributions are welcomed.
