import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeProjectDefaultNetworkTierConfig extends cdktf.TerraformMetaArguments {
    /**
     * The default network tier to be configured for the project.
     *
     * This field can take the following values: PREMIUM or STANDARD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#network_tier ComputeProjectDefaultNetworkTier#network_tier}
     *
     * @stability stable
     */
    readonly networkTier: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#project ComputeProjectDefaultNetworkTier#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#timeouts ComputeProjectDefaultNetworkTier#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeProjectDefaultNetworkTierTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeProjectDefaultNetworkTierTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#create ComputeProjectDefaultNetworkTier#create}.
     *
     * @stability stable
     */
    readonly create?: string;
}
export declare function computeProjectDefaultNetworkTierTimeoutsToTerraform(struct?: ComputeProjectDefaultNetworkTierTimeoutsOutputReference | ComputeProjectDefaultNetworkTierTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeProjectDefaultNetworkTierTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeProjectDefaultNetworkTierTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeProjectDefaultNetworkTierTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html google_compute_project_default_network_tier}.
 *
 * @stability stable
 */
export declare class ComputeProjectDefaultNetworkTier extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html google_compute_project_default_network_tier} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeProjectDefaultNetworkTierConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _networkTier?;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    set networkTier(value: string);
    /**
     * @stability stable
     */
    get networkTierInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeProjectDefaultNetworkTierTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeProjectDefaultNetworkTierTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeProjectDefaultNetworkTierTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
