"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupStorage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [backup-storage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupstorage.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class BackupStorage extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [backup-storage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupstorage.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'backup-storage';
        this.accessLevelList = {
            Write: [
                'CommitBackupJob',
                'DeleteObjects',
                'DescribeBackupJob',
                'GetBaseBackup',
                'GetChunk',
                'GetIncrementalBaseBackup',
                'GetObjectMetadata',
                'ListChunks',
                'ListObjects',
                'MountCapsule',
                'NotifyObjectComplete',
                'PutChunk',
                'PutObject',
                'StartObject',
                'UpdateObjectComplete'
            ]
        };
    }
    /**
     * Grants permission to commit backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toCommitBackupJob() {
        return this.to('CommitBackupJob');
    }
    /**
     * Grants permission to delete objects
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toDeleteObjects() {
        return this.to('DeleteObjects');
    }
    /**
     * Grants permission to describe backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toDescribeBackupJob() {
        return this.to('DescribeBackupJob');
    }
    /**
     * Grants permission to get base backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetBaseBackup() {
        return this.to('GetBaseBackup');
    }
    /**
     * Grants permission to get data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetChunk() {
        return this.to('GetChunk');
    }
    /**
     * Grants permission to get incremental base backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetIncrementalBaseBackup() {
        return this.to('GetIncrementalBaseBackup');
    }
    /**
     * Grants permission to get metadata from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetObjectMetadata() {
        return this.to('GetObjectMetadata');
    }
    /**
     * Grants permission to list data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toListChunks() {
        return this.to('ListChunks');
    }
    /**
     * Grants permission to list data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toListObjects() {
        return this.to('ListObjects');
    }
    /**
     * Associates a KMS key to a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     */
    toMountCapsule() {
        return this.to('MountCapsule');
    }
    /**
     * Grants permission to mark an uploaded data as completed for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toNotifyObjectComplete() {
        return this.to('NotifyObjectComplete');
    }
    /**
     * Grants permission to upload data to an AWS Backup-managed recovery point for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toPutChunk() {
        return this.to('PutChunk');
    }
    /**
     * Grants permission to put object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toPutObject() {
        return this.to('PutObject');
    }
    /**
     * Grants permission to upload data to an AWS Backup-managed recovery point for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toStartObject() {
        return this.to('StartObject');
    }
    /**
     * Grants permission to update object complete
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toUpdateObjectComplete() {
        return this.to('UpdateObjectComplete');
    }
}
exports.BackupStorage = BackupStorage;
_a = JSII_RTTI_SYMBOL_1;
BackupStorage[_a] = { fqn: "iam-floyd.BackupStorage", version: "0.488.0" };
//# sourceMappingURL=data:application/json;base64,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