"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cleanrooms = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Cleanrooms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'cleanrooms';
        this.accessLevelList = {
            Read: [
                'BatchGetSchema',
                'GetCollaboration',
                'GetConfiguredTable',
                'GetConfiguredTableAnalysisRule',
                'GetConfiguredTableAssociation',
                'GetMembership',
                'GetProtectedQuery',
                'GetSchema',
                'GetSchemaAnalysisRule'
            ],
            Write: [
                'CreateCollaboration',
                'CreateConfiguredTable',
                'CreateConfiguredTableAnalysisRule',
                'CreateConfiguredTableAssociation',
                'CreateMembership',
                'DeleteCollaboration',
                'DeleteConfiguredTable',
                'DeleteConfiguredTableAnalysisRule',
                'DeleteConfiguredTableAssociation',
                'DeleteMember',
                'DeleteMembership',
                'StartProtectedQuery',
                'UpdateCollaboration',
                'UpdateConfiguredTable',
                'UpdateConfiguredTableAnalysisRule',
                'UpdateConfiguredTableAssociation',
                'UpdateMembership',
                'UpdateProtectedQuery'
            ],
            List: [
                'ListCollaborations',
                'ListConfiguredTableAssociations',
                'ListConfiguredTables',
                'ListMembers',
                'ListMemberships',
                'ListProtectedQueries',
                'ListSchemas'
            ]
        };
    }
    /**
     * Grants permission to view details for schemas
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetSchema.html
     */
    toBatchGetSchema() {
        return this.to('BatchGetSchema');
    }
    /**
     * Grants permission to create a new collaboration, a shared data collaboration environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html
     */
    toCreateCollaboration() {
        return this.to('CreateCollaboration');
    }
    /**
     * Grants permission to create a new configured table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:BatchGetPartition
     * - glue:GetDatabase
     * - glue:GetDatabases
     * - glue:GetPartition
     * - glue:GetPartitions
     * - glue:GetSchemaVersion
     * - glue:GetTable
     * - glue:GetTables
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTable.html
     */
    toCreateConfiguredTable() {
        return this.to('CreateConfiguredTable');
    }
    /**
     * Grants permission to create a analysis rule for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAnalysisRule.html
     */
    toCreateConfiguredTableAnalysisRule() {
        return this.to('CreateConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to link a configured table with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAssociation.html
     */
    toCreateConfiguredTableAssociation() {
        return this.to('CreateConfiguredTableAssociation');
    }
    /**
     * Grants permission to join collaborations by creating a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateMembership.html
     */
    toCreateMembership() {
        return this.to('CreateMembership');
    }
    /**
     * Grants permission to delete an existing collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteCollaboration.html
     */
    toDeleteCollaboration() {
        return this.to('DeleteCollaboration');
    }
    /**
     * Grants permission to delete a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTable.html
     */
    toDeleteConfiguredTable() {
        return this.to('DeleteConfiguredTable');
    }
    /**
     * Grants permission to delete an existing analysis rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAnalysisRule.html
     */
    toDeleteConfiguredTableAnalysisRule() {
        return this.to('DeleteConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to remove a configured table association from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAssociation.html
     */
    toDeleteConfiguredTableAssociation() {
        return this.to('DeleteConfiguredTableAssociation');
    }
    /**
     * Grants permission to delete members from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMember.html
     */
    toDeleteMember() {
        return this.to('DeleteMember');
    }
    /**
     * Grants permission to leave collaborations by deleting a membership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMembership.html
     */
    toDeleteMembership() {
        return this.to('DeleteMembership');
    }
    /**
     * Grants permission to view details for a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaboration.html
     */
    toGetCollaboration() {
        return this.to('GetCollaboration');
    }
    /**
     * Grants permission to view details for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTable.html
     */
    toGetConfiguredTable() {
        return this.to('GetConfiguredTable');
    }
    /**
     * Grants permission to view analysis rules for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAnalysisRule.html
     */
    toGetConfiguredTableAnalysisRule() {
        return this.to('GetConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to view details for a configured table association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAssociation.html
     */
    toGetConfiguredTableAssociation() {
        return this.to('GetConfiguredTableAssociation');
    }
    /**
     * Grants permission to view details about a membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetMembership.html
     */
    toGetMembership() {
        return this.to('GetMembership');
    }
    /**
     * Grants permission to view a protected query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetProtectedQuery.html
     */
    toGetProtectedQuery() {
        return this.to('GetProtectedQuery');
    }
    /**
     * Grants permission to view details for a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchema.html
     */
    toGetSchema() {
        return this.to('GetSchema');
    }
    /**
     * Grants permission to view analysis rules associated with a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchemaAnalysisRule.html
     */
    toGetSchemaAnalysisRule() {
        return this.to('GetSchemaAnalysisRule');
    }
    /**
     * Grants permission to list available collaborations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborations.html
     */
    toListCollaborations() {
        return this.to('ListCollaborations');
    }
    /**
     * Grants permission to list available configured table associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTableAssociations.html
     */
    toListConfiguredTableAssociations() {
        return this.to('ListConfiguredTableAssociations');
    }
    /**
     * Grants permission to list available configured tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTables.html
     */
    toListConfiguredTables() {
        return this.to('ListConfiguredTables');
    }
    /**
     * Grants permission to list the members of a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMembers.html
     */
    toListMembers() {
        return this.to('ListMembers');
    }
    /**
     * Grants permission to list available memberships
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMemberships.html
     */
    toListMemberships() {
        return this.to('ListMemberships');
    }
    /**
     * Grants permission to list protected queries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListProtectedQueries.html
     */
    toListProtectedQueries() {
        return this.to('ListProtectedQueries');
    }
    /**
     * Grants permission to view available schemas for a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListSchemas.html
     */
    toListSchemas() {
        return this.to('ListSchemas');
    }
    /**
     * Grants permission to start protected queries
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     * - s3:GetBucketLocation
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_StartProtectedQuery.html
     */
    toStartProtectedQuery() {
        return this.to('StartProtectedQuery');
    }
    /**
     * Grants permission to update details of the collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateCollaboration.html
     */
    toUpdateCollaboration() {
        return this.to('UpdateCollaboration');
    }
    /**
     * Grants permission to update an existing configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTable.html
     */
    toUpdateConfiguredTable() {
        return this.to('UpdateConfiguredTable');
    }
    /**
     * Grants permission to update analysis rules for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAnalysisRule.html
     */
    toUpdateConfiguredTableAnalysisRule() {
        return this.to('UpdateConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to update a configured table association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAssociation.html
     */
    toUpdateConfiguredTableAssociation() {
        return this.to('UpdateConfiguredTableAssociation');
    }
    /**
     * Grants permission to update details of a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateMembership.html
     */
    toUpdateMembership() {
        return this.to('UpdateMembership');
    }
    /**
     * Grants permission to update protected queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateProtectedQuery.html
     */
    toUpdateProtectedQuery() {
        return this.to('UpdateProtectedQuery');
    }
    /**
     * Adds a resource of type Collaboration to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param collaborationId - Identifier for the collaborationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCollaboration(collaborationId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:collaboration/${collaborationId}`);
    }
    /**
     * Adds a resource of type ConfiguredTable to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param configuredTableId - Identifier for the configuredTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConfiguredTable(configuredTableId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:configuredtable/${configuredTableId}`);
    }
    /**
     * Adds a resource of type ConfiguredTableAssociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param configuredTableAssociationId - Identifier for the configuredTableAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConfiguredTableAssociation(membershipId, configuredTableAssociationId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:membership/${membershipId}/configuredtableassociation/${configuredTableAssociationId}`);
    }
    /**
     * Adds a resource of type Membership to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMembership(membershipId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:membership/${membershipId}`);
    }
}
exports.Cleanrooms = Cleanrooms;
_a = JSII_RTTI_SYMBOL_1;
Cleanrooms[_a] = { fqn: "iam-floyd.Cleanrooms", version: "0.488.0" };
//# sourceMappingURL=data:application/json;base64,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