import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [identitystore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystore.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Identitystore extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [identitystore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitystore.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a group in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Grants permission to create a member to a group in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_CreateGroupMembership.html
     */
    toCreateGroupMembership(): this;
    /**
     * Grants permission to create a user in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete a group in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to remove a member that is part of a group in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DeleteGroupMembership.html
     */
    toDeleteGroupMembership(): this;
    /**
     * Grants permission to delete a user in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to retrieve information about a group in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DescribeGroup.html
     */
    toDescribeGroup(): this;
    /**
     * Grants permission to retrieve information about a member that is part of a group in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DescribeGroupMembership.html
     */
    toDescribeGroupMembership(): this;
    /**
     * Grants permission to retrieve information about user in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_DescribeUser.html
     */
    toDescribeUser(): this;
    /**
     * Grants permission to retrieve ID information about group in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_GetGroupId.html
     */
    toGetGroupId(): this;
    /**
     * Grants permission to retrieve ID information of a member which is part of a group in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_GetGroupMembershipId.html
     */
    toGetGroupMembershipId(): this;
    /**
     * Grants permission to retrieves ID information about user in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_GetUserId.html
     */
    toGetUserId(): this;
    /**
     * Grants permission to check if a member is a part of groups in the specified IdentityStore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_IsMemberInGroups.html
     */
    toIsMemberInGroups(): this;
    /**
     * Grants permission to retrieve all members that are part of a group in the specified IdentityStore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_ListGroupMemberships.html
     */
    toListGroupMemberships(): this;
    /**
     * Grants permission to list groups of the target member in the specified IdentityStore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_ListGroupMembershipsForMember.html
     */
    toListGroupMembershipsForMember(): this;
    /**
     * Grants permission to search for groups within the specified IdentityStore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to search for users in the specified IdentityStore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to update information about a group in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_UpdateGroup.html
     */
    toUpdateGroup(): this;
    /**
     * Grants permission to update user information in the specified IdentityStore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_UpdateUser.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Identitystore to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param identityStoreId - Identifier for the identityStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onIdentitystore(identityStoreId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type User to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param userId - Identifier for the userId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onUser(userId: string, partition?: string): this;
    /**
     * Adds a resource of type Group to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param groupId - Identifier for the groupId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGroup(groupId: string, partition?: string): this;
    /**
     * Adds a resource of type GroupMembership to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param membershipId - Identifier for the membershipId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGroupMembership(membershipId: string, partition?: string): this;
    /**
     * Adds a resource of type AllUsers to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAllUsers(resourceName: string, partition?: string): this;
    /**
     * Adds a resource of type AllGroups to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAllGroups(resourceName: string, partition?: string): this;
    /**
     * Adds a resource of type AllGroupMemberships to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAllGroupMemberships(resourceName: string, partition?: string): this;
}
