import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [kinesisanalytics-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkinesisanalyticsv2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class KinesisanalyticsV2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [kinesisanalytics-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkinesisanalyticsv2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add cloudwatch logging option to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationCloudWatchLoggingOption.html
     */
    toAddApplicationCloudWatchLoggingOption(): this;
    /**
     * Grants permission to add input to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationInput.html
     */
    toAddApplicationInput(): this;
    /**
     * Grants permission to add input processing configuration to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationInputProcessingConfiguration.html
     */
    toAddApplicationInputProcessingConfiguration(): this;
    /**
     * Grants permission to add output to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationOutput.html
     */
    toAddApplicationOutput(): this;
    /**
     * Grants permission to add reference data source to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationReferenceDataSource.html
     */
    toAddApplicationReferenceDataSource(): this;
    /**
     * Grants permission to add VPC configuration to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_AddApplicationVpcConfiguration.html
     */
    toAddApplicationVpcConfiguration(): this;
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create and return a URL that you can use to connect to an application's extension
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_CreateApplicationPresignedUrl.html
     */
    toCreateApplicationPresignedUrl(): this;
    /**
     * Grants permission to create a snapshot for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_CreateApplicationSnapshot.html
     */
    toCreateApplicationSnapshot(): this;
    /**
     * Grants permission to delete the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete the specified cloudwatch logging option of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationCloudWatchLoggingOption.html
     */
    toDeleteApplicationCloudWatchLoggingOption(): this;
    /**
     * Grants permission to delete the specified input processing configuration of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationInputProcessingConfiguration.html
     */
    toDeleteApplicationInputProcessingConfiguration(): this;
    /**
     * Grants permission to delete the specified output of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationOutput.html
     */
    toDeleteApplicationOutput(): this;
    /**
     * Grants permission to delete the specified reference data source of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationReferenceDataSource.html
     */
    toDeleteApplicationReferenceDataSource(): this;
    /**
     * Grants permission to delete a snapshot for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationSnapshot.html
     */
    toDeleteApplicationSnapshot(): this;
    /**
     * Grants permission to delete the specified VPC configuration of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DeleteApplicationVpcConfiguration.html
     */
    toDeleteApplicationVpcConfiguration(): this;
    /**
     * Grants permission to describe the specified application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DescribeApplication.html
     */
    toDescribeApplication(): this;
    /**
     * Grants permission to describe an application snapshot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DescribeApplicationSnapshot.html
     */
    toDescribeApplicationSnapshot(): this;
    /**
     * Grants permission to describe the application version of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DescribeApplicationVersion.html
     */
    toDescribeApplicationVersion(): this;
    /**
     * Grants permission to discover the input schema for the application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_DiscoverInputSchema.html
     */
    toDiscoverInputSchema(): this;
    /**
     * Grants permission to list the snapshots for an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ListApplicationSnapshots.html
     */
    toListApplicationSnapshots(): this;
    /**
     * Grants permission to list application versions of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ListApplicationVersions.html
     */
    toListApplicationVersions(): this;
    /**
     * Grants permission to list applications for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to fetch the tags associated with the application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to perform rollback operation on an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_RollbackApplication.html
     */
    toRollbackApplication(): this;
    /**
     * Grants permission to start the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_StartApplication.html
     */
    toStartApplication(): this;
    /**
     * Grants permission to stop the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_StopApplication.html
     */
    toStopApplication(): this;
    /**
     * Grants permission to add tags to the application
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the application
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update the maintenance configuration of an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/apiv2/API_UpdateApplicationMaintenanceConfiguration.html
     */
    toUpdateApplicationMaintenanceConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-it-works.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationName: string, account?: string, region?: string, partition?: string): this;
}
