"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeptuneDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class NeptuneDb extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'neptune-db';
        this.accessLevelList = {
            Write: [
                'CancelLoaderJob',
                'CancelMLDataProcessingJob',
                'CancelMLModelTrainingJob',
                'CancelMLModelTransformJob',
                'CancelQuery',
                'CreateMLEndpoint',
                'DeleteDataViaQuery',
                'DeleteMLEndpoint',
                'DeleteStatistics',
                'ManageStatistics',
                'ResetDatabase',
                'StartLoaderJob',
                'StartMLDataProcessingJob',
                'StartMLModelTrainingJob',
                'StartMLModelTransformJob',
                'WriteDataViaQuery',
                'connect'
            ],
            Read: [
                'GetEngineStatus',
                'GetLoaderJobStatus',
                'GetMLDataProcessingJobStatus',
                'GetMLEndpointStatus',
                'GetMLModelTrainingJobStatus',
                'GetMLModelTransformJobStatus',
                'GetQueryStatus',
                'GetStatisticsStatus',
                'GetStreamRecords',
                'ReadDataViaQuery'
            ],
            List: [
                'ListLoaderJobs',
                'ListMLDataProcessingJobs',
                'ListMLEndpoints',
                'ListMLModelTrainingJobs',
                'ListMLModelTransformJobs'
            ]
        };
    }
    /**
     * Grants permission to cancel a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob
     */
    toCancelLoaderJob() {
        return this.to('CancelLoaderJob');
    }
    /**
     * Grants permission to cancel an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob
     */
    toCancelMLDataProcessingJob() {
        return this.to('CancelMLDataProcessingJob');
    }
    /**
     * Grants permission to cancel an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob
     */
    toCancelMLModelTrainingJob() {
        return this.to('CancelMLModelTrainingJob');
    }
    /**
     * Grants permission to cancel an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob
     */
    toCancelMLModelTransformJob() {
        return this.to('CancelMLModelTransformJob');
    }
    /**
     * Grants permission to cancel a query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery
     */
    toCancelQuery() {
        return this.to('CancelQuery');
    }
    /**
     * Grants permission to create an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint
     */
    toCreateMLEndpoint() {
        return this.to('CreateMLEndpoint');
    }
    /**
     * Grants permission to run delete data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery
     */
    toDeleteDataViaQuery() {
        return this.to('DeleteDataViaQuery');
    }
    /**
     * Grants permission to delete an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint
     */
    toDeleteMLEndpoint() {
        return this.to('DeleteMLEndpoint');
    }
    /**
     * Grants permission to delete all the statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics
     */
    toDeleteStatistics() {
        return this.to('DeleteStatistics');
    }
    /**
     * Grants permission to check the status of the Neptune engine
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus
     */
    toGetEngineStatus() {
        return this.to('GetEngineStatus');
    }
    /**
     * Grants permission to check the status of a loader job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus
     */
    toGetLoaderJobStatus() {
        return this.to('GetLoaderJobStatus');
    }
    /**
     * Grants permission to check the status of an ML data processing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus
     */
    toGetMLDataProcessingJobStatus() {
        return this.to('GetMLDataProcessingJobStatus');
    }
    /**
     * Grants permission to check the status of an ML endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus
     */
    toGetMLEndpointStatus() {
        return this.to('GetMLEndpointStatus');
    }
    /**
     * Grants permission to check the status of an ML model training job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus
     */
    toGetMLModelTrainingJobStatus() {
        return this.to('GetMLModelTrainingJobStatus');
    }
    /**
     * Grants permission to check the status of an ML model transform job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus
     */
    toGetMLModelTransformJobStatus() {
        return this.to('GetMLModelTransformJobStatus');
    }
    /**
     * Grants permission to check the status of all active queries
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus
     */
    toGetQueryStatus() {
        return this.to('GetQueryStatus');
    }
    /**
     * Grants permission to check the status of statistics of the database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus
     */
    toGetStatisticsStatus() {
        return this.to('GetStatisticsStatus');
    }
    /**
     * Grants permission to fetch stream records from Neptune
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords
     */
    toGetStreamRecords() {
        return this.to('GetStreamRecords');
    }
    /**
     * Grants permission to list all the loader jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs
     */
    toListLoaderJobs() {
        return this.to('ListLoaderJobs');
    }
    /**
     * Grants permission to list all the ML data processing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs
     */
    toListMLDataProcessingJobs() {
        return this.to('ListMLDataProcessingJobs');
    }
    /**
     * Grants permission to list all the ML endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints
     */
    toListMLEndpoints() {
        return this.to('ListMLEndpoints');
    }
    /**
     * Grants permission to list all the ML model training jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltrainingjobs
     */
    toListMLModelTrainingJobs() {
        return this.to('ListMLModelTrainingJobs');
    }
    /**
     * Grants permission to list all the ML model transform jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs
     */
    toListMLModelTransformJobs() {
        return this.to('ListMLModelTransformJobs');
    }
    /**
     * Grants permission to manage statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics
     */
    toManageStatistics() {
        return this.to('ManageStatistics');
    }
    /**
     * Grants permission to run read data via query APIs on database
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery
     */
    toReadDataViaQuery() {
        return this.to('ReadDataViaQuery');
    }
    /**
     * Grants permission to get the token needed for reset and resets the Neptune database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase
     */
    toResetDatabase() {
        return this.to('ResetDatabase');
    }
    /**
     * Grants permission to start a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob
     */
    toStartLoaderJob() {
        return this.to('StartLoaderJob');
    }
    /**
     * Grants permission to start an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmldataprocessingjob
     */
    toStartMLDataProcessingJob() {
        return this.to('StartMLDataProcessingJob');
    }
    /**
     * Grants permission to start an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob
     */
    toStartMLModelTrainingJob() {
        return this.to('StartMLModelTrainingJob');
    }
    /**
     * Grants permission to start an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob
     */
    toStartMLModelTransformJob() {
        return this.to('StartMLModelTransformJob');
    }
    /**
     * Grants permission to run write data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery
     */
    toWriteDataViaQuery() {
        return this.to('WriteDataViaQuery');
    }
    /**
     * Grants permission to all data-access actions in engine versions prior to 1.2.0.0
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html
     */
    toConnect() {
        return this.to('connect');
    }
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-resources.html
     *
     * @param cluster - Identifier for the cluster.
     * @param database - Identifier for the database.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(cluster, database, account, region, partition) {
        return this.on(`arn:${partition || NeptuneDb.defaultPartition}:neptune-db:${region || '*'}:${account || '*'}:${cluster}/${database}`);
    }
    /**
     * Filters access by graph model
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-context-keys.html#querylanguage
     *
     * Applies to actions:
     * - .toDeleteDataViaQuery()
     * - .toGetQueryStatus()
     * - .toGetStreamRecords()
     * - .toReadDataViaQuery()
     * - .toWriteDataViaQuery()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifQueryLanguage(value, operator) {
        return this.if(`QueryLanguage`, value, operator || 'StringLike');
    }
}
exports.NeptuneDb = NeptuneDb;
_a = JSII_RTTI_SYMBOL_1;
NeptuneDb[_a] = { fqn: "iam-floyd.NeptuneDb", version: "0.488.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVwdHVuZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm5lcHR1bmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBc0Q7QUFFdEQ7Ozs7R0FJRztBQUNILE1BQWEsU0FBVSxTQUFRLHdCQUFlO0lBRzVDOzs7O09BSUc7SUFDSCxZQUFZLEdBQVk7UUFDdEIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBUk4sa0JBQWEsR0FBRyxZQUFZLENBQUM7UUEwWDFCLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCxpQkFBaUI7Z0JBQ2pCLDJCQUEyQjtnQkFDM0IsMEJBQTBCO2dCQUMxQiwyQkFBMkI7Z0JBQzNCLGFBQWE7Z0JBQ2Isa0JBQWtCO2dCQUNsQixvQkFBb0I7Z0JBQ3BCLGtCQUFrQjtnQkFDbEIsa0JBQWtCO2dCQUNsQixrQkFBa0I7Z0JBQ2xCLGVBQWU7Z0JBQ2YsZ0JBQWdCO2dCQUNoQiwwQkFBMEI7Z0JBQzFCLHlCQUF5QjtnQkFDekIsMEJBQTBCO2dCQUMxQixtQkFBbUI7Z0JBQ25CLFNBQVM7YUFDVjtZQUNELElBQUksRUFBRTtnQkFDSixpQkFBaUI7Z0JBQ2pCLG9CQUFvQjtnQkFDcEIsOEJBQThCO2dCQUM5QixxQkFBcUI7Z0JBQ3JCLDZCQUE2QjtnQkFDN0IsOEJBQThCO2dCQUM5QixnQkFBZ0I7Z0JBQ2hCLHFCQUFxQjtnQkFDckIsa0JBQWtCO2dCQUNsQixrQkFBa0I7YUFDbkI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osZ0JBQWdCO2dCQUNoQiwwQkFBMEI7Z0JBQzFCLGlCQUFpQjtnQkFDakIseUJBQXlCO2dCQUN6QiwwQkFBMEI7YUFDM0I7U0FDRixDQUFDO0lBeFpGLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxTQUFTO1FBQ2QsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVCLENBQUM7SUEyQ0Q7Ozs7Ozs7Ozs7T0FVRztJQUNJLFVBQVUsQ0FBQyxPQUFlLEVBQUUsUUFBZ0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN4RyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksU0FBUyxDQUFDLGdCQUFpQixlQUFnQixNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLElBQUssT0FBUSxJQUFLLFFBQVMsRUFBRSxDQUFDLENBQUM7SUFDbEosQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksZUFBZSxDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDM0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ25FLENBQUM7O0FBcGNILDhCQXFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtuZXB0dW5lLWRiXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25uZXB0dW5lLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgTmVwdHVuZURiIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnbmVwdHVuZS1kYic7XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbmVwdHVuZS1kYl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubmVwdHVuZS5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNhbmNlbCBhIGxvYWRlciBqb2JcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjY2FuY2VsbG9hZGVyam9iXG4gICAqL1xuICBwdWJsaWMgdG9DYW5jZWxMb2FkZXJKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NhbmNlbExvYWRlckpvYicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNhbmNlbCBhbiBNTCBkYXRhIHByb2Nlc3Npbmcgam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2NhbmNlbG1sZGF0YXByb2Nlc3Npbmdqb2JcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbE1MRGF0YVByb2Nlc3NpbmdKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NhbmNlbE1MRGF0YVByb2Nlc3NpbmdKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjYW5jZWwgYW4gTUwgbW9kZWwgdHJhaW5pbmcgam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2NhbmNlbG1sbW9kZWx0cmFpbmluZ2pvYlxuICAgKi9cbiAgcHVibGljIHRvQ2FuY2VsTUxNb2RlbFRyYWluaW5nSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDYW5jZWxNTE1vZGVsVHJhaW5pbmdKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjYW5jZWwgYW4gTUwgbW9kZWwgdHJhbnNmb3JtIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNjYW5jZWxtbG1vZGVsdHJhbnNmb3Jtam9iXG4gICAqL1xuICBwdWJsaWMgdG9DYW5jZWxNTE1vZGVsVHJhbnNmb3JtSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDYW5jZWxNTE1vZGVsVHJhbnNmb3JtSm9iJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2FuY2VsIGEgcXVlcnlcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjY2FuY2VscXVlcnlcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbFF1ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDYW5jZWxRdWVyeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBNTCBlbmRwb2ludFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNjcmVhdGVtbGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVNTEVuZHBvaW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVNTEVuZHBvaW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcnVuIGRlbGV0ZSBkYXRhIHZpYSBxdWVyeSBBUElzIG9uIGRhdGFiYXNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZRdWVyeUxhbmd1YWdlKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2RlbGV0ZWRhdGF2aWFxdWVyeVxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRGF0YVZpYVF1ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVEYXRhVmlhUXVlcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYW4gTUwgZW5kcG9pbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjZGVsZXRlbWxlbmRwb2ludFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTUxFbmRwb2ludCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTUxFbmRwb2ludCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhbGwgdGhlIHN0YXRpc3RpY3MgaW4gdGhlIGRhdGFiYXNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2RlbGV0ZXN0YXRpc3RpY3NcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVN0YXRpc3RpY3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVN0YXRpc3RpY3MnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGVjayB0aGUgc3RhdHVzIG9mIHRoZSBOZXB0dW5lIGVuZ2luZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2dldGVuZ2luZXN0YXR1c1xuICAgKi9cbiAgcHVibGljIHRvR2V0RW5naW5lU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRFbmdpbmVTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGVjayB0aGUgc3RhdHVzIG9mIGEgbG9hZGVyIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2dldGxvYWRlcmpvYnN0YXR1c1xuICAgKi9cbiAgcHVibGljIHRvR2V0TG9hZGVySm9iU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRMb2FkZXJKb2JTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGVjayB0aGUgc3RhdHVzIG9mIGFuIE1MIGRhdGEgcHJvY2Vzc2luZyBqb2JcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNnZXRtbGRhdGFwcm9jZXNzaW5nam9ic3RhdHVzXG4gICAqL1xuICBwdWJsaWMgdG9HZXRNTERhdGFQcm9jZXNzaW5nSm9iU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRNTERhdGFQcm9jZXNzaW5nSm9iU3RhdHVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2hlY2sgdGhlIHN0YXR1cyBvZiBhbiBNTCBlbmRwb2ludFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2dldG1sZW5kcG9pbnRzdGF0dXNcbiAgICovXG4gIHB1YmxpYyB0b0dldE1MRW5kcG9pbnRTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldE1MRW5kcG9pbnRTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGVjayB0aGUgc3RhdHVzIG9mIGFuIE1MIG1vZGVsIHRyYWluaW5nIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2dldG1sbW9kZWx0cmFpbmluZ2pvYnN0YXR1c1xuICAgKi9cbiAgcHVibGljIHRvR2V0TUxNb2RlbFRyYWluaW5nSm9iU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRNTE1vZGVsVHJhaW5pbmdKb2JTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGVjayB0aGUgc3RhdHVzIG9mIGFuIE1MIG1vZGVsIHRyYW5zZm9ybSBqb2JcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNnZXRtbG1vZGVsdHJhbnNmb3Jtam9ic3RhdHVzXG4gICAqL1xuICBwdWJsaWMgdG9HZXRNTE1vZGVsVHJhbnNmb3JtSm9iU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRNTE1vZGVsVHJhbnNmb3JtSm9iU3RhdHVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2hlY2sgdGhlIHN0YXR1cyBvZiBhbGwgYWN0aXZlIHF1ZXJpZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUXVlcnlMYW5ndWFnZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNnZXRxdWVyeXN0YXR1c1xuICAgKi9cbiAgcHVibGljIHRvR2V0UXVlcnlTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFF1ZXJ5U3RhdHVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2hlY2sgdGhlIHN0YXR1cyBvZiBzdGF0aXN0aWNzIG9mIHRoZSBkYXRhYmFzZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2dldHN0YXRpc3RpY3NzdGF0dXNcbiAgICovXG4gIHB1YmxpYyB0b0dldFN0YXRpc3RpY3NTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0YXRpc3RpY3NTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBmZXRjaCBzdHJlYW0gcmVjb3JkcyBmcm9tIE5lcHR1bmVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUXVlcnlMYW5ndWFnZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNnZXRzdHJlYW1yZWNvcmRzXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdHJlYW1SZWNvcmRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTdHJlYW1SZWNvcmRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhbGwgdGhlIGxvYWRlciBqb2JzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjbGlzdGxvYWRlcmpvYnNcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RMb2FkZXJKb2JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TG9hZGVySm9icycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYWxsIHRoZSBNTCBkYXRhIHByb2Nlc3Npbmcgam9ic1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2xpc3RtbGRhdGFwcm9jZXNzaW5nam9ic1xuICAgKi9cbiAgcHVibGljIHRvTGlzdE1MRGF0YVByb2Nlc3NpbmdKb2JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TUxEYXRhUHJvY2Vzc2luZ0pvYnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCB0aGUgTUwgZW5kcG9pbnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjbGlzdG1sZW5kcG9pbnRzXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0TUxFbmRwb2ludHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNTEVuZHBvaW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYWxsIHRoZSBNTCBtb2RlbCB0cmFpbmluZyBqb2JzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjbGlzdG1sbW9kZWx0cmFpbmluZ2pvYnNcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RNTE1vZGVsVHJhaW5pbmdKb2JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TUxNb2RlbFRyYWluaW5nSm9icycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYWxsIHRoZSBNTCBtb2RlbCB0cmFuc2Zvcm0gam9ic1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI2xpc3RtbG1vZGVsdHJhbnNmb3Jtam9ic1xuICAgKi9cbiAgcHVibGljIHRvTGlzdE1MTW9kZWxUcmFuc2Zvcm1Kb2JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TUxNb2RlbFRyYW5zZm9ybUpvYnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBtYW5hZ2Ugc3RhdGlzdGljcyBpbiB0aGUgZGF0YWJhc2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjbWFuYWdlc3RhdGlzdGljc1xuICAgKi9cbiAgcHVibGljIHRvTWFuYWdlU3RhdGlzdGljcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTWFuYWdlU3RhdGlzdGljcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJ1biByZWFkIGRhdGEgdmlhIHF1ZXJ5IEFQSXMgb24gZGF0YWJhc2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUXVlcnlMYW5ndWFnZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNyZWFkZGF0YXZpYXF1ZXJ5XG4gICAqL1xuICBwdWJsaWMgdG9SZWFkRGF0YVZpYVF1ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZWFkRGF0YVZpYVF1ZXJ5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSB0b2tlbiBuZWVkZWQgZm9yIHJlc2V0IGFuZCByZXNldHMgdGhlIE5lcHR1bmUgZGF0YWJhc2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWwjcmVzZXRkYXRhYmFzZVxuICAgKi9cbiAgcHVibGljIHRvUmVzZXREYXRhYmFzZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUmVzZXREYXRhYmFzZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0YXJ0IGEgbG9hZGVyIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNzdGFydGxvYWRlcmpvYlxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRMb2FkZXJKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0TG9hZGVySm9iJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYW4gTUwgZGF0YSBwcm9jZXNzaW5nIGpvYlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCNzdGFydG1sZGF0YXByb2Nlc3Npbmdqb2JcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0TUxEYXRhUHJvY2Vzc2luZ0pvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnRNTERhdGFQcm9jZXNzaW5nSm9iJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgYW4gTUwgbW9kZWwgdHJhaW5pbmcgam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI3N0YXJ0bWxtb2RlbHRyYWluaW5nam9iXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydE1MTW9kZWxUcmFpbmluZ0pvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnRNTE1vZGVsVHJhaW5pbmdKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCBhbiBNTCBtb2RlbCB0cmFuc2Zvcm0gam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtYWN0aW9ucy5odG1sI3N0YXJ0bWxtb2RlbHRyYW5zZm9ybWpvYlxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRNTE1vZGVsVHJhbnNmb3JtSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydE1MTW9kZWxUcmFuc2Zvcm1Kb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBydW4gd3JpdGUgZGF0YSB2aWEgcXVlcnkgQVBJcyBvbiBkYXRhYmFzZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmUXVlcnlMYW5ndWFnZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRwLWFjdGlvbnMuaHRtbCN3cml0ZWRhdGF2aWFxdWVyeVxuICAgKi9cbiAgcHVibGljIHRvV3JpdGVEYXRhVmlhUXVlcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1dyaXRlRGF0YVZpYVF1ZXJ5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWxsIGRhdGEtYWNjZXNzIGFjdGlvbnMgaW4gZW5naW5lIHZlcnNpb25zIHByaW9yIHRvIDEuMi4wLjBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbmVwdHVuZS9sYXRlc3QvdXNlcmd1aWRlL2lhbS1kcC1hY3Rpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Nvbm5lY3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ2Nvbm5lY3QnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NhbmNlbExvYWRlckpvYicsXG4gICAgICAnQ2FuY2VsTUxEYXRhUHJvY2Vzc2luZ0pvYicsXG4gICAgICAnQ2FuY2VsTUxNb2RlbFRyYWluaW5nSm9iJyxcbiAgICAgICdDYW5jZWxNTE1vZGVsVHJhbnNmb3JtSm9iJyxcbiAgICAgICdDYW5jZWxRdWVyeScsXG4gICAgICAnQ3JlYXRlTUxFbmRwb2ludCcsXG4gICAgICAnRGVsZXRlRGF0YVZpYVF1ZXJ5JyxcbiAgICAgICdEZWxldGVNTEVuZHBvaW50JyxcbiAgICAgICdEZWxldGVTdGF0aXN0aWNzJyxcbiAgICAgICdNYW5hZ2VTdGF0aXN0aWNzJyxcbiAgICAgICdSZXNldERhdGFiYXNlJyxcbiAgICAgICdTdGFydExvYWRlckpvYicsXG4gICAgICAnU3RhcnRNTERhdGFQcm9jZXNzaW5nSm9iJyxcbiAgICAgICdTdGFydE1MTW9kZWxUcmFpbmluZ0pvYicsXG4gICAgICAnU3RhcnRNTE1vZGVsVHJhbnNmb3JtSm9iJyxcbiAgICAgICdXcml0ZURhdGFWaWFRdWVyeScsXG4gICAgICAnY29ubmVjdCdcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdHZXRFbmdpbmVTdGF0dXMnLFxuICAgICAgJ0dldExvYWRlckpvYlN0YXR1cycsXG4gICAgICAnR2V0TUxEYXRhUHJvY2Vzc2luZ0pvYlN0YXR1cycsXG4gICAgICAnR2V0TUxFbmRwb2ludFN0YXR1cycsXG4gICAgICAnR2V0TUxNb2RlbFRyYWluaW5nSm9iU3RhdHVzJyxcbiAgICAgICdHZXRNTE1vZGVsVHJhbnNmb3JtSm9iU3RhdHVzJyxcbiAgICAgICdHZXRRdWVyeVN0YXR1cycsXG4gICAgICAnR2V0U3RhdGlzdGljc1N0YXR1cycsXG4gICAgICAnR2V0U3RyZWFtUmVjb3JkcycsXG4gICAgICAnUmVhZERhdGFWaWFRdWVyeSdcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0TG9hZGVySm9icycsXG4gICAgICAnTGlzdE1MRGF0YVByb2Nlc3NpbmdKb2JzJyxcbiAgICAgICdMaXN0TUxFbmRwb2ludHMnLFxuICAgICAgJ0xpc3RNTE1vZGVsVHJhaW5pbmdKb2JzJyxcbiAgICAgICdMaXN0TUxNb2RlbFRyYW5zZm9ybUpvYnMnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBkYXRhYmFzZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXB0dW5lL2xhdGVzdC91c2VyZ3VpZGUvaWFtLWRhdGEtcmVzb3VyY2VzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGNsdXN0ZXIgLSBJZGVudGlmaWVyIGZvciB0aGUgY2x1c3Rlci5cbiAgICogQHBhcmFtIGRhdGFiYXNlIC0gSWRlbnRpZmllciBmb3IgdGhlIGRhdGFiYXNlLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqL1xuICBwdWJsaWMgb25EYXRhYmFzZShjbHVzdGVyOiBzdHJpbmcsIGRhdGFiYXNlOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgTmVwdHVuZURiLmRlZmF1bHRQYXJ0aXRpb24gfTpuZXB0dW5lLWRiOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OiR7IGNsdXN0ZXIgfS8keyBkYXRhYmFzZSB9YCk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgZ3JhcGggbW9kZWxcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL25lcHR1bmUvbGF0ZXN0L3VzZXJndWlkZS9pYW0tZHAtY29udGV4dC1rZXlzLmh0bWwjcXVlcnlsYW5ndWFnZVxuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvRGVsZXRlRGF0YVZpYVF1ZXJ5KClcbiAgICogLSAudG9HZXRRdWVyeVN0YXR1cygpXG4gICAqIC0gLnRvR2V0U3RyZWFtUmVjb3JkcygpXG4gICAqIC0gLnRvUmVhZERhdGFWaWFRdWVyeSgpXG4gICAqIC0gLnRvV3JpdGVEYXRhVmlhUXVlcnkoKVxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlKHMpIHRvIGNoZWNrXG4gICAqIEBwYXJhbSBvcGVyYXRvciBXb3JrcyB3aXRoIFtzdHJpbmcgb3BlcmF0b3JzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX2NvbmRpdGlvbl9vcGVyYXRvcnMuaHRtbCNDb25kaXRpb25zX1N0cmluZykuICoqRGVmYXVsdDoqKiBgU3RyaW5nTGlrZWBcbiAgICovXG4gIHB1YmxpYyBpZlF1ZXJ5TGFuZ3VhZ2UodmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYFF1ZXJ5TGFuZ3VhZ2VgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxufVxuIl19