"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Securitylake = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Securitylake extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'securitylake';
        this.accessLevelList = {
            Write: [
                'CreateAwsLogSource',
                'CreateCustomLogSource',
                'CreateDatalake',
                'CreateDatalakeAutoEnable',
                'CreateDatalakeDelegatedAdmin',
                'CreateDatalakeExceptionsSubscription',
                'CreateSubscriber',
                'CreateSubscriptionNotificationConfiguration',
                'DeleteAwsLogSource',
                'DeleteCustomLogSource',
                'DeleteDatalake',
                'DeleteDatalakeAutoEnable',
                'DeleteDatalakeDelegatedAdmin',
                'DeleteDatalakeExceptionsSubscription',
                'DeleteSubscriber',
                'DeleteSubscriptionNotificationConfiguration',
                'UpdateDatalake',
                'UpdateDatalakeExceptionsExpiry',
                'UpdateDatalakeExceptionsSubscription',
                'UpdateSubscriber',
                'UpdateSubscriptionNotificationConfiguration'
            ],
            Read: [
                'GetDatalake',
                'GetDatalakeAutoEnable',
                'GetDatalakeExceptionsExpiry',
                'GetDatalakeExceptionsSubscription',
                'GetDatalakeStatus',
                'GetSubscriber',
                'GetSubscriptionNotificationConfiguration'
            ],
            List: [
                'ListDatalakeExceptions',
                'ListLogSources',
                'ListSubscribers'
            ]
        };
    }
    /**
     * Grants permission to enable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:GetDatabase
     * - glue:GetTable
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateAwsLogSource.html
     */
    toCreateAwsLogSource() {
        return this.to('CreateAwsLogSource');
    }
    /**
     * Grants permission to add a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateCrawler
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:StartCrawlerSchedule
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - lakeformation:GrantPermissions
     * - lakeformation:RegisterResource
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateCustomLogSource.html
     */
    toCreateCustomLogSource() {
        return this.to('CreateCustomLogSource');
    }
    /**
     * Grants permission to create a new Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalake.html
     */
    toCreateDatalake() {
        return this.to('CreateDatalake');
    }
    /**
     * Grants permission to add to the configuration for automatically enabling Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeAutoEnable.html
     */
    toCreateDatalakeAutoEnable() {
        return this.to('CreateDatalakeAutoEnable');
    }
    /**
     * Grants permission to designate the Amazon Security Lake administrator account for the organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeDelegatedAdmin.html
     */
    toCreateDatalakeDelegatedAdmin() {
        return this.to('CreateDatalakeDelegatedAdmin');
    }
    /**
     * Grants permission to get instant notifications about exceptions by subscribing to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeExceptionsSubscription.html
     */
    toCreateDatalakeExceptionsSubscription() {
        return this.to('CreateDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to create a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - lakeformation:GrantPermissions
     * - lakeformation:ListPermissions
     * - lakeformation:RegisterResource
     * - lakeformation:RevokePermissions
     * - ram:GetResourceShareAssociations
     * - ram:GetResourceShares
     * - ram:UpdateResourceShare
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriber.html
     */
    toCreateSubscriber() {
        return this.to('CreateSubscriber');
    }
    /**
     * Grants permission to create a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - s3:GetBucketNotification
     * - s3:PutBucketNotification
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriptionNotificationConfiguration.html
     */
    toCreateSubscriptionNotificationConfiguration() {
        return this.to('CreateSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to disable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteAwsLogSource.html
     */
    toDeleteAwsLogSource() {
        return this.to('DeleteAwsLogSource');
    }
    /**
     * Grants permission to remove a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:StopCrawlerSchedule
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteCustomLogSource.html
     */
    toDeleteCustomLogSource() {
        return this.to('DeleteCustomLogSource');
    }
    /**
     * Grants permission to delete all Security Data Lakes
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalake.html
     */
    toDeleteDatalake() {
        return this.to('DeleteDatalake');
    }
    /**
     * Grants permission to remove from the existing configuration the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeAutoEnable.html
     */
    toDeleteDatalakeAutoEnable() {
        return this.to('DeleteDatalakeAutoEnable');
    }
    /**
     * Grants permission to remove the Delegated Administrator account and disable Amazon Security Lake as a service for this organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DeregisterDelegatedAdministrator
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeDelegatedAdmin.html
     */
    toDeleteDatalakeDelegatedAdmin() {
        return this.to('DeleteDatalakeDelegatedAdmin');
    }
    /**
     * Grants permission to unsubscribe from SNS topics for exception notifications. Also, removes the SNS exception notifications topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeExceptionsSubscription.html
     */
    toDeleteDatalakeExceptionsSubscription() {
        return this.to('DeleteDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to delete the specified subscription permissions for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:ListPermissions
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriber.html
     */
    toDeleteSubscriber() {
        return this.to('DeleteSubscriber');
    }
    /**
     * Grants permission to remove a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriptionNotificationConfiguration.html
     */
    toDeleteSubscriptionNotificationConfiguration() {
        return this.to('DeleteSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to get information on the Security Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalake.html
     */
    toGetDatalake() {
        return this.to('GetDatalake');
    }
    /**
     * Grants permission to get an organization’s configuration setting for the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeAutoEnable.html
     */
    toGetDatalakeAutoEnable() {
        return this.to('GetDatalakeAutoEnable');
    }
    /**
     * Grants permission to allow user to query what was set as the expiration period for the exception message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsExpiry.html
     */
    toGetDatalakeExceptionsExpiry() {
        return this.to('GetDatalakeExceptionsExpiry');
    }
    /**
     * Grants permission to query the protocol and endpoint that were supplied when subscribing to the SNS topics for exception notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsSubscription.html
     */
    toGetDatalakeExceptionsSubscription() {
        return this.to('GetDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to get a static snapshot of the Security Data Lake in the current region, including enabled accounts and log sources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeStatus.html
     */
    toGetDatalakeStatus() {
        return this.to('GetDatalakeStatus');
    }
    /**
     * Grants permission to get subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriber.html
     */
    toGetSubscriber() {
        return this.to('GetSubscriber');
    }
    /**
     * Grants permission to get information for a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriptionNotificationConfiguration.html
     */
    toGetSubscriptionNotificationConfiguration() {
        return this.to('GetSubscriptionNotificationConfiguration');
    }
    /**
     * Grants permission to get the list of all non-retry-able failures
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListDatalakeExceptions.html
     */
    toListDatalakeExceptions() {
        return this.to('ListDatalakeExceptions');
    }
    /**
     * Grants permission to show the estate view of enabled accounts with the enabled sources in the enabled regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListLogSources.html
     */
    toListLogSources() {
        return this.to('ListLogSources');
    }
    /**
     * Grants permission to list all subscription permissions for accounts that are already enabled
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListSubscribers.html
     */
    toListSubscribers() {
        return this.to('ListSubscribers');
    }
    /**
     * Grants permission to update a Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalake.html
     */
    toUpdateDatalake() {
        return this.to('UpdateDatalake');
    }
    /**
     * Grants permission to control the time-to-live (TTL) for the exception message to remain in service cache
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsExpiry.html
     */
    toUpdateDatalakeExceptionsExpiry() {
        return this.to('UpdateDatalakeExceptionsExpiry');
    }
    /**
     * Grants permission to update subscriptions to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsSubscription.html
     */
    toUpdateDatalakeExceptionsSubscription() {
        return this.to('UpdateDatalakeExceptionsSubscription');
    }
    /**
     * Grants permission to update subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriber.html
     */
    toUpdateSubscriber() {
        return this.to('UpdateSubscriber');
    }
    /**
     * Grants permission to update a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - s3:CreateBucket
     * - s3:GetBucketNotification
     * - s3:ListBucket
     * - s3:PutBucketNotification
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - s3:PutLifecycleConfiguration
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriptionNotificationConfiguration.html
     */
    toUpdateSubscriptionNotificationConfiguration() {
        return this.to('UpdateSubscriptionNotificationConfiguration');
    }
}
exports.Securitylake = Securitylake;
_a = JSII_RTTI_SYMBOL_1;
Securitylake[_a] = { fqn: "iam-floyd.Securitylake", version: "0.488.0" };
//# sourceMappingURL=data:application/json;base64,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