"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workmailmessageflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [workmailmessageflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmailmessageflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workmailmessageflow extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [workmailmessageflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmailmessageflow.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'workmailmessageflow';
        this.accessLevelList = {
            Read: [
                'GetRawMessageContent'
            ],
            Write: [
                'PutRawMessageContent'
            ]
        };
    }
    /**
     * Grants permission to read the content of email messages with the specified message ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_messageflow_GetRawMessageContent.html
     */
    toGetRawMessageContent() {
        return this.to('GetRawMessageContent');
    }
    /**
     * Grants permission to update the content of email messages with the specified message ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_messageflow_PutRawMessageContent.html
     */
    toPutRawMessageContent() {
        return this.to('PutRawMessageContent');
    }
    /**
     * Adds a resource of type RawMessage to the statement
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/lambda-content.html
     *
     * @param organizationId - Identifier for the organizationId.
     * @param context - Identifier for the context.
     * @param messageId - Identifier for the messageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRawMessage(organizationId, context, messageId, account, region, partition) {
        return this.on(`arn:${partition || Workmailmessageflow.defaultPartition}:workmailmessageflow:${region || '*'}:${account || '*'}:message/${organizationId}/${context}/${messageId}`);
    }
}
exports.Workmailmessageflow = Workmailmessageflow;
_a = JSII_RTTI_SYMBOL_1;
Workmailmessageflow[_a] = { fqn: "iam-floyd.Workmailmessageflow", version: "0.488.0" };
//# sourceMappingURL=data:application/json;base64,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