#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2018  David Arroyo Menéndez

# Author: David Arroyo Menéndez <davidam@gnu.org>
# Maintainer: David Arroyo Menéndez <davidam@gnu.org>

# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.

# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with damenltk; see the file LICENSE.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301 USA,

import unittest
import nltk
from nltk.corpus import stopwords
from src.stopwords import StopWords


class TddInPythonExample(unittest.TestCase):

    def test_stopwords_remove_method_returns_correct_result(self):
        sw = StopWords()
        str1 = "For sequences, (strings, lists, tuples), use the fact "
        str1 = str1 + "that empty sequences are false."
        self.assertEqual(['For', 'sequences', ',', '(', 'strings', ',',
                          'lists', ',', 'tuples', ')', ',', 'use', 'fact',
                          'empty', 'sequences', 'false', '.'],
                         sw.remove(str1))

    def test_stopwords_definition_method_returns_correct_result(self):
        st0 = stopwords.words('english')
        st1 = ['i', 'me', 'my', 'myself', 'we', 'our', 'ours', 'ourselves',
               'you', 'your', 'yours', 'yourself', 'yourselves', 'he', 'him',
               'his', 'himself', 'she', 'her', 'hers', 'herself', 'it', 'its',
               'itself', 'they', 'them', 'their', 'theirs', 'themselves',
               'what', 'which', 'who', 'whom', 'this', 'that', 'these',
               'those', 'am', 'is', 'are', 'was', 'were', 'be', 'been',
               'being', 'have', 'has', 'had', 'having', 'do', 'does', 'did',
               'doing', 'a', 'an', 'the', 'and', 'but', 'if', 'or', 'because',
               'as', 'until', 'while', 'of', 'at', 'by', 'for', 'with',
               'about', 'against', 'between', 'into', 'through', 'during',
               'before', 'after', 'above', 'below', 'to', 'from', 'up',
               'down', 'in', 'out', 'on', 'off', 'over', 'under', 'again',
               'further', 'then', 'once', 'here', 'there', 'when', 'where',
               'why', 'how', 'all', 'any', 'both', 'each', 'few', 'more',
               'most', 'other', 'some', 'such', 'no', 'nor', 'not', 'only',
               'own', 'same', 'so', 'than', 'too', 'very', 's', 't', 'can',
               'will', 'just', 'don', 'should', 'now', 'd', 'll', 'm',
               'o', 're', 've', 'y', 'ain', 'aren',
               'couldn', 'didn', 'doesn', 'hadn', 'hasn', 'haven', 'isn', 'ma',
               'mightn', 'mustn', 'needn', 'shan', 'shouldn', 'wasn', 'weren',
               'won', 'wouldn']
        self.assertEqual(st0[0], st1[0])
        self.assertEqual(st0[4], st1[4])

    def test_stopwords_spanish_method_returns_correct_result(self):
        st0 = stopwords.words('spanish')
        self.assertEqual(st0[0], "de")
        self.assertEqual(st0[-1], "tened")

        
