import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#id LoadbalancerBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the load balancer to which the backend is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#loadbalancer LoadbalancerBackend#loadbalancer}
    */
    readonly loadbalancer: string;
    /**
    * The name of the backend must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#name LoadbalancerBackend#name}
    */
    readonly name: string;
    /**
    * Domain Name Resolver used with dynamic type members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#resolver_name LoadbalancerBackend#resolver_name}
    */
    readonly resolverName?: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#properties LoadbalancerBackend#properties}
    */
    readonly properties?: LoadbalancerBackendProperties;
}
export interface LoadbalancerBackendProperties {
    /**
    * Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for tcp type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_expected_status LoadbalancerBackend#health_check_expected_status}
    */
    readonly healthCheckExpectedStatus?: number;
    /**
    * Sets how many failed health checks are allowed until the backend member is taken off from the rotation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_fall LoadbalancerBackend#health_check_fall}
    */
    readonly healthCheckFall?: number;
    /**
    * Interval between health checks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_interval LoadbalancerBackend#health_check_interval}
    */
    readonly healthCheckInterval?: number;
    /**
    * Sets how many passing checks there must be before returning the backend member to the rotation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_rise LoadbalancerBackend#health_check_rise}
    */
    readonly healthCheckRise?: number;
    /**
    * Health check type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_type LoadbalancerBackend#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Target path for health check HTTP GET requests. Ignored for tcp type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#health_check_url LoadbalancerBackend#health_check_url}
    */
    readonly healthCheckUrl?: string;
    /**
    * Enable outbound proxy protocol by setting the desired version. Empty string disables proxy protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#outbound_proxy_protocol LoadbalancerBackend#outbound_proxy_protocol}
    */
    readonly outboundProxyProtocol?: string;
    /**
    * Sets sticky session cookie name. Empty string disables sticky session.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#sticky_session_cookie_name LoadbalancerBackend#sticky_session_cookie_name}
    */
    readonly stickySessionCookieName?: string;
    /**
    * Backend server timeout in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_server LoadbalancerBackend#timeout_server}
    */
    readonly timeoutServer?: number;
    /**
    * Maximum inactivity time on the client and server side for tunnels in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#timeout_tunnel LoadbalancerBackend#timeout_tunnel}
    */
    readonly timeoutTunnel?: number;
}
export declare function loadbalancerBackendPropertiesToTerraform(struct?: LoadbalancerBackendPropertiesOutputReference | LoadbalancerBackendProperties): any;
export declare class LoadbalancerBackendPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerBackendProperties | undefined;
    set internalValue(value: LoadbalancerBackendProperties | undefined);
    private _healthCheckExpectedStatus?;
    get healthCheckExpectedStatus(): number;
    set healthCheckExpectedStatus(value: number);
    resetHealthCheckExpectedStatus(): void;
    get healthCheckExpectedStatusInput(): number | undefined;
    private _healthCheckFall?;
    get healthCheckFall(): number;
    set healthCheckFall(value: number);
    resetHealthCheckFall(): void;
    get healthCheckFallInput(): number | undefined;
    private _healthCheckInterval?;
    get healthCheckInterval(): number;
    set healthCheckInterval(value: number);
    resetHealthCheckInterval(): void;
    get healthCheckIntervalInput(): number | undefined;
    private _healthCheckRise?;
    get healthCheckRise(): number;
    set healthCheckRise(value: number);
    resetHealthCheckRise(): void;
    get healthCheckRiseInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _healthCheckUrl?;
    get healthCheckUrl(): string;
    set healthCheckUrl(value: string);
    resetHealthCheckUrl(): void;
    get healthCheckUrlInput(): string | undefined;
    private _outboundProxyProtocol?;
    get outboundProxyProtocol(): string;
    set outboundProxyProtocol(value: string);
    resetOutboundProxyProtocol(): void;
    get outboundProxyProtocolInput(): string | undefined;
    private _stickySessionCookieName?;
    get stickySessionCookieName(): string;
    set stickySessionCookieName(value: string);
    resetStickySessionCookieName(): void;
    get stickySessionCookieNameInput(): string | undefined;
    private _timeoutServer?;
    get timeoutServer(): number;
    set timeoutServer(value: number);
    resetTimeoutServer(): void;
    get timeoutServerInput(): number | undefined;
    private _timeoutTunnel?;
    get timeoutTunnel(): number;
    set timeoutTunnel(value: number);
    resetTimeoutTunnel(): void;
    get timeoutTunnelInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend}
*/
export declare class LoadbalancerBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerBackendConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerBackendConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadbalancer?;
    get loadbalancer(): string;
    set loadbalancer(value: string);
    get loadbalancerInput(): string | undefined;
    get members(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resolverName?;
    get resolverName(): string;
    set resolverName(value: string);
    resetResolverName(): void;
    get resolverNameInput(): string | undefined;
    private _properties;
    get properties(): LoadbalancerBackendPropertiesOutputReference;
    putProperties(value: LoadbalancerBackendProperties): void;
    resetProperties(): void;
    get propertiesInput(): LoadbalancerBackendProperties | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
