"""
    Colors info
"""

# fmt: off
# Material colors: https://material.io/design/color/the-color-system.html#color-usage-palettes
MATERIAL = {
    "red":           {50:"#FFEBEE", 100:"#FFCDD2", 200:"#EF9A9A", 300:"#E57373", 400:"#EF5350", 500:"#F44336", 600:"#E53935", 700:"#D32F2F", 800:"#C62828", 900:"#B71C1C"},
    "pink":          {50:"#FCE4EC", 100:"#F8BBD0", 200:"#F48FB1", 300:"#F06292", 400:"#EC407A", 500:"#E91E63", 600:"#D81B60", 700:"#C2185B", 800:"#AD1457", 900:"#880E4F"},
    "purple":        {50:"#F3E5F5", 100:"#E1BEE7", 200:"#CE93D8", 300:"#BA68C8", 400:"#AB47BC", 500:"#9C27B0", 600:"#8E24AA", 700:"#7B1FA2", 800:"#6A1B9A", 900:"#4A148C"},
    "deep purple":   {50:"#EDE7F6", 100:"#D1C4E9", 200:"#B39DDB", 300:"#9575CD", 400:"#7E57C2", 500:"#673AB7", 600:"#5E35B1", 700:"#512DA8", 800:"#4527A0", 900:"#311B92"},
    "indigo":        {50:"#E8EAF6", 100:"#C5CAE9", 200:"#9FA8DA", 300:"#7986CB", 400:"#5C6BC0", 500:"#3F51B5", 600:"#3949AB", 700:"#303F9F", 800:"#283593", 900:"#1A237E"},
    "blue":          {50:"#E3F2FD", 100:"#BBDEFB", 200:"#90CAF9", 300:"#64B5F6", 400:"#42A5F5", 500:"#2196F3", 600:"#1E88E5", 700:"#1976D2", 800:"#1565C0", 900:"#0D47A1"},
    "light blue":    {50:"#E1F5FE", 100:"#B3E5FC", 200:"#81D4FA", 300:"#4FC3F7", 400:"#29B6F6", 500:"#03A9F4", 600:"#039BE5", 700:"#0288D1", 800:"#0277BD", 900:"#01579B"},
    "cyan":          {50:"#E0F7FA", 100:"#B2EBF2", 200:"#80DEEA", 300:"#4DD0E1", 400:"#26C6DA", 500:"#00BCD4", 600:"#00ACC1", 700:"#0097A7", 800:"#00838F", 900:"#006064"},
    "teal":          {50:"#E0F2F1", 100:"#B2DFDB", 200:"#80CBC4", 300:"#4DB6AC", 400:"#26A69A", 500:"#009688", 600:"#00897B", 700:"#00796B", 800:"#00695C", 900:"#004D40"},
    "green":         {50:"#E8F5E9", 100:"#C8E6C9", 200:"#A5D6A7", 300:"#81C784", 400:"#66BB6A", 500:"#4CAF50", 600:"#43A047", 700:"#388E3C", 800:"#2E7D32", 900:"#1B5E20"},
    "light green":   {50:"#F1F8E9", 100:"#DCEDC8", 200:"#C5E1A5", 300:"#AED581", 400:"#9CCC65", 500:"#8BC34A", 600:"#7CB342", 700:"#689F38", 800:"#558B2F", 900:"#33691E"},
    "lime":          {50:"#F9FBE7", 100:"#F0F4C3", 200:"#E6EE9C", 300:"#DCE775", 400:"#D4E157", 500:"#CDDC39", 600:"#C0CA33", 700:"#AFB42B", 800:"#9E9D24", 900:"#827717"},
    "yellow":        {50:"#FFFDE7", 100:"#FFF9C4", 200:"#FFF59D", 300:"#FFF176", 400:"#FFEE58", 500:"#FFEB3B", 600:"#FDD835", 700:"#FBC02D", 800:"#F9A825", 900:"#F57F17"},
    "amber":         {50:"#FFF8E1", 100:"#FFECB3", 200:"#FFE082", 300:"#FFD54F", 400:"#FFCA28", 500:"#FFC107", 600:"#FFB300", 700:"#FFA000", 800:"#FF8F00", 900:"#FF6F00"},
    "orange":        {50:"#FFF3E0", 100:"#FFE0B2", 200:"#FFCC80", 300:"#FFB74D", 400:"#FFA726", 500:"#FF9800", 600:"#FB8C00", 700:"#F57C00", 800:"#EF6C00", 900:"#E65100"},
    "deep orange":   {50:"#FBE9E7", 100:"#FFCCBC", 200:"#FFAB91", 300:"#FF8A65", 400:"#FF7043", 500:"#FF5722", 600:"#F4511E", 700:"#E64A19", 800:"#D84315", 900:"#BF360C"},
    "brown":         {50:"#EFEBE9", 100:"#D7CCC8", 200:"#BCAAA4", 300:"#A1887F", 400:"#8D6E63", 500:"#795548", 600:"#6D4C41", 700:"#5D4037", 800:"#4E342E", 900:"#3E2723"},
    "grey":          {50:"#FAFAFA", 100:"#F5F5F5", 200:"#EEEEEE", 300:"#E0E0E0", 400:"#BDBDBD", 500:"#9E9E9E", 600:"#757575", 700:"#616161", 800:"#424242", 900:"#212121"},
    "blue grey":     {50:"#ECEFF1", 100:"#CFD8DC", 200:"#B0BEC5", 300:"#90A4AE", 400:"#78909C", 500:"#607D8B", 600:"#546E7A", 700:"#455A64", 800:"#37474F", 900:"#263238"},
    "black":         {50:"#000000", 100:"#000000", 200:"#000000", 300:"#000000", 400:"#000000", 500:"#000000", 600:"#000000", 700:"#000000", 800:"#000000", 900:"#000000"},
    "white":         {50:"#FFFFFF", 100:"#FFFFFF", 200:"#FFFFFF", 300:"#FFFFFF", 400:"#FFFFFF", 500:"#FFFFFF", 600:"#FFFFFF", 700:"#FFFFFF", 800:"#FFFFFF", 900:"#FFFFFF"},
}

# Flat UI colors: https://htmlcolorcodes.com/color-chart/flat-design-color-chart/
FLAT = {
    "turquoise":     {50:"#E8F8F5", 100:"#D1F2EB", 200:"#A3E4D7", 300:"#76D7C4", 400:"#48C9B0", 500:"#1ABC9C", 600:"#17A589", 700:"#148F77", 800:"#117864", 900:"#0E6251"},
    "green-sea":     {50:"#E8F6F3", 100:"#D0ECE7", 200:"#A2D9CE", 300:"#73C6B6", 400:"#45B39D", 500:"#16A085", 600:"#138D75", 700:"#117A65", 800:"#0E6655", 900:"#0B5345"},
    "emerald":       {50:"#EAFAF1", 100:"#D5F5E3", 200:"#ABEBC6", 300:"#82E0AA", 400:"#58D68D", 500:"#2ECC71", 600:"#28B463", 700:"#239B56", 800:"#1D8348", 900:"#186A3B"},
    "nephritis":     {50:"#E9F7EF", 100:"#D4EFDF", 200:"#A9DFBF", 300:"#7DCEA0", 400:"#52BE80", 500:"#27AE60", 600:"#229954", 700:"#1E8449", 800:"#196F3D", 900:"#145A32"},
    "peter-river":   {50:"#EBF5FB", 100:"#D6EAF8", 200:"#AED6F1", 300:"#85C1E9", 400:"#5DADE2", 500:"#3498DB", 600:"#2E86C1", 700:"#2874A6", 800:"#21618C", 900:"#1B4F72"},
    "belize-hole":   {50:"#EAF2F8", 100:"#D4E6F1", 200:"#A9CCE3", 300:"#7FB3D5", 400:"#5499C7", 500:"#2980B9", 600:"#2471A3", 700:"#1F618D", 800:"#1A5276", 900:"#154360"},
    "amethyst":      {50:"#F5EEF8", 100:"#EBDEF0", 200:"#D7BDE2", 300:"#C39BD3", 400:"#AF7AC5", 500:"#9B59B6", 600:"#884EA0", 700:"#76448A", 800:"#633974", 900:"#512E5F"},
    "wisteria":      {50:"#F4ECF7", 100:"#E8DAEF", 200:"#D2B4DE", 300:"#BB8FCE", 400:"#A569BD", 500:"#8E44AD", 600:"#7D3C98", 700:"#6C3483", 800:"#5B2C6F", 900:"#4A235A"},
    "wet-asphalt":   {50:"#EBEDEF", 100:"#D6DBDF", 200:"#AEB6BF", 300:"#85929E", 400:"#5D6D7E", 500:"#34495E", 600:"#2E4053", 700:"#283747", 800:"#212F3C", 900:"#1B2631"},
    "midnight-blue": {50:"#EAECEE", 100:"#D5D8DC", 200:"#ABB2B9", 300:"#808B96", 400:"#566573", 500:"#2C3E50", 600:"#273746", 700:"#212F3D", 800:"#1C2833", 900:"#17202A"},
    "sunflower":     {50:"#FEF9E7", 100:"#FCF3CF", 200:"#F9E79F", 300:"#F7DC6F", 400:"#F4D03F", 500:"#F1C40F", 600:"#D4AC0D", 700:"#B7950B", 800:"#9A7D0A", 900:"#7D6608"},
    "orange":        {50:"#FEF5E7", 100:"#FDEBD0", 200:"#FAD7A0", 300:"#F8C471", 400:"#F5B041", 500:"#F39C12", 600:"#D68910", 700:"#B9770E", 800:"#9C640C", 900:"#7E5109"},
    "carrot":        {50:"#FDF2E9", 100:"#FAE5D3", 200:"#F5CBA7", 300:"#F0B27A", 400:"#EB984E", 500:"#E67E22", 600:"#CA6F1E", 700:"#AF601A", 800:"#935116", 900:"#784212"},
    "pumpkin":       {50:"#FBEEE6", 100:"#F6DDCC", 200:"#EDBB99", 300:"#E59866", 400:"#DC7633", 500:"#D35400", 600:"#BA4A00", 700:"#A04000", 800:"#873600", 900:"#6E2C00"},
    "alizarin":      {50:"#FDEDEC", 100:"#FADBD8", 200:"#F5B7B1", 300:"#F1948A", 400:"#EC7063", 500:"#E74C3C", 600:"#CB4335", 700:"#B03A2E", 800:"#943126", 900:"#78281F"},
    "pomegranate":   {50:"#F9EBEA", 100:"#F2D7D5", 200:"#E6B0AA", 300:"#D98880", 400:"#CD6155", 500:"#C0392B", 600:"#A93226", 700:"#922B21", 800:"#7B241C", 900:"#641E16"},
    "clouds":        {50:"#FDFEFE", 100:"#FBFCFC", 200:"#F7F9F9", 300:"#F4F6F7", 400:"#F0F3F4", 500:"#ECF0F1", 600:"#D0D3D4", 700:"#B3B6B7", 800:"#979A9A", 900:"#7B7D7D"},
    "silver":        {50:"#F8F9F9", 100:"#F2F3F4", 200:"#E5E7E9", 300:"#D7DBDD", 400:"#CACFD2", 500:"#BDC3C7", 600:"#A6ACAF", 700:"#909497", 800:"#797D7F", 900:"#626567"},
    "concrete":      {50:"#F4F6F6", 100:"#EAEDED", 200:"#D5DBDB", 300:"#BFC9CA", 400:"#AAB7B8", 500:"#95A5A6", 600:"#839192", 700:"#717D7E", 800:"#5F6A6A", 900:"#4D5656"},
    "asbestos":      {50:"#F2F4F4", 100:"#E5E8E8", 200:"#CCD1D1", 300:"#B2BABB", 400:"#99A3A4", 500:"#7F8C8D", 600:"#707B7C", 700:"#616A6B", 800:"#515A5A", 900:"#424949"}, 
}

# Tailwind colors: https://uicolors.app/browse/tailwind-colors
TAILWIND = {
    "rose":          {50:"#FFF1F2", 100:"#FFE4E6", 200:"#FECDD3", 300:"#FDA4AF", 400:"#FB7185", 500:"#F43F5E", 600:"#E11D48", 700:"#BE123C", 800:"#9F1239", 900:"#881337", 950:"#4C0519"},
    "pink":          {50:"#FDF2F8", 100:"#FCE7F3", 200:"#FBCFE8", 300:"#F9A8D4", 400:"#F472B6", 500:"#EC4899", 600:"#DB2777", 700:"#BE185D", 800:"#9D174D", 900:"#831843", 950:"#500724"},
    "fuchsia":       {50:"#FDF4FF", 100:"#FAE8FF", 200:"#F5D0FE", 300:"#F0ABFC", 400:"#E879F9", 500:"#D946EF", 600:"#C026D3", 700:"#A21CAF", 800:"#86198F", 900:"#701A75", 950:"#4A044E"},
    "purple":        {50:"#FAF5FF", 100:"#F3E8FF", 200:"#E9D5FF", 300:"#D8B4FE", 400:"#C084FC", 500:"#A855F7", 600:"#9333EA", 700:"#7E22CE", 800:"#6B21A8", 900:"#581C87", 950:"#3B0764"},
    "violet":        {50:"#F5F3FF", 100:"#EDE9FE", 200:"#DDD6FE", 300:"#C4B5FD", 400:"#A78BFA", 500:"#8B5CF6", 600:"#7C3AED", 700:"#6D28D9", 800:"#5B21B6", 900:"#4C1D95", 950:"#2E1065"},
    "indigo":        {50:"#EEF2FF", 100:"#E0E7FF", 200:"#C7D2FE", 300:"#A5B4FC", 400:"#818CF8", 500:"#6366F1", 600:"#4F46E5", 700:"#4338CA", 800:"#3730A3", 900:"#312E81", 950:"#1E1B4B"},
    "blue":          {50:"#EFF6FF", 100:"#DBEAFE", 200:"#BFDBFE", 300:"#93C5FD", 400:"#60A5FA", 500:"#3B82F6", 600:"#2563EB", 700:"#1D4ED8", 800:"#1E40AF", 900:"#1E3A8A", 950:"#172554"},
    "sky":           {50:"#F0F9FF", 100:"#E0F2FE", 200:"#BAE6FD", 300:"#7DD3FC", 400:"#38BDF8", 500:"#0EA5E9", 600:"#0284C7", 700:"#0369A1", 800:"#075985", 900:"#0C4A6E", 950:"#082F49"},
    "cyan":          {50:"#ECFEFF", 100:"#CFFAFE", 200:"#A5F3FC", 300:"#67E8F9", 400:"#22D3EE", 500:"#06B6D4", 600:"#0891B2", 700:"#0E7490", 800:"#155E75", 900:"#164E63", 950:"#083344"},
    "teal":          {50:"#F0FDFA", 100:"#CCFBF1", 200:"#99F6E4", 300:"#5EEAD4", 400:"#2DD4BF", 500:"#14B8A6", 600:"#0D9488", 700:"#0F766E", 800:"#115E59", 900:"#134E4A", 950:"#042F2E"},
    "emerald":       {50:"#ECFDF5", 100:"#D1FAE5", 200:"#A7F3D0", 300:"#6EE7B7", 400:"#34D399", 500:"#10B981", 600:"#059669", 700:"#047857", 800:"#065F46", 900:"#064E3B", 950:"#022C22"},
    "green":         {50:"#F0FDF4", 100:"#DCFCE7", 200:"#BBF7D0", 300:"#86EFAC", 400:"#4ADE80", 500:"#22C55E", 600:"#16A34A", 700:"#15803D", 800:"#166534", 900:"#14532D", 950:"#052E16"},
    "lime":          {50:"#F7FEE7", 100:"#ECFCCB", 200:"#D9F99D", 300:"#BEF264", 400:"#A3E635", 500:"#84CC16", 600:"#65A30D", 700:"#4D7C0F", 800:"#3F6212", 900:"#365314", 950:"#1A2E05"},
    "yellow":        {50:"#FEFCE8", 100:"#FEF9C3", 200:"#FEF08A", 300:"#FDE047", 400:"#FACC15", 500:"#EAB308", 600:"#CA8A04", 700:"#A16207", 800:"#854D0E", 900:"#713F12", 950:"#422006"},
    "amber":         {50:"#FFFBEB", 100:"#FEF3C7", 200:"#FDE68A", 300:"#FCD34D", 400:"#FBBF24", 500:"#F59E0B", 600:"#D97706", 700:"#B45309", 800:"#92400E", 900:"#78350F", 950:"#451A03"},
    "orange":        {50:"#FFF7ED", 100:"#FFEDD5", 200:"#FED7AA", 300:"#FDBA74", 400:"#FB923C", 500:"#F97316", 600:"#EA580C", 700:"#C2410C", 800:"#9A3412", 900:"#7C2D12", 950:"#431407"},
    "red":           {50:"#FEF2F2", 100:"#FEE2E2", 200:"#FECACA", 300:"#FCA5A5", 400:"#F87171", 500:"#EF4444", 600:"#DC2626", 700:"#B91C1C", 800:"#991B1B", 900:"#7F1D1D", 950:"#450A0A"},
    "stone":         {50:"#FAFAF9", 100:"#F5F5F4", 200:"#E7E5E4", 300:"#D6D3D1", 400:"#A8A29E", 500:"#78716C", 600:"#57534E", 700:"#44403C", 800:"#292524", 900:"#1C1917", 950:"#0C0A09"},
    "neutral":       {50:"#FAFAFA", 100:"#F5F5F5", 200:"#E5E5E5", 300:"#D4D4D4", 400:"#A3A3A3", 500:"#737373", 600:"#525252", 700:"#404040", 800:"#262626", 900:"#171717", 950:"#0A0A0A"},
    "zinc":          {50:"#FAFAFA", 100:"#F4F4F5", 200:"#E4E4E7", 300:"#D4D4D8", 400:"#A1A1AA", 500:"#71717A", 600:"#52525B", 700:"#3F3F46", 800:"#27272A", 900:"#18181B", 950:"#09090B"},
    "gray":          {50:"#F9FAFB", 100:"#F3F4F6", 200:"#E5E7EB", 300:"#D1D5DB", 400:"#9CA3AF", 500:"#6B7280", 600:"#4B5563", 700:"#374151", 800:"#1F2937", 900:"#111827", 950:"#030712"},
    "slate":         {50:"#F8FAFC", 100:"#F1F5F9", 200:"#E2E8F0", 300:"#CBD5E1", 400:"#94A3B8", 500:"#64748B", 600:"#475569", 700:"#334155", 800:"#1E293B", 900:"#0F172A", 950:"#020617"},
}
# fmt: on

COLORS = {"material": MATERIAL, "flat": FLAT, "tailwind": TAILWIND}
