# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['panels']

package_data = \
{'': ['*'],
 'panels': ['json/*',
            'json/emtech/adoption/*',
            'json/emtech/dev/*',
            'json/emtech/social/*']}

setup_kwargs = {
    'name': 'grimoirelab-panels',
    'version': '0.1.2rc3',
    'description': 'Panels and visualizations for GrimoireLab dashboards',
    'long_description': "Generic Dashboards for GrimoireLab\n==================================\n\nEach of the files found in this directory are a JSON file that contains all of the information related to a Kibana dashboard.\nThis usually has information about the following artifacts:\n* Original indexes where the information come from.\n* Searches on those indexes that provide a sub-set of the information.\n* Widgets either built on top of the original indexes or on top of the searches.\n* Final panels that are an aggregation of several widgets.\n\nThere are Dashboards for Kibana 6 right now stored in `panels/json`\n\nPanels\n------\n\nA panel is composed by the several widgets this contains.\nSo far the panels proposed as generic are a mix of the several data sources available in a project. Those could be only focused on Git, but there are others such as review systems like Gerrit, IRC channels, mailing lists, etc.\n\nThe structure for naming files should be:\n* For data sources: \n```\n<data_source>[_<panel_name>].json\n\nExamples:\ngit_<panel_name>.json\ngerrit_<panel_name>.json\n```\n* For other panels not focused on particular data sources we just use the name of the panel:\n```\n<panel_name>.json\n\nExamples:\nabout.json\noverview.json\ngit.json\ngit_pair_programming.json\ngerrit.json\ngerrit_timing.json\n```\nTo give some examples, below there is a list of some panels that can be found in this directory:\n* git.json: provides aggregated information about all of the gits in the analysis.\n* gerrit.json: provides aggregated information from all of the gerrit projects.\n* gerrit-backlog.json: provides specific widgets to track the backlog of the project.\n* mailinglists.json: provides information about the discussions that take place in the several mailing lists.\n* about.json: provides some widgets detailing this information and how to interact with the panels.\n* overview.json: provides a generic view of the dataset with some widgets that help to drill down the information from the whole list of data sources.\n\nAll panels will provide widgets for filtering information by project, domain, organization, etc. depending on the availability of that information in the corresponding index.\n\nWidgets Naming\n--------------\n\n```\n <data_source>_<metric_used>\n\n Example: git_top_authors\n Example: git_authors\n```\n\nWhere data source could be git, gerrit, mbox, etc.\n\nWidgets Title Naming\n--------------------\n\nIn general, titles should follow the same naming scheme as the widget itself, substituting underscore characters by single spaces and adding capital letters. Nevertheless, **widgets title depends on the name of the panel** in which the widgets are located: \n\n- **If the panel shows information for several data sources, then the name of the data source must be included**. For example, it's the case of Data Status Panel, because it contains the same information per data source, so using data source name in title is mandatory.  \n\n- **If the name of the data source is included in the title of the panel, then the name of the data source shouldn't be included in widgets' title**, except in cases where it could help understand what the widget contains.\n\n\n```\n <data_source> <metric_used>\n \n Example: \n   Same visualization for top authors would be named: \n \n   - 'Top Authors' in 'Git' panel, as the panel is giving us context.\n   - 'Git Top Authors' in 'Overview' panel where we could have similar visualizations for other data sources.\n```\n\nOf course this is a general rule, just have context into account with naming widgets to know if data source is clear or not.\n\nSearches Naming\n---------------\n\n```\nSearch:_<field>:<search>\n\nExample: Search:_pull_request:true\n```\n\n\nIndexes Naming\n--------------\nNotice that optional date is included to allow keeping several copies of the same data source when needed.\n\nRaw indexes should use suffix `-raw`:\n```\n<data_source>-raw[_date]\n\nExample: git-raw\nExample: gerrit-raw\nExample: stackoverflow-raw\nExample: jira-raw\nExample: bugzilla-raw\n```\nEnriched indexes:\n```\n<data_source>_enriched[_date]\n\nExample: git_enriched\nExample: gerrit_enriched\nExample: stackoverflow_enriched\nExample: jira_enriched\nExample: bugzilla_enriched\n```\n\nAliases Naming\n--------------\n\nFinally, an alias should be created pointing to the enriched index. This allows to easily modify the data used under the hood in a transparent way from the point of view of panels. Its name should be just the name of the data source, but sometimes we need different indexes for the same data source. In that case we would add a suffix to indicate the functionality of that alias.\n```\n<data_source>\n\nExample: git\nExample: gerrit\nExample: stackoverflow\nExample: jira\nExample: bugzilla\n```\n\nFor each index there could be as many aliases as needed. The most usual use case is using aliases for building panels or visualizations based on different time series. E.g.:\n```\n<data_source>_<field_name>\n\nExample for git index and metadata__timestamp:\ngit_metadata__timestamp\n\nExample for git index and metadata__updated_on:\ngit_metadata__updated_on\n\nExample for jenkins and created_at field:\njenkins_created_at\n```\n\nIndex Pattern Naming\n--------------------\n\nIndex patterns in Kibana should follow the same naming scheme as aliases in ES (see [Aliases Naming](#aliases-naming) section). This way, is easy to know what alias is being used by a given index pattern. Besides, it makes easier to select index patterns from kibana, because their names include the field configured for time series in that index pattern. \n\n\nCommon Index Fields\n-------------------\n\nFollowing fields that should be included in any index pattern:\n\n* id\n* url\n* metadata__timestamp\n* metadata__updated_on\n* author_bot\n* author_name\n* author_org_name\n* author_uuid\n* author_domain\n* author_user_name\n* origin\n* grimoire_creation_date\n\n\nData model\n----------\n\nEach of the indexes are based on a previous definition. This\nis declared in CSV format with two columns: name and type.\n\nMore information at the [Schema](https://github.com/chaoss/grimoirelab-elk/tree/master/schema) directory.\n\n\nHow this info was retrieved\n---------------------------\n\nThese json files were retrieved using [Kidash](https://github.com/chaoss/grimoirelab-kidash).\n\nExample of how to run this:\n\n```\n$ kidash -g -e <elasticsearch-url> --dashboard <dashboard-id>* --export <local-file-path> --split-index-patterns\n\nexample: \n$ kidash -g -e https://admin:admin@localhost:9200 --dashboard overview --export overview.json --split-index-patterns\n```\n\nMore information: [Kidash - Usage](https://github.com/chaoss/grimoirelab-kidash#usage).\n",
    'author': 'GrimoireLab Developers',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chaoss.github.io/grimoirelab/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
