"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codestar_GitHubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitHubRepository);
            }
            throw error;
        }
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.unsafeUnwrap(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: props.enableIssues ?? true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
_a = JSII_RTTI_SYMBOL_1;
GitHubRepository[_a] = { fqn: "@aws-cdk/aws-codestar.GitHubRepository", version: "1.163.1" };
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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