# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bookops_worldcat']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27,<3.0']

setup_kwargs = {
    'name': 'bookops-worldcat',
    'version': '0.5.0',
    'description': 'OCLC WorldCat Metadata APIs wrapper',
    'long_description': '[![Build Status](https://github.com/BookOps-CAT/bookops-marc/actions/workflows/unit-tests.yaml/badge.svg?branch=master)](https://github.com/BookOps-CAT/bookops-worldcat/actions) [![Coverage Status](https://coveralls.io/repos/github/BookOps-CAT/bookops-worldcat/badge.svg?branch=master)](https://coveralls.io/github/BookOps-CAT/bookops-worldcat?branch=master) [![PyPI version](https://badge.fury.io/py/bookops-worldcat.svg)](https://badge.fury.io/py/bookops-worldcat) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/bookops-worldcat) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n\n# bookops-worldcat\n**Early ALPHA version**\n\n\nBookOps-Worldcat provides a Python interface for the WorldCat Metadata API.\nThis wrapper simplifies requests to OCLC web services making them ideally more accessible to OCLC member libraries.\n\nDue to major changes introduced by OCLC in May 2020, the version 0.3.0 of the wrapper dropped functionality related to WorldCat Search API. New search endopoints of the Metadata API supported in the 0.3.0 version should fill that gap. While WorldCat Metadata API is our primary focus, we plan in the future to expand wrapper\'s functionality to other related OCLC web services, including the now dropped Search API.  \n\n## Installation\n\nUse pip:\n\n`$ pip install bookops-worldcat`\n\n## Documentation\n\nFor full documentation please see https://bookops-cat.github.io/bookops-worldcat/\n\n## Features\n\nThis package takes advantage of the functionality of the popular [Requests library](https://requests.readthedocs.io/en/master/). Interactions with [OCLC](https://www.oclc.org/en/home.html)\'s services are built around \'Requests\' sessions. Authorizing a web service session simply requires passing an access token to `MetadataSession`. Opening a session allows the user to call specific methods to facilitate communication between the user\'s script/client and particular endpoint of OCLC API service. Many of the hurdles related to making valid requests are hidden under the hood of this package, making it as simple as possible.\nPlease note, not all endpoints of the Metadata API are implemented at the moment.  This tool was primarily built for the specific needs of BookOps but we are open to collaboration to expand and improve this package.\n\nAt the moment, BookOps-Worldcat supports requests to following OCLC\'s web services:\n\n+ [Authentication via Client Credential Grant](https://www.oclc.org/developer/develop/authentication/oauth/client-credentials-grant.en.html)\n+ [Worldcat Metadata API](https://www.oclc.org/developer/develop/web-services/worldcat-metadata-api.en.html)\n    + [Metadata API Search Functionality](https://developer.api.oclc.org/wc-metadata-v1-1)\n      + member shared print holdings\n      + member general holdings\n      + searching bibliographic resources:\n        + search brief bibs\n        + retrieve specific brief bib\n        + retrieve other editions related to a specific bibliographic resource\n    + [Metadata API](https://developer.api.oclc.org/wc-metadata)\n      + bibliographic records\n        + retrieve full bib\n        + find current OCLC number\n      + holdings\n        + set institution holding for a single resource\n        + unset institution holding for a single resource\n        + retrieve holding status of a single resource\n        + set institution holdings for a batch of resources\n        + unset institution holdings for a batch of resouces\n        + set holdings for a single resource for multiple institutions\n        + unset holdings for a single resource for multiple institutions\n\n\n#### Basic usage:\n\nObtaining access token\n```python\n>>> from bookops_worldcat import WorldcatAccessToken\n>>> token = WorldcatAccessToken(\n    key="my_WSkey",\n    secret="my_WSsecret",\n    scopes="selected_scope",\n    principal_id="my_principalID",\n    principal_idns="my_principalIDNS",\n    agent="my_client"\n  )\n>>> print(token.token_str)\n  "tk_Yebz4BpEp9dAsghA7KpWx6dYD1OZKWBlHjqW"\n```\n\nMetadata API\n```python\n>>> from bookops_worldcat import MetadataSession\n>>> session = MetadataSession(authorization=token)\n>>> result = session.get_brief_bib(oclcNumber=1143317889)\n>>> print(result)\n  <Response [200]>\n>>> print(result.json())\n```\n```json\n{\n  "oclcNumber": "1143317889",\n  "title": "Blueprint : the evolutionary origins of a good society",\n  "creator": "Nicholas A. Christakis",\n  "date": "2020",\n  "language": "eng",\n  "generalFormat": "Book",\n  "specificFormat": "PrintBook",\n  "edition": "First Little, Brown Spark trade paperback edition.",\n  "publisher": "Little, Brown Spark",\n  "catalogingInfo": {\n    "catalogingAgency": "NYP",\n    "transcribingAgency": "NYP"\n  }\n}\n```\n\nUsing a context manager:\n```python\nwith MetadataSession(authorization=token) as session:\n    results = session.get_full_bib(1143317889)\n    print(results.text)\n```\n```xml\n<?xml version="1.0" encoding="UTF-8"?>\n<entry xmlns="http://www.w3.org/2005/Atom">\n  <content type="application/xml">\n    <response xmlns="http://worldcat.org/rb" mimeType="application/vnd.oclc.marc21+xml">\n      <record xmlns="http://www.loc.gov/MARC21/slim">\n        <leader>00000cam a2200000 i 4500</leader>\n        <controlfield tag="001">on1143317889</controlfield>\n        <controlfield tag="003">OCoLC</controlfield>\n        <controlfield tag="005">20200328101446.1</controlfield>\n        <controlfield tag="008">200305t20202019nyuabf   b    001 0 eng c</controlfield>\n        <datafield tag="010" ind1=" " ind2=" ">\n          <subfield code="a">  2018957420</subfield>\n    </datafield>\n        <datafield tag="040" ind1=" " ind2=" ">\n          <subfield code="a">NYP</subfield>\n          <subfield code="b">eng</subfield>\n          <subfield code="e">rda</subfield>\n          <subfield code="c">NYP</subfield>\n<!--...-->\n        <datafield tag="020" ind1=" " ind2=" ">\n          <subfield code="a">9780316230049</subfield>\n          <subfield code="q">(pbk.)</subfield>\n<!--...-->\n        <datafield tag="100" ind1="1" ind2=" ">\n          <subfield code="a">Christakis, Nicholas A.,</subfield>\n          <subfield code="e">author.</subfield>\n    </datafield>\n        <datafield tag="245" ind1="1" ind2="0">\n          <subfield code="a">Blueprint :</subfield>\n          <subfield code="b">the evolutionary origins of a good society /</subfield>\n          <subfield code="c">Nicholas A. Christakis.</subfield>\n    </datafield>\n        <datafield tag="250" ind1=" " ind2=" ">\n          <subfield code="a">First Little, Brown Spark trade paperback edition.</subfield>\n    </datafield>\n        <datafield tag="264" ind1=" " ind2="1">\n          <subfield code="a">New York, NY :</subfield>\n          <subfield code="b">Little, Brown Spark,</subfield>\n          <subfield code="c">2020</subfield>\n    </datafield>\n<!--...-->\n  </record>\n    </response>\n  </content>\n  <id>http://worldcat.org/oclc/1143317889</id>\n  <link href="http://worldcat.org/oclc/1143317889"></link>\n</entry>\n```\n\n## Changelog\n\nConsult the [Changelog page](https://bookops-cat.github.io/bookops-worldcat/latest/changelog/) for fixes and enhancements of each version.\n\n## Bugs/Requests\n\nPlease use [Github issue tracker](https://github.com/BookOps-CAT/bookops-worldcat/issues) to submit bugs or request features.\n\n## Todo\n\n+ Metadata API:\n  + support for local holdings resources endpoints of the search functionality of the Metadata API\n  + support for local bibliographic data endpoints\n  + record validation endpoints\n  + methods to create and update bibliographic records\n',
    'author': 'Tomasz Kalata',
    'author_email': 'klingaroo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://bookops-cat.github.io/bookops-worldcat/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
