# Generated by Django 3.0.4 on 2020-04-02 13:37

from django.db import migrations


def fill_crud_view_title(apps, schema_editor):
    CrudView = apps.get_model('terra_geocrud', 'CrudView')
    CrudViewProperty = apps.get_model('terra_geocrud', 'CrudViewProperty')

    for view in CrudView.objects.all():
        title_prop = CrudViewProperty.objects.filter(view=view, key=view.feature_title_property).first()
        view.new_feature_title_property = title_prop
        view.save()


def fill_crud_view_default_list_properties(apps, schema_editor):
    CrudView = apps.get_model('terra_geocrud', 'CrudView')
    CrudViewProperty = apps.get_model('terra_geocrud', 'CrudViewProperty')

    for view in CrudView.objects.all():
        default_list_properties = CrudViewProperty.objects.filter(view=view, key__in=view.default_list_properties)
        view.new_default_list_properties.set(default_list_properties)


class Migration(migrations.Migration):

    dependencies = [
        ('terra_geocrud', '0045_auto_20200402_1337'),
    ]

    operations = [
        migrations.RunPython(fill_crud_view_title),
        migrations.RunPython(fill_crud_view_default_list_properties),
    ]
