"""GaGe defined constants."""


# compuscope status codes (returned by CsGetStatus)
acq_status_codes = dict()
acq_status_codes[0] = "ACQ_STATUS_READY"
acq_status_codes[1] = "ACQ_STATUS_WAIT_TRIGGER"
acq_status_codes[2] = "ACQ_STATUS_TRIGGERED"
acq_status_codes[3] = "ACQ_STATUS_BUSY_TX"
acq_status_codes[4] = "ACQ_STATUS_BUSY_CALIB"


# compuscope error codes
error_codes = {}
error_codes[6] = "CS_STRUCTURE_TRUNCATED"
error_codes[5] = "CS_STRUCTURE_PADDED"
error_codes[4] = "CS_SEGMENTINFO_EMPTY"
error_codes[3] = "CS_ASYNC_SUCCESS"
error_codes[2] = "CS_CONFIG_CHANGED"
error_codes[1] = "CS_SUCCESS"
error_codes[0] = "CS_FALSE"
error_codes[-1] = "CS_NOT_INITIALIZED"
error_codes[-3] = "CS_UNABLE_CREATE_RM"
error_codes[-4] = "CS_INTERFACE_NOT_FOUND"
error_codes[-5] = "CS_HANDLE_IN_USE"
error_codes[-6] = "CS_INVALID_HANDLE"
error_codes[-7] = "CS_INVALID_REQUEST"
error_codes[-8] = "CS_NO_SYSTEMS_FOUND"
error_codes[-9] = "CS_MEMORY_ERROR"
error_codes[-10] = "CS_LOCK_SYSTEM_FAILED"
error_codes[-11] = "CS_INVALID_STRUCT_SIZE"
error_codes[-12] = "CS_INVALID_STATE"
error_codes[-13] = "CS_INVALID_EVENT"
error_codes[-14] = "CS_INVALID_SHARED_REGION"
error_codes[-15] = "CS_INVALID_FILENAME"
error_codes[-16] = "CS_SHARED_MAP_UNAVAILIABLE"
error_codes[-17] = "CS_INVALID_START"
error_codes[-18] = "CS_INVALID_LENGTH"
error_codes[-19] = "CS_SOCKET_NOT_FOUND"
error_codes[-20] = "CS_SOCKET_ERROR"
error_codes[-21] = "CS_NO_AVAILABLE_SYSTEM"
error_codes[-22] = "CS_NULL_POINTER"
error_codes[-23] = "CS_INVALID_CHANNEL"
error_codes[-24] = "CS_INVALID_TRIGGER"
error_codes[-25] = "CS_INVALID_EVENT_TYPE"
error_codes[-26] = "CS_BUFFER_TOO_SMALL"
error_codes[-27] = "CS_INVALID_PARAMETER"
error_codes[-28] = "CS_INVALID_SAMPLE_RATE"
error_codes[-29] = "CS_NO_EXT_CLK"
error_codes[-30] = "CS_SEG_COUNT_TOO_BIG"
error_codes[-31] = "CS_INVALID_SEGMENT_SIZE"
error_codes[-32] = "CS_DEPTH_SIZE_TOO_BIG"
error_codes[-33] = "CS_INVALID_CAL_MODE"
error_codes[-34] = "CS_INVALID_TRIG_COND"
error_codes[-35] = "CS_INVALID_TRIG_LEVEL"
error_codes[-36] = "CS_INVALID_TRIG_SOURCE"
error_codes[-37] = "CS_INVALID_EXT_TRIG"
error_codes[-38] = "CS_INVALID_ACQ_MODE"
error_codes[-39] = "CS_INVALID_IMPEDANCE"
error_codes[-40] = "CS_INVALID_GAIN"
error_codes[-41] = "CS_INVALID_COUPLING"
error_codes[-42] = "CS_BUFFER_NOT_ALIGNED"
error_codes[-43] = "CS_PRETRIG_DEPTH_TOO_BIG"
error_codes[-44] = "CS_INVALID_TRIG_DEPTH"
error_codes[-45] = "CS_FUNCTION_NOT_SUPPORTED"
error_codes[-46] = "CS_HARDWARE_TIMEOUT"
error_codes[-47] = "CS_INVALID_PARAMS_ID"
error_codes[-48] = "CS_INVALID_POINTER_BUFFER"
error_codes[-49] = "CS_CANNOT_LOCKDOWN_BUFFER"
error_codes[-50] = "CS_DRIVER_ASYNC_REQUEST_BUSY"
error_codes[-51] = "CS_INVALID_CHANNEL_COUNT"
error_codes[-52] = "CS_INVALID_TRIGGER_COUNT"
error_codes[-53] = "CS_INVALID_SEGMENT"
error_codes[-54] = "CS_INVALID_SEGMENT_COUNT"
error_codes[-55] = "CS_INVALID_CAPS_ID"
error_codes[-56] = "CS_HANDLE_NOT_IN_USE"
error_codes[-57] = "CS_INSUFFICIENT_RESOURCES"
error_codes[-58] = "CS_INVALID_TRANSFER_MODE"
error_codes[-59] = "CS_DRIVER_ASYNC_NOT_SUPPORTED"
error_codes[-60] = "CS_INVALID_TRIGGER_ENABLED"
error_codes[-61] = "CS_NOT_TRIGGER_FROM_SAME_CARD"
error_codes[-62] = "CS_INVALID_PRETRIGGER_DEPTH"
error_codes[-63] = "CS_INVALID_FW_VERSION"
error_codes[-64] = "CS_INVALID_TRIGHOLDOFF"
error_codes[-65] = "CS_INVALID_TRIGDELAY"
error_codes[-66] = "CS_INVALID_STREAMING_BUFFER"
error_codes[-67] = "CS_HW_FIFO_OVERFLOW"
error_codes[-68] = "CS_INVALID_CARD"
error_codes[-69] = "CS_INVALID_TOKEN"
error_codes[-70] = "CS_MASTERSLAVE_DISCREPANCY"
error_codes[-71] = "CS_INVALID_FIR_MULTIPLIER"
error_codes[-72] = "CS_MINMAXDETECTQUEUE_INVALID"
error_codes[-73] = "CS_ALLTRIGGERENGINES_USED"
error_codes[-74] = "CS_MULREC_RAWDATA_TOOBIG"
error_codes[-75] = "CS_INVALID_FILTER"
error_codes[-76] = "CS_INVALID_POSITION"
error_codes[-77] = "CS_EXT_CLK_OUT_OF_RANGE"
error_codes[-78] = "CS_EXT_CLK_NOT_PRESENT"
error_codes[-79] = "CS_RE_INIT_FAILED"
error_codes[-80] = "CS_CHANNEL_PROTECT_FAULT"
error_codes[-81] = "CS_INVALID_NUM_OF_AVERAGE"
error_codes[-82] = "CS_INVALID_TIMESTAMP_CLOCK"
error_codes[-83] = "CS_ASYNCTRANSFER_ABORTED"
error_codes[-84] = "CS_STREAM_ERROR_CIRCULAR_BUFFER"
error_codes[-85] = "CS_STREAM_ERROR_CREATEFILE"
error_codes[-86] = "CS_STREAM_ERROR_WRITEFILE"
error_codes[-87] = "CS_TRANSFER_DATA_TIMEOUT"
error_codes[-88] = "CS_DEVIOCTL_ERROR"
error_codes[-89] = "CS_OVERLAPPED_ERROR"
error_codes[-90] = "CS_CREATEEVENT_ERROR"
error_codes[-91] = "CS_FLASHSTATE_ERROR"
error_codes[-92] = "CS_FLASH_SECTORCROSS_ERROR"
error_codes[-93] = "CS_FLASH_SECTORERASE_ERROR"
error_codes[-94] = "CS_FLASH_INVALID_SECTOR"
error_codes[-95] = "CS_FLASH_DATAREAD_ERROR"
error_codes[-96] = "CS_FLASH_DATAWRITE_ERROR"
error_codes[-97] = "CS_SYSTEM_NOT_INITIALIZED"
error_codes[-98] = "CS_POWERSTATE_ERROR"
error_codes[-99] = "CS_SEGMENTSIZE_TOO_BIG"
error_codes[-100] = "CS_INVALID_FRM_CMD"
error_codes[-101] = "CS_FRM_NO_RESPONSE"
error_codes[-102] = "CS_INVALID_DAC_ADDR"
error_codes[-103] = "CS_INVALID_EDGE"
error_codes[-104] = "CS_INVALID_SELF_TEST"
error_codes[-105] = "CS_NIOS_FAILED"
error_codes[-106] = "CS_NO_INTERRUPT"
error_codes[-107] = "CS_ADDONINIT_ERROR"
error_codes[-108] = "CS_INVALID_ADC_ADDR"
error_codes[-109] = "CS_ADC_ACCESS_ERROR"
error_codes[-110] = "CS_FLASH_TIMEOUT"
error_codes[-111] = "CS_FLASH_BUFFER_BOUNDARY_ERROR"
error_codes[-112] = "CS_FLASH_BUFFER_SIZE_ERROR"
error_codes[-113] = "CS_FLASH_ADDRESS_ERROR"
error_codes[-114] = "CS_FLASH_ERASESECTOR_ERROR"
error_codes[-120] = "CS_INVALID_CARD_COUNT"
error_codes[-200] = "CS_DAC_CALIB_FAILURE"
error_codes[-201] = "CS_CAL_BUSY_TIMEOUT"
error_codes[-202] = "CS_TIMING_CAL_FAILED"
error_codes[-203] = "CS_COARSE_OFFSET_CAL_FAILED"
error_codes[-204] = "CS_FINE_OFFSET_CAL_FAILED"
error_codes[-205] = "CS_GAIN_CAL_FAILED"
error_codes[-206] = "CS_POSITION_CAL_FAILED"
error_codes[-207] = "CS_CALIB_DAC_OUT_OF_RANGE"
error_codes[-208] = "CS_CALIB_ADC_CAPTURE_FAILURE"
error_codes[-209] = "CS_CALIB_MEAS_ADC_FAILURE"
error_codes[-201] = "CS_CALIB_ADC_READ_FAILURE"
error_codes[-211] = "CS_CHANNELS_NOTCALIBRATED"
error_codes[-212] = "CS_MASTERSLAVE_CALIB_FAILURE"
error_codes[-213] = "CS_EXTTRIG_CALIB_FAILURE"
error_codes[-214] = "CS_INVALID_DACCALIBTABLE"
error_codes[-215] = "CS_ADCALIGN_CALIB_FAILURE"
error_codes[-216] = "CS_CALIB_REF_FAILURE"
error_codes[-217] = "CS_FAST_CALIB_FAILURE"
error_codes[-218] = "CS_ADC_DPA_FAILURE"
error_codes[-219] = "CS_EXT_TRIG_DPA_FAILURE"
error_codes[-220] = "CS_CLK_NOT_LOCKED"
error_codes[-221] = "CS_INVALID_CALIB_BUFFER"
error_codes[-222] = "CS_NULL_OFFSET_CAL_FAILED"
error_codes[-223] = "CS_ADC_SKEW_CAL_FAILED"
error_codes[-224] = "CS_ADC_PHASE_CAL_FAILED"
error_codes[-225] = "CS_ACCAL_NOT_LOCKED"
error_codes[-226] = "CS_LVDS_ALIGNMENT_FAILED"
error_codes[-227] = "CS_OFFSET_ADJUST_FAILED"
error_codes[-228] = "CS_ADC_IQ_GAIN_CALIB_FAILED"
error_codes[-229] = "CS_ADC_IQ_OFFSET_CALIB_FAILED"
error_codes[-230] = "CS_DC_LEVEL_FREEZE_FAILED"
error_codes[-231] = "CS_GAIN_CROSS_CHECK_FAILED"
error_codes[-300] = "CS_NVRAM_NOT_INIT"
error_codes[-301] = "CS_FLASH_NOT_INIT"
error_codes[-302] = "CS_EEPROM_NOT_INIT"
error_codes[-303] = "CS_ADDON_NOT_CONNECTED"
error_codes[-304] = "CS_MS_BRIDGE_FAILED"
error_codes[-305] = "CS_GIO_DETECT_FAILED"
error_codes[-408] = "CS_INVALID_DIRECTORY"
error_codes[-409] = "CS_DISK_STREAM_NOT_INITIALIZED"
error_codes[-410] = "CS_INVALID_DISK_STREAM_ACQ_COUNT"
error_codes[-411] = "CS_INVALID_SIG_HEADER"
error_codes[-412] = "CS_FWUPDATED_SHUTDOWN_REQUIRED"
error_codes[-413] = "CS_INVALID_DATAPACKING"
error_codes[-800] = "CS_STM_TRANSFER_ABORTED"
error_codes[-801] = "CS_STM_FIFO_OVERFLOW"
error_codes[-802] = "CS_STM_INVALID_TRANSFER_SIZE"
error_codes[-803] = "CS_STM_COMPLETED"
error_codes[-804] = "CS_STM_TRANSFER_TIMEOUT"
error_codes[-805] = "CS_HISTOGRAM_FULL"
error_codes[-806] = "CS_STM_INVALID_BUFFER"
error_codes[-807] = "CS_DDC_CORE_CONFIG_ERROR"
error_codes[-808] = "CS_STM_TOTALDATA_SIZE_INVALID"
error_codes[-809] = "CS_OCT_CORE_CONFIG_ERROR"
error_codes[-810] = "CS_OCT_INVALID_CONFIG_PARAMS"
error_codes[-850] = "CS_REMOTE_SOCKET_ERROR"
error_codes[-32767] = "CS_MISC_ERROR"


# transfer modes
transfer_modes = dict()
transfer_modes["slave"] = 0x80000000  # pci slave mode transfer used for troubleshooting
transfer_modes["rawdata"] = 0x40000000  # transfer data in raw data format with timestamp
transfer_modes["default"] = 0x00
transfer_modes["data_analogonly"] = 0x00  # transfer only analog data.
transfer_modes["data_float"] = 0x01  # transfer data in floating point format
transfer_modes["timestamp"] = 0x02  # transfer time-stamp information
transfer_modes["data_16"] = 0x04  # transfer all data bits including digital input bits
transfer_modes["data_onlydigital"] = 0x08  # transfer only digital input bits
transfer_modes["data_32"] = 0x10  # transfer data as 32 bit samples
transfer_modes[
    "data_fft"
] = 0x30  # transfer data in fft format. should be used only with expert fft firmware
transfer_modes["data_interleaved"] = 0x40  # transfer data in interleaved format
transfer_modes["segment_tail"] = 0x80  # transfer segment tail in raw data format
transfer_modes[
    "histogram"
] = 0x100  # transfer histogram data (cobra pci only). should be use only with expert histogram
transfer_modes["data_64"] = 0x200  # transfer data as 64 bit samples
