# Generated by Django 4.0.7 on 2022-08-04 08:06

import uuid

import django.db.models.deletion
import django.db.models.expressions
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Currency",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                ("name", models.TextField()),
                ("code", models.TextField()),
                ("fluctuates", models.FloatField()),
            ],
            options={
                "verbose_name_plural": "currencies",
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                (
                    "buyer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="orders",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Shop",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                ("name", models.TextField()),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="shops",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Rate",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                ("rate", models.FloatField()),
                (
                    "base",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="based_rates",
                        to="drf_shop.currency",
                    ),
                ),
                (
                    "quote",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="quoted_rates",
                        to="drf_shop.currency",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                ("name", models.TextField()),
                (
                    "shop",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="products",
                        to="drf_shop.shop",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Price",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                (
                    "amount",
                    models.DecimalField(decimal_places=0, max_digits=30),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="prices",
                        to="drf_shop.currency",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="prices",
                        to="drf_shop.product",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Payment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "modified_at",
                    models.DateTimeField(auto_now=True, db_index=True),
                ),
                (
                    "received_amount",
                    models.DecimalField(
                        decimal_places=0, max_digits=30, null=True
                    ),
                ),
                (
                    "method",
                    models.SmallIntegerField(
                        choices=[
                            (1, "Online"),
                            (2, "Manual"),
                            (3, "Remission"),
                        ]
                    ),
                ),
                ("reference_code", models.TextField(null=True)),
                ("verified_at", models.DateTimeField(null=True)),
                ("rejected_at", models.DateTimeField(null=True)),
                (
                    "currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="payments",
                        to="drf_shop.currency",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="payments",
                        to="drf_shop.order",
                    ),
                ),
                (
                    "verifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="verified_payments",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="OrderProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="items",
                        to="drf_shop.order",
                    ),
                ),
                (
                    "price",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="items",
                        to="drf_shop.price",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="items",
                        to="drf_shop.product",
                    ),
                ),
                (
                    "shop",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.RESTRICT,
                        related_name="items",
                        to="drf_shop.shop",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="order",
            name="products",
            field=models.ManyToManyField(
                related_name="orders",
                through="drf_shop.OrderProduct",
                to="drf_shop.product",
            ),
        ),
        migrations.AddConstraint(
            model_name="rate",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("base", django.db.models.expressions.F("quote")),
                    _negated=True,
                ),
                name="same_base_quote",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="rate",
            unique_together={("base", "quote")},
        ),
        migrations.AddConstraint(
            model_name="payment",
            constraint=models.CheckConstraint(
                check=models.Q(("received_amount__gte", 0)),
                name="positive_amount",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="orderproduct",
            unique_together={("order", "product")},
        ),
    ]
