# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import active_contracts_service_pb2 as com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2


class ActiveContractsServiceStub(object):
    """Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetActiveContracts = channel.unary_stream(
                '/com.daml.ledger.api.v1.ActiveContractsService/GetActiveContracts',
                request_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsRequest.SerializeToString,
                response_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsResponse.FromString,
                )


class ActiveContractsServiceServicer(object):
    """Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
    """

    def GetActiveContracts(self, request, context):
        """Returns a stream of the latest snapshot of active contracts.
        If there are no active contracts, the stream returns a single GetActiveContractsResponse message with the offset at which the snapshot has been taken.
        Clients SHOULD use the offset in the last GetActiveContractsResponse message to continue streaming transactions with the transaction service.
        Clients SHOULD NOT assume that the set of active contracts they receive reflects the state at the ledger end.
        Errors:
        - ``UNAUTHENTICATED``: if the request does not include a valid access token
        - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
        - ``NOT_FOUND``: if the request does not include a valid ledger id
        - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields (filters by party cannot be empty)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ActiveContractsServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetActiveContracts': grpc.unary_stream_rpc_method_handler(
                    servicer.GetActiveContracts,
                    request_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsRequest.FromString,
                    response_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.daml.ledger.api.v1.ActiveContractsService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ActiveContractsService(object):
    """Allows clients to initialize themselves according to a fairly recent state of the ledger without reading through all transactions that were committed since the ledger's creation.
    """

    @staticmethod
    def GetActiveContracts(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.daml.ledger.api.v1.ActiveContractsService/GetActiveContracts',
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsRequest.SerializeToString,
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_active__contracts__service__pb2.GetActiveContractsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
