# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.duration_pb2 import Duration
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

__all__ = [
    "GetTimeModelRequest",
    "GetTimeModelResponse",
    "SetTimeModelRequest",
    "SetTimeModelResponse",
    "TimeModel",
]


class GetTimeModelRequest(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTimeModelResponse(_Message):
    configuration_generation: int
    @property
    def time_model(self) -> TimeModel: ...
    def __init__(self, *, configuration_generation: _typing.Optional[int] = ..., time_model: _typing.Optional[TimeModel] = ...): ...
    def HasField(self, field_name: _typing.Literal["configuration_generation", "time_model"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["configuration_generation", "time_model"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class SetTimeModelRequest(_Message):
    submission_id: str
    @property
    def maximum_record_time(self) -> Timestamp: ...
    configuration_generation: int
    @property
    def new_time_model(self) -> TimeModel: ...
    def __init__(self, *, submission_id: _typing.Optional[str] = ..., maximum_record_time: _typing.Optional[Timestamp] = ..., configuration_generation: _typing.Optional[int] = ..., new_time_model: _typing.Optional[TimeModel] = ...): ...
    def HasField(self, field_name: _typing.Literal["submission_id", "maximum_record_time", "configuration_generation", "new_time_model"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["submission_id", "maximum_record_time", "configuration_generation", "new_time_model"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class SetTimeModelResponse(_Message):
    configuration_generation: int
    def __init__(self, *, configuration_generation: _typing.Optional[int] = ...): ...
    def HasField(self, field_name: _typing.Literal["configuration_generation"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["configuration_generation"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class TimeModel(_Message):
    @property
    def avg_transaction_latency(self) -> Duration: ...
    @property
    def min_skew(self) -> Duration: ...
    @property
    def max_skew(self) -> Duration: ...
    def __init__(self, *, avg_transaction_latency: _typing.Optional[Duration] = ..., min_skew: _typing.Optional[Duration] = ..., max_skew: _typing.Optional[Duration] = ...): ...
    def HasField(self, field_name: _typing.Literal["avg_transaction_latency", "min_skew", "max_skew"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["avg_transaction_latency", "min_skew", "max_skew"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
