# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message

__all__ = [
    "GetParticipantIdRequest",
    "GetParticipantIdResponse",
    "GetPartiesRequest",
    "GetPartiesResponse",
    "ListKnownPartiesRequest",
    "ListKnownPartiesResponse",
    "AllocatePartyRequest",
    "AllocatePartyResponse",
    "PartyDetails",
]


class GetParticipantIdRequest(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetParticipantIdResponse(_Message):
    participant_id: str
    def __init__(self, *, participant_id: _typing.Optional[str] = ...): ...
    def HasField(self, field_name: _typing.Literal["participant_id"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["participant_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetPartiesRequest(_Message):
    @property
    def parties(self) -> RepeatedScalarFieldContainer[str]: ...
    def __init__(self, *, parties: _typing.Optional[_typing.Iterable[str]] = ...): ...
    def HasField(self, field_name: _typing.Literal["parties"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["parties"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetPartiesResponse(_Message):
    @property
    def party_details(self) -> RepeatedCompositeFieldContainer[PartyDetails]: ...
    def __init__(self, *, party_details: _typing.Optional[_typing.Iterable[PartyDetails]] = ...): ...
    def HasField(self, field_name: _typing.Literal["party_details"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["party_details"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListKnownPartiesRequest(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListKnownPartiesResponse(_Message):
    @property
    def party_details(self) -> RepeatedCompositeFieldContainer[PartyDetails]: ...
    def __init__(self, *, party_details: _typing.Optional[_typing.Iterable[PartyDetails]] = ...): ...
    def HasField(self, field_name: _typing.Literal["party_details"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["party_details"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class AllocatePartyRequest(_Message):
    party_id_hint: str
    display_name: str
    def __init__(self, *, party_id_hint: _typing.Optional[str] = ..., display_name: _typing.Optional[str] = ...): ...
    def HasField(self, field_name: _typing.Literal["party_id_hint", "display_name"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["party_id_hint", "display_name"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class AllocatePartyResponse(_Message):
    @property
    def party_details(self) -> PartyDetails: ...
    def __init__(self, *, party_details: _typing.Optional[PartyDetails] = ...): ...
    def HasField(self, field_name: _typing.Literal["party_details"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["party_details"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class PartyDetails(_Message):
    party: str
    display_name: str
    is_local: bool
    def __init__(self, *, party: _typing.Optional[str] = ..., display_name: _typing.Optional[str] = ..., is_local: _typing.Optional[bool] = ...): ...
    def HasField(self, field_name: _typing.Literal["party", "display_name", "is_local"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["party", "display_name", "is_local"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
