# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

from .completion_pb2 import Completion
from .ledger_offset_pb2 import LedgerOffset
from .trace_context_pb2 import TraceContext

__all__ = [
    "CompletionStreamRequest",
    "CompletionStreamResponse",
    "Checkpoint",
    "CompletionEndRequest",
    "CompletionEndResponse",
]


class CompletionStreamRequest(_Message):
    ledger_id: str
    application_id: str
    @property
    def parties(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., application_id: _typing.Optional[str] = ..., parties: _typing.Optional[_typing.Iterable[str]] = ..., offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "application_id", "parties", "offset"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "application_id", "parties", "offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionStreamResponse(_Message):
    @property
    def checkpoint(self) -> Checkpoint: ...
    @property
    def completions(self) -> RepeatedCompositeFieldContainer[Completion]: ...
    def __init__(self, *, checkpoint: _typing.Optional[Checkpoint] = ..., completions: _typing.Optional[_typing.Iterable[Completion]] = ...): ...
    def HasField(self, field_name: _typing.Literal["checkpoint", "completions"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["checkpoint", "completions"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Checkpoint(_Message):
    @property
    def record_time(self) -> Timestamp: ...
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, record_time: _typing.Optional[Timestamp] = ..., offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _typing.Literal["record_time", "offset"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["record_time", "offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionEndRequest(_Message):
    ledger_id: str
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionEndResponse(_Message):
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _typing.Literal["offset"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
