# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.duration_pb2 import Duration
from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

from .value_pb2 import Identifier, Record, Value

__all__ = [
    "Commands",
    "Command",
    "CreateCommand",
    "ExerciseCommand",
    "ExerciseByKeyCommand",
    "CreateAndExerciseCommand",
]


class Commands(_Message):
    ledger_id: str
    workflow_id: str
    application_id: str
    command_id: str
    party: str
    @property
    def commands(self) -> RepeatedCompositeFieldContainer[Command]: ...
    @property
    def deduplication_time(self) -> Duration: ...
    @property
    def min_ledger_time_abs(self) -> Timestamp: ...
    @property
    def min_ledger_time_rel(self) -> Duration: ...
    @property
    def act_as(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def read_as(self) -> RepeatedScalarFieldContainer[str]: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., workflow_id: _typing.Optional[str] = ..., application_id: _typing.Optional[str] = ..., command_id: _typing.Optional[str] = ..., party: _typing.Optional[str] = ..., commands: _typing.Optional[_typing.Iterable[Command]] = ..., deduplication_time: _typing.Optional[Duration] = ..., min_ledger_time_abs: _typing.Optional[Timestamp] = ..., min_ledger_time_rel: _typing.Optional[Duration] = ..., act_as: _typing.Optional[_typing.Iterable[str]] = ..., read_as: _typing.Optional[_typing.Iterable[str]] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "workflow_id", "application_id", "command_id", "party", "commands", "deduplication_time", "min_ledger_time_abs", "min_ledger_time_rel", "act_as", "read_as"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "workflow_id", "application_id", "command_id", "party", "commands", "deduplication_time", "min_ledger_time_abs", "min_ledger_time_rel", "act_as", "read_as"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Command(_Message):
    @property
    def create(self) -> CreateCommand: ...
    @property
    def exercise(self) -> ExerciseCommand: ...
    @property
    def exerciseByKey(self) -> ExerciseByKeyCommand: ...
    @property
    def createAndExercise(self) -> CreateAndExerciseCommand: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, create: CreateCommand = ...): ...
    @_typing.overload
    def __init__(self, *, exercise: ExerciseCommand = ...): ...
    @_typing.overload
    def __init__(self, *, exerciseByKey: ExerciseByKeyCommand = ...): ...
    @_typing.overload
    def __init__(self, *, createAndExercise: CreateAndExerciseCommand = ...): ...
    def HasField(self, field_name: _typing.Literal["command", "create", "exercise", "exerciseByKey", "createAndExercise"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["command", "create", "exercise", "exerciseByKey", "createAndExercise"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.Literal["command"]) -> _typing.Literal[None, "create", "exercise", "exerciseByKey", "createAndExercise"]: ...

class CreateCommand(_Message):
    @property
    def template_id(self) -> Identifier: ...
    @property
    def create_arguments(self) -> Record: ...
    def __init__(self, *, template_id: _typing.Optional[Identifier] = ..., create_arguments: _typing.Optional[Record] = ...): ...
    def HasField(self, field_name: _typing.Literal["template_id", "create_arguments"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["template_id", "create_arguments"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ExerciseCommand(_Message):
    @property
    def template_id(self) -> Identifier: ...
    contract_id: str
    choice: str
    @property
    def choice_argument(self) -> Value: ...
    def __init__(self, *, template_id: _typing.Optional[Identifier] = ..., contract_id: _typing.Optional[str] = ..., choice: _typing.Optional[str] = ..., choice_argument: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _typing.Literal["template_id", "contract_id", "choice", "choice_argument"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["template_id", "contract_id", "choice", "choice_argument"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ExerciseByKeyCommand(_Message):
    @property
    def template_id(self) -> Identifier: ...
    @property
    def contract_key(self) -> Value: ...
    choice: str
    @property
    def choice_argument(self) -> Value: ...
    def __init__(self, *, template_id: _typing.Optional[Identifier] = ..., contract_key: _typing.Optional[Value] = ..., choice: _typing.Optional[str] = ..., choice_argument: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _typing.Literal["template_id", "contract_key", "choice", "choice_argument"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["template_id", "contract_key", "choice", "choice_argument"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CreateAndExerciseCommand(_Message):
    @property
    def template_id(self) -> Identifier: ...
    @property
    def create_arguments(self) -> Record: ...
    choice: str
    @property
    def choice_argument(self) -> Value: ...
    def __init__(self, *, template_id: _typing.Optional[Identifier] = ..., create_arguments: _typing.Optional[Record] = ..., choice: _typing.Optional[str] = ..., choice_argument: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _typing.Literal["template_id", "create_arguments", "choice", "choice_argument"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["template_id", "create_arguments", "choice", "choice_argument"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
