# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.internal.containers import RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.wrappers_pb2 import StringValue

from .value_pb2 import Identifier, Record, Value

__all__ = [
    "Event",
    "CreatedEvent",
    "ArchivedEvent",
    "ExercisedEvent",
]


class Event(_Message):
    @property
    def created(self) -> CreatedEvent: ...
    @property
    def archived(self) -> ArchivedEvent: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, created: CreatedEvent = ...): ...
    @_typing.overload
    def __init__(self, *, archived: ArchivedEvent = ...): ...
    def HasField(self, field_name: _typing.Literal["event", "created", "archived"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["event", "created", "archived"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.Literal["event"]) -> _typing.Literal[None, "created", "archived"]: ...

class CreatedEvent(_Message):
    event_id: str
    contract_id: str
    @property
    def template_id(self) -> Identifier: ...
    @property
    def contract_key(self) -> Value: ...
    @property
    def create_arguments(self) -> Record: ...
    @property
    def witness_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def signatories(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def observers(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def agreement_text(self) -> StringValue: ...
    def __init__(self, *, event_id: _typing.Optional[str] = ..., contract_id: _typing.Optional[str] = ..., template_id: _typing.Optional[Identifier] = ..., contract_key: _typing.Optional[Value] = ..., create_arguments: _typing.Optional[Record] = ..., witness_parties: _typing.Optional[_typing.Iterable[str]] = ..., signatories: _typing.Optional[_typing.Iterable[str]] = ..., observers: _typing.Optional[_typing.Iterable[str]] = ..., agreement_text: _typing.Optional[StringValue] = ...): ...
    def HasField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "contract_key", "create_arguments", "witness_parties", "signatories", "observers", "agreement_text"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "contract_key", "create_arguments", "witness_parties", "signatories", "observers", "agreement_text"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ArchivedEvent(_Message):
    event_id: str
    contract_id: str
    @property
    def template_id(self) -> Identifier: ...
    @property
    def witness_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    def __init__(self, *, event_id: _typing.Optional[str] = ..., contract_id: _typing.Optional[str] = ..., template_id: _typing.Optional[Identifier] = ..., witness_parties: _typing.Optional[_typing.Iterable[str]] = ...): ...
    def HasField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "witness_parties"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "witness_parties"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ExercisedEvent(_Message):
    event_id: str
    contract_id: str
    @property
    def template_id(self) -> Identifier: ...
    choice: str
    @property
    def choice_argument(self) -> Value: ...
    @property
    def acting_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    consuming: bool
    @property
    def witness_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def child_event_ids(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def exercise_result(self) -> Value: ...
    def __init__(self, *, event_id: _typing.Optional[str] = ..., contract_id: _typing.Optional[str] = ..., template_id: _typing.Optional[Identifier] = ..., choice: _typing.Optional[str] = ..., choice_argument: _typing.Optional[Value] = ..., acting_parties: _typing.Optional[_typing.Iterable[str]] = ..., consuming: _typing.Optional[bool] = ..., witness_parties: _typing.Optional[_typing.Iterable[str]] = ..., child_event_ids: _typing.Optional[_typing.Iterable[str]] = ..., exercise_result: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "choice", "choice_argument", "acting_parties", "consuming", "witness_parties", "child_event_ids", "exercise_result"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["event_id", "contract_id", "template_id", "choice", "choice_argument", "acting_parties", "consuming", "witness_parties", "child_event_ids", "exercise_result"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
