# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.duration_pb2 import Duration
from google.protobuf.message import Message as _Message

from .trace_context_pb2 import TraceContext

__all__ = [
    "GetLedgerConfigurationRequest",
    "GetLedgerConfigurationResponse",
    "LedgerConfiguration",
]


class GetLedgerConfigurationRequest(_Message):
    ledger_id: str
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetLedgerConfigurationResponse(_Message):
    @property
    def ledger_configuration(self) -> LedgerConfiguration: ...
    def __init__(self, *, ledger_configuration: _typing.Optional[LedgerConfiguration] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_configuration"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_configuration"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class LedgerConfiguration(_Message):
    @property
    def max_deduplication_time(self) -> Duration: ...
    def __init__(self, *, max_deduplication_time: _typing.Optional[Duration] = ...): ...
    def HasField(self, field_name: _typing.Literal["max_deduplication_time"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["max_deduplication_time"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
