# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.internal.containers import MessageMap, RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

from .event_pb2 import CreatedEvent, Event, ExercisedEvent
from .trace_context_pb2 import TraceContext

__all__ = [
    "TransactionTree",
    "TreeEvent",
    "Transaction",
]


class TransactionTree(_Message):
    transaction_id: str
    command_id: str
    workflow_id: str
    @property
    def effective_at(self) -> Timestamp: ...
    offset: str
    @property
    def events_by_id(self) -> MessageMap[str, TreeEvent]: ...
    @property
    def root_event_ids(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, transaction_id: _typing.Optional[str] = ..., command_id: _typing.Optional[str] = ..., workflow_id: _typing.Optional[str] = ..., effective_at: _typing.Optional[Timestamp] = ..., offset: _typing.Optional[str] = ..., events_by_id: _typing.Optional[_typing.Mapping[str, TreeEvent]] = ..., root_event_ids: _typing.Optional[_typing.Iterable[str]] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["transaction_id", "command_id", "workflow_id", "effective_at", "offset", "events_by_id", "root_event_ids", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transaction_id", "command_id", "workflow_id", "effective_at", "offset", "events_by_id", "root_event_ids", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class TreeEvent(_Message):
    @property
    def created(self) -> CreatedEvent: ...
    @property
    def exercised(self) -> ExercisedEvent: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, created: CreatedEvent = ...): ...
    @_typing.overload
    def __init__(self, *, exercised: ExercisedEvent = ...): ...
    def HasField(self, field_name: _typing.Literal["kind", "created", "exercised"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["kind", "created", "exercised"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.Literal["kind"]) -> _typing.Literal[None, "created", "exercised"]: ...

class Transaction(_Message):
    transaction_id: str
    command_id: str
    workflow_id: str
    @property
    def effective_at(self) -> Timestamp: ...
    @property
    def events(self) -> RepeatedCompositeFieldContainer[Event]: ...
    offset: str
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, transaction_id: _typing.Optional[str] = ..., command_id: _typing.Optional[str] = ..., workflow_id: _typing.Optional[str] = ..., effective_at: _typing.Optional[Timestamp] = ..., events: _typing.Optional[_typing.Iterable[Event]] = ..., offset: _typing.Optional[str] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["transaction_id", "command_id", "workflow_id", "effective_at", "events", "offset", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transaction_id", "command_id", "workflow_id", "effective_at", "events", "offset", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
