# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message

from .ledger_offset_pb2 import LedgerOffset
from .trace_context_pb2 import TraceContext
from .transaction_filter_pb2 import TransactionFilter
from .transaction_pb2 import Transaction, TransactionTree

__all__ = [
    "GetTransactionsRequest",
    "GetTransactionsResponse",
    "GetTransactionTreesResponse",
    "GetTransactionByEventIdRequest",
    "GetTransactionByIdRequest",
    "GetTransactionResponse",
    "GetFlatTransactionResponse",
    "GetLedgerEndRequest",
    "GetLedgerEndResponse",
]


class GetTransactionsRequest(_Message):
    ledger_id: str
    @property
    def begin(self) -> LedgerOffset: ...
    @property
    def end(self) -> LedgerOffset: ...
    @property
    def filter(self) -> TransactionFilter: ...
    verbose: bool
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., begin: _typing.Optional[LedgerOffset] = ..., end: _typing.Optional[LedgerOffset] = ..., filter: _typing.Optional[TransactionFilter] = ..., verbose: _typing.Optional[bool] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "begin", "end", "filter", "verbose", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "begin", "end", "filter", "verbose", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTransactionsResponse(_Message):
    @property
    def transactions(self) -> RepeatedCompositeFieldContainer[Transaction]: ...
    def __init__(self, *, transactions: _typing.Optional[_typing.Iterable[Transaction]] = ...): ...
    def HasField(self, field_name: _typing.Literal["transactions"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transactions"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTransactionTreesResponse(_Message):
    @property
    def transactions(self) -> RepeatedCompositeFieldContainer[TransactionTree]: ...
    def __init__(self, *, transactions: _typing.Optional[_typing.Iterable[TransactionTree]] = ...): ...
    def HasField(self, field_name: _typing.Literal["transactions"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transactions"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTransactionByEventIdRequest(_Message):
    ledger_id: str
    event_id: str
    @property
    def requesting_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., event_id: _typing.Optional[str] = ..., requesting_parties: _typing.Optional[_typing.Iterable[str]] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "event_id", "requesting_parties", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "event_id", "requesting_parties", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTransactionByIdRequest(_Message):
    ledger_id: str
    transaction_id: str
    @property
    def requesting_parties(self) -> RepeatedScalarFieldContainer[str]: ...
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., transaction_id: _typing.Optional[str] = ..., requesting_parties: _typing.Optional[_typing.Iterable[str]] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "transaction_id", "requesting_parties", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "transaction_id", "requesting_parties", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetTransactionResponse(_Message):
    @property
    def transaction(self) -> TransactionTree: ...
    def __init__(self, *, transaction: _typing.Optional[TransactionTree] = ...): ...
    def HasField(self, field_name: _typing.Literal["transaction"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transaction"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetFlatTransactionResponse(_Message):
    @property
    def transaction(self) -> Transaction: ...
    def __init__(self, *, transaction: _typing.Optional[Transaction] = ...): ...
    def HasField(self, field_name: _typing.Literal["transaction"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["transaction"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetLedgerEndRequest(_Message):
    ledger_id: str
    @property
    def trace_context(self) -> TraceContext: ...
    def __init__(self, *, ledger_id: _typing.Optional[str] = ..., trace_context: _typing.Optional[TraceContext] = ...): ...
    def HasField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["ledger_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetLedgerEndResponse(_Message):
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _typing.Literal["offset"]) -> bool: ...
    def ClearField(self, field_name: _typing.Literal["offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
